#!/usr/bin/perl

use warnings;
use strict;

my @questions;
open my $qf, 'FYTESsodpov 29.3.09.txt' or die $!;
my $qi = 0; my $ai = 'a';
while (<$qf>) {
	chomp;
	/^\s*$/ and next;
	if (/^\s*(\d+)\.?\s*(.*)/) {
		$1 == $qi + 1 or print "SEQ ERROR\n";
		$qi = $1;
		print "Q $qi - $2\n";
		$questions[$qi]->{q} = $2;
		$questions[$qi]->{n} = $qi;
		$ai = 'q';
		next;
	}
	if (/^\s*([a-z])\)(-?)\s*(.*)/) {
		$ai = $1;
		print "A $qi - $ai - $3 ($2)\n";
		$questions[$qi]->{$ai} = [$3, $2];
		next;
	}
		print "APP $qi : $ai : $_\n";
	if ($ai eq 'q') {
		$questions[$qi]->{q} .= " $_";
	} else {
		$questions[$qi]->{$ai}->[0] .= $_;
	}
}
close $qf;

open $qf, 'questions.wrong.third.list' or die $!;
my @qfilter = <$qf>;
chomp @qfilter;
close $qf;

@questions = map { my $a = $_; if ($a and grep { $a->{n} eq $_ } @qfilter) { $a; } else { undef; } } @questions;

use Data::Dumper;
print Dumper(\@questions);

open my $noa, ">questions.noa.txt" or die $!;
open my $wia, ">questions.wia.txt" or die $!;

my @q2;
while (@questions) {
	push @q2, splice(@questions, rand $#questions, 1);
}

for my $q (@q2) {
	next unless $q;
	print $noa $q->{n}.". ".$q->{q}."\n";
	print $wia $q->{n}.". ".$q->{q}."\n";
	for my $l ('a'..'e') {
		next unless $q->{$l};
		print $noa $l.") ".$q->{$l}->[0]."\n";
		print $wia $l.")".($q->{$l}->[1]?'-':' ').$q->{$l}->[0]."\n";
	}
	print $noa "\n";
	print $wia "\n";
}
