#!/usr/bin/perl

use warnings;
use strict;

use Term::ANSIColor;

sub load_questions {
	my @questions;
	open my $qf, 'FYTESsodpov 29.3.09.txt' or die $!;
	my $qi = 0; my $ai = 'a';
	while (<$qf>) {
		chomp;
		/^\s*$/ and next;
		if (/^\s*(\d+)\.?\s*(.*)/) {
			# $1 == $qi + 1 or print "SEQ ERROR\n";
			$qi = $1;
			# print "Q $qi - $2\n";
			$questions[$qi]->{q} = $2;
			$questions[$qi]->{n} = $qi;
			$ai = 'q';
			next;
		}
		if (/^\s*([a-z])\)(-?)\s*(.*)/) {
			$ai = $1;
			# print "A $qi - $ai - $3 ($2)\n";
			$questions[$qi]->{$ai} = [$3, $2];
			next;
		}
		# print "APP $qi : $ai : $_\n";
		if ($ai eq 'q') {
			$questions[$qi]->{q} .= " $_";
		} else {
			$questions[$qi]->{$ai}->[0] .= $_;
		}
	}
	close $qf;
	return @questions;
}

my @questions = load_questions();

my $minwins = 0;

my @stats;
if (open my $statf, "stats.json") {
	use JSON;
	@stats = @{JSON::decode_json(<$statf>)};
	close $statf;
	use List::Util;
	$minwins = List::Util::min map { $stats[$_] ? $stats[$_]->{wins} : 0 } grep { defined $questions[$_] } (1..$#questions);
	print "Minimum amount of correct answers is so far $minwins.\n";
	print "Considering questions with only this number of correct answers. Good luck!\n\n";
} else {
	print "First run. Good luck!\n\n";
}

my $qcount = 0;
my $cacount = 0;
my $wcount = 0;

$| = 1;
QLOOP:
while (1) {
	my @qset = map { $questions[$_] } grep { not defined $stats[$_] or $stats[$_]->{wins} <= $minwins } (1..$#questions);
	if (not @qset) {
		$minwins++;
		print color 'lightgreen';
		print "Congratulations! You have answered all questions at least $minwins times.\n";
		print "We will consider the full set of questions again.\n\n";
		print color 'reset';
		next QLOOP;
	}
	my $qi = rand @qset;
	my $q = $qset[$qi];
	defined $q or next;

	print color 'cyan';
	print $q->{n}.". ".$q->{q}."\n";
	print color 'reset';
	for my $l ('a'..'e') {
		next unless $q->{$l};
		print $l.") ".$q->{$l}->[0]."\n";
	}
	print "\n? ";

	my $letters = <>;
	chomp $letters;
	my @letters = split(//, $letters);
	if (grep { $_ eq 'q' } @letters) {
		last QLOOP;
	}

	my $wrong = 0;
	for my $l ('a'..'d') {
		if (not $q->{$l}->[1]) {
			if (grep { $_ eq $l } @letters) {
				print color 'red';
				print "$l is wrong.\n";
				print color 'reset';
				$wrong++;
			}

		} else {
			if (grep { $_ eq $l } @letters) {
				print color 'green';
				print "$l is correct.\n";
				print color 'reset';
			} else {
				print color 'red';
				print "$l is in fact correct.\n";
				print color 'reset';
				$wrong++;
			}
		}
	}

	$stats[$qi]->{wins} += not $wrong;
	$stats[$qi]->{tries}++;
	$cacount += not $wrong;
	$qcount++;
	$wcount += $wrong;

	if (not $wrong) {
		print "Yay! :-)  ";
	} else {
		print "$wrong ".($wrong eq 1 ? "mistake" : "mistakes").".  ";
	}
	print "(Total bilance ".$stats[$qi]->{wins}."/".$stats[$qi]->{tries}." for this question. ";
	print "Current run bilance ".$cacount."/".$qcount." questions ".int(100*$cacount/$qcount)."%, ".$wcount." mistakes.)\n";
	print color 'reset';

	<>;
	$_ and /q/ and last QLOOP;
	print "\n";
}

use JSON;
open my $statf, ">stats.json" or die $!;
print $statf JSON::encode_json [@stats];
close $statf;
