  /** hexedit.c - 08/01/00 - v0.3 - by Pasky - and for Linux - more questions? - e-mail to pasky@libra.sinus.cz! ***\
  /=================================================================================================================/
  *     HexEditor - programmer's hexadecimal editor with integrated calculator
  *     Copyright (C) 1999, 2000  Petr Baudis <pasky@libra.sinus.cz>
  *
  *     This program is free software; you can redistribute it and/or modify
  *     it under the terms of the GNU General Public License as published by
  *     the Free Software Foundation; either version 2 of the License, or
  *     (at your option) any later version.
  *
  *     This program is distributed in the hope that it will be useful,
  *     but WITHOUT ANY WARRANTY; without even the implied warranty of
  *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  *     GNU General Public License for more details.
  *
  *     You should have received a copy of the GNU General Public License
  *     along with this program; if not, write to the Free Software
  *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  *
  \==================================================================================================================\
  *                                                                                                                  * F
  *    This file is protected by the GPL. Please see notes above, and if you want to make some job with it, please   *  R
  *  read the whole license. You can too get it from internet (somewhere at http://www.gnu.org).                     * E
  *                                                                                                                  *  E
  *    And what is it? An useful hexadecimal editor with color support, small notetab and many more... But it is     * D
  *  in an evolution! If you want to help me, please contact me at hexedit@libra.sinus.cz. Any suggestions or        *  O
  *  bug-reports please mail to hexedit-bugs@libra.sinus.cz...                                                       * M
  *                                                                                                                  *
  *    Yes, I think there is a lot of better and more nice hexadecimal programmer editors - but I didn't have        * I
  *  anyone, so I started developing this ugly one. But it is small and... my!                                       *  N
  *                                                                                                                  *
  *    Please rembember my english is horrible and this is practically my first bigger project in C.                 *  T
  *  So I'll welcome all comments about it, any optimalizations, extensions, etc...                                  * H
  *                                                                                                                  *  E
  \******************************************************************************************************************/
  
  /********************************************************\
   * Please see main file (hexedit.c) or attached files   *
   * to get any more informations (TODO, features, etc.). *
  \********************************************************/

#include<stdio.h>
#include<curses.h>
#include<stdlib.h>
#include<string.h>
#include<ctype.h>
  
#include<config.h>
#include<hexedit.h>
#include<display.h>
  
/*
 * This is an equivalent to clrtoeol(), but fills a rest of line by specified attr...
 */				
int
filltoeol(int attr)
{
  int z,q,x,y;
  getmaxyx(curscr,z,q);
  getyx(curscr,y,x);
  for (;x<=q;x++) mvaddch(y,x,' ' | attr); 
  return 0;
}

/*
 * This is an equivalent to addstr(), but applies to every char an attribute.
 */
int
aaddstr(char *str, int attr)
{
  int n;
  for (n=0;n<strlen(str);addch(str[n] | attr),n++) { /* so no overflow'll be occured (I hope ;) */ }
  return 0;
}

/*
 * Replaces some characters in a string by a '.'.
 */
char
*flatstring(long where, long rlimit)
{
  int n=0; char *z;
  z=malloc(rlimit);
  for (;n<rlimit;n++) /*z[n]=(str[n]<32||str[n]>0x7e)?'.':str[n];*//* we have something better :) */
    				 z[n]=PRCHAR(n+where);
  z[rlimit]='\0';
  return z;
}

/*
 * Returns hex. character's index in cpole (I think(+hope) never used).
 */
unsigned char
tohexa(unsigned char c)
{
  return strchr(cpole,c)-cpole;
}

/*
 * Returns hex. representation of char c. It-is-primitive! I-know-it!
 */
char
*frhexa(unsigned char c)
{
  char *tmp;
  c&=0x0ff; /* hodina casu stravena badanim + trpke vystrizliveni z Ceckove euforie :-((( 
	       je opravdu zvlastni ze i kdyz je to typ _unsigned_ char (SIZEOF=1), tak to hlasilo -128 :-\
	       kdo mi rekne v cem se mylim vyhraje prvni cenu...
	       Don't try to translate it, my english friends, it's only description of one *********... :( */
  tmp=(char *)malloc(4); tmp[0]=' '; tmp[3]='\0';
  tmp[1]=cpole[c>>4]; tmp[2]=cpole[c & 0x0F];
  return tmp;
}

/*
 * Redraws specific byte.
 */
int
redraw_no(int no)
{
  char *temp; int x,y;
 
  y=(no-startpos)/numbers_on_line+scrstart;
  x=7+(((no%numbers_on_line))*3)+((no%numbers_on_line)/16*2)-1;
  move(y,x);
  
  /*sprintf(temp," %02hX",(char)edspace[no]);*/ /*nefunguje, smejd */
  temp=frhexa(edspace[no]);
  aaddstr(temp,no==pos?CLR_ACTU:CLR_BASE); /* actual position? */
  free(temp);
  /* sprintf(z," y=%d ; startpos=%d ",y,startpos); mvaddstr(0,20,z); */ 
  /* refresh(); - with it it's very slow - so turn it on only for debug stage... */
  x=9+(numbers_on_line)*3+no%numbers_on_line; /* y is the same... */
  move(y,x);
  addch((PRCHAR(no))|(no==pos?CLR_ACTU:CLR_BASE)); /* in the ASCII column */ /* ___don't remove any parentheses!!!___ */
  
  return 0;
}

/*
 * Redraws the whole data screen.
 */
int
redraw(void)
{
  int x,t; char tmp[20];
  move(scrstart,1);
  for (x=startpos;x<=limit && (x-startpos)/numbers_on_line-scrstart<scrlimit;x++)
  { if ((x%numbers_on_line)==0)
    { t=(x-startpos)/numbers_on_line+scrstart;
      /*if ((x/numbers_on_line)>0)
        {*/ mvaddch(t,7+(numbers_on_line)*3,ACS_VLINE); addch(' ');
	  strcpy(tmp,flatstring(x-numbers_on_line,numbers_on_line));
	  addstr(tmp); /*}*/
      sprintf(tmp,"%04X:",x);
      mvaddstr(t,1,tmp); }
    else
      if ((x%16)==0)
        { addch(' '); addch(ACS_VLINE); }
    redraw_no(x); }
  deleteln();
  refresh();
  return 0;
}

/*
 * Tests that file is saved and if then displays warning.
 * Return: 0=all is Ok;1=Warned, saved;2=Warned, ignored
 */
int
testmodify(void)
{ char tmp[133]; int maxx,maxy;
  getmaxyx(curscr,maxy,maxx);
  if (!modified) return 0;
  sprintf(tmp,"File %s is not saved! Save it? [Y/N] ",filename);
  move(maxy-1,0);
  aaddstr(tmp,CLR_ERRD);
  refresh();
  filltoeol(CLR_ERRD);
  move(maxy-1,strlen(tmp));
  refresh();
  while ((tmp[0]=toupper(getchar()))!='Y' && tmp[0]!='N');
  move(maxy-1,0);
  refresh();
  clrtoeol();
  refresh();
  if (tmp[0]=='Y') savefile(filename); else return 2;
  return 1;
}

/*
 * Refreshes the status bar.
 */
int
actua() /* exchange 'x' with 'X' in sprintfs, if you want to read big hex. letters... */
{
  char tmp[133];
  move(0,54); addch((modified?'*':' ') | CLR_STAT); /* indicator of file modification */
  move(0,55); addch((pos>=filesize?'+':' ') | CLR_STAT); /* indicator of pos. after eof */
  sprintf(tmp,"%.42s",filename);move(0,11); aaddstr(tmp,CLR_STAT); /* print a filename */
  sprintf(tmp,"0x%05lx",pos);    move(0,64); aaddstr(tmp,CLR_STAT); /*       an offset */
  sprintf(tmp,"%lu (%d%%)    ",pos,pos<filesize?(int)(((float)pos/(float)filesize)*100):100);move(0,72); aaddstr(tmp,CLR_STAT);
  sprintf(tmp,"'%c' (#%u\t0x%02x)",PRSCHAR(pos),*(edspace+pos),*(edspace+pos));
				move(0,110); aaddstr(tmp,CLR_STAT); /*      actual char */
  sprintf(tmp,"0x%02x (%u)   ",*(edspace+pos),*(edspace+pos));
  				move(1,7); aaddstr(tmp,CLR_STAT);  /*       actual chars  */
  sprintf(tmp,"0x%02x (%u)   ",*(edspace+pos+1),*(edspace+pos+1));
  				move(1,19); aaddstr(tmp,CLR_STAT);
  sprintf(tmp,"0x%02x (%u)   ",*(edspace+pos+2),*(edspace+pos+2));
  				move(1,31); aaddstr(tmp,CLR_STAT);
  sprintf(tmp,"0x%02x (%u)   ",*(edspace+pos+3),*(edspace+pos+3));
  				move(1,43); aaddstr(tmp,CLR_STAT);
  sprintf(tmp,"0x%04x (%u)    ",UPTC(char)(edspace+pos) | UPTC(char)(edspace+pos+1)<<8,
      			     UPTC(char)(edspace+pos) | UPTC(char)(edspace+pos+1)<<8);/* any more elegant solve of this problem ?!?*/
  								   /*       see bellow UPTC */
                                move(1,62); aaddstr(tmp,CLR_STAT); /*       actual ints */
  sprintf(tmp,"0x%04x (%u)    ",UPTC(char)(edspace+pos+2)|UPTC(char)(edspace+pos+3)<<8, 
				UPTC(char)(edspace+pos+2)|UPTC(char)(edspace+pos+3)<<8);
  				move(1,77); aaddstr(tmp,CLR_STAT); /* acutal ints */
  sprintf(tmp,"0x%08lx #%-10lu",UPTC(long)(edspace+pos),UPTC(long)(edspace+pos)); /* else (uniform dec. image) supercomplicate :( */
                                move(1,103); aaddstr(tmp,CLR_STAT);/*       actual long */
  refresh();
  return 0;
}

