 /** hexedit.c - 08/12/99 - v0.21 - by Pasky - and for Linux - more questions? - e-mail to pasky@libra.sinus.cz! ***\
 /==================================================================================================================/
 *     HexEditor - programmer's hexadecimal editor with integrated calculator
 *     Copyright (C) 1999  Petr Baudis <pasky@libra.sinus.cz>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 \==================================================================================================================\
 *														    * F
 *    This file is protected by the GPL. Please read beggining of some system header file and imagine it	    *  R
 *  is written here... No distribution to system not containing GPL allowed.					    * E
 *														    *  E
 *    And what is it? An useful hexadecimal editor with color support, small notetab and many more... But it is	    * D
 *  in an evolution! If you want to help me, please contact me at hexedit@libra.sinus.cz. Any suggestions or	    *  O
 *  bug-reports please mail to hexedit-bugs@libra.sinus.cz...							    * M
 *														    *
 *    Yes, I think there is a lot of better and more nice hexadecimal programmer editors - but I didn't have	    * I
 *  anyone, so I started developing this ugly one. But it is small and... my!					    *  N
 *														    *
 *    Please rembember my english is horrible and this is practically my first bigger project in C.                 *  T
 *  So I'll welcome all comments about it, any optimalizations, extensions, etc...				    * H
 *      													    *  E
 \******************************************************************************************************************/

 /******************************************************************************************************************\ I
 *   Copyright (c) 1999  Pasky [Sirius Labs]; Thanks for help with linux and adding to his distribution to Patrol   *  N
 *   														    * T
 *   If you want to join programmers's team Sirius Labs, please mailto: pasky@libra.sinus.cz; If you want to see    *  E
 *   the list of our actual projects and members of team, please visit http://tangens.sinus.cz/~pasky/ (not yet,    * R
 *   if you want to visit my homepage, fly.to/pasky). 								    *  N
 *														    * E
 *   Actual members: Pasky [pasky@libra.sinus.cz] Silp [silp@pruvodce.cz] Charley [charley@pruvodce.cz]		    *  T
 \******************************************************************************************************************/ 

/************************************************************************************\
\/===================================================================================/
 *   What is the HexEdit???
 *
 *  New very interesting and useful program, especially for system programmers and
 * developers needing some very useful features of program. It is written by one ;-) 
 * but he don't know to speak english enough :-( and he'll welcome all ideas from
 * others.
 *
 *   Overview of HexEdit's features
 *
 *  - HexEdit is fully free program, protected by General Public License
 *  - HexEdit is program yet especially for developers understanding the C-code,
 *    having ability to send me any idea or bug-report, and having min. 132-column
 *    display (yet, but I want to make short-screen option - note that only
 *    header needs it, main view could work on 80-columns display too... - but
 *    I didn't test it) - so you migth have problen even you've xt*rm...
 *  - HexEdit is only in __developing__ and __alpha__ state! I didn't test it
 *    anywhere outside my system... There's no other person developing it yet
 *  - HexEdit is developed on Linux to Linux - there's no ports yet
 *    (but if you want to do any, I will welcome your work :-)
 *  - HexEdit allows you to edit (creating not implemented yet :-[ ) any
 *    (especially binary) file in hexadecimal or ASCII form (column)
 *  - HexEdit allows you to move in the file by pressing arrows and PgUp+PgDwn
 *  - HexEdit is displaying nice header on the screen, containing file name,
 *    current offset and values under the cursor (in various sizes) - all the
 *    numbers in hex. and dec. form - and now he could teel you about percentual
 *    position in your file and if you modify your file after the last save!
 *  - HexEdit could load the file by passing it as parameter, it faults other way
 *  - HexEdit could save the file by pressing F2
 *  - HexEdit could eof (new verb :-) the file anywhere by pressing F5, and
 *    indicates that you are past eof by '+' sign near the offset
 *  - HexEdit could exit everytime by pressing Esc (it asks you if you want to
 *    save your file if you modified it)
 *  - HexEdit contains integrated simple hexadecimal calculator (F8), allowing
 *    basic commands (+, -, *, /, =), editing the number, changing the num. base
 *    by pressing hot-keys printed under the input field and browsing by up/down
 *    arrows the history... 'Tab' or 'Esc' returns back to hexedit
 *  - HexEdit now can insert numbers from calculator to file and from file to
 *    calculator too, now with properly handling the size of number...
 *  - HexEdit now seems to be able to find & replace hex/ascii strings via
 *    F7/F6 - normally it searches ASCII strings, but if you wannt to find hex
 *    ones, simply write them into the calculator and press F7
 *  - HexEdit is perspective and interesting program ;-)
 *
 *    How to install HexEdit?
 *
 *  - HexEdit doesn't need any installation - but if you want, you can do it
 *  - HexEdit installation only copies executable (bin/hexedit) and manual page
 *    to common locations (/usr/bin;/usr/man)
 *  - If you want to run install procedure, first edit and customize the root
 *    Makefile (especially directory variables and target install)
 *  - Now run from root hexedit's directory 'make install'
 *  - All the files will be copied to selected locations
 *  - If you want to 'uninstall' hexedit, you must do it handly - but it is not
 *    any big work, only look at Makefile where was the files copied to and
 *    remove it (it is only two files for now copied anywhere to the public dirs)
 *
\************************************************************************************/

/************************************************************************************\
 *   History of hexedit:  * v0.3  - more recomposition, new 2 files spawned         *
 *   				  - new display organisation due to expanding 64kb  *
 *   				    limit					    *
 *   				  - yes, that announce you saw on freshmeat is	    *
 *   				    announcement of this one			    *
 *   				  - no, not smaller displays solution yet, but now  *
 *   				    the program analyses its parameters and could   *
 *   				    make a new file				    *
 *   				  - some small corections			    *
 *   			  * v0.21 - hardly recomposed, code is separed to several   *
 *                                  files and header files are made - so I wrote    *
 *                                  my first and second makefile :-)                *
 *                                - many minor changes and fixes of source codes    *
 *                                  (made more readable)                            *
 *                                - base configuration is in separate               *
 *                                  easy-to-change header file config.h             *
 *                                - percentual position pointer near the offset     *
 *                                - warning when exiting with non-saved file        *
 *                                - indicator of modification of file after last    *
 *                                  save - it looks as asterisk near offset         *
 *                                - calculator now right handles typing of numbers  *
 *                                  ofter bases than decimal                        *
 *                                - and length limit of number at calculator is     *
 *                                  now dynamic for every base                      *
 *                                - calculator now could insert its result to the   *
 *                                  file and load number from file to calculator    *
 *                                - fixed buggy displaying of 8-bit characters (or  *
 *                                  higher) - now there's substitued by a point on  *
 *                                  status line                                     *
 *                                - manual page attached                            *
 *                                  						    *
 *   			  * v0.2  - fixed some bugs in switching hex/ascii columns  *
 *                                - added small hexadecimal calculator - it seems   *
 *                                  really working! 3 numeric bases supported (dec, *
 *                                  oct and hex), and binary is preparing... Basic  *
 *                                  numeric functions implemented (+-/*= ;-) and    *
 *                                  10-results history is working. Wonderful! :-)   *
 *                                - heading of this file and its structure is       *
 *                                  little improved (some functions moved, this     *
 *                                  history written :-)                             *
 *                                - this is first really released version (I post   *
 *                                  previous only to patrol)                        *
 *                                                                                  *
 *                        * v0.1  - first real version of hexedit - functional      *
 *                                  editing of first 64kb segment of program (-0x10 *
 *                                  last line bug ;-), hexadecimal and ascii        *
 *                                  column, color nice interface, saving of files,  *
 *                                  ability to mark the end of file and the plus    *
 *                                  sign near the offset to indicate it, displaying *
 *                                  title bar with base numbers view, big space     *
 *                                  at the right :-). Big plans to future ;-).      *
 *										    *
\************************************************************************************/

/*************************************************************************************\
 *   Plans to improve for next version with highest priority:                        *
 *   - make editable large files (minimally 4 Gb ;) - I think that I'll implement    *
 *     paging-on-demand 64kb segments of file (and saving paged-out but modified     *
 *     segments to temporary file or better to other places in memory), because it   *
 *     looks nice and simple (looks that not big changes of the code is needed :-)   *
 *   - solution of the last-line bug, if possible?                                   *
 *   - allow creating of new files, intelligent reaction to no parameter given :-)   *
 *   - make possible to work with it in smaller displays, especially on xterm...     *
 *   - key hints and my sign on the display :-)                                      *
 *   - really release it to the whole world!!! (freshmeat.net, etc... :-)            *
 *   - something more?                                                               *
\*************************************************************************************/

/*************************************************************************************\
 * -----------------------------------------------------------------[KNOWN BUGS]---- *
 * + last line bug - the last line of 64kb segment is not displayed - it is possible *
 *                   to move into it and from it, and piece where you move to        *
 *                   'unhides' and looks normally - but separator and offset is      *
 *                   never displayed - this is the main bug of the HexEdit ;)        *
 * + segfault on startup - if there's no parameter given or file given as parameter  *
 *                         not exist, segfault occured - this error is known and I   *
 *                         plane to fix it in new version (+ intelligent proceeding  *
 *                         of parameters will be implemented too, see plans above    *
 * + color char. displaying - into the header of the screen, if 'under cursor'       *
 *                            is some high character (e.g. unicode etc.), there's    *
 *                            some ugly blinking char - I think this is bug of the   *
 *                            curses library and it is caused by system of attrs     *
 *                            passing to the chars :( - I think there's no way to    *
 *                            fix it, but I'll welcome any suggestion about it.      *
 *                            Now I soluted it by declaring two macros for           *
 *                            substitution of chars, one for status bar and one for  *
 *                            ASCII bar. If you want to see how seems this bug,      *
 *                            uncomment SUBST_UPP_CHARS at PRSCHAR() macro.          *
 * + header line is not true always - I won't actualize version number and date      *
 *                                    in every version in files that aren't changed, *
 *                                    I think - please refer to this file to actual  *
 *                                    date of change or version (fixed from v0.21)   *
 * + need at least 132 columns - this program is designed for large textmodes and    *
 * 				 if the display is smaller than 132 columns, the     *
 * 				 line 'overflows' and it looks really ugly :). This  *
 * 				 is bad especially because it doesn't fit to xterms, *
 * 				 so running hexedit in x-windows is very difficult.  *
 * 				 It needs make possibility to (re)move some fields   *
 * 				 if too small display is detected.		     *
 * + it is too slow - yes, the reaction of program e.g. if you end pushing a         *
 *                    scrolling key is not fast how I want, it looks to need some    *
 *                    more optimalizations :)                                        *
 * + my english - there's no way to fix it for now :)                                *
 *                                                                                   *
 * There is no more bugs known now, so I'll welcome any feedback! Thanks...          *
 * Yes, you can see that with new versions, some bugs are new and nothing	     *
 * is gone... :)   								     *
\*************************************************************************************/

 /******************************************************************************************************************\
 *														    *
 *   TODO for next versions: - solution of the last line bug							    *
 *   			     - optimalize redraw_no and functions calling from it to be more faster                 *
 *   			     - make notetab functional								    *
 *   			     - make small clipboard with notetab (pasting a data from and to notetab)		    *
 *   			     - more than first ffffh bytes editable!						    *
 *   			     - online options ('.' substitution, status bar opt., notetab options)		    *
 *   			     - some other integrated utilites? (more improving of hex. calculator?)		    *
 *   			     - help?!?										    *
 *   			     - better organization of writing past eof!?!                                           *
 *   			     - better source code								    *
 *   			     - multiple files (source and doc.) + better makefile				    *
 *														    *
 \******************************************************************************************************************/

/****************************************************************************\
 * Last note: please ignore every TODO for notetab, it is obsolete because  *
 * it looks notetab'll be handled in completely separated statement...      *
\****************************************************************************/

#include<curses.h>
#include<ctype.h>
#include<string.h>
#include<stdlib.h>

#include<hexedit.h>
#include<calculator.h>
#include<config.h> /* configuration saved in include file */

/*************** ALL THE CONFIGURATION ARE NOW SAVED IN THE FILE CONFIG.H *****************/

/************ Please see coments and better declaration of these in hexedit.h *************/

int scrlimit=LINES;
int startpos=0; 
int scrstart=2; 
int actcolumn=0; /* 0 = Hex; 1 = ASCII; (2 = Notetab, will be? I think no...) */
int modified=0; /* flag that file is modified */
char filename[256];
long pos=0,filesize=0; 

char cpole[]={'0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F','\0'}; /* hex<->dec conversion */
unsigned char edspace[limit]; /* main array - small definition, big size */
int separator[]={0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}; /* temporary array for handling of a possible overflowing of the edspace */
WINDOW *s; /* my screen */

/*
 * Called in some mysterious situations; writes an error message and aborts.
 */

int
oops(int which) /* 0123 used yet */
{ /*char tmp[132];*/
  endwin(); /* to rest the terminal usable :) */
  fprintf(stderr,"Oops! Unknown powers're online/someone is hacking da hackers by error %d!\n",which); /* WoW! ;) */
  exit(255-which); /* or abort() ?!?*/
  return 0; /*?!?!?!*/ }

/*
 * Loads a file to the array.
 */
int
readfile(FILE *f)
{ /*int x,c;*/ fseek(f,0,SEEK_SET);
  fread(edspace,filesize,1,f);
  modified=0;
  /*for (x=0;((c=getc(f)) != EOF) && (x<limit);x++)
    edspace[x]=(unsigned char)c;*/ /* old code, why? */
  return 0;
}

/*
 * Saves the array to a file.
 */
int
savefile(char *name)
{ FILE *f;
  f=fopen(name,"wb");
  fwrite(edspace,filesize,1,f);
  fclose(f);
  modified=0;
  return 0;
}

/*
 * 
 * Main program:
 * 
 * - initialization
 * - never ending loop with key handler, cursor position calculator, etc
 * - anything more?!?
 *
 */

int main(int argc, char *argv[])
{
  int mpos=0,inkey,y,x,pp; /* pos. in hex. num, inkey, y and x position temporaries, temp. for redrawing an actual bytes... */
  unsigned char c,d;
  FILE *f; char tmp[133];

  printf("Please wait while loading (if the segfault received, check the 1st attributte!)...\n");
  
  if (argc<1) oops(254); 
  strcpy(filename,argv[1]);
  f=fopen(filename,"rb"); /* we don't check a file exists! happy segfaults... :) */
  fseek(f,0,SEEK_END); filesize=ftell(f); 
  readfile(f);
  fclose(f);
  
  s=initscr();
  cbreak(); noecho(); nonl();
  intrflush(s,FALSE);
  keypad(s,TRUE);
  start_color();
  init_pair(BASE,COLOR_WHITE,COLOR_BLACK);
  init_pair(STAT,COLOR_YELLOW,COLOR_BLUE); /* warning! on some cards this could mean ugly brown! see 'man curs_color'... */
  init_pair(ERRD,COLOR_YELLOW,COLOR_RED);  /* e. g. on my :) (I think"other cards"(where c_y==c_y) means CGA etc. :(*//* here too */
  init_pair(ACTU,COLOR_YELLOW,COLOR_BLACK);/* ugly, if you know any better, let me know... */
  
  redraw();

  /*move(0,0); filltoeol(CLR_STAT);*//* we actually don't need to do this, because a status line string do it automatic*/
  sprintf(tmp,"\
 Filename:\t\t\t\t\t\tOffset: \t\t\t\tUnder cursor:\t\t\t    ");
  move(0,0); aaddstr(tmp,CLR_STAT);
  sprintf(tmp,"\
 Char:\t\t\t\t\t\t\tInt:\t\t\t\t\tLong:\t\t\t\t    ");
  move(1,0); aaddstr(tmp,CLR_STAT);
/*        			       		      										
 Filename:						Offset: 0x00000 (......)		Under cursor: '.' (#...	0x..)	
 Char: 0x.. (...)  0x.. (...)  0x.. (...)  0x.. (...)	Int: 0x0000 (65535) 0x0000 (65535)	Long: 0x00000000 (4293918720)
 */

  calc_draw();
  
  actua();
  
  while (1==1)
  {
    y=(pos-startpos)/numbers_on_line+scrstart;
    x=!actcolumn?7+mpos+((pos%numbers_on_line)*3)+((pos%numbers_on_line)/16*2):9+(numbers_on_line)*3+pos%numbers_on_line;
      /* TODO: Modify code bellow for handle NoteTab value 2 (only for 2 values now :[) */
    move(y,x); /* go to x,y position */
    refresh();
    
    switch (inkey=getch()) {
      case '\033'   : testmodify(); endwin(); printf("\n"); return 0; /*... and to be nice: */ break; /* yahoo! */
      case KEY_LEFT : pp=pos; if ((!actcolumn?mpos==0:1) && pos>=1) {pos--; if (!actcolumn) mpos++;} else
		      if (mpos==1) mpos--; actua(); if (pos-startpos<0)
		      { startpos-=numbers_on_line; redraw(); } /* TODO: modify if for NTab! */
		      redraw_no(pos); redraw_no(pp);
			break;
      default       : modified=1;
		      switch (actcolumn) {
			case 0 : if ((inkey>='0' && inkey<='9') || (toupper(inkey)>='A' && toupper(inkey)<='F'))
				 { c=((edspace[pos] & (mpos?0xF0:0x0F)));
				   d=tohexa (toupper(inkey)) << (4*(1-mpos));
				   edspace[pos]=(c | d);
				   redraw_no(pos); } else tmp[7]=''; break;
			case 1 : edspace[pos]=inkey; /* TODO: check this isn't buggy */ 
				 redraw_no(pos); break;
			case 2 : /* Future is coming on! */
			default: oops(3); }
		      if (tmp[7]=='') { tmp[7]--; break; }/* without s(actpos) the life would be more happy... */
		      else if (pos>=filesize) filesize=pos+1; /* handle write after end of file */
      case KEY_RIGHT: pp=pos; if ((!actcolumn?mpos==1:1) && pos<limit) {pos++; if (!actcolumn) mpos--;} else
		      if (mpos==0) mpos++; actua(); if (pos-startpos>scrlimit*numbers_on_line)
		      { startpos+=numbers_on_line; redraw(); }
		      redraw_no(pos); redraw_no(pp); /* TODO: mif NT */
			break;
      case KEY_UP   : pp=pos; if (pos>=numbers_on_line) pos-=numbers_on_line; actua();
		      if (pos-startpos<0) { startpos-=numbers_on_line; redraw(); }
		      redraw_no(pos); redraw_no(pp);
			break;
      case KEY_DOWN : pp=pos; if (pos<limit-numbers_on_line) pos+=numbers_on_line; actua();
		      if (pos-startpos>scrlimit*numbers_on_line) { startpos+=numbers_on_line; redraw(); }
		      redraw_no(pos); redraw_no(pp);
			break;
      case KEY_NPAGE: pos+=scrlimit*numbers_on_line; if (pos>limit) pos=limit; /* FIXME: THERE IS A BUG AND I KNOW IT! */
		      startpos+=scrlimit*numbers_on_line; if (startpos+1+scrlimit*numbers_on_line>limit)
		      startpos=limit-scrlimit*numbers_on_line+1; startpos-=startpos%numbers_on_line; redraw(); actua();
			break;                                   /* if you want to know why, try to go to the last line of file! */
      case KEY_PPAGE: pos-=scrlimit*numbers_on_line; if (pos<0) pos=0;
		      startpos-=scrlimit*numbers_on_line; if (startpos<0) startpos=0; redraw(); actua();
			break;
      case 9        : if (actcolumn!=2)
			actcolumn=!actcolumn;
		      else { /* make classic tab char or some function... */ }
			break;
      case KEY_F(2) : savefile(filename); actua(); break; /* save the file */
      case KEY_F(5) : filesize=pos; actua(); break; /* put there the EOF */
      case KEY_F(7) : break;
      case KEY_F(8) : calculator(); break; /* hexcalc */
      case KEY_F(9) : /* Options, not yet */ break;
    }
  }
  oops(0);
} /* brrr.... */
