  /** hexedit.c - 08/12/99 - v0.21- by Pasky - and for Linux - more questions? - e-mail to pasky@libra.sinus.cz! ***\
  /=================================================================================================================/
  *     HexEditor - programmer's hexadecimal editor with integrated calculator
  *     Copyright (C) 1999  Petr Baudis <pasky@libra.sinus.cz>
  *
  *     This program is free software; you can redistribute it and/or modify
  *     it under the terms of the GNU General Public License as published by
  *     the Free Software Foundation; either version 2 of the License, or
  *     (at your option) any later version.
  *
  *     This program is distributed in the hope that it will be useful,
  *     but WITHOUT ANY WARRANTY; without even the implied warranty of
  *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  *     GNU General Public License for more details.
  *
  *     You should have received a copy of the GNU General Public License
  *     along with this program; if not, write to the Free Software
  *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  *
  \==================================================================================================================\
  *                                                                                                                  * F
  *    This file is protected by the GPL. Please read beggining of some system header file and imagine it            *  R
  *  is written here... No distribution to system not containing GPL allowed.                                        * E
  *                                                                                                                  *  E
  *    And what is it? An useful hexadecimal editor with color support, small notetab and many more... But it is     * D
  *  in an evolution! If you want to help me, please contact me at hexedit@libra.sinus.cz. Any suggestions or        *  O
  *  bug-reports please mail to hexedit-bugs@libra.sinus.cz...                                                       * M
  *                                                                                                                  *
  *    Yes, I think there is a lot of better and more nice hexadecimal programmer editors - but I didn't have        * I
  *  anyone, so I started developing this ugly one. But it is small and... my!                                       *  N
  *                                                                                                                  *
  *    Please rembember my english is horrible and this is practically my first bigger project in C.                 *  T
  *  So I'll welcome all comments about it, any optimalizations, extensions, etc...                                  * H
  *                                                                                                                  *  E
  \******************************************************************************************************************/
  
  /********************************************************\
   * Please see main file (hexedit.c) or attached files   *
   * to get any more informations (TODO, features, etc.). *
  \********************************************************/

#ifndef HEXEDIT_CONFIG_H
#define HEXEDIT_CONFIG_H
  
/* -- colors -- */

/* base ID definitions */
#define	BASE	1 /* edit area */
#define	STAT	2 /* status lines */
#define	ERRD	3 /* error dialog */
#define ACTU	4 /* acutal char */

/* only raw values, I think never'll be used */
#define COL_BASE	COLOR_PAIR(BASE)
#define	COL_STAT	COLOR_PAIR(STAT)
#define	COL_ERRD	COLOR_PAIR(ERRD)
#define COL_ACTU	COLOR_PAIR(ACTU)

/* highlighted, mostly recommended */
#define CLR_BASE	(COL_BASE) /* somebody like lighter font (then enable '| A_BOLD') */
#define CLR_STAT	(COL_STAT | A_BOLD)
#define CLR_ERRD	(COL_ERRD | A_BOLD)
#define CLR_ACTU	(COL_ACTU | A_BOLD)

/* and foreground and background */ /********** EDIT THIS BY YOUR MIND, PLEASE ***********/
#define CLR_BASE_F	COLOR_WHITE
#define CLR_BASE_B	COLOR_BLACK
#define CLR_STAT_F	COLOR_YELLOW
#define CLR_STAT_B	COLOR_BLUEe
#define CLR_ERRD_F	COLOR_YELLOW
#define CLR_ERRD_B	COLOR_RED
#define CLR_ACTU_F	COLOR_YELLOW
#define CLR_ACTU_B	COLOR_BLACK

/* -- colors end -- */

  
#define numbers_on_line	0x10  /* 32 doesn't fit to my display with an ASCII bar *//* and 24 is too... hmm... 'unorientable' :) */
#define limit		0xfffff /* wow! :) */ /* debugged with this, I don't try anything other! */


/*
 * Macro for subst. ugly chars with '.' - here is a lot of place for customization.
 * You can enable/disable some levels of substitution by your mind...
 * (for enable, uncomment SUBST_UPP_CHARS if you don't want to printing 8-bit characters)
 */

#define SAP(z)		(unsigned char)*(edspace+z+0)
#define SUBST_LOW_CHARS(z)	(SAP(z)<32)
#define	SUBST_WHT_CHARS(z)	(SAP(z)==0 || SAP(z)==255)
#define	SUBST_UPP_CHARS(z)	(SAP(z)>127) /* FIXME! A problem (I think a ncurses bug) occurs when displaying
					        with CLR_STAT - it fade out to blinking blue char on black :-\ */
#define SUBST_127_CHAR(z)	(SAP(z)==127 || SAP(z)==0x09b) /* added strange 0x09b, making errors */
/* Characters on status line ( - with background) */
#define	PRSCHAR(z)	(SUBST_LOW_CHARS(z) || SUBST_WHT_CHARS(z) || SUBST_127_CHAR(z) || SUBST_UPP_CHARS(z))?'.':SAP(z)
/* Characters in file ( - on black) */
#define PRCHAR(z)	(SUBST_LOW_CHARS(z) || SUBST_WHT_CHARS(z) || SUBST_127_CHAR(z) || SUBST_UPP_CHARS(z))?'.':SAP(z)

#define UPTC(zz)	*(unsigned zz *) /* macro for say compiler about get value greater than char */

/** CALCULATOR IDs, should not be changed... **/
  
#define DECIMAL 10 /* decimal numeric base */
#define HEXADECIMAL 16 /* hex. */
#define OCTAL 8 /* oct. */
#define BINARY 2 /* bin. (not yet supported) */

#define CALC_FIELD_SIZE 12
#define CALC_HIST_DEPTH 10 /* depth of calculator's history */ /*** DO YOU WANT MORE? THEN INCREASE IT... ***/

#define LINES 23 /* on the screen; length of file's view */

#endif /* HEXEDIT_CONFIG_H */
