  /** hexedit.c - 08/12/99 - v0.2 - by Pasky - and for Linux - more questions? - e-mail to pasky@libra.sinus.cz! ***\
  /=================================================================================================================/
  *     HexEditor - programmer's hexadecimal editor with integrated calculator
  *     Copyright (C) 1999  Petr Baudis <pasky@libra.sinus.cz>
  *
  *     This program is free software; you can redistribute it and/or modify
  *     it under the terms of the GNU General Public License as published by
  *     the Free Software Foundation; either version 2 of the License, or
  *     (at your option) any later version.
  *
  *     This program is distributed in the hope that it will be useful,
  *     but WITHOUT ANY WARRANTY; without even the implied warranty of
  *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  *     GNU General Public License for more details.
  *
  *     You should have received a copy of the GNU General Public License
  *     along with this program; if not, write to the Free Software
  *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  *
  \==================================================================================================================\
  *                                                                                                                  * F
  *    This file is protected by the GPL. Please read beggining of some system header file and imagine it            *  R
  *  is written here... No distribution to system not containing GPL allowed.                                        * E
  *                                                                                                                  *  E
  *    And what is it? An useful hexadecimal editor with color support, small notetab and many more... But it is     * D
  *  in an evolution! If you want to help me, please contact me at hexedit@libra.sinus.cz. Any suggestions or        *  O
  *  bug-reports please mail to hexedit-bugs@libra.sinus.cz...                                                       * M
  *                                                                                                                  *
  *    Yes, I think there is a lot of better and more nice hexadecimal programmer editors - but I didn't have        * I
  *  anyone, so I started developing this ugly one. But it is small and... my!                                       *  N
  *                                                                                                                  *
  *    Please rembember my english is horrible and this is practically my first bigger project in C.                 *  T
  *  So I'll welcome all comments about it, any optimalizations, extensions, etc...                                  * H
  *                                                                                                                  *  E
  \******************************************************************************************************************/
  
  /********************************************************\
   * Please see main file (hexedit.c) or attached files   *
   * to get any more informations (TODO, features, etc.). *
  \********************************************************/

#include<stdio.h>
#include<stdlib.h>
#include<ctype.h>
#include<string.h>
#include<curses.h>
#include<hexedit.h>
#include<calculator.h>
  
/***********************************************************
 * CALCULATOR BLOCK
 *
 * TODO: - Especially add support of binary numeric base!
 *       - Make UI more friendly...
 *       - Add possibility to insert result to file!
 *       - Extend form of numbers for other platforms?
 *       - Any other?
 */

unsigned int
calc_space=CALC_FIELD_SIZE, /* length of the field for numbers */
calc_result=0, /* last result of calculator */
calc_base=DECIMAL; /* current numeric base */
char
*calc_suffixes[18]={"",""," &","","","","",""," 0",""," #","","","","","","0x",""}, /* suffixes for each num. base */
calc_hotkeyz[18]={"\1\001\01\01\01\01\01\001O\001I\01\01\01\01\001H\0"}, /* used for determining base's hotkey */ /*bin=N*/
calc_conv[18]={"\0\0d\0\0\0\0\0o\0d\0\0\0\0\0x\0"}, /* converses for printf for each base */
calc_opkeyz[7]={"+-/*=\r\0"}; /* keyz of allowed operations */
int
calc_not_used_1[2]={0,0}, /* to handle of possible underflowing... (note that this is source!) */
history[CALC_HIST_DEPTH]={0,0,0,0,0,0,0,0,0,0}, /* history of the results */
hist_pos=0, /* position in the history */
calc_max_digits[18]={0,0,12,0,0,0,0,0,10,0,9,0,0,0,0,0,8,0}; /* digits number limits for each num. base */
 
/*
 * Refreshes the calculator's input array and base suffix
 */
void
calc_actua(void)
{
  char tmp[133],tmp2[133];
  sprintf(tmp,"%%-%dl%c",calc_space,calc_conv[calc_base]);
  sprintf(tmp2,tmp,calc_result);
  move(3,100);
  aaddstr(tmp2,CLR_STAT);
  move(3,98);
  aaddstr(calc_suffixes[calc_base],CLR_BASE );
  /*addch(calc_suffixes[calc_base] | CLR_BASE );*/
}

/*
 * Refreshes the calculator's "window" and the place around
 */
void
calc_draw(void)
{
  char tmp[133];
  sprintf(tmp,"Hex. calculator: ");
  move(3,80);
  aaddstr(tmp,CLR_BASE);
  calc_actua();
  sprintf(tmp,"%c = decimal  %c = octal  %c = hexadecimal  R = reset",
      calc_hotkeyz[DECIMAL],
      calc_hotkeyz[OCTAL],
      calc_hotkeyz[HEXADECIMAL]);
  move(4,80);
  aaddstr(tmp,CLR_BASE);
  move(5,80);
  aaddstr("P = put result to the file",CLR_BASE);
  move(6,80);
  aaddstr("G = get char from the file",CLR_BASE);
  move(7,80);
  aaddstr("Y = get int from the file",CLR_BASE);
  move(8,80);
  aaddstr("L = get long from the file",CLR_BASE);
}

int
calc_inrange(char what)
{
  return calc_base==DECIMAL?isdigit(what):
         (calc_base==HEXADECIMAL?isxdigit(what):
	  (calc_base==OCTAL?(isdigit(what) && what<'8'):oops(2)));
}

int /* I'm sorry for this function, it had only an historical meaning... */
calc_todec(char what)
{
  /*char xlat[17]=("0123456789ABCDEF\0");*/
  return calc_base==DECIMAL || calc_base==OCTAL?(isdigit(what)?what:'0'):
         (calc_base==HEXADECIMAL?(isxdigit(what)?/*strchr(xlat,toupper(*/what/*))-xlat*/:'0'):'0');
}

int /* Warning! Controlled underflowing here! */
calc_shift_hist(void)
{
  int q;
  for (q=CALC_HIST_DEPTH-2;q>=0;q--) history[q+1]=history[q];
  history[0]=0; /* to be sure... */
  return 0;
}

int
calc_eval(int operand1, int operator, int operand2)
{
  switch (operator) {
    case 0 : return operand1+operand2; /*add*/
    case 1 : return operand1-operand2; /*sub*/
    case 2 : return operand1/operand2; /*mul*/
    case 3 : return operand1*operand2; /*div*/
    case 4 :
    case 5 : return operand2;
    default : return 0; }
}

int
calculator(void)
{
 unsigned int
   position=0, /* position on the line */
   last_op=0, /* last operation (index in calc_opkeyz) */
   key_temp, inkey, residuum=0, digits=0;
 char
    tmp[133], tmp2[133];
  while (1==1) {
    calc_actua();
    history[hist_pos]=calc_result; /* refresh history */
    if (position>digits) position=digits;
    move(3,100+position);
    switch (inkey=getch()) {
      case 9        :
      case '\033'   : return calc_result; /*... and to be nice: */ break; /* yahoo!*/
      case KEY_LEFT : if (position>0) position--; break;
      default       : if (calc_inrange(toupper(inkey)) && (!residuum?digits:0)<calc_max_digits[calc_base]) {
			if (residuum) { calc_shift_hist(); calc_result=0; position=0; digits=0; hist_pos=0; residuum=0; }
			calc_result=history[hist_pos];
			sprintf(tmp2,"%%%c",calc_conv[calc_base]);
			sprintf(tmp,tmp2,calc_result); /* 10 */
			if (!strcmp(tmp,"0")) strcpy(tmp,"");
			strncpy(tmp2,tmp,position);
			tmp2[position]=calc_todec(inkey);
			tmp2[position+1]=0;
			strcat(tmp2,tmp+position);
			sprintf(tmp,"%%%c",calc_conv[calc_base]); if (tmp2[0]==0) strcat(tmp2,"0");
			sscanf(tmp2,tmp,&calc_result);
			digits=strlen(tmp2); /* I know that digits++ looks more effective, but
					        this expression avoids a lot of problems with
					        inconsistence in digits variable... */ } else
		      if ((key_temp=strchr(calc_hotkeyz,toupper(inkey))))
		      { calc_base=key_temp-(int)calc_hotkeyz;
			sprintf(tmp2,"%%%c",calc_conv[calc_base]);
			sprintf(tmp,tmp2,calc_result);if (!strcmp(tmp,"0")) strcpy(tmp,"");
			digits=strlen(tmp); break; } else
		      if ((key_temp=strchr(calc_opkeyz,toupper(inkey)))) {
			calc_result=history[hist_pos]; history[0]=calc_result; hist_pos=0;
			calc_shift_hist(); calc_result=calc_eval(history[2],last_op,history[1]);
			last_op=key_temp-(int)calc_opkeyz; position=0; residuum=1;
			sprintf(tmp2,"%%%c",calc_conv[calc_base]);
			sprintf(tmp,tmp2,calc_result);if (!strcmp(tmp,"0")) strcpy(tmp,"");
			digits=strlen(tmp); break; } else
		      if (toupper(inkey)=='R') {
			for (hist_pos=CALC_HIST_DEPTH;hist_pos>0;hist_pos--) history[hist_pos]=0;
		        calc_result=0; position=0; last_op=0; digits=0; break; } else
		      if (toupper(inkey)=='P') { /* note that this code is i386-specific!!! */ /* 0123 */
			if (calc_result>0xffffff && pos>2) { edspace[pos]=*((unsigned char *)(&calc_result)+3);
			                                  edspace[pos-1]=*((unsigned char *)(&calc_result)+2);
							  edspace[pos-2]=*((unsigned char *)(&calc_result)+1);
			                                  edspace[pos-3]=*((unsigned char *)(&calc_result)+0); } else
			if (calc_result>65535 && pos>1) { edspace[pos]=*((unsigned char *)(&calc_result)+2);
			                                  edspace[pos-1]=*((unsigned char *)(&calc_result)+1);
							  edspace[pos-2]=*((unsigned char *)(&calc_result)+0); } else
			if (calc_result>256 && pos>0) { edspace[pos-1]=*((unsigned char *)(&calc_result)+0);
			      				edspace[pos]=*((unsigned char *)(&calc_result)+1); } else
			edspace[pos]=*((unsigned char *)(&calc_result)+0);
			/* yes, this is horrible, but I didn't find any more simple method :-( */
			modified=1; redraw(); actua(); break; } else
		      if (toupper(inkey)=='G') { calc_shift_hist(); calc_result=*(((char *)&edspace)+pos);
			sprintf(tmp,"%%%c",calc_conv[calc_base]); if (tmp2[0]==0) strcat(tmp2,"0");
			sprintf(tmp2,tmp,calc_result);
			digits=strlen(tmp2); history[0]=calc_result; break; } else
		      if (toupper(inkey)=='Y') { calc_shift_hist(); calc_result=*(int *)((char *)&edspace+pos);
			*(((char *)&calc_result)+2)=0; *(((char *)&calc_result)+3)=0;
			sprintf(tmp,"%%%c",calc_conv[calc_base]); if (tmp2[0]==0) strcat(tmp2,"0");
			sprintf(tmp2,tmp,calc_result);
			digits=strlen(tmp2); history[0]=calc_result; break; } else
		      if (toupper(inkey)=='L') { calc_shift_hist(); calc_result=*((long *)((char *)&edspace+pos));
			sprintf(tmp,"%%%c",calc_conv[calc_base]); if (tmp2[0]==0) strcat(tmp2,"0");
			sprintf(tmp2,tmp,calc_result);
			digits=strlen(tmp2); history[0]=calc_result; break; } else
		      break;
      case KEY_RIGHT: if (position<digits) position++; break;
      case KEY_UP   : if (hist_pos<CALC_HIST_DEPTH-1) { hist_pos++; calc_result=history[hist_pos];
		      sprintf(tmp2,"%%%c",calc_conv[calc_base]);
		      sprintf(tmp,tmp2,calc_result);if (!strcmp(tmp,"0")) strcpy(tmp,"");
		      digits=strlen(tmp); position=0; } break;
      case KEY_DOWN : if (hist_pos>0) { hist_pos--; calc_result=history[hist_pos];
		      sprintf(tmp2,"%%%c",calc_conv[calc_base]);
		      sprintf(tmp,tmp2,calc_result);if (!strcmp(tmp,"0")) strcpy(tmp,"");
		      digits=strlen(tmp); position=0; } break;
      case KEY_DC   : calc_result=history[hist_pos];
		      sprintf(tmp2,"%%%c",calc_conv[calc_base]);
		      sprintf(tmp,tmp2,calc_result); /* 10 */
		      strncpy(tmp2,tmp,position);
		      tmp2[position]=0;
		      strcat(tmp2,tmp+position+1);
		      sprintf(tmp,"%%%c",calc_conv[calc_base]); if (tmp2[0]==0) strcat(tmp2,"0");
		      sscanf(tmp2,tmp,&calc_result);
                      if (position>strlen(tmp2)) { position--; digits=strlen(tmp2); } break;
      case KEY_BACKSPACE: if (position==0) break;
		      calc_result=history[hist_pos];
		      sprintf(tmp2,"%%%c",calc_conv[calc_base]);
		      sprintf(tmp,tmp2,calc_result);
		      strncpy(tmp2,tmp,position-1);
		      tmp2[position-1]=0;
		      strcat(tmp2,tmp+position); if (tmp2[0]==0) strcat(tmp2,"0");
		      sprintf(tmp,"%%%c",calc_conv[calc_base]);
		      sscanf(tmp2,tmp,&calc_result);
		      position--; digits=strlen(tmp2); break;
      case KEY_F(2) : savefile(filename); break; /* save the file */
      case KEY_F(9) : /* Options, not yet */ break;
    }
  }
  oops(1); 
}


/* end of calculator */
