/** sock_addr - internet addresses abstraction */

#ifndef LIBAIO__ADDR_H
#define	LIBAIO__ADDR_H

#include <inttypes.h>
#include <sys/socket.h>
#include <netinet/in.h>


/*** SYNOPSIS */
/*| addr_t a = sock_addr_getbyname("example.com", 1234); */
/*| sock_addr_del(a); */


/** Generic network address */

typedef struct {
	int af; /* address family (currently only AF_INET is supported) */
	struct sockaddr *addr;
	socklen_t addrlen;
} addr_t;


/*+ Address functions */

/* Get v4 IP from a string containing host's name/address */
/* If @name is "", INADDR_ANY is returned */
/* Returns address in network-byte order or 0 on failure */
uint32_t sock_addr_ip4byname(char *name);

/* Get v4 addr_t structure representing given ip:port */
/* Returns newly allocated addr_t structure or NULL */
addr_t *sock_addr_get4(uint32_t ip, int port);

/* Get an addr_t structure representing given name:port */
/* Returns newly allocated addr_t structure or NULL */
addr_t *sock_addr_getbyname(char *name, int port);

/* Get a generic addr_t structure */
/* Returns newly allocated addr_t structure or NULL */
addr_t *sock_addr_get(int af, struct sockaddr *saddr, int addrlen);

/* Delete the addr_t structure */
/* Returns always NULL */
addr_t *sock_addr_del(addr_t *addr);

#endif
