program gen_patch_include;

var desc:text;
    patchname,patchdata:string;
    i,patchcount,offset:longint;
    mode:(l_c,l_assembler);

begin
    if paramcount<>2 then
	writeln('Usage: gen_patch_include <patch_desc_file> <c|assembler>')
    else
	begin
	    if paramstr(2)='c' then
		mode:=l_c
	    else if paramstr(2)='assembler' then
		mode:=l_assembler;
	    if mode=l_c then
		begin
		    writeln('/*');
		    writeln(' * This file was automatically generated by '+
		     'gen_patch_include.');
		    writeln(' * Do not edit it manually');
		    writeln(' */');
		    writeln;
		end
	    else
		begin
		    writeln(';');
		    writeln('; This file was automatically generated by '+
		     'gen_patch_include.');
		    writeln('; Do not edit it manually');
		    writeln(';');
		    writeln;
		end;
	    assign(desc,paramstr(1));
	    reset(desc);
	    readln(desc,patchcount);
	    for i:=1 to patchcount do
		begin
		    readln(desc,patchname);
		    readln(desc,offset);
		    readln(desc,patchdata);
		    while length(patchname)<32 do
			patchname:=patchname+' ';
		    if mode=l_c then
			writeln('#define p_',patchname,i-1)
		    else
			writeln('%define p_',patchname,i-1);
		end;
	    close(desc);
	end;
end.
