#ifndef COMMON_H
#define COMMON_H
//
// This file is part of TTDPatch
// Copyright (C) 1999 by Josef Drexler
//
// common.h: Definitions pertinent to both C code and Assembler code
//

// Because hex values have different notation in C and Assembler, we
// need to use this


#ifdef C
#	define HEXVAL(number)		0 ## x ## number
#endif

#ifdef ASSEMBLER
#	define HEXVAL(number)		number ## h
#endif

// this is for identifying the correct interrupt
#define MAGIC HEXVAL(6b5a3f83)
#define MOREMAGIC HEXVAL(45cb7e39)

#define nflags 4	// number of longs with flags switch bits
#define nparlong 8	// number of longs in the data part of the params


// bit numbers for the patchflags variable.
// Don't add any defines BUT patchflags bit numbers between the BEGIN and END
// BEGIN PATCHFLAGS
#define uselargerarray		 0	// Use larger vehicle array
#define usenewcurves		 1	// Use new curves
#define usenewmountain		 2	// Use new mountain
#define usenewnonstop		 3	// Use new non-stop handling
#define increasetraincount	 4	// Increase number of trains
#define increaservcount		 5	// Increase number of road vehicles
#define setnewservinterval	 6	// Set service internal
#define usesigncheat		 7	// Sign Cheat
#define allowtrainrefit		 8	// Allow train refitting
#define increaseplanecount	 9	// Increase number of planes
#define increaseshipcount	10	// Increase number of ships
#define saveonlysmall		11	// When saving, store only 850 vehicles
#define keepsmallairports	12	// Keep small airports forever
#define largerstations		13	// Stations may be further apart
#define morestationtracks	14	// up to 7 tracks per station
#define longerbridges		15	// bridges up to 127 squares long
#define improvedloadtimes	16	// improved load time calculation
#define mammothtrains		17	// maximum train length is 127
#define presignals		18	// use pre-signals
#define officefood		19	// office towers accept food too
#define noinflation		20	// Turn off inflation
#define maxloanwithctrl		21	// Borrow/Repay maximum amount with Ctrl
#define persistentengines	22	// Persistent engines while they exist
#define fullloadany		23	// Full load is full if any type full
#define selectstationgoods	24	// Only transported station goods appear
#define morethingsremovable	25	// More things can be removed, at a cost
#define aibooster		26	// Increase AI recursion factor
#define multihead		27	// Allow arbitrary number of engines in train
#define newlineup		28	// Make busses and trucks wait at their stops
#define lowmemory		29	// Run with little memory, only 2.5MB
#define generalfixes		30	// several general fixes
#define moreairports		31	// new maximum airport numbers: 9; lrg=4, sml=3, hp=1, of=0
#define bribe			 0+32	// add "bribe" option to LA menu

// add new flags here, also update lastbitused and lastbit

// so far unused flags, simply to remember what names I've used already
// the numbers of these can be changed as desired
#define moresignals		 1+32	// make tunnels&bridges behave as if there were signals
#define hugeairport		 2+32	// build huge airports

// END PATCHFLAGS

#define lastbitused		 0+32	// Last bit to be set by -a
#define lastbit			 0+32	// Last bit defined so far, set by -a if DEBUG


// these go always in the last bits of the last flag DWORD
#define noflag			30+3*32	// Reserved. A flag that's always zero
#define anyflagset		31+3*32	// is any flag set?



#define TOTALOFFSETS		HEXVAL(80)	// Number of entries in the version table

// Alignment for the protected mode code in real mode memory (shift)
// smaller number = less wasted memory, but slightly longer loading time
#define PROT_ALIGN		9
	// 12 = 4KB, 11=2KB, 10=1KB, 9=512 byte

// to find relocated entries, search for [A-F0-9]+r[ \<ctrl-p><tab>]
// with regexp and capitals

#endif // COMMON_H
