program extract_strings;

uses strings;

const	string_count=820;
	stringtable_location=$f2632;

var stringtable:array[1..string_count] of Pchar;
    stringlocs:array[1..string_count] of cardinal;
    readbuf:array[0..1023] of char;
    
procedure write_ttstr(s:Pchar);

const	charset=['a'..'z','A'..'Z','0'..'9','!','@','#','$','%','^','&',
		 '*','(',')','[',']','{','}','\',';',':',',','.','/','?'
		 ,'<','>','+','-','=','_',' '];

var eerste,in_string:boolean;

begin
    if s=nil then
	begin
	    writeln(#9'db 0');
	    exit;
	end;
    eerste:=true;
    in_string:=false;
    write(#9'db ');
    while s^<>#0 do
	begin
	    if in_string then
		if s^ in charset then
		    write(s^)
		else
		    begin
			write(''',',byte(s^));
			in_string:=false;
		    end
	    else
		if s^ in charset then
		    begin
			if not eerste then
			    write(',');
		        write('''',s^);
			in_string:=true;
		    end
		else
		    begin
			if not eerste then
			    write(',');
			write(byte(s^));
		    end;
	    inc(s);
	    eerste:=false;
	end;
    if in_string then
	write('''');
    writeln(',0');
end;

var f:file;
    i:word;

begin
    writeln('[SECTION .data]');
    writeln;
    writeln('global stringtable_size');
    writeln('global stringtable');
    writeln;
    writeln('stringtable_size:'#9'dd 820');
    writeln('stringtable:');
    for i:=1 to string_count do
	writeln(#9'dd string_',i);
    assign(f,'tycoon.img');
    reset(f,1);
    seek(f,stringtable_location);
    blockread(f,stringlocs,string_count*sizeof(Pchar));
    for i:=1 to string_count do
	begin
	    seek(f,stringlocs[i]);
	    blockread(f,readbuf,1024);
	    stringtable[i]:=strnew(readbuf);
	    writeln('string_',i,':');
	    write_ttstr(stringtable[i]);
	end;
    close(f);
end.
