;*****************************************************************************
;*                    Transport Tycoon loader for Linux                      *
;*                                                                           *
;*                   Copyright (C) 2001 by Danil Mantione                   *
;*                          Delft, the Netherlands                           *
;*                                                                           *
;* The author grants you permission to use this software under the terms of  *
;* the "GNU public license" version 2 (and only version 2) until             *
;* 31 December 2004. If the author likes the next version of the GPL         *
;* permission will be granted to use this software under that license too.   *
;* The expiration date is necessary to enforce the new version of the GPL    *
;* if the author decides to use it, otherwise this date will be extended.    *
;*                                                                           *
;* As a special exeception to the "GNU public license", you are granted      *
;* permission to link this code against PC-Dos based computer games like     *
;* Transport Tycoon.                                                         *
;*                                                                           *
;* Contact information:                                                      *
;* E-mail:   daniel.mantione@freepascal.org                                  *
;* Phone:    ++31 15 2510958                                                 *
;*****************************************************************************

%include "keyboard.inc"
%include "patches.inc"

extern patch_locs

[SECTION .text]

global keyb_patch_1

extern scrollh
extern scrollv
extern pr_not

; Original at $1256d8

keyb_patch_1:
    cmp byte [$9f15b],0
    je .no_shot
    ; Take a screenshot
    jl .giant
    dec byte [$9f15b]
    jnz .no_shot
    mov ebx,4*p_keyb_patch_1_sub1
    add ebx,[patch_locs]
    call [ebx]
;    call $12ef9f
    jmp .a2
.giant:
    inc byte [$9f15b]
    jne .no_shot
    mov ebx,4*p_keyb_patch_1_sub2
    add ebx,[patch_locs]
    call [ebx]
;    call $12f14f
.a2:
    mov [$774dc],ax
    mov word [$774da],$31a
    mov bx,$31b
    jnc .a1
    inc ebx
.a1:
    mov dx,$0ffff
    xor eax,eax
    xor ecx,ecx
    mov esi,4*p_keyb_patch_1_sub3
    add esi,[patch_locs]
    call [esi]
;    call $136575
.no_shot:
    ; Handle scrolling with keyboard arrows
    cmp byte [$9ed33],0
    je .no_scroll
.no_right:
    xor ax,ax
    xor bx,bx
    xchg ax,[scrollh]
    xchg bx,[scrollv]
    mov dx,ax
    or dx,bx
    jz .no_scroll
    mov esi,4*p_scroll_screen
    add esi,[patch_locs]
    call [esi]
;    call $1310af	; Scroll the screen
.no_scroll:
    ret
