;*****************************************************************************
;*                    Transport Tycoon loader for Linux                      *
;*                                                                           *
;*                   Copyright (C) 2001 by Danil Mantione                   *
;*                          Delft, the Netherlands                           *
;*                                                                           *
;* The author grants you permission to use this software under the terms of  *
;* the "GNU public license" version 2 (and only version 2) until             *
;* 31 December 2004. If the author likes the next version of the GPL         *
;* permission will be granted to use this software under that license too.   *
;* The expiration date is necessary to enforce the new version of the GPL    *
;* if the author decides to use it, otherwise this date will be extended.    *
;*                                                                           *
;* As a special exeception to the "GNU public license", you are granted      *
;* permission to link this code against PC-Dos based computer games like     *
;* Transport Tycoon.                                                         *
;*                                                                           *
;* Contact information:                                                      *
;* E-mail:   daniel.mantione@freepascal.org                                  *
;* Phone:    ++31 15 2510958                                                 *
;*****************************************************************************

%include "system.inc"
%include "patches.inc"

[SECTION .data]

scenariodir:		db '.',0
;filex:			db 'filex',0
;file_header:		resb $40

extern patch_locs
extern varf9xxx_offset

[SECTION .bss]

global statbuf

statbuf: 	resb stat_size

%define PROT_NONE	$00000000
%define PROT_READ	$00000001
%define PROT_WRITE	$00000002
%define PROT_EXEC	$00000004

%define MAP_SHARED	$00000001
%define MAP_PRIVATE	$00000002
%define MAP_FIXED	$00000010
%define MAP_ANON	$00000020
%define MAP_ANONYMOUS	$00000020

%define S_IXOTH		$00000001;
%define S_IWOTH		$00000002;
%define S_IROTH		$00000004;
%define S_IRWXO		$00000007;
%define S_IXGRP		$00000008;
%define S_IWGRP		$00000010;
%define S_IRGRP		$00000020;
%define S_IRWXG		$00000038;
%define S_IXUSR		$00000040;
%define S_IWUSR		$00000080;
%define S_IRUSR		$00000100;
%define S_IRWXU		$000001c0;
%define S_ISVTX		$00000200;
%define S_ISGID		$00000400;
%define S_ISUID		$00000800;
%define S_IFIFO		$00001000;
%define S_IFCHR		$00002000;
%define S_IFDIR		$00004000;
%define S_IFBLK		$00006000;
%define S_IFREG		$00008000;
%define S_IFLNK		$0000a000;
%define S_IFSOCK	$0000c000;
%define S_IFMT		$0000f000;

;-----------------------------------------------------------------------------
[SECTION .text]

global search_scenarios
global file_dlg_search

;
; Iterate through all files in a directory
;
; Parameters: (First parameter is pushed first on the stack.)
;
; dword [ebp+12]		pointer to directoty name
; dword [ebp+8]			address of routine to call
;
; Paramters to routine:
;
; dword [ebp-8]			pointer to file name

iterate_dir:
    ; We need local variables...
    ;
    ; dword [ebp-4]		=	file handle
    ; dword [ebp-8]		=	pointer to auto alloc memory
    ; dword [ebp-12]		=	number of bytes read from dir
    enter 12,0
    ; Argh!! We cannot use opendir, because that uses the malloc
    ; memory manager, which cannot be used because of thread safety
    ; problems. (We do not use pthreads).
    ;
    ; So... Open the directory with open
    sys_open [ebp+12],O_RDONLY|O_DIRECTORY
    mov [ebp-4],eax
    
    ; We need to have a buffer that is large enough to get the
    ; whole directory. (Or call getdirent more than once.)
    ; We create 128kb auto allocated memory. In case
    ; even that is not enough we skip files.
    
    ; Create 128kb auto allocated memory.
    ; We create a structure for mmap on the stack. We don't clean
    ; it up; leave does this already at the end of this routine.
    _push dword 0
    _push dword 0
    _push dword MAP_PRIVATE|MAP_ANON
    _push dword PROT_READ|PROT_WRITE
    _push dword $20000 ; 128 kb
    _push dword 0
    sys_mmap esp
    mov [ebp-8],eax

    xor eax,eax
    _mov [ebp-12],eax
    _mov ecx,[ebp-8]
    _mov edx,$20000
.nextset:
    _push ecx
    _push edx
    ; Get a directory entry. Huh? Getdents not in libc?!
    ; Grmbl.. Okay, okay, okay, we call the kernel directly.
    sys_getdents [ebp-4],ecx,edx
    pop edx
    pop ecx
    add [ebp-12],eax
    add ecx,eax
    sub edx,eax
    js .buffer_full	; Buffer is full, skip rest of directory.
    or eax,eax
    jnz .nextset
.buffer_full:
;    Debug code, writes the data to disk:
;    sys_open filex,O_CREAT|O_WRONLY
;    push eax
;    sys_write eax,[ebp-8],$20000
;    pop eax
;    sys_close eax

    ; Start iteration through the directories
    _mov esi,[ebp-8]
    xor ebx,ebx
    
.next_file:
    movzx edi,byte [esi+ebx+dirent.reclen]
    ; A directory contains at least . and .., so we can safely assume
    ; the is at least one entry in a directory.
    
    ; Save the registers and call the routine
    _push ebx
    _push esi
    _push edi
    
    lea edx,[esi+ebx+dirent.name]
    push edx
    call [ebp+8] ; Call the routine
    pop edi
    pop esi
    pop ebx
    ; Is there still a file left?
    lea edx,[ebx+edi]
    cmp edx,[ebp-12] ; Compare with number of bytes in buffer
    jae .done_files
    add ebx,edi
    jmp .next_file
.done_files
    
    ; Free the auto allocated memory
    sys_munmap [ebp-8],20000
    
    ; Close the directory
    sys_close [ebp-4]
    leave
    ret $8
    
;
; Check if a filename matches that of a scenario
;
; Parameters:
;
; [ebp+8]			filename

check_filename_scen:
    push ebp
    mov ebp,esp
    ; A scenario file looks like 'TR#??.SS?'
    ; Where # is a C, H, T or Y depending on the climate type
    mov esi,[ebp+8]
    lodsb
    cmp al,'T'
    jne .nomatch
    lodsb
    cmp al,'R'
    jne .nomatch
    lodsb
    movzx ebx,byte [$9f159]		; Climate type
    mov edx,[varf9xxx_offset]
    mov cl,byte [$0f91c4+ebx+edx]	; Climate character
    cmp al,cl
    jne .nomatch
    lodsb
    cmp al,0
    je .nomatch
    lodsb
    cmp al,0
    je .nomatch
    lodsb
    cmp al,'.'
    jne .nomatch
    lodsb
    cmp al,'S'
    jne .nomatch
    lodsb
    cmp al,'S'
    jne .nomatch
    lodsb
    cmp al,0
    je .nomatch
    lodsb
    cmp al,0	; Reject longer files
    jne .nomatch
    stc
    jmp .match
.nomatch:
    clc
.match:
    pop ebp
    ret $4

;
; Check if a filename matches that of a savegame
;
; Parameters:
;
; [ebp+8]			filename

check_filename_savegame:
    push ebp
    mov ebp,esp
;    push dword [ebp+8]
;    call log_file
;    add esp,4
    ; A savegame file looks like 'TRT??.SV#'
    ; Where # is 1 or 2 depending on a 1 or 2 player game
    mov esi,[ebp+8]
    lodsb
    cmp al,'T'
    jne .nomatch
    lodsb
    cmp al,'R'
    jne .nomatch
    lodsb
    cmp al,'T'
    jne .nomatch
    lodsb
    cmp al,0
    je .nomatch
    lodsb
    cmp al,0
    je .nomatch
    lodsb
    cmp al,'.'
    jne .nomatch
    lodsb
    cmp al,'S'
    jne .nomatch
    lodsb
    cmp al,'V'
    jne .nomatch
    lodsb
    mov cl,'1'
    cmp byte [$9ed32],2 ; 2 player game ?
    jne .oneplayer
    mov cl,'2'
.oneplayer:
    cmp byte [$9ef2b],0 ; Loading a scenario ?
    je .noscenario
    mov cl,'0'
.noscenario:
    cmp al,cl
    jne .nomatch
    lodsb
    cmp al,0	; Reject longer files
    jne .nomatch
    stc
    jmp .match
.nomatch:
    clc
.match:
    pop ebp
    ret $4

;
; Check if a file is a real file
;
; Parameters:
;
; [ebp+8]			filename

check_is_file:
    push ebp
    mov ebp,esp
    sys_stat [ebp+8],statbuf
    mov ax,word [statbuf+stat.mode]
    and ax,S_IFMT
    cmp ax,S_IFREG
    jne .nomatch
    stc
    jmp .match
.nomatch:
    clc
.match:
    pop ebp
    ret $4

;
; Check if a file is a directory
;
; Parameters:
;
; [ebp+8]			filename

check_is_dir:
    push ebp
    mov ebp,esp
    sys_stat [ebp+8],statbuf
    mov ax,word [statbuf+stat.mode]
    and ax,S_IFMT
    cmp ax,S_IFDIR
    jne .nomatch
    stc
    jmp .match
.nomatch:
    clc
.match:
    pop ebp
    ret $4

;
; Check if a file header matches that of a scenario
;
; Parameters:
;
; [ebp+8]			filename

check_is_scenario:
    enter 8,0
    sys_open dword [ebp+8],O_RDONLY
    mov [ebp-4],eax
    sys_read dword [ebp-4],$9f1e8,$31
    mov [ebp-8],eax
    sys_close dword [ebp-4]
    cmp dword [ebp-8],$31	; File is long enough?
    jne .nomatch
    _mov esi,$9f1e8
    xor edx,edx
    _mov ecx,$2f
    xor ax,ax
.a1:
    lodsb
    add dx,ax
    rol dx,1
    loop .a1
    xor dx,$0aaaa
    cmp dx,[esi]
    jne .nomatch
    stc
    jmp .match
.nomatch:
    clc
.match:
    leave
    ret $4

;
; Check if a file is indeed a scenario
;
; Parameters:
;
; [ebp+8]			filename

check_file_scen:
    push ebp
    mov ebp,esp

    ; Check if the file name matches that of a scenario.
    push dword [ebp+8]
    call check_filename_scen
    jnc .nomatch
    
    ; Check if the file found is indeed a file (and not a directory).
    push dword [ebp+8]
    call check_is_file
    jnc .nomatch
    
    ; Open the file and check if it contains a scenario
    push dword [ebp+8]
    call check_is_scenario
    jnc .nomatch
    _mov ebp,[ebp+8]
    mov al,6
    mov edi,ebp
    _mov esi,$9f1e8
.a1:
    inc edi
    cmp byte [edi],0
    jne .a1
    cmp byte [edi-1],$30
    je .a2
    mov al,5
    cmp byte [$9ed32],1
    jne .a3
.a2:
    mov ebx,4*p_filedlg_foundfile
    add ebx,[patch_locs]
    call [ebx]
.a3:
;    call log_file
    
.nomatch:
    pop ebp
    ret $4

; Search for scenarios on disk. Original located at $143936

search_scenarios:
    push fs
    push gs
    mov eax,[varf9xxx_offset]
    mov byte [$0f91b2+eax],0
    mov edi,$9f2e8
    mov ax,$4010
    mov ebx,4*p_search_scen_sub1
    add ebx,[patch_locs]
    call [ebx]
;    call $12fa7a

    push ds
    pop es    
    mov al,4
    mov esi,$9f2e8
    xor ebp,ebp
    mov ebx,4*p_filedlg_foundfile
    add ebx,[patch_locs]
    call [ebx]
;    call $142714
    
    push ds
    pop fs
    push dword scenariodir
    push dword check_file_scen
    call iterate_dir

    pop gs
    pop fs
    mov al,$21
    xor bx,bx
    mov esi,4*p_search_scen_sub2
    add esi,[patch_locs]
    call [esi]
;    call $133ff3
    retn
    
;
; Check if a file header matches that of a savegame
;
; Parameters:
;
; [ebp+8]			filename

check_is_savegame:
    enter 8,0
    mov esi,$9eced
    mov edi,$9f1e8
.a1:
    lodsb
    stosb
    cmp al,0
    jne .a1
    dec edi
    mov esi,[ebp+8]
.a2:
    lodsb
    stosb
    cmp al,0
    jne .a2
    
    sys_open dword $9f1e8,O_RDONLY
    mov [ebp-4],eax
    sys_read dword [ebp-4],$9f1e8,$31
    mov [ebp-8],eax
    sys_close dword [ebp-4]
    cmp dword [ebp-8],$31	; File is long enough?
    jne .nomatch
    _mov esi,$9f1e8
    xor edx,edx
    _mov ecx,$2f
    xor ax,ax
.a3:
    lodsb
    add dx,ax
    rol dx,1
    loop .a3
    xor dx,$0aaaa
    cmp dx,[esi]
    jne .nomatch
    stc
    jmp .match
.nomatch:
    clc
.match:
    leave
    ret $4

;
; Check if a file is indeed a directory
;
; Parameters:
;
; [ebp+8]			filename

check_file_directory:
    push ebp
    mov ebp,esp
    ; We don't want . and ..
    mov esi,[ebp+8]
    lodsb
    cmp al,'.'
    jne .check_type
    lodsb
    cmp al,0
    je .nomatch
    cmp al,'.'
    jne .check_type
    lodsb
    cmp al,0
    je .nomatch
.check_type
    ; Check if the file is a directory
    push dword [ebp+8]
    call check_is_dir
    jnc .nomatch
    mov esi,[ebp+8]
    _mov edi,$9f1e8
    _mov ebx,$9f2e8
    mov al,'/'
    stosb
.a1:
    lodsb
    stosb
    mov [ebx],al
    inc ebx
    cmp al,0
    jne .a1
    _mov esi,$0f7c7e
    dec edi
.a2:
    lodsb
    stosb
    cmp al,0
    jne .a2
    mov al,2
    push ss
    pop es
    _mov esi,$9f1e8
    push ss
    pop fs
    _mov ebp,$9f2e8
    mov ebx,4*p_filedlg_foundfile
    add ebx,[patch_locs]
    call [ebx]
;    call $142714
.nomatch:
    pop ebp
    ret $4

;
; Check if a file is indeed a savegame
;
; Parameters:
;
; [ebp+8]			filename

check_file_savegame:
    push ebp
    mov ebp,esp

    ; Check if the file name matches that of a scenario.
    push dword [ebp+8]
    call check_filename_savegame
    jnc .nomatch
    
    ; Check if the file found is indeed a file (and not a directory).
    push dword [ebp+8]
    call check_is_file
    jnc .nomatch
    
    ; Open the file and check if it contains a scenario
    push dword [ebp+8]
    call check_is_savegame
    jnc .nomatch
    push ss
    pop es
    push ds
    pop fs
    _mov ebp,[ebp+8]
    mov esi,$9f1e8
    mov al,3
    mov ebx,4*p_filedlg_foundfile
    add ebx,[patch_locs]
    call [ebx]
;    call $142714
    
.nomatch:
    pop ebp
    ret $4
    
; Search already saved files. Original at $142556
file_dlg_search:
;    push fs
;    push gs
    mov esi,$9eced
    mov edi,$9f3e8
.a1:
    lodsb
    stosb
    cmp al,0
    jnz .a1
    push dword $9f3e8
    push dword check_file_directory
    call iterate_dir
    push dword $9f3e8
    push dword check_file_savegame
    call iterate_dir
    pop gs
    pop fs
    mov al,$21
    xor bx,bx
    mov esi,4*p_search_scen_sub2
    add esi,[patch_locs]
    call [esi]
;    call $133f33
    retn
