;******************************************************************************
;
;   Conversion of GII keyboard.h to Nasm include file keyboard.inc
;   (C) 2001 Danil Mantione [daniel.mantione@freepascal.org]
;
;   Original copyright message:
;
;   LibGII keyboard definitions
;
;   Copyright (C) 1998 Andrew Apted	[andrew@ggi-project.org]
;   Copyright (C) 1999 Marcus Sundberg	[marcus@ggi-project.org]
;
;   Permission is hereby granted, free of charge, to any person obtaining a
;   copy of this software and associated documentation files (the "Software"),
;   to deal in the Software without restriction, including without limitation
;   the rights to use, copy, modify, merge, publish, distribute, sublicense,
;   and/or sell copies of the Software, and to permit persons to whom the
;   Software is furnished to do so, subject to the following conditions:
;
;   The above copyright notice and this permission notice shall be included in
;   all copies or substantial portions of the Software.
;
;   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
;   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
;   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
;   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
;   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
;   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
;
;******************************************************************************

%define GII_KEY(typ,val)	(((typ) << 8) | (val))
%define GII_KTYP(x)		((x) >> 8)
%define GII_KVAL(x)		((x) & $0ff)
%define GII_UNICODE(x)		((x) < $0E000 || (x) >= $0F900)

; types

%define GII_KT_LATIN1	$00
%define GII_KT_SPEC	$0E0
%define GII_KT_FN	$0E1
%define GII_KT_PAD	$0E2
%define GII_KT_MOD	$0E3
%define GII_KT_DEAD	$0E4

; modifiers

%define GII_KM_SHIFT	$00
%define GII_KM_CTRL	$01
%define GII_KM_ALT	$02
%define GII_KM_META	$03
%define GII_KM_SUPER	$04
%define GII_KM_HYPER	$05
%define GII_KM_ALTGR	$06
%define GII_KM_CAPS	$07
%define GII_KM_NUM	$08
%define GII_KM_SCROLL	$09

%define GII_KM_MASK	$0f
%define GII_KM_RIGHT	$40	; additive
%define GII_KM_LOCK	$80	;  - " -   (only used for labels)

; Bits in the "modifiers" field

%define GII_MOD_SHIFT	(1 << GII_KM_SHIFT)
%define GII_MOD_CTRL	(1 << GII_KM_CTRL)
%define GII_MOD_ALT	(1 << GII_KM_ALT)
%define GII_MOD_META	(1 << GII_KM_META)
%define GII_MOD_SUPER	(1 << GII_KM_SUPER)
%define GII_MOD_HYPER	(1 << GII_KM_HYPER)
%define GII_MOD_ALTGR	(1 << GII_KM_ALTGR)
%define GII_MOD_CAPS	(1 << GII_KM_CAPS)
%define GII_MOD_NUM	(1 << GII_KM_NUM)
%define GII_MOD_SCROLL	(1 << GII_KM_SCROLL)

; function keys

%define GIIK_F0			GII_KEY(GII_KT_FN, 0)
%define GIIK_F1			GII_KEY(GII_KT_FN, 1)
%define GIIK_F2			GII_KEY(GII_KT_FN, 2)
%define GIIK_F3			GII_KEY(GII_KT_FN, 3)
%define GIIK_F4			GII_KEY(GII_KT_FN, 4)
%define GIIK_F5			GII_KEY(GII_KT_FN, 5)
%define GIIK_F6			GII_KEY(GII_KT_FN, 6)
%define GIIK_F7			GII_KEY(GII_KT_FN, 7)
%define GIIK_F8			GII_KEY(GII_KT_FN, 8)
%define GIIK_F9			GII_KEY(GII_KT_FN, 9)
%define GIIK_F10		GII_KEY(GII_KT_FN, 10)
%define GIIK_F11		GII_KEY(GII_KT_FN, 11)
%define GIIK_F12		GII_KEY(GII_KT_FN, 12)
%define GIIK_F13		GII_KEY(GII_KT_FN, 13)
%define GIIK_F14		GII_KEY(GII_KT_FN, 14)
%define GIIK_F15		GII_KEY(GII_KT_FN, 15)
%define GIIK_F16		GII_KEY(GII_KT_FN, 16)
%define GIIK_F17		GII_KEY(GII_KT_FN, 17)
%define GIIK_F18		GII_KEY(GII_KT_FN, 18)
%define GIIK_F19		GII_KEY(GII_KT_FN, 19)
%define GIIK_F20		GII_KEY(GII_KT_FN, 20)
%define GIIK_F21		GII_KEY(GII_KT_FN, 21)
%define GIIK_F22		GII_KEY(GII_KT_FN, 22)
%define GIIK_F23		GII_KEY(GII_KT_FN, 23)
%define GIIK_F24		GII_KEY(GII_KT_FN, 24)
%define GIIK_F25		GII_KEY(GII_KT_FN, 25)
%define GIIK_F26		GII_KEY(GII_KT_FN, 26)
%define GIIK_F27		GII_KEY(GII_KT_FN, 27)
%define GIIK_F28		GII_KEY(GII_KT_FN, 28)
%define GIIK_F29		GII_KEY(GII_KT_FN, 29)
%define GIIK_F30		GII_KEY(GII_KT_FN, 30)
%define GIIK_F31		GII_KEY(GII_KT_FN, 31)
%define GIIK_F32		GII_KEY(GII_KT_FN, 32)
%define GIIK_F33		GII_KEY(GII_KT_FN, 33)
%define GIIK_F34		GII_KEY(GII_KT_FN, 34)
%define GIIK_F35		GII_KEY(GII_KT_FN, 35)
%define GIIK_F36		GII_KEY(GII_KT_FN, 36)
%define GIIK_F37		GII_KEY(GII_KT_FN, 37)
%define GIIK_F38		GII_KEY(GII_KT_FN, 38)
%define GIIK_F39		GII_KEY(GII_KT_FN, 39)
%define GIIK_F40		GII_KEY(GII_KT_FN, 40)
%define GIIK_F41		GII_KEY(GII_KT_FN, 41)
%define GIIK_F42		GII_KEY(GII_KT_FN, 42)
%define GIIK_F43		GII_KEY(GII_KT_FN, 43)
%define GIIK_F44		GII_KEY(GII_KT_FN, 44)
%define GIIK_F45		GII_KEY(GII_KT_FN, 45)
%define GIIK_F46		GII_KEY(GII_KT_FN, 46)
%define GIIK_F47		GII_KEY(GII_KT_FN, 47)
%define GIIK_F48		GII_KEY(GII_KT_FN, 48)
%define GIIK_F49		GII_KEY(GII_KT_FN, 49)
%define GIIK_F50		GII_KEY(GII_KT_FN, 50)
%define GIIK_F51		GII_KEY(GII_KT_FN, 51)
%define GIIK_F52		GII_KEY(GII_KT_FN, 52)
%define GIIK_F53		GII_KEY(GII_KT_FN, 53)
%define GIIK_F54		GII_KEY(GII_KT_FN, 54)
%define GIIK_F55		GII_KEY(GII_KT_FN, 55)
%define GIIK_F56		GII_KEY(GII_KT_FN, 56)
%define GIIK_F57		GII_KEY(GII_KT_FN, 57)
%define GIIK_F58		GII_KEY(GII_KT_FN, 58)
%define GIIK_F59		GII_KEY(GII_KT_FN, 59)
%define GIIK_F60		GII_KEY(GII_KT_FN, 60)
%define GIIK_F61		GII_KEY(GII_KT_FN, 61)
%define GIIK_F62		GII_KEY(GII_KT_FN, 62)
%define GIIK_F63		GII_KEY(GII_KT_FN, 63)
%define GIIK_F64		GII_KEY(GII_KT_FN, 64)

; special keys

%define GIIK_VOID		GII_KEY(GII_KT_SPEC, 0)

%define GIIK_Enter		GIIUC_Return
%define GIIK_Delete		GIIUC_Delete

%define GIIK_Break		GII_KEY(GII_KT_SPEC, 5)

%define GIIK_ScrollForw		GII_KEY(GII_KT_SPEC, 10)
%define GIIK_ScrollBack		GII_KEY(GII_KT_SPEC, 11)

%define GIIK_Boot		GII_KEY(GII_KT_SPEC, 12)
%define GIIK_Compose		GII_KEY(GII_KT_SPEC, 14)
%define GIIK_SAK		GII_KEY(GII_KT_SPEC, 15)

%define GIIK_Undo		GII_KEY(GII_KT_SPEC, 23)
%define GIIK_Redo		GII_KEY(GII_KT_SPEC, 24)
%define GIIK_Menu		GII_KEY(GII_KT_SPEC, 25)
%define GIIK_Cancel		GII_KEY(GII_KT_SPEC, 26)
%define GIIK_PrintScreen	GII_KEY(GII_KT_SPEC, 27)
%define GIIK_Execute		GII_KEY(GII_KT_SPEC, 28)
%define GIIK_Find		GII_KEY(GII_KT_SPEC, 30)
%define GIIK_Begin		GII_KEY(GII_KT_SPEC, 31)
%define GIIK_Clear		GII_KEY(GII_KT_SPEC, 32)
%define GIIK_Insert		GII_KEY(GII_KT_SPEC, 34)
%define GIIK_Select		GII_KEY(GII_KT_SPEC, 35)
%define GIIK_Macro	 	GII_KEY(GII_KT_SPEC, 38)
%define GIIK_Help		GII_KEY(GII_KT_SPEC, 39)
%define GIIK_Do			GII_KEY(GII_KT_SPEC, 40)
%define GIIK_Pause	 	GII_KEY(GII_KT_SPEC, 41)
%define GIIK_Stop		GIIK_Pause
%define GIIK_SysRq		GII_KEY(GII_KT_SPEC, 42)
%define GIIK_ModeSwitch		GII_KEY(GII_KT_SPEC, 43)

%define GIIK_Up			GII_KEY(GII_KT_SPEC, 50)
%define GIIK_Down		GII_KEY(GII_KT_SPEC, 51)
%define GIIK_Left		GII_KEY(GII_KT_SPEC, 52)
%define GIIK_Right		GII_KEY(GII_KT_SPEC, 53)
%define GIIK_Prior		GII_KEY(GII_KT_SPEC, 54)
%define GIIK_PageUp		GIIK_Prior
%define GIIK_Next		GII_KEY(GII_KT_SPEC, 55)
%define GIIK_PageDown		GIIK_Next
%define GIIK_Home		GII_KEY(GII_KT_SPEC, 56)
%define GIIK_End		GII_KEY(GII_KT_SPEC, 57)

; keys on the numeric keypad

%define GIIK_P0			GII_KEY(GII_KT_PAD, '0')
%define GIIK_P1			GII_KEY(GII_KT_PAD, '1')
%define GIIK_P2			GII_KEY(GII_KT_PAD, '2')
%define GIIK_P3			GII_KEY(GII_KT_PAD, '3')
%define GIIK_P4			GII_KEY(GII_KT_PAD, '4')
%define GIIK_P5			GII_KEY(GII_KT_PAD, '5')
%define GIIK_P6			GII_KEY(GII_KT_PAD, '6')
%define GIIK_P7			GII_KEY(GII_KT_PAD, '7')
%define GIIK_P8			GII_KEY(GII_KT_PAD, '8')
%define GIIK_P9			GII_KEY(GII_KT_PAD, '9')
%define GIIK_PA			GII_KEY(GII_KT_PAD, 'A')
%define GIIK_PB			GII_KEY(GII_KT_PAD, 'B')
%define GIIK_PC			GII_KEY(GII_KT_PAD, 'C')
%define GIIK_PD			GII_KEY(GII_KT_PAD, 'D')
%define GIIK_PE			GII_KEY(GII_KT_PAD, 'E')
%define GIIK_PF			GII_KEY(GII_KT_PAD, 'F')

%define GIIK_PPlus		GII_KEY(GII_KT_PAD, '+')
%define GIIK_PMinus		GII_KEY(GII_KT_PAD, '-')
%define GIIK_PSlash		GII_KEY(GII_KT_PAD, '/')
%define GIIK_PAsterisk		GII_KEY(GII_KT_PAD, '*')
%define GIIK_PStar		GIIK_PAsterisk
%define GIIK_PEqual		GII_KEY(GII_KT_PAD, '=')
%define GIIK_PSeparator		GII_KEY(GII_KT_PAD, ',')
%define GIIK_PDecimal		GII_KEY(GII_KT_PAD, '.')
%define GIIK_PParenLeft		GII_KEY(GII_KT_PAD, '(')
%define GIIK_PParenRight	GII_KEY(GII_KT_PAD, ')')
%define GIIK_PSpace		GII_KEY(GII_KT_PAD, ' ')
%define GIIK_PEnter		GII_KEY(GII_KT_PAD, '\r')
%define GIIK_PTab		GII_KEY(GII_KT_PAD, '\t')

%define GIIK_PPlusMinus		GII_KEY(GII_KT_PAD, $80)
%define GIIK_PBegin		GII_KEY(GII_KT_PAD, $81)

%define GIIK_PF1		GII_KEY(GII_KT_PAD, $91)
%define GIIK_PF2		GII_KEY(GII_KT_PAD, $92)
%define GIIK_PF3		GII_KEY(GII_KT_PAD, $93)
%define GIIK_PF4		GII_KEY(GII_KT_PAD, $94)
%define GIIK_PF5		GII_KEY(GII_KT_PAD, $95)
%define GIIK_PF6		GII_KEY(GII_KT_PAD, $96)
%define GIIK_PF7		GII_KEY(GII_KT_PAD, $97)
%define GIIK_PF8		GII_KEY(GII_KT_PAD, $98)
%define GIIK_PF9		GII_KEY(GII_KT_PAD, $99)

; modifier keys

%define GIIK_Shift		GII_KEY(GII_KT_MOD, GII_KM_SHIFT)
%define GIIK_Ctrl		GII_KEY(GII_KT_MOD, GII_KM_CTRL)
%define GIIK_Alt		GII_KEY(GII_KT_MOD, GII_KM_ALT)
%define GIIK_Meta		GII_KEY(GII_KT_MOD, GII_KM_META)
%define GIIK_Super		GII_KEY(GII_KT_MOD, GII_KM_SUPER)
%define GIIK_Hyper		GII_KEY(GII_KT_MOD, GII_KM_HYPER)
%define GIIK_AltGr		GII_KEY(GII_KT_MOD, GII_KM_ALTGR)
%define GIIK_Caps		GII_KEY(GII_KT_MOD, GII_KM_CAPS)
%define GIIK_Num		GII_KEY(GII_KT_MOD, GII_KM_NUM)
%define GIIK_Scroll		GII_KEY(GII_KT_MOD, GII_KM_SCROLL)

; modifier _labels_

%define GIIK_ShiftL		(GIIK_Shift  | 0)
%define GIIK_ShiftR		(GIIK_Shift  | GII_KM_RIGHT)
%define GIIK_CtrlL		(GIIK_Ctrl   | 0)
%define GIIK_CtrlR		(GIIK_Ctrl   | GII_KM_RIGHT)
%define GIIK_AltL		(GIIK_Alt    | 0)
%define GIIK_AltR		(GIIK_Alt    | GII_KM_RIGHT)
%define GIIK_MetaL		(GIIK_Meta   | 0)
%define GIIK_MetaR		(GIIK_Meta   | GII_KM_RIGHT)
%define GIIK_SuperL		(GIIK_Super  | 0)
%define GIIK_SuperR		(GIIK_Super  | GII_KM_RIGHT)
%define GIIK_HyperL		(GIIK_Hyper  | 0)
%define GIIK_HyperR		(GIIK_Hyper  | GII_KM_RIGHT)

%define GIIK_ShiftLock		(GIIK_Shift  | GII_KM_LOCK)
%define GIIK_CtrlLock		(GIIK_Ctrl   | GII_KM_LOCK)
%define GIIK_AltLock		(GIIK_Alt    | GII_KM_LOCK)
%define GIIK_MetaLock		(GIIK_Meta   | GII_KM_LOCK)
%define GIIK_SuperLock		(GIIK_Super  | GII_KM_LOCK)
%define GIIK_HyperLock		(GIIK_Hyper  | GII_KM_LOCK)
%define GIIK_AltGrLock		(GIIK_AltGr  | GII_KM_LOCK)
%define GIIK_CapsLock		(GIIK_Caps   | GII_KM_LOCK)
%define GIIK_NumLock		(GIIK_Num    | GII_KM_LOCK)
%define GIIK_ScrollLock		(GIIK_Scroll | GII_KM_LOCK)

; miscellaneous

%define GIIK_NIL   	$ffff	/* used to indicate "not mapped yet" */
%define GII_BUTTON_NIL	$ff	/* used for pseudo keys (composed ones) */

; ASCII keys
%define GIIUC_Nul		$00
%define GIIUC_BackSpace		$08
%define GIIUC_Tab		$09
%define GIIUC_Linefeed		$0a
%define GIIUC_Return		$0d
%define GIIUC_Escape		$1b
%define GIIUC_Delete		$7f

%define GIIUC_Space		$20
%define GIIUC_Exclamation	$21
%define GIIUC_Exclam		GIIUC_Exclamation
%define GIIUC_DoubleQuote	$22
%define GIIUC_QuoteDbl		GIIUC_DoubleQuote
%define GIIUC_NumberSign	$23
%define GIIUC_Hash		GIIUC_NumberSign
%define GIIUC_Dollar		$24
%define GIIUC_Percent		$25
%define GIIUC_Ampersand		$26
%define GIIUC_Apostrophe	$27
%define GIIUC_ParenLeft		$28
%define GIIUC_ParenRight	$29
%define GIIUC_Asterisk		$2a
%define GIIUC_Star		GIIUC_Asterisk
%define GIIUC_Plus		$2b
%define GIIUC_Comma		$2c
%define GIIUC_Minus		$2d
%define GIIUC_Period		$2e
%define GIIUC_Slash		$2f
%define GIIUC_0			$30
%define GIIUC_1			$31
%define GIIUC_2			$32
%define GIIUC_3			$33
%define GIIUC_4			$34
%define GIIUC_5			$35
%define GIIUC_6			$36
%define GIIUC_7			$37
%define GIIUC_8			$38
%define GIIUC_9			$39
%define GIIUC_Colon		$3a
%define GIIUC_Semicolon		$3b
%define GIIUC_Less		$3c
%define GIIUC_Equal		$3d
%define GIIUC_Greater		$3e
%define GIIUC_Question		$3f
%define GIIUC_At		$40
%define GIIUC_A			$41
%define GIIUC_B			$42
%define GIIUC_C			$43
%define GIIUC_D			$44
%define GIIUC_E			$45
%define GIIUC_F			$46
%define GIIUC_G			$47
%define GIIUC_H			$48
%define GIIUC_I			$49
%define GIIUC_J			$4a
%define GIIUC_K			$4b
%define GIIUC_L			$4c
%define GIIUC_M			$4d
%define GIIUC_N			$4e
%define GIIUC_O			$4f
%define GIIUC_P			$50
%define GIIUC_Q			$51
%define GIIUC_R			$52
%define GIIUC_S			$53
%define GIIUC_T			$54
%define GIIUC_U			$55
%define GIIUC_V			$56
%define GIIUC_W			$57
%define GIIUC_X			$58
%define GIIUC_Y			$59
%define GIIUC_Z			$5a
%define GIIUC_BracketLeft	$5b
%define GIIUC_BackSlash		$5c
%define GIIUC_BracketRight	$5d
%define GIIUC_Circumflex	$5e
%define GIIUC_Hat		GIIUC_Circumflex
%define GIIUC_Underscore	$5f
%define GIIUC_Grave		$60
%define GIIUC_a			$61
%define GIIUC_b			$62
%define GIIUC_c			$63
%define GIIUC_d			$64
%define GIIUC_e			$65
%define GIIUC_f			$66
%define GIIUC_g			$67
%define GIIUC_h			$68
%define GIIUC_i			$69
%define GIIUC_j			$6a
%define GIIUC_k			$6b
%define GIIUC_l			$6c
%define GIIUC_m			$6d
%define GIIUC_n			$6e
%define GIIUC_o			$6f
%define GIIUC_p			$70
%define GIIUC_q			$71
%define GIIUC_r			$72
%define GIIUC_s			$73
%define GIIUC_t			$74
%define GIIUC_u			$75
%define GIIUC_v			$76
%define GIIUC_w			$77
%define GIIUC_x			$78
%define GIIUC_y			$79
%define GIIUC_z			$7a
%define GIIUC_BraceLeft		$7b
%define GIIUC_Bar		$7c
%define GIIUC_Pipe		GIIUC_Bar
%define GIIUC_BraceRight	$7d
%define GIIUC_Tilde		$7e

%define GIIUC_NoBreakSpace	$0a0
%define GIIUC_NBSP		GIIUC_NoBreakSpace
%define GIIUC_ExclamDown	$0a1
%define GIIUC_Cent		$0a2
%define GIIUC_Sterling		$0a3
%define GIIUC_Pound		GIIUC_Sterling
%define GIIUC_Currency		$0a4
%define GIIUC_Yen		$0a5
%define GIIUC_BrokenBar		$0a6
%define GIIUC_Section		$0a7
%define GIIUC_Diaeresis		$0a8
%define GIIUC_Umlaut		GIIUC_Diaeresis
%define GIIUC_Copyright		$0a9
%define GIIUC_OrdFeminine	$0aa
%define GIIUC_GuillemotLeft	$0ab
%define GIIUC_NotSign		$0ac
%define GIIUC_SoftHyphen	$0ad
%define GIIUC_Registered	$0ae
%define GIIUC_Macron		$0af
%define GIIUC_Degree		$0b0
%define GIIUC_PlusMinus		$0b1
%define GIIUC_TwoSuperior	$0b2
%define GIIUC_ThreeSuperior	$0b3
%define GIIUC_Acute		$0b4
%define GIIUC_Mu		$0b5
%define GIIUC_Micro		GIIUC_Mu
%define GIIUC_Paragraph		$0b6
%define GIIUC_Pilcrow		GIIUC_Paragraph
%define GIIUC_PeriodCentered	$0b7
%define GIIUC_MiddleDot		GIIUC_PeriodCentered
%define GIIUC_Cedilla		$0b8
%define GIIUC_OneSuperior	$0b9
%define GIIUC_mKuline		$0ba
%define GIIUC_GuillemotRight	$0bb
%define GIIUC_OneQuarter	$0bc
%define GIIUC_OneHalf		$0bd
%define GIIUC_ThreeQuarters	$0be
%define GIIUC_QuestionDown	$0bf
%define GIIUC_Agrave		$0c0
%define GIIUC_Aacute		$0c1
%define GIIUC_Acircumflex	$0c2
%define GIIUC_Atilde		$0c3
%define GIIUC_Adiaeresis	$0c4
%define GIIUC_Aumlaut		GIIUC_Adiaeresis
%define GIIUC_Aring		$0c5
%define GIIUC_AE		$0c6
%define GIIUC_Ccedilla		$0c7
%define GIIUC_Egrave		$0c8
%define GIIUC_Eacute		$0c9
%define GIIUC_Ecircumflex	$0ca
%define GIIUC_Ediaeresis	$0cb
%define GIIUC_Eumlaut		GIIUC_Ediaeresis
%define GIIUC_Igrave		$0cc
%define GIIUC_Iacute		$0cd
%define GIIUC_Icircumflex	$0ce
%define GIIUC_Idiaeresis	$0cf
%define GIIUC_Iumlaut		GIIUC_Idiaeresis
%define GIIUC_ETH		$0d0
%define GIIUC_Ntilde		$0d1
%define GIIUC_Ograve		$0d2
%define GIIUC_Oacute		$0d3
%define GIIUC_Ocircumflex	$0d4
%define GIIUC_Otilde		$0d5
%define GIIUC_Odiaeresis	$0d6
%define GIIUC_Oumlaut		GIIUC_Odiaeresis
%define GIIUC_Multiply		$0d7
%define GIIUC_Ooblique		$0d8
%define GIIUC_Ugrave		$0d9
%define GIIUC_Uacute		$0da
%define GIIUC_Ucircumflex	$0db
%define GIIUC_Udiaeresis	$0dc
%define GIIUC_Uumlaut		GIIUC_Udiaeresis
%define GIIUC_Yacute		$0dd
%define GIIUC_THORN		$0de
%define GIIUC_ssharp		$0df
%define GIIUC_agrave		$0e0
%define GIIUC_aacute		$0e1
%define GIIUC_acircumflex	$0e2
%define GIIUC_atilde		$0e3
%define GIIUC_adiaeresis	$0e4
%define GIIUC_aumlaut		GIIUC_adiaeresis
%define GIIUC_aring		$0e5
%define GIIUC_ae		$0e6
%define GIIUC_ccedilla		$0e7
%define GIIUC_egrave		$0e8
%define GIIUC_eacute		$0e9
%define GIIUC_ecircumflex	$0ea
%define GIIUC_ediaeresis	$0eb
%define GIIUC_eumlaut		GIIUC_ediaeresis
%define GIIUC_igrave		$0ec
%define GIIUC_iacute		$0ed
%define GIIUC_icircumflex	$0ee
%define GIIUC_idiaeresis	$0ef
%define GIIUC_iumlaut		GIIUC_idiaeresis
%define GIIUC_eth		$0f0
%define GIIUC_ntilde		$0f1
%define GIIUC_ograve		$0f2
%define GIIUC_oacute		$0f3
%define GIIUC_ocircumflex	$0f4
%define GIIUC_otilde		$0f5
%define GIIUC_odiaeresis	$0f6
%define GIIUC_oumlaut		GIIUC_odiaeresis
%define GIIUC_Division		$0f7
%define GIIUC_oslash		$0f8
%define GIIUC_ugrave		$0f9
%define GIIUC_uacute		$0fa
%define GIIUC_ucircumflex	$0fb
%define GIIUC_udiaeresis	$0fc
%define GIIUC_uumlaut		GIIUC_udiaeresis
%define GIIUC_yacute		$0fd
%define GIIUC_thorn		$0fe
%define GIIUC_ydiaeresis	$0ff
%define GIIUC_yumlaut		GIIUC_ydiaeresis

; Dead keys
%define GIIK_DeadRing			GII_KEY(GII_KT_DEAD, $00)
%define GIIK_DeadCaron			GII_KEY(GII_KT_DEAD, $01)
%define GIIK_DeadOgonek			GII_KEY(GII_KT_DEAD, $02)
%define GIIK_DeadIota			GII_KEY(GII_KT_DEAD, $03)
%define GIIK_DeadDoubleAcute		GII_KEY(GII_KT_DEAD, $04)
%define GIIK_DeadBreve			GII_KEY(GII_KT_DEAD, $05)
%define GIIK_DeadAboveDot		GII_KEY(GII_KT_DEAD, $06)
%define GIIK_DeadBelowDot		GII_KEY(GII_KT_DEAD, $07)
%define GIIK_DeadVoicedSound		GII_KEY(GII_KT_DEAD, $08)
%define GIIK_DeadSemiVoicedSound	GII_KEY(GII_KT_DEAD, $09)

%define GIIK_DeadAcute			GII_KEY(GII_KT_DEAD, GIIUC_Acute)
%define GIIK_DeadCedilla		GII_KEY(GII_KT_DEAD, GIIUC_Cedilla)
%define GIIK_DeadCircumflex		GII_KEY(GII_KT_DEAD, GIIUC_Circumflex)
%define GIIK_DeadDiaeresis		GII_KEY(GII_KT_DEAD, GIIUC_Diaeresis)
%define GIIK_DeadGrave			GII_KEY(GII_KT_DEAD, GIIUC_Grave)
%define GIIK_DeadTilde			GII_KEY(GII_KT_DEAD, GIIUC_Tilde)
%define GIIK_DeadMacron			GII_KEY(GII_KT_DEAD, GIIUC_Macron)
