#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/fcntl.h>
#include <sys/mman.h>
#include <sys/stat.h>

#include "ttdpatch/grep.h"

unsigned int grep_blksize=4096;

int main(int argc,char **argv) {
    FILE *desc;
    FILE *output;
    int imgfilefd;
    int npatches,offset;
    int i,n;
    char *image;
    char *s;
    struct stat sb;
    char patchline[256];
    char patchname[256];
    char restline[256];
    int value;
    char search[256];
    int searchcount;
    
    if (argc!=5) {
	fprintf(stderr,"Usage: searchpatches <patch_desc_file> <image_file> <output_file> <label_name>\n");
	exit(0);
    } else {
	desc=fopen(argv[1],"r");
	if (desc==NULL) {
	    fprintf(stderr,"Unable to open description file.\n");
	    exit(1);
	};
	
	/* Open the output file */
	output=fopen(argv[3],"w+");
	fprintf(output,";\n");
	fprintf(output,"; This file was automatically generated by search_patches\n");
	fprintf(output,"; Do not modify it manually\n");
	fprintf(output,";\n\n");

	fprintf(output,"[SECTION .data]\n\n");
	fprintf(output,"global %s\n\n",argv[4]);
	fprintf(output,"%s:\n",argv[4]);
	/* Read the number of locations to scan for */
	fscanf(desc,"%d\n",&npatches);
	
	/* Open the image file */
	imgfilefd=open(argv[2],O_RDONLY);
	if (imgfilefd<0) {
	    fprintf(stderr,"Unable to open image file.\n");
	    exit(2);
	};
	fstat(imgfilefd,&sb);
	/* Mmap the image fule */
	image=mmap(0,sb.st_size,PROT_READ,MAP_SHARED,imgfilefd,0);
	if (image==NULL) {
	    fprintf(stderr,"MMap error\n");
	    exit(3);
	};
	for (i=0;i<npatches;i++) {
	    fscanf(desc,"%s\n",patchname);
	    printf("Searching location for patch %d (%s)",i+1,patchname);
	    fscanf(desc,"%d\n",&offset);
	    fgets(patchline,256,desc);
	    searchcount=0;
	    s=patchline;
	    *restline=0;
	    while (sscanf(patchline,"%x%[^\n]",&value,&restline)>0) {
		search[searchcount]=value;
		searchcount++;
		strcpy(patchline,restline);
		*restline=0;
	    };
		
	    /* Search for the bytes. */
	    n=grepmem(image,sb.st_size,search,searchcount,1);
	    if (n!=GREP_NOMATCH) {
	        printf(" -> found at $%x\n",n+offset);
		fprintf(output,"\tdd $0%x ; %s\n",n+offset,patchname);
	    } else {
	        printf(" -> not found\n");
		fprintf(output,"\tdd $0\n");
	    };
	};
	munmap(0,sb.st_size);
	close(imgfilefd);
	fclose(output);
	fclose(desc);
    };
};
