;*****************************************************************************
;*                    Transport Tycoon loader for Linux                      *
;*                                                                           *
;*                   Copyright (C) 2001 by Danil Mantione                   *
;*                          Delft, the Netherlands                           *
;*                                                                           *
;* The author grants you permission to use this software under the terms of  *
;* the "GNU public license" version 2 (and only version 2) until             *
;* 31 December 2004. If the author likes the next version of the GPL         *
;* permission will be granted to use this software under that license too.   *
;* The expiration date is necessary to enforce the new version of the GPL    *
;* if the author decides to use it, otherwise this date will be extended.    *
;*                                                                           *
;* As a special exeception to the "GNU public license", you are granted      *
;* permission to link this code against PC-Dos based computer games like     *
;* Transport Tycoon.                                                         *
;*                                                                           *
;* Contact information:                                                      *
;* E-mail:   daniel.mantione@freepascal.org                                  *
;* Phone:    ++31 15 2510958                                                 *
;*****************************************************************************

%include "system.inc"

[SECTION .data]

extern varedxxx_offset

serial_com1		db '/dev/ttyS0',0
serial_com2		db '/dev/ttyS1',0
serial_com3		db '/dev/ttyS2',0
serial_com4		db '/dev/ttyS3',0

serial_devices		dd serial_com1,serial_com2,serial_com3,serial_com4

; Linux serial support SUCKS!! We must request 38400 baud and then
; set the real baudrate using a custom divisor to be able to use
; TTD's 14400 baud!

newtio: istruc termios
    at termios.c_iflag,	dd IGNPAR
    at termios.c_oflag,	dd 0
    at termios.c_cflag,	dd B38400|CRTSCTS|CS8|CREAD
    at termios.c_lflag,	dd 0
iend

[SECTION .bss]

serial_info		resb serial_struct_size
serial_handle		resd 1
serial_data_byte	resb 1

oldtio			resb termios_size
oldserial_info		resb serial_struct_size

[SECTION .text]

global serial_detect
global open_serial_port
global send_serial_byte
global read_serial_byte
global close_serial_port

;
; Detect the available serial ports. Original at $127ed2
;

serial_detect:
    _mov ebx,0
.next_device:
    push ebx
    sys_open dword [serial_devices+4*ebx],O_RDWR|O_NOCTTY
    pop ebx
    or eax,eax
    js .no_device
    push eax
    push ebx
    sys_ioctl eax,TIOCGSERIAL,serial_info
    pop ebx
    _mov edx,0
    mov esi,[serial_info+serial_struct.type]
    cmp dword [serial_info+serial_struct.type],edx
    je .port_not_present
    ; We return as IO port $8000+the serial port number
    mov dh,$80
    mov dl,bl
.port_not_present:
    mov [$9c45e+2*ebx],dx
    pop eax
    push ebx
    sys_close eax
    pop ebx
.no_device:
    inc ebx
    cmp bl,4
    jne .next_device
    ret

;
; Open the serial port and configure it. Original at $12777b
;

open_serial_port:
    ; In case the serial port is already open, close it first.
    push ax
    call close_serial_port
    pop ax
    mov byte [$9edea],al	; Store which serial port we try to open.
    movzx eax,al
    
    ; Open the serial port
    sys_open dword [serial_devices+4*eax],O_RDWR,O_NOCTTY
    mov [serial_handle],eax
    
    ; Store the old configuration of the port
    push eax
    sys_ioctl eax,TCGETS,oldtio
    pop eax
    push eax
    sys_ioctl eax,TIOCGSERIAL,oldserial_info
    pop eax
    
    ; Configure the port
    push eax
    sys_ioctl eax,TCSETSF,newtio
    pop eax
    push eax
    sys_ioctl eax,TIOCGSERIAL,serial_info
    pop eax
    mov ecx,[serial_info+serial_struct.flags]
    and ecx,ASYNC_SPD_MASK
    or ecx,ASYNC_SPD_CUST
    mov [serial_info+serial_struct.flags],ecx
    ; Get the speed divisor
    mov esi,[varedxxx_offset]
    movzx ebx,byte [$9ed36]
    movzx ebx,byte [$0ed079+ebx+esi]
    mov [serial_info+serial_struct.custom_divisor],ebx
    sys_ioctl eax,TIOCSSERIAL,serial_info
    xor eax,eax
    mov esi,[varedxxx_offset]
    mov [$0ed058+esi],eax
    mov [$0ed05c+esi],eax
    ret

;
; Send a byte in ah over the serial port. Original at $127981 and $1279bd
;
send_serial_byte:
    push ebx
    push ecx
    push edx
    mov [serial_data_byte],ah
    push eax
    sys_write [serial_handle],serial_data_byte,1
    or eax,eax
    js .error
    jz .error
    pop eax
    pop edx
    pop ecx
    pop ebx
    clc
    ret
.error:
    pop eax
    pop edx
    pop ecx
    pop ebx
    stc
    ret

;
; Read a byte from the serial port. Original at $1279e6
;

read_serial_byte:
    push ebx
    push ecx
    push edx
    push esi
    push eax
    mov esi,[varedxxx_offset]
    mov eax,[$0ed058+esi]
    cmp eax,[$0ed05c+esi]
    jne .data_available
    ; Read some data from the serial port
    add esi,$0ecc58
    sys_read dword [serial_handle],esi,$400
    or eax,eax
    js .error
    jz .error
    mov esi,[varedxxx_offset]
    mov [$0ed05c+esi],eax
    _mov eax,0
    mov [$0ed058+esi],eax
.data_available:
    mov ebx,[varedxxx_offset]
    mov esi,[$0ed058+ebx]
    mov al,[$0ecc58+esi+ebx]
    inc dword [$0ed058+ebx]
    mov bl,al
    pop eax
    mov al,bl
    pop esi
    pop edx
    pop ecx
    pop ebx
    clc
    ret
.error:
    pop eax
    pop esi
    pop edx
    pop ecx
    pop ebx
    stc
    ret

;
; Close the current open serial port. Original at $12769e
;

close_serial_port:
    cmp byte [$9edea],$0ff	; If there is no serial port open, exit.
    je .exit
    ; Configure the port to it's old configuration
    sys_ioctl [serial_handle],TCSETSF,oldtio
    sys_ioctl [serial_handle],TIOCSSERIAL,oldserial_info
    ; Close the port
    sys_close [serial_handle]
.exit:
    ret
