//
// Localization strings for TTDPatch.
//

//-------------------------------------------
//  INFO ABOUT THIS LANGUAGE
//-------------------------------------------
SETNAME("English")
COUNTRYARRAY(countries) = { -1, 0, 0x09, -1, 0 };

// Normal code pages 437, 850.

//-------------------------------------------
//  PROGRAM BLURBS
//-------------------------------------------

// First line of output is something like "TTDPatch V1.5.1 starting.\n"
// The program name and version are autogenerated, only put the " starting\n"
// here
SETTEXT(LANG_STARTING, " starting.\n")


//-------------------------------------------
//  VERSION CHECKING
//-------------------------------------------

// In the version identifier, this is for the file size
SETTEXT(LANG_SIZE, "size")

// Shown if the version is recognized
SETTEXT(LANG_KNOWNVERSION, "This version of the program has known addresses.\n")

// Warning if the version isn't recognized.  Be sure *not* to use tabs
// in the text.  All but the last lines should end in ...\n"
SETTEXT(LANG_WRONGVERSION, "\n"
	"WARNING! Your program version is not known to this program. We can now try\n"
	"         to start it anyway and determine the necessary information, but if\n"
	"         that fails, TTD will receive a Protection Fault and terminate.\n"
	"\n"
	"         Depending on how well your operating system handles a GPF, it may\n"
	"         cause your computer to lock up, and you may lose data. Please look\n"
	"         in section 4.1 of TTDPATCH.TXT for more information.\n"
	"\n"
	"Answer 'y' only if you really know what you are doing. YOU HAVE BEEN WARNED!\n"
	"Do you want to start TTD anyway? ")

// Keys which continue loading after the above warning. *MUST* be lower case.
// can be several different keys, e.g. one for your language "yjo"
SETTEXT(LANG_YESKEYS, "y")

// Answering anything but the above keys gives this message.
SETTEXT(LANG_ABORTLOAD, "Program load aborted.\n")

// otherwise continue loading
SETTEXT(LANG_CONTINUELOAD, "I'll try to do my best...\n")

// Warning if '-y' was used and the version is unknown
SETTEXT(LANG_WARNVERSION, "WARNING: Version is unknown!\n")

// Successful load of ttdload and writing the .ver file gives this
SETTEXT(LANG_VERSIONINFOSAVED,
	"Congratulations! It seems that all necessary information has been\n"
	"collected, and that this version can be added to the loader.\n\n")

// Something went wrong, not all offsets could be determined
SETTEXT(LANG_VERSIONINFONOTSAVED, 
	"Hmm, it seems all is not right, some information could not be found.\n" 
	"Please look in section 3.2 of TTDPATCH.TXT to see what to do about this.\n\n")

// Text just after the above messages
// %s is the file name
SETTEXT(LANG_WRITINGINFO,
	"I will now write %s which will contain the information.\n" 
	"Please have a look in section 4.1 of TTDPATCH.TXT about what to do with this\n" 
	"file.  Until the information is fully integrated, you can use the -Y switch\n" 
	"to always answer ''Y'' to the previous query.\n")


// -------------------------------------------
//    CREATING AND PATCHING TTDLOAD
// -------------------------------------------

// TTDLOAD.EXE doesn't exist
SETTEXT(LANG_FILENOTFOUND, " not found, looking for original files:\n")

// neither do tycoon.exe or ttdx.exe.  %s is TTDX.EXE
SETTEXT(LANG_NOFILESFOUND, "Could find neither TYCOON.EXE nor %s.\n")

// Shown when copying tycoon.exe or ttdx.exe (first %s) to ttdload.exe (2nd %s)
SETTEXT(LANG_SHOWCOPYING, "Copying %s to %s")

// Error if running the copy command fails.  %s is the command.
SETTEXT(LANG_COPYERROR_RUN, "Couldn't run %s\n")

// Error if command returned successfully, but nothing was copied.
// %s=TTDLOAD.EXE
SETTEXT(LANG_COPYERROR_NOEXIST, "Copy error - file %s doesn't exist.\n")

// Invalid .EXE format
SETTEXT(LANG_INVALIDEXE, "Unrecognized .EXE format.\n")

// Version could not be determined
SETTEXT(LANG_VERSIONUNCONFIRMED, "Could not determine program version.\n")

// Shows program name (1st %s) and version (2nd %s)
SETTEXT(LANG_PROGANDVER, "The program name is %s\nThe exact version is %s\n")

// More than three numbers in the version string (not #.#.#)
SETTEXT(LANG_TOOMANYNUMBERS, "Version has too many numbers!\n")

// .EXE is not TTD
SETTEXT(LANG_WRONGPROGRAM, "This is not Transport Tycoon Deluxe.\n")

// Displays the parsed version number
SETTEXT(LANG_PARSEDVERSION, "Parsed version is %s\n")

// The exe has been determined to be the DOS extended executable
SETTEXT(LANG_ISDOSEXTEXE, "This is the DOS extended executable.\n")

// The exe has been determined to be the Windows executable
SETTEXT(LANG_ISWINDOWSEXE, "This is the Windows executable.\n")

// The exe is of an unknown type
SETTEXT(LANG_ISUNKNOWNEXE, "This is not a known executable format.\n")

// The exe is the wrong one for this TTDPatch, i.e. DOS/Windows mixed up. %s=DOS or Windows
SETTEXT(LANG_NOTSUPPORTED, "Sorry, this version of TTDPatch works only with the %s version.\n")

// If the original .exe segment length (%lx) is too large or too small
SETTEXT(LANG_INVALIDSEGMENTLEN, "Invalid original segment length of %lx.\n")

// When increasing the segment length
SETTEXT(LANG_INCREASECODELENGTH, "Setting program size to %g MB.\n")

// Can't write to TTDLOAD.EXE (%s) [or TTDLOADW.EXE for the Windows version]
SETTEXT(LANG_WRITEERROR, "Can't write to %s, is it read-only?\n")

// Installing the code loeader
SETTEXT(LANG_INSTALLLOADER, "Installing code loader.\n")

// TTDLOAD.EXE (%s) is invalid, needs to be deleted.
SETTEXT(LANG_TTDLOADINVALID, "Couldn't install code loader - try to delete %s.\n")

// TTDLOAD.EXE was verified to be correct
SETTEXT(LANG_TTDLOADOK, "%s is OK.\n")


//-----------------------------------------------
//   COMMAND LINE HELP (-h)
//-----------------------------------------------

// Introduction, prefixed with "TTDPATCH V<version> - "
SETTEXT(LANG_COMMANDLINEHELP, "Patches TTD and start the patched program %s\n"
	  "\n"
	  "Usage: TTDPATCH [-C cfg-file] [switches] [CD Path] [-W cfg-file]\n"
	  "\n")

// Lines of help for all on/off switches, each at most 38 chars long.
// If you need more chars just insert another line.
TEXTARRAY(halflines,) =
	{ "-a: All switches but -o,-x",
	  "-f: Make trains refittable",
	  "-g: Some general fixes",
	  "-k: Keep small airports",
	  "-l: Up to 7 station platforms",
	  "-n: New non-stop handling",
	  "-q: Improved (un)load time algorithm",
	  "-s: Enable the sign cheats",
	  "-v: Verbosely show the switches",
	  "-w: Enable pre-signals setups",
	  "-y: Skip unknown version query",
	  "-z: Mammoth trains (126 cars)",
	  "-B: Allow longer bridges",
	  "-D: Dynamite can destroy more items",
	  "-F: Full load means any cargo type",
	  "-G: Selectable station goods",
	  "-I: Turn off inflation",
	  "-J: Allow more airports per city",
	  "-L: Borrow/repay max. with \"Ctrl\"",
	  "-M: Allow multi-headed trains",
	  "-O: Office Tower accept food",
	  "-P: Persistent engines if used",
	  "-R: Road vehicles queue up",
	  "-Z: Low memory version (2.5MB)",
	  NULL
	};

// Text describing the switches with values.  The lines have to be shorter
// than 79 chars, excluding the "\n".  Start new lines if necessary.
SETTEXT(LANG_FULLSWITCHES, "\n"
	  "-e #:    Increase possible station spread\n"
	  "-i #:    Default service interval is the given number of days\n"
	  "-o #:    Reduce vehicle array when saving. DANGEROUS! Read the documentation!\n"
	  "-x #:    Extend the vehicle array to 850*#. Read the documentation!\n"
	  "-mc #:   New mountain or curve handling, respectively\n"
	  "-trpb #: Increase number of trains, road vehicles, planes or ships, resp.\n"
	  "-A #:    Boost the AI by this number. Use small values only.\n"
	  "\n"
	  "-C cfg-file:  Read this configuration file instead of ttdpatch.cfg\n"
	  "-W cfg-file:  Creates a configuration file with the current configuration\n"
	  "\n"
	  "Capitalization is important!\n"
	  "\n"
	  "Example:  ttdpatch -fnqz -m 00 -c 13 -trpb 240 -FG -A 2 -v\n"
	  "\n"
	  "(Hint:  If everything scrolled by too fast, enter \"ttdpatch -h|more\")\n"
	  "\n")

// Referral to the docs, prefixed by "Copyright (C) 1999 by Josef Drexler.  "
SETTEXT(LANG_HELPTRAILER, "See TTDPATCH.TXT for more details.\n")


//-----------------------------------------------
//  COMMAND LINE AND CONFIG FILE PARSING
//-----------------------------------------------

// if an on/off switch has a value other than the above (%s = wrong value)
SETTEXT(LANG_UNKNOWNSTATE, "Unknown on/off state %s, set to off.\n")

// switch is unknown.  %c is '-' or '/' etc, %s is the switch char
SETTEXT(LANG_UNKNOWNSWITCH, "Unknown switch '%c%s'.  Use -h for help.")

// cfg command %s is unknown
SETTEXT(LANG_UNKNOWNCFGLINE, "Invalid cfg line '%s'.")

// Names of the switches for the '-v' options
// First string is shown always, second only if set and with the given
// value of the switch in %d.
// These lines (both parts) are limited to 36 chars, also consider how large
// the expansion of the %d can be for that switch.
SWITCHTEXT(uselargerarray, "Extend total vehicles", " to %d*850")
SWITCHTEXT(usenewcurves, "New curve handler", "")
SWITCHTEXT(usenewmountain, "New mountain handler", "")
SWITCHTEXT(usenewnonstop, "New non-stop handling", "")
SWITCHTEXT(increasetraincount, "New train count", ": %d")
SWITCHTEXT(increaservcount, "New road vehicle count", ": %d")
SWITCHTEXT(setnewservinterval, "New def.service interval", ": %d days")
SWITCHTEXT(usesigncheat, "Use Sign cheat", "")
SWITCHTEXT(allowtrainrefit, "Allow train refit", "")
SWITCHTEXT(increaseplanecount, "New aircraft count", ": %d")
SWITCHTEXT(increaseshipcount, "New ship count", ": %d")
SWITCHTEXT(saveonlysmall, "Save reduced vehicles", " up to %d*850")
SWITCHTEXT(keepsmallairports, "Keep small airports", "")
SWITCHTEXT(largerstations, "Incr. station spread", " to %d sq.")
SWITCHTEXT(morestationtracks, "Extensible stations", "")
SWITCHTEXT(longerbridges, "Longer bridges", "")
SWITCHTEXT(improvedloadtimes, "Improved load time calc.", "")
SWITCHTEXT(mammothtrains, "Mammoth trains (length 127)", "")
SWITCHTEXT(presignals, "Use pre-signals", "")
SWITCHTEXT(officefood, "Office Towers accept food", "")
SWITCHTEXT(noinflation, "Turn off inflation", "")
SWITCHTEXT(maxloanwithctrl, "Max borrow/repay w/ctrl", "")
SWITCHTEXT(persistentengines, "Persistent engines if used", "")
SWITCHTEXT(fullloadany, "Full load means any cargo", "")
SWITCHTEXT(selectstationgoods, "Selectable station goods", "")
SWITCHTEXT(morethingsremovable, "More things removable", "")
SWITCHTEXT(aibooster, "Boost AI recursion", " by %d")
SWITCHTEXT(multihead, "Multi-headed trains", "")
SWITCHTEXT(newlineup, "Road vehicle queueing", "")
SWITCHTEXT(lowmemory, "Low memory version (2.5MB)", "")
SWITCHTEXT(generalfixes, "General fixes (see docs)", "")
SWITCHTEXT(moreairports, "More airports allowed per town", "")

// A cfg file (%s) could not be found and is ignored.
SETTEXT(LANG_CFGFILENOTFOUND, "Couldn't find cfg file %s.  Ignored.\n")

// Couldn't write the config file
SETTEXT(LANG_CFGFILENOTWRITABLE, "Couldn't open %s for writing.\n")

// A non-comment line is longer than 32 chars, rest ignored.
SETTEXT(LANG_CFGLINETOOLONG, "Warning!  Configuration line is longer than 32 chars, truncated.\n")

// Shown if an obsolete switch is used. First option is %s which is the
// config name, second one is %s which is the command line char
SETTEXT(LANG_SWITCHOBSOLETE, "The switch `%s' (-%s) is obsolete. Please do not use it, it will\n"
		"be removed in a future version.\n")

//---------------------------------------------------
//   CONFIG FILE COMMENTS (for '-W')
//---------------------------------------------------

// This is the intro at the start of the config file.  No constraints on line lengths.
SETTEXT(CFG_INTRO,
	CFG_COMMENT "\n"
	CFG_COMMENT "TTDPatch Configuration File, automatically created by TTDPatch -W filename.\n"
	CFG_COMMENT "\n"
	CFG_COMMENT "Format for the switches is:\n"
	CFG_COMMENT "   switchname = switchvalue\n"
	CFG_COMMENT "\n"
	CFG_COMMENT "The \"=\" can be omitted, as can the spaces.  Case is ignored.\n"
	CFG_COMMENT "\n"
	CFG_COMMENT "For yes/no [y/n] switches, the value can be one of:\n"
	CFG_COMMENT "   yes, y, on, 1, no, n, off, 0\n"
	CFG_COMMENT "If the value is omitted, a yes/no switch defaults to yes.\n"
	CFG_COMMENT "\n"
	CFG_COMMENT "For the switches with a value option [v], the range is given in the\n"
	CFG_COMMENT "description, as is the default if the value is omitted.  The switch can\n"
	CFG_COMMENT "be turned off by giving it one of the 'off' values.\n"
	CFG_COMMENT "\n"
	CFG_COMMENT "Comments are all lines starting with any non-alphabetical character.\n"
	CFG_COMMENT "\n")

// Definitions of the cfg file comments.
// All can have a place holder %s to stand for the actual setting name,
// and all but CFG_CDPATH can have a %s *after* the %s for the command
// line switch.
// They will have the "comment" char and a space prefixed.
//
SETTEXT(CFG_SHIPS, "`%s' (-%s) increases the maximum number of ships.  Range 1..240.  Default 240.")
SETTEXT(CFG_CURVES, "`%s' (-%s) makes trains faster in wide curves.  Bitcoded two-digit value.  Default 13.")
SETTEXT(CFG_SPREAD, "`%s' (-%s) makes it possible to have stations more spread out.  Range 1..255.  Default 20.")
SETTEXT(CFG_TRAINREFIT, "`%s' (-%s) makes it possible to refit train engines.")
SETTEXT(CFG_SERVINT, "`%s' (-%s) allow to change the initial service interval for new engines.  Range 1..32000.  Default 16000.")
SETTEXT(CFG_NOINFLATION, "`%s' (-%s) turns off all inflation, both for cost and revenue.")
SETTEXT(CFG_LARGESTATIONS, "`%s' (-%s) allows to add more platforms or make a station longer, up to 4x7 or 7x5.")
SETTEXT(CFG_MOUNTAINS, "`%s' (-%s) makes trains faster on mountains.  Bitcoded two-digit value.  Default 13.")
SETTEXT(CFG_NONSTOP, "`%s' (-%s) makes the \"Non-stop\" switch behave differently.")
SETTEXT(CFG_REDUCEDSAVE, "`%s' (-%s) reduces the number of vehicles in the running game when saving.  Range 1..(morevehicles-1).")
SETTEXT(CFG_PLANES, "`%s' (-%s) increases the maximum number of planes.  Range 1..240.  Default 240.")
SETTEXT(CFG_LOADTIME, "`%s' (-%s) enables a different calculation for load/unload times.")
SETTEXT(CFG_ROADVEHS, "`%s' (-%s) increases the maximum number of road vehicles.  Range 1..240.  Default 240.")
SETTEXT(CFG_SIGNCHEATS, "`%s' (-%s) enables the sign cheats.")
SETTEXT(CFG_TRAINS, "`%s' (-%s) increases the maximum number of trains.  Range 1..240.  Default 240.")
//*#define CFG_PLAYERS "`%s' (-%s) set the players to be affected by the cheats.  A list of players from 0..7"
SETTEXT(CFG_VERBOSE, "`%s' (-%s) shows a summary of the switches before starting TTD.")
SETTEXT(CFG_PRESIGNALS, "`%s' (-%s) allows the use of 'pre-signals' to improve station handling.")
SETTEXT(CFG_MOREVEHICLES, "`%s' (-%s) increases the total number of vehicles to value*850.  Range 1..40.  Default 1.")
SETTEXT(CFG_MAMMOTHTRAINS, "`%s' (-%s) allows mammoth trains with up to 126 cars.")
SETTEXT(CFG_FULLLOADANY, "`%s' (-%s) makes a train leave a station if any type of cargo is full.")
SETTEXT(CFG_SELECTGOODS, "With `%s' (-%s) goods arrive only after the service has been inaugurated.")
SETTEXT(CFG_DEBTMAX, "`%s' (-%s) enables borrowing/repaying the maximum amount by pressing Ctrl.")
SETTEXT(CFG_OFFICEFOOD, "`%s' (-%s) makes office towers accept food (tropic/arctic scenarios).")
SETTEXT(CFG_ENGINESPERSIST, "`%s' (-%s) keeps engines around for as long as they are in use.")
SETTEXT(CFG_CDPATH, "`%s' (no command line switch) sets the CD path.")
// Note- CFG_CDPATH has no command line switch, so don't give %s!
SETTEXT(CFG_KEEPSMALLAP, "`%s' (-%s) keeps small airports around forever.")
SETTEXT(CFG_AIBOOST, "`%s' (-%s) increases the AI recursion by this amount.")
SETTEXT(CFG_LONGBRIDGES, "`%s' (-%s) allows bridges of up to 127 squares length.")
SETTEXT(CFG_DYNAMITE, "`%s' (-%s) allows more things to be removed with dynamite.")
SETTEXT(CFG_MULTIHEAD, "`%s' (-%s) allows an arbitrary number of engines on a train. Buy extra engines with 'Ctrl'.")
SETTEXT(CFG_RVQUEUEING, "`%s' (-%s) makes road vehicles queue up in front of a station, not turn around.")
SETTEXT(CFG_LOWMEMORY, "`%s' (-%s) allows TTDPatch to run with 2.5MB of memory, but reduces the max. value for the extended vehicle array to 2.")
SETTEXT(CFG_GENERALFIXES, "`%s' (-%s) fixes various little things, see the docs for more info on what exactly it does.")
SETTEXT(CFG_MOREAIRPORTS, "`%s' (-%s) allows building more airports than the normal two per city.")


//----------------------------------------------------
//   SWITCH DISPLAY ('-v')
//----------------------------------------------------

// Introduction
SETTEXT(LANG_SHOWSWITCHINTRO, "\n"
	  "\n"
	  "    Switches enabled:   (* enabled,  disabled)\n"
	  "\n")

// Names of the three train types, plus "none ", all trailed by a space
TEXTARRAY(traintypes, TRAINTYPENUM) =
	{ "Railroad ", "Monorail ", "MagLev ", "none " };

// Three characters: vertical line for the table; enabled switch; disabled switch.
SETTEXT(LANG_SWTABLEVERCHAR, "*")

// Output after "New mountain handler" or "New curve handler" if set
SETTEXT(LANG_SWFASTERFOR, " for %02x.  ")

// Output before the train types for the given speed increases
SETTEXT(LANG_SWFASTER, "Faster: ")
SETTEXT(LANG_SWFULLSPEED, "Full: ")

// Shows the load options for ttdload.  %s is the given parameters to be passed to ttdload
SETTEXT(LANG_SWSHOWLOAD, "Press any key to run \"TTDLOAD %s\" (Escape to abort).")

SETTEXT(LANG_SWABORTLOAD, "\nProgram load aborted at user request.\n")


//---------------------------------------
//  STARTUP AND REPORTING
//---------------------------------------

// Incorrect magic bytes for protected mode code
SETTEXT(LANG_CHECKMAGIC, "Code is invalid: %d.\n")

// DOS reports no memory available
SETTEXT(LANG_NOTENOUGHMEM, "Not enough memory available %s, need %d KB more.\n")

// ...for starting TTD
SETTEXT(LANG_TOSTARTTTD, "to start TTD")

// Protected mode code exceeds 32kb
SETTEXT(LANG_PROTECTEDTOOLARGE, "Protected mode code too large!\n")

// Show where the code was stored, %p is the location
SETTEXT(LANG_CODESTOREDAT, "Protected mode code stored at %lX.\n")

// Swapping TTDPatch out
SETTEXT(LANG_SWAPPING, "Swapping out.\n")

// Just before running ttdload, show this.
// 1st %s is ttdload.exe, then %s is a space if there are options,
// and the 2nd %s contains the options
SETTEXT(LANG_RUNTTDLOAD, "Starting %s%s%s\n")

// Error executing ttdload.  1st %s is ttdload.exe, 2nd %s is the error message from the OS
SETTEXT(LANG_RUNERROR, "Couldn't execute %s: %s.\n")

// Show the result after after running, %s is one of the following strings
SETTEXT(LANG_RUNRESULT, "Result: [%s]\n")
SETTEXT(LANG_RUNRESULTOK, "OK")
SETTEXT(LANG_RUNRESULTERROR, "Error!")
