//
// This file is part of TTDPatch
// Copyright (C) 1999 by Josef Drexler
//
// lang.h:	define function for dealing with the languages
//		Each lang#.cpp deals with a set of four languages
//		This .h file is included by all of them and does the
//		actual work
//


#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#ifndef C
#	define C	// for common.h
#endif

#include "types.h"
#include "error.h"
#include "common.h"

#define IS_LANGUAGE_CPP
#include "language.h"


// Macros to make defining the arrays easier
#define ARRAYNAME(name) name ## _ ## LANGUAGE
#define COUNTRYARRAY(name) \
	static u16 ARRAYNAME(name) []
#define TEXTARRAY(name,size) \
	static char * ARRAYNAME(name) [size]
#define SETARRAY(name) \
	name = ARRAYNAME(name)

#define SETNAME(name) \
	char *langname = name;
#define SETTEXT(name,text) \
	langtext[name] = text;
#define SETLONGTEXT(name) \
	langtext[name] =
#define SWITCHTEXT(name, text1, text2) \
	switchnames[name*2] = text1; switchnames[name*2+1] = text2;

#define LANGFILE(name) <lang/ ## LANGUAGE ## .h>

#define ACTION "loadlang.h"
#include "proclang.h"
#undef ACTION

void PROCESS_LANGUAGES()
{
# define ACTION "deflang.h"
# include "proclang.h"
# undef ACTION
  nlang = curlang;

  if (curlang > LANG_MAX) {
	printf("Too many languages, adjust LANG_MAX in language.h\n");
	exit(1);
  }

}
