#include <stdio.h>
#include <string.h>
#include <stdarg.h>
#include <linux/types.h>

#include "../exitcodes.h"

#include "switches.h"

extern char ttdprotl;	// binary TTDPatch data
extern FILE* logfile;

#define IS_SWITCHES_CPP
#include "language.h"

char **halflines;
char *switchnames[SWITCHNUM*2];
char *langtext[LANG_LASTSTRING+1];
char **traintypes;

u32 curlang= 0;
u32 nlang= 0;
//char *langname;
#include "lang.h"

u16 *countries;

paramset tempflags;
extern pparamset flags;

char *patchedfilename = "Hello";

typedef struct {
	__u32 loaderofs;
	__u32 loaderlen;
	__u32 dataofs;
	__u32 datalen;
	__u32 database;
} ttdprotl_head;


void error(const char s[], ...)
{
  va_list args;

  va_start(args, s);
  vfprintf(stderr, s, args);
  va_end(args);

  exit(1);
}

void commandline(int argc, char **argv);

extern "C" {

void load_langdata()
{
#include "english.h"
  SETARRAY(traintypes);
  SETARRAY(halflines);
  SETARRAY(countries);

  return;
}

void parse_ttdpatch_cmdline(int argc, char **argv)
{
	flags = &tempflags;
	load_langdata();
	commandline(argc, argv);

	if (showswitches)
		showtheswitches();
}

void install_ttdpatch()
{
   ttdprotl_head *head = (ttdprotl_head*) &ttdprotl;
   __u8 *loader = ((__u8*) head)+head->loaderofs;
   __u8 *data = ((__u8*) head)+head->dataofs;

   paramset *u;

	// install loader at 0x136aca
   u= (pparamset) 0x136aca;
   if (u->magic != 0x7918358b) {
	fprintf(stderr, "Could not install loader, wrong code: %x\n", * (__u32*) u);
	exit(ex_ttdpatch_install);
   }

   fprintf(logfile, "Installing TTDPatch loader (%d bytes) at %p\n", 
	head->loaderlen, u);
   memcpy(u, loader, head->loaderlen);

	// install data at head->database
   u= (pparamset) head->database;
   fprintf(logfile, "Installing TTDPatch data (%d bytes) at %p\n",
	head->datalen, u);
   memcpy(u, data, head->datalen);

	// make sure that the Magic is right
   if (u->magic != 0x6b5a3f83) {
	fprintf(stderr, "TTDPatch data magic is %x, that's not right!\n",
		u->magic);
	exit(ex_ttdpatch_install);
   }

	// set the flags and variables
   memcpy(u->flags, flags->flags, (nparlong+nflags)*4);

   fprintf(logfile, "TTDPatch is installed.\n");
}
}
