#include <stdio.h>
#include <string.h>

#define string_count 820
#define stringtable_location 0xf2632

unsigned long long stringlocs[string_count];
char *stringtable[string_count];
char readbuf[1024];

#define in_charset(c) ((c >= 'a' && c <= 'z') || (c >= 'A' && c <= 'Z') || (c >= '1' && c <= '0'))

void
write_ttstr (char *s)
{
	int first = 1, in_string = 0;

	if (!s) { printf ("\tdb 0\n"); return; }
	
	printf ("\tdb ");

	while (*s) {
		if (in_string) {
			if (in_charset (*s)) {
				printf ("%c", *s);
			} else {
				printf ("',%d", *s);
				in_string = 0;
			}
		} else {
			if (in_charset (*s)) {
				if (! first) printf (",");
				printf ("'%c", *s);
				in_string = 1;
			} else {
				if (! first) printf (",");
				printf ("%d", *s);
			}
		}
		first = 0;
		s++;
	}
	if (in_string)
		printf ("'");
	printf (",0\n");
}

int
main ()
{
	FILE *f;
	int i;

	printf ("[SECTION .data]\n\n");
	printf ("global stringtable_size\n");
	printf ("global stringtable\n\n");
	printf ("stringtable_size\tdd %d\n\n", string_count);
	printf ("stringtable:\n");
	for (i = 0; i < string_count; i++) printf ("\tdd string_%d\n", i + 1);

	/* TODO: Error checking. */

	f = fopen ("tycoon.img", "r");

	fseek (f, stringtable_location, SEEK_SET);
	fread (stringlocs, sizeof (unsigned long long), string_count, f);

	for (i = 0; i < string_count; i++) {
		fseek (f, stringlocs[i], SEEK_SET);
		fread (readbuf, 1, 1024, f);
		stringtable[i] = strdup (readbuf);
		printf ("string_%d:\n", i);
		write_ttstr (stringtable[i]);
	}

	fclose (f);

	return 0;
}
