;*****************************************************************************
;*                    Transport Tycoon loader for Linux                      *
;*                                                                           *
;*                   Copyright (C) 2001 by Danil Mantione                   *
;*                          Delft, the Netherlands                           *
;*                                                                           *
;* The author grants you permission to use this software under the terms of  *
;* the "GNU public license" version 2 (and only version 2) until             *
;* 31 December 2004. If the author likes the next version of the GPL         *
;* permission will be granted to use this software under that license too.   *
;* The expiration date is necessary to enforce the new version of the GPL    *
;* if the author decides to use it, otherwise this date will be extended.    *
;*                                                                           *
;* As a special exeception to the "GNU public license", you are granted      *
;* permission to link this code against PC-Dos based computer games like     *
;* Transport Tycoon.                                                         *
;*                                                                           *
;* Contact information:                                                      *
;* E-mail:   daniel.mantione@freepascal.org                                  *
;* Phone:    ++31 15 2510958                                                 *
;*****************************************************************************

%include "system.inc"
%include "ttd.inc"
%include "patches.inc"

[SECTION .bss]
cmap_red:	resw 256
cmap_green:	resw 256
cmap_blue:	resw 256

[SECTION .data]

cmap:	istruc fb_cmap
	at fb_cmap.start,	dd 0
	at fb_cmap.len,		dd 0
	at fb_cmap.r_ptr,	dd cmap_red
	at fb_cmap.g_ptr,	dd cmap_green
	at fb_cmap.b_ptr,	dd cmap_blue
	at fb_cmap.t_ptr,	dd 0
	iend
	
extern	fbdev_fd
extern  patch_locs

[SECTION .text]

extern  enter_graphics_mode

global video_detect
global video_patch_1
global video_patch_2
global palette_patch_1
global palette_patch_2
global palette_patch_3
global palette_patch_4

extern ioctl

;Video card detection
video_detect:
    mov dword [$9f1c2],banked_fb_addr
    mov word [$9f1c6],ds
    mov word [$9f172],16 	; Rightshift a pixelnumber with this to get the bank
    mov dword [$9f16e],$0ffff	; And a pixelnumber with this to get the offset

    _mov ebx,4*p_video_detect_exit
    add ebx,[patch_locs]
    jmp [ebx]

video_patch_1:
    ; At a lot of locations there is a check if we write to the video memory.
    ; This is done by comparing the segments. Because we are in
    ; a flat memory model the segments are allways equal, so
    ; the check does not work.
    ;
    ; This patch does the check and returns the result in the zero flag
    ; so the original je instruction in the core can be used to jump.
    mov al,1
    cmp edi,banked_fb_addr
    jb near .outrange
    cmp edi,banked_fb_addr+(1024*1024)
    jae near .outrange
    dec al
.outrange:
    or al,al
    ret

video_patch_2:
    ;
    ; There is also a situation where this happens for the esi register
    ; instead of edi
    ;
    mov al,1
    cmp esi,banked_fb_addr
    jb near .outrange
    cmp esi,banked_fb_addr+(1024*1024)
    jae near .outrange
    dec al
.outrange:
    or al,al
    ret

;
; Waits for a vertical retrace
;

wait_retrace:
    mov dx,$3da
.a1:
    in al,dx
    test al,8
    jnz .a1
.a2:
    in al,dx
    test al,8
    jz .a2
    ret
    
;
; Set the palette from $e3 on. Original at $12d194
;

palette_patch_1:
    mov dword [cmap+fb_cmap.start],$0e3
    mov ecx,$1d
    mov dword [cmap+fb_cmap.len],ecx
    xor ebx,ebx
    mov esi,esp
.a1:
    lodsb
    shl al,2
    mov ah,al
    mov word [cmap_red+2*ebx],ax
    lodsb
    shl al,2
    mov ah,al
    mov word [cmap_green+2*ebx],ax
    lodsb
    shl al,2
    mov ah,al
    mov word [cmap_blue+2*ebx],ax
    inc ebx
    loop .a1
    call wait_retrace
    sys_ioctl [fbdev_fd],FBIOPUTCMAP,cmap
    dec word [$778ee]
    _add esp,$400
    retn
    
;
; Palette set routine. Original at $1291f9
;

palette_patch_2:
    mov cx,$100
    xor eax,eax
    mov dword [cmap+fb_cmap.start],eax
    mov dword [cmap+fb_cmap.len],$100
    xor ebx,ebx
.a1:
    lodsb
    shl al,2
    mov ah,al
    mov [cmap_red+2*ebx],ax
    lodsb
    shl al,2
    mov ah,al
    mov [cmap_green+2*ebx],ax
    lodsb
    shl al,2
    mov ah,al
    mov [cmap_blue+2*ebx],ax
    inc ebx
    loop .a1
    call wait_retrace
    sys_ioctl [fbdev_fd],FBIOPUTCMAP,cmap
    ret

;
; Palette set routine. Original at $1291b9
;

palette_patch_3:
    mov cx,$100
    xor eax,eax
    mov dword [cmap+fb_cmap.start],eax
    mov dword [cmap+fb_cmap.len],$100
    xor ebx,ebx
.a1:
    lodsb
    shl al,2
    mov ah,al
    mov [cmap_red+2*ebx],ax
    lodsb
    shl al,2
    mov ah,al
    mov [cmap_green+2*ebx],ax
    lodsb
    shl al,2
    mov ah,al
    mov [cmap_blue+2*ebx],ax
    inc ebx
    loop .a1
    call wait_retrace
    sys_ioctl [fbdev_fd],FBIOPUTCMAP,cmap
    _add esp,$400
    ret

;
; Palette read routine for screenshots. Original at $12f0f6
;

palette_patch_4:
    xor eax,eax
    mov dword [cmap+fb_cmap.start],eax
    mov dword [cmap+fb_cmap.len],$100
    sys_ioctl [fbdev_fd],FBIOGETCMAP,cmap
    _mov cx,$100
    xor ebx,ebx
.a1:
    mov al,[cmap_red+2*ebx+1]
    stosb
    mov al,[cmap_green+2*ebx+1]
    stosb
    mov al,[cmap_blue+2*ebx+1]
    stosb
    inc ebx
    loop .a1
    ret
