#include <stdlib.h>
#include <fcntl.h>
#include <stdio.h>
#include <unistd.h>
#include <errno.h>
#include <sys/mman.h>
#include <sys/stat.h>
#include <stdint.h>
#include <sys/types.h>
#include <inttypes.h>

#define executable "tycoon/TYCOON.EXE"
#define core_size 32 * 1024 * 1024

char *exe_ptr;
char *core_ptr;

typedef struct {
    unsigned short int len;
    unsigned char val;
} exe_rect;

void decompress_exe(int skip_bytes) {
    int bytes_read,bytes_written,i;
    char *p;
    char *q;
    int *core_location, *bytes_to_read;
    exe_rect er;

    core_location=exe_ptr+0x1980+0x26;
    bytes_to_read=core_location+1;

    p=exe_ptr+0x1980+*core_location;
    q=core_ptr;

    bytes_read=0;
    bytes_written=0;

    while (bytes_read<*bytes_to_read) {
        er.len=*((uint16_t *)p)++;
	er.val=*p++;
	bytes_read+=3;
	fprintf(stdout,"3 bytes read, len=%u, val=%u\n",er.len,er.val);
	if ((er.len & 0x8000)==0) {
	    bytes_written+=er.len;
	    er.len--;
	    fprintf(stdout,"%u bytes read\n", er.len);
	    *q=er.val;
	    q++;
	    for (i=0; i<er.len;i++) {
		*q=*p;
		p++;
		q++;
	    };
	    bytes_read+=er.len;
	} else {
	    er.len = er.len & 0x7fff;
	    if (er.val==0) {
		/* We do not output zeros. That is because the mmaped area
		   is filled with zeros. It is allocated on access so writing
                   zero's only costs memory if a full page consists of zeros.
		while (er.len>0) {
		*q=0;
		q++;
		er.len--;
		}*/
		q+=er.len;	// Increase q instead.
		bytes_written+=er.len;
	    } else {
		while (er.len>0) {
		    memcpy(q,p,er.val);
		    bytes_written+=er.val;
		    q+=er.val;
		    er.len--;
		};
		bytes_read+=er.val;
		p+=er.val;
	        fprintf(stdout,"%u bytes read\n", er.val);
	    };
	};
    };
    fprintf(stdout,"%d bytes written\n",bytes_written);

    // For some not yet known reason there are 185820 zero's too much before the
    // core starts...
    memmove(core_ptr+0x80000,core_ptr+0x80000+skip_bytes,bytes_written-skip_bytes-0x80000);

    {
    int fd=open("tycoon.img",O_WRONLY|O_CREAT|O_TRUNC,0666);
    write(fd,core_ptr,bytes_written-skip_bytes);
    close(fd);
    }
};

void loadexe() {
    int fd;
    int len;
    struct stat statbuf;

    fd=open(executable,O_RDONLY);
    if (fd<0) {
	fprintf(stderr,"open error\n");
	exit(1);
    };
    if (fstat(fd,&statbuf)<0) {
	fprintf(stderr,"stat error\n");
	exit(3);
    };
    len=statbuf.st_size;
    exe_ptr=mmap(0,len,PROT_READ,MAP_SHARED,fd,0);
    if (exe_ptr==-1) {
	fprintf(stderr,"mmap error %d\n",errno);
	exit(2);
    };
    core_ptr=mmap(0, core_size, PROT_READ|PROT_WRITE,MAP_FIXED|MAP_PRIVATE|MAP_ANON,0,0);
    if (core_ptr==-1) {
	fprintf(stderr,"mmap error %d\n",errno);
	exit(2);
    };

    decompress_exe(185820);

    munmap(exe_ptr,len);
    munmap(core_ptr,core_size);
    close(fd);
};

int main() {
    loadexe();
    //start_core();
};
