;*****************************************************************************
;*                    Transport Tycoon loader for Linux                      *
;*                                                                           *
;*                   Copyright (C) 2001 by Danil Mantione                   *
;*                          Delft, the Netherlands                           *
;*                                                                           *
;* The author grants you permission to use this software under the terms of  *
;* the "GNU public license" version 2 (and only version 2) until             *
;* 31 December 2004. If the author likes the next version of the GPL         *
;* permission will be granted to use this software under that license too.   *
;* The expiration date is necessary to enforce the new version of the GPL    *
;* if the author decides to use it, otherwise this date will be extended.    *
;*                                                                           *
;* As a special exeception to the "GNU public license", you are granted      *
;* permission to link this code against PC-Dos based computer games like     *
;* Transport Tycoon.                                                         *
;*                                                                           *
;* Contact information:                                                      *
;* E-mail:   daniel.mantione@freepascal.org                                  *
;* Phone:    ++31 15 2510958                                                 *
;*****************************************************************************

%include "system.inc"
%include "patches.inc"

global do_timer_interrupt
global idle_loop


[SECTION .data]

extern game_pid
extern patch_locs

game_idle	db 0

[SECTION .text]

do_timer_interrupt:
    push ebp
    inc word [$7f9dc]
    ; This is for the idle loop. If the game is idle we can start it again
    ; if this counter is >= 8
    inc word [$774d4]
    cmp word [$774d4],8
    jb .a6
    cmp byte [game_idle],0
    je .a6
    ; The game was stopped. Start it again.
    sys_kill [game_pid],SIGCONT
    mov byte [game_idle],0
.a6:
    cmp byte [$9ea38],0
    jne .a1
    inc word [$4b2a]
.a1:
    cmp word [$771b4],0
    je .a2
    dec word [$771b4]
.a2:
    inc word [$0ecc4c]
    bts word [$9c57a],0
    jc near .einde
    xor ax,ax
    xchg ax,word [$0ecc4c]
.a3:
;    push ax
;    call $1714af
;    pop ax
    dec ax
    jnz .a3
    dec byte [$9c579]
    jnz .a4
    mov byte [$9c579],5
    _mov ebp,4*p_timer_sub1
    add ebp,[patch_locs]
    call [ebp]
;    call $12728a
.a4:
    cmp byte [$9ede3],0
    jne .einde
    bt word [$9f1e6],1
    jnc .einde
    dec word [$771ae]
    jnz .einde
    inc word [$771ae]
    cmp byte [$9ede3],0
    jne .a5
    ; Using ebx causes unkown problems!!
    _mov ebp,4*p_timer_sub2
    add ebp,[patch_locs]
    call [ebp]
;    call $12cb82
    jmp .einde
.a5:
    bts word [$9f1e6],2
.einde:
    and byte [$9c57a],$0fe
    pop ebp
    retn


; We modify the idle loop somewhat to let Linux know if
; we don't need the CPU.
;
; Original idle loop at $129576

idle_loop:
    mov byte [game_idle],1
    sys_kill [game_pid],SIGSTOP		; Stop the game, the timer
					; thread will start us again.
    ret
