#ifndef SWITCHES_H
#define SWITCHES_H
//
// This file is part of TTDPatch
// Copyright (C) 1999, 2000 by Josef Drexler
//
// switches.h: header file for switches.cpp
//

#include "types.h"

#ifndef C
#	define C	// for common.h
#endif

#include "common.h"


	// this defines the bits to be set by the switches.
typedef struct {
	int cmdline;	// the command line switch for this
	char *cfgcmd;	// the configuration file command
	int comment;	// the comment written by -W
	int bit:8;	// the bit to be set.  -1 for special handling
	int radix:4;	// 0=auto, 1=force octal, 2=force dec, 3=force hex; >4=invert
	int varsize:4;	// 0=u8  1=u16  2=s16  3=s32
	int range[3];	// lower and upper bounds for the value, and the default.
			// -1/-1 = none (yes/no)
	void _fptr *var;	// variable to change if special
			// (NULL if *really* special, -1 if obsolete)
} switchinfo;

typedef struct {
		u32 magic;
		u32 flags[nflags];

		// the other parameter can be access via name, or
		// index into the byte/word/long arrays
		union {
			struct {
				u16 newservint;		// this MUST always be first!
				u8  aiboostfactor, stationspread,
				    vehicledatafactor, savesize,
				    mctype[2],		// [0]:curves [1]:mountains
				    vehcount[4];	// trains,rv,plane,ship
			} d;
			u8  bytes[nparlong*4];
			u16 words[nparlong*2];
			s16 ints[nparlong*2];
			s32 longs[nparlong];
		} u;

		u32 versionoffset;

} paramset, _fptr *pparamset

;


#if defined(IS_SWITCHES_CPP)
#	define ISEXTERN
#else
#	define ISEXTERN extern
//#elif defined(IS_TTDSTART_CPP)
//#	define ISEXTERN extern
//#elif defined(IS_DOS_CPP)
//#	define ISEXTERN extern
//#elif defined(IS_CHECKEXE_CPP)
//#	define ISEXTERN extern
//#else
//#	error Something's wrong.
#endif

// ISEXTERN for uninitialized, extern for initialized variables
ISEXTERN pparamset flags;
extern int showswitches;
extern int writeverfile;

extern char ttdoptions[128];
ISEXTERN int alwaysrun;

extern int cfgfilespecified;
ISEXTERN char tempstr[17];


void allswitches(int reallyall, int swon);
void commandline(int argc, char **argv);
void showtheswitches();

void inline setfv(u32 bitnum, u32 val)
{
	flags->flags[bitnum>>5] &= ~( (u32) 1 << bitnum);
	flags->flags[bitnum>>5] |= ( (val & 1) << bitnum);
}

int inline getf(u32 bitnum)
{
	return ( (flags->flags[bitnum>>5] & ( (u32) 1 << bitnum) ) != 0);
}

void inline setf(u32 bitnum)
{
	flags->flags[bitnum>>5] |= ( (u32) 1 << bitnum);
}

void inline clearf(u32 bitnum)
{
	flags->flags[bitnum>>5] &= ~( (u32) 1 << bitnum);
}




#undef ISEXTERN

#endif
