#ifndef TYPES_H
#define TYPES_H
//
// This file is part of TTDPatch
// Copyright (C) 1999, 2000 by Josef Drexler
//
// types.h: Define platform-indepent data types with known size
//	    and signed-ness
//



#if WINTTDX
#	if __BCPLUSPLUS__>0x310
#		define _fptr
#	else
#		define _fptr far
#	endif

	typedef unsigned char u8;
	typedef signed char s8;

	typedef unsigned short int u16;
	typedef signed short int s16;

	typedef signed long s32;
	typedef unsigned long u32;

#else
#	ifdef __BORLANDC__
#		define _fptr far
#	else
#		define _fptr
#	endif
#	define _texport

	typedef unsigned char u8;
	typedef signed char s8;

	typedef unsigned int u16;
	typedef signed int s16;

	typedef unsigned long u32;
	typedef signed long s32;

#endif

typedef char _fptr *_protptr;

#define externSETIT(defn,value) defn
#define SETIT(defn,value) defn = value
#define SETEXTERN(defn,value) ISEXTERN ## SETIT(defn,value)

#endif	// ndef TYPES_H