;*****************************************************************************
;*                    Transport Tycoon loader for Linux                      *
;*                                                                           *
;*                   Copyright (C) 2001 by Danil Mantione                   *
;*                          Delft, the Netherlands                           *
;*                                                                           *
;* The author grants you permission to use this software under the terms of  *
;* the "GNU public license" version 2 (and only version 2) until             *
;* 31 December 2004. If the author likes the next version of the GPL         *
;* permission will be granted to use this software under that license too.   *
;* The expiration date is necessary to enforce the new version of the GPL    *
;* if the author decides to use it, otherwise this date will be extended.    *
;*                                                                           *
;* As a special exeception to the "GNU public license", you are granted      *
;* permission to link this code against PC-Dos based computer games like     *
;* Transport Tycoon.                                                         *
;*                                                                           *
;* Contact information:                                                      *
;* E-mail:   daniel.mantione@freepascal.org                                  *
;* Phone:    ++31 15 2510958                                                 *
;*****************************************************************************

%include "system.inc"
%include "ipx.inc"

[SECTION .data]

ipx_proc_file		db '/proc/net/ipx',0

; Transport Tycoon uses IPX port $5115, but we should reverse the bytes
; because ports are specified in big endian

addr:   istruc sockaddr_ipx
        at sockaddr_ipx.family,   dw AF_IPX
        at sockaddr_ipx.port,     dw $1551
        at sockaddr_ipx.network,  dd 0
        at sockaddr_ipx.node,     db 0,0,0,0,0,0
        at sockaddr_ipx.type,     db IPX_USER_PTYPE
        at sockaddr_ipx.zero,     db 0
iend

addr_size		dd sockaddr_ipx_size

[SECTION .bss]

extern statbuf
extern varedxxx_offset

[SECTION .text]

global novell_detect
global open_ipx_socket
global send_packet
global receive_packet
global close_ipx_socket


;
; Detect if we can use an IPX network. Original at $1281aa
;
; To detect this, we check if the file "/proc/net/ipx" exists.
;

novell_detect:
    mov word [$774fc],$331
    sys_stat ipx_proc_file,statbuf
    _cmp eax,0
    jne .noipx
    mov word [$774fc],$332
    ; Carry flag is already cleared by cmp eax,0
    ret
.noipx:
    stc
    ret

;
; Open an IPX socket. Original at $128207
; We open a socket and bind it to the right port.
;

open_ipx_socket:
    sys_socket PF_IPX,SOCK_DGRAM,PF_IPX
    _cmp eax,0
    js .nosocket
    push eax
    sys_bind eax,addr,sockaddr_ipx_size
    xchg ebx,eax
    pop eax
    mov word [$774fc],$333
    or ebx,ebx
    js .nosocket
    clc
    ret
.nosocket:
    _mov ax,$0ffff
    stc
    ret

;
; Transport Tycoon packets are 64 bytes large.
; The first 60 bytes of them are the actual data,
; the last 4 bytes are a checksum
;

calc_checksum:
    mov esi,$0ed08c
    add esi,[varedxxx_offset]
    mov ebx,$12345678
    _mov ecx,$0f
.a1:
    lodsd
    xor ebx,eax
    ror ebx,3
    loop .a1
    ret

;
; Send a 64 byte packet at $0ed08c. Original at $128343
;

send_packet:
    ; eax,dx = IPX address to send packet to
    ; ebp    = IPX network to send packet to
    mov dword [addr+sockaddr_ipx.node],eax
    mov word [addr+sockaddr_ipx.node+4],dx
    mov dword [addr+sockaddr_ipx.network],ebp
    call calc_checksum
    mov [esi],ebx
    mov ebx,$0ed08a
    add ebx,[varedxxx_offset]
    movzx eax,word [ebx]
    _add ebx,2 ; Place $0ed08c in ebx
    sys_sendto eax,ebx,64,0,addr,sockaddr_ipx_size
    ret

;
; Receive a 64 byte packet, place it at $0ed80c. Original at $128440
;

receive_packet:
    mov ebx,$0ed08a
    add ebx,[varedxxx_offset]
    movzx eax,word [ebx]
    _add ebx,2 ; Place $0ed08c in ebx
    sys_recvfrom eax,ebx,64,MSG_DONTWAIT,addr,addr_size
    _cmp eax,0
    js .error
    ; Packet has been received
    call calc_checksum
    cmp [esi],ebx
    jne .error
    ; Save the host we received the packet from.
    mov esi,addr
    mov edi,$0ed0d2
    add edi,[varedxxx_offset]
    mov eax,[esi+sockaddr_ipx.network]
    mov [edi+10],eax
    mov eax,[esi+sockaddr_ipx.node]
    mov [edi],eax
    mov ax,[esi+sockaddr_ipx.node+4]
    mov [edi+4],ax
    ; Carry flag is already cleared by cmp [esi],ebx
    ret
.error:
    stc
    ret

;
; Close the socket in ax. Original at $128245
;

close_ipx_socket:
    cmp ax,-1
    je .exit
    cwde
    sys_close eax
.exit:
    ret
