;*****************************************************************************
;*                    Transport Tycoon loader for Linux                      *
;*                                                                           *
;*                   Copyright (C) 2001 by Danil Mantione                   *
;*                          Delft, the Netherlands                           *
;*                                                                           *
;* The author grants you permission to use this software under the terms of  *
;* the "GNU public license" version 2 (and only version 2) until             *
;* 31 December 2004. If the author likes the next version of the GPL         *
;* permission will be granted to use this software under that license too.   *
;* The expiration date is necessary to enforce the new version of the GPL    *
;* if the author decides to use it, otherwise this date will be extended.    *
;*                                                                           *
;* As a special exeception to the "GNU public license", you are granted      *
;* permission to link this code against PC-Dos based computer games like     *
;* Transport Tycoon.                                                         *
;*                                                                           *
;* Contact information:                                                      *
;* E-mail:   daniel.mantione@freepascal.org                                  *
;* Phone:    ++31 15 2510958                                                 *
;*****************************************************************************

%include "system.inc"
%include "patches.inc"

[SECTION .data]

devrandom:	db '/dev/random',0

extern patch_locs

[SECTION .bss]

seed:		resw 1


;-----------------------------------------------------------------------------
[SECTION .text]

global seed_random_1
global seed_random_2

;
; Get a new random seed. It is returned in dx.
;

get_seed:
    ; Open /dev/random and read 2 bytes.
    sys_open devrandom,O_RDONLY
    push eax
.again:
    sys_read eax,seed,2
    cmp eax,2
    je .again
    mov dx,[seed]
    and dx,$7fff
    pop eax
    sys_close eax
    ret
    
;
; Seed the random generator. Original located at $143855
;
seed_random_1:
    call get_seed
    _mov eax,0
    mov ecx,eax
    mov bl,1
    _mov esi,$60
    ; edi is not suitable!!
    _mov ebp,4*p_seed_random_sub1
    add ebp,[patch_locs]
    call [ebp]
    retn

;
; Seed the random generator. Original located at $125f65
;
seed_random_2:
    call get_seed
    _mov eax,0
    mov ecx,eax
    mov bl,1
    _mov esi,$30060
    ; edi is not suitable!!
    _mov ebp,4*p_seed_random_sub1
    add ebp,[patch_locs]
    call [ebp]
    retn
