#ifndef COMMON_H
#define COMMON_H
//
// This file is part of TTDPatch
// Copyright (C) 1999 by Josef Drexler
//
// common.h: Definitions pertinent to both C code and Assembler code
//

// Because hex values have different notation in C and Assembler, we
// need to use this


//#ifdef C
#	define HEXVAL(number)		0 ## x ## number
//#endif
//
//#ifdef ASSEMBLER
//#	define HEXVAL(number)		0 ## number ## h
//#endif

// this is for identifying the correct interrupt
#define MAGIC HEXVAL(6b5a3f83)
#define MOREMAGIC HEXVAL(45cb7e39)

#define nflags 4	// number of longs with flags switch bits
#define nflagssw 3	// number of above flag dwords which can be set by cmd/cfg switches
#define nparlong 8	// number of longs in the data part of the params


// bit numbers for the patchflags variable.
// Don't add any defines BUT patchflags bit numbers between the BEGIN and END
// (because this file has to be parsed externally too)
// BEGIN PATCHFLAGS
#define uselargerarray		 0	// Use larger vehicle array
#define usenewcurves		 1	// Use new curves
#define usenewmountain		 2	// Use new mountain (must be usenewcurves+1)
#define usenewnonstop		 3	// Use new non-stop handling
#define increasetraincount	 4	// Increase number of trains
#define increaservcount		 5	// Increase number of road vehicles
#define setnewservinterval	 6	// Set service internal
#define autorenew		 7	// Renew vehicles if they're old
#define gotodepot		 8	// Allow adding depots to vehicles' orders
#define increaseplanecount	 9	// Increase number of planes
#define increaseshipcount	10	// Increase number of ships
//#define saveonlysmall		11	// When saving, store only 850 vehicles
#define saveoptdata		11	// Save/load optional data in the extra chunks
#define keepsmallairports	12	// Keep small airports forever
#define largerstations		13	// Stations may be further apart
#define morestationtracks	14	// up to 7 tracks per station
#define longerbridges		15	// bridges up to 127 squares long
#define improvedloadtimes	16	// improved load time calculation
#define feederservice		17	// forced unload if station accepts
#define presignals		18	// use pre-signals
#define extpresignals		19	// extended pre-signal setups
#define noinflation		20	// Turn off inflation
#define maxloanwithctrl		21	// Borrow/Repay maximum amount with Ctrl
#define persistentengines	22	// Persistent engines while they exist
#define fullloadany		23	// Full load is full if any type full
#define selectstationgoods	24	// Only transported station goods appear
#define morethingsremovable	25	// More things can be removed, at a cost
#define aibooster		26	// Increase AI recursion factor
#define multihead		27	// Allow arbitrary number of engines in train
#define newlineup		28	// Make busses and trucks wait at their stops
#define lowmemory		29	// Run with little memory, only 2.5MB
#define generalfixes		30	// several general fixes
#define win2k			31	// fix up some routines for win2k
#define bribe			32	// add "bribe" option to LA menu
#define noplanecrashes		33	// control when and how planes crash
#define showspeed		34	// show train/etc. speed in window
#define officefood		35	// office towers accept food too
#define usesigncheat		36	// Sign Cheats
#define cheatscost		37	// all cheats actually cost their money
#define diskmenu		38	// add load option to disk menu
#define moreairports		39	// new maximum airport numbers: 9; lrg=4, sml=3, hp=1, of=0
#define mammothtrains		40	// maximum train length is 127
#define allowtrainrefit		41	// Allow train refitting
#define showfulldate		42	// always show full date with day/mo/yr
#define subsidiaries		43	// allow humans to take over AI subsidiaries
#define gradualloading		44	// load vehicles gradually (not all at once)
#define moveerrorpopup		45	// move error popups to top-right corner
#define setsignal1waittime	46	// set time for trains to wait on 1-way signals
#define setsignal2waittime	47	// set time for trains to wait on 2-way signals
#define maskdisasters		48	// disable disasters selectively
#define forceautorenew		49	// when on, autorenew sends vehicles to depots
#define morenews		50	// generate news reports on more events
#define unifiedmaglev		51	// monorail and maglev unified
#define newbridgespeeds		52	// new speed limits on monorail and maglev tubular bridges
#define newstartyear		53	// new default start year
#define eternalgame		54	// play forever, date doesn't stop at 2070
#define newtrains		55	// new models for trains, and new graphics
#define newrvs			56	// ...and road vehicles
#define newships		57	// ...and ships
#define newplanes		58	// ...and planes (don't change any of newtrains...newplanes)
#define signalsontrafficside	59	// railroad signals on the side road vehicles drive on
#define electrifiedrail		60	// electrified railways instead of two maglev types
#define largertowns		61	// make some or all towns grow larger
#define newerrorpopuptime	62	// new error popup expiration time
#define newtowngrowthfactor	63	// new town growth recursion factor
#define miscmods		64	// miscellaneous modifications to the ways other switches work
#define loadallgraphics		65	// always load grfs regardless of climate/ID/etc.
#define morebuildoptions	66	// remove checks that prevent construction of some objects
#define semaphoresignals	67	// build semaphores before 1975
#define morehotkeys		68	// New Hotkeys
#define plantmanytrees		69	// Plant many trees at once
#define tracktypecostdiff	70	// Different types of track cost differently
#define morecurrencies		71	// Allows using more currencies
#define manualconvert		72	// Allows converting tracks to different type manually
#define newtowngrowthrate	73	// new town growth rate calculation rules
#define displmoretownstats	74	// display more statistics for each town
#define enhancegui		75	// enhance TTD GUI
#define newagerating		76	// Makes ratings more tolerant to vehicle ages
#define buildonslopes		77	// Build stations etc. on ledges on sloped land
#define buildoncoasts		78	// Build on coasts/waterbanks w/o having to clear them first
#define planespeed		79	// Fix plane speed to be 4 x faster
#define fastwagonsell		80	// Sell whole consist with Ctrl
#define newrvcrash		81	// Modify train/rv crashes
#define stableindustry		82	// Prevent industry closedowns with stable economy

// add new flags above, also update experimentalfeatures

// must always be highest bit number, one more than second highest
#define experimentalfeatures	83	// Latest experimental features; disabled by default.

// so far unused flags, simply to remember what names I've used already
// the numbers of these can be changed as desired
//#define moresignals		 ?	// make tunnels&bridges behave as if there were signals
//#define hugeairport		 ?	// build huge airports

// END PATCHFLAGS

#define lastbitused		experimentalfeatures-1	// Last bit to be set by -a
#define lastbit			experimentalfeatures	// Last bit defined so far, set by -a if DEBUG


// these go always in the last bits of the last flag DWORD, and can't
// be modified by command line or config switches
// if any of these need versiondata, be sure to always turn them on separately
// in function allswitches in switches.c.
#define enhancedkbdhandler	121	// Can we install an enhanced keyboard handler?
#define dontshowkbdleds		122	// don't let enhanced kbd handler mess with LEDs in DOS version
#define onlygetversiondata	123	// Terminate after collecting version data
#define recordversiondata	124	// Whether we're recording version data
#define canmodifygraphics	125	// Can we modify graphics?
#define noflag			126	// Reserved. A flag that's always zero
#define anyflagset		127	// is any flag set?


#endif // COMMON_H
