// This file is part of TTDPatch
//
// flagdata.h: Define switch variables
//

// This will be included both in C and assembly code, therefore we use
// special one-line macros which are defined appropriately for each
// language:
//
//  simple variables:
//    defbyte(name), defword(name), deflong(name)
//  arrays:
//    defbytes(name, size), defwords(name, size), deflongs(name, size)
//
// where 'name' is the name of the variable.  In C, it's a field in the
// paramset.data struct; in assembly, it's a global variable.
//
// Longs and words should be aligned at 4 and 2 byte boundaries, respectively.

deflong(cusmultiplier)		// multiplier for the CUS currency in 1/1000th units
defword(newservint)		// new def. service interval
defword(expswitches)		// bit mask of enabled experimental features
defword(miscmodsflags)		// flags for the miscmods switch

// custom town growth rate variables:
defword(townmaxgrowthrate)	// max. growth rate in houses per 100 years
defbyte(townmingrowthrate)	// min. growth rate in houses per 100 years
defbyte(tgractstationexist)	// influence of having any active stations / 10 (signed, default 5)
defbyte(tgractstations)		// influence of each active station / 10 (default 10)
defbyte(tgractstationsweight)	// weight of the active stations into the rate calculation
defbyte(tgrpassoutweight)	// weight of the fraction of passengers transported
defbyte(tgrmailoutweight)	// weight of the fraction of mail transported
defword(tgrpassinmax)		// maximum number of passengers accepted that will influence growth
defbyte(tgrpassinweight)	// weight of the influence of the number of passengers accepted
defbyte(tgrmailinoptim)		// population per 2 bags of mail that stimulates growth optimally
defbyte(tgrmailinweight)	// weight of the influence of the mail accepted
defbyte(tgrgoodsinoptim)	// population per 2 crates of goods that stimulates growth optimally
defbyte(tgrgoodsinweight)	// weight of the influence of the goods accepted
defbyte(tgrfoodinmin)		// minimum population per 2 tonnes of food for a town to grow
defbyte(tgrfoodinoptim)		// optimal population per 2 tonnes of food for a town to grow
defbyte(tgrfoodinweight) 	// how much food affects growth rate
defbyte(tgrwaterinmin)		// minimum population per 2 tonnes of water for a town to grow
defbyte(tgrwaterinoptim)	// optimal population per 2 tonnes of water for a town to grow
defbyte(tgrwaterinweight)	// how much water affects growth rate
defbyte(tgrsweetsinoptim)	// population per 2 crates of sweets that stimulates growth optimally
defbyte(tgrsweetsinweight)	// weight of the influence of the sweets accepted
defbyte(tgrfizzydrinksinoptim)	// population per 2 fizzy drinks that stimulates growth optimally
defbyte(tgrfizzydrinksinweight)	// weight of the influence of the fizzy drinks accepted
defbyte(tgrtownsizebase)	// town size (number of houses) that yields base growth rate
defbyte(tgrtownsizefactor)	// how much town size affects growth rate
defbyte(townminpopulationsnow)	// minimum 'guaranteed' population of towns on snow
defbyte(townminpopulationdesert)// minimum 'guaranteed' population of towns on desert
// end of custom town growth rate variables

defbyte(aiboostfactor)		// AI boost factor
defbyte(newstationspread)	// new maximum station spread in tiles
defbyte(vehicledatafactor)	// size multiplier of vehicle array
defbytes(mctype, 2)		// [0]:curves [1]:mountains
defbytes(newvehcount, 4)	// trains,rv,plane,ship
defbyte(planecrashctrl)		// plane crash control byte
defbyte(replaceage)		// months relative to age for autorenew
defbyte(multihdspeedup)		// max. speed up for multiple heads in percent
defbyte(disastermask)		// mask of allowed disasters
defbytes(signalwaittimes, 2) 	// days to wait on red signals, 1- and 2-way
defbyte(unimaglevmode)		// mode of monorail-maglev unification
defbyte(newbridgespeedpc)	// max. new bridge speed in percent of highest engine speed
defbyte(languageid)		// current TTD language ID
defbyte(startyear)		// default start year, 1920-based
defbyte(redpopuptime)		// time after which red popup windows close, 0=very long
defbyte(bigtownfreq)		// frequency of towns that can grow larger
defbyte(townsizelimit)		// distance limit for the random town growth procedure
defbyte(treeplantmode)		// flags for the plantmanytrees switch
defbyte(morecurropts)		// options for the morecurrencies patch
defbyte(enhanceguiflags)	// flags for enhance gui
defbyte(rvcrashtype)		// new type of train/rv crashes
defbyte(towngrowthratemode)	// mode of town growth rate calculation
defbyte(morebuildoptionsflags)	// flags for morebuildoptions
