//
// Localization strings for TTDPatch.
//
// Czech translation by Miroslav Duda.
//

//-------------------------------------------
//  INFO ABOUT THIS LANGUAGE
//-------------------------------------------
SETNAME("Czech")
COUNTRYARRAY(countries) = { 421, 42, 0, 0x05, 0 };
SETARRAY(countries);
	// 421 is the Czech Republic (42 is Czechoslovakia in old DOS versions),
	// and 0x05 is Czech in Windows

DOSCODEPAGE(852)	// The default DOS code page for this language
WINCODEPAGE(1250)	// The default Windows code page for this language
EDITORCODEPAGE(852)	// The code page of all strings in this file.

//-------------------------------------------
//  PROGRAM BLURBS
//-------------------------------------------

// First line of output is something like "TTDPatch V1.5.1 starting.\n"
// The program name and version are autogenerated, only put the " starting\n"
// here
SETTEXT(LANG_STARTING, " byl sputn.\n")


//-------------------------------------------
//  VERSION CHECKING
//-------------------------------------------

// In the version identifier, this is for the file size
SETTEXT(LANG_SIZE, "velikost")

// Shown if the version is recognized
SETTEXT(LANG_KNOWNVERSION, "Verze programu je sprvn\n")

// Warning if the version isn't recognized.  Be sure *not* to use tabs
// in the text.  All but the last lines should end in ...\n"
SETTEXT(LANG_WRONGVERSION, "\n"
	"POZOR!   Neznm verze programu. Meme se pokusit\n"
	"         jej i pesto spustit a zjistit potebn informace, pokud\n"
	"         se to nepovede, TTD nahls chybu ochrany a bude ukonen.\n"
	"\n"
	"         V zvislosti na schopnostech operanho systmu nakldat s GPF, se me\n"
	"         pota zablokovat a vy pijt o data. Prosm, nahldnte\n"
	"         do sekce " VERSIONSECTION " souboru TTDPATCH.TXT, kde zjistte dal informace.\n"
	"\n"
	"Odpovzte 'a' jen pokud opravdu vte, co dlte. BYL JSTE VAROVN!\n"
	"Chcete i pesto TTD spustit? ")

// Keys which continue loading after the above warning. *MUST* be lower case.
// can be several different keys, e.g. one for your language "yjo"
SETTEXT(LANG_YESKEYS, "ay")

// Answering anything but the above keys gives this message.
SETTEXT(LANG_ABORTLOAD, "Nahrvn programu bylo zastaveno.\n")

// otherwise continue loading
SETTEXT(LANG_CONTINUELOAD, "Pokusm se...\n")

// Warning if '-y' was used and the version is unknown
SETTEXT(LANG_WARNVERSION, "POZOR: Neznm verze!\n")


// -------------------------------------------
//    CREATING AND PATCHING TTDLOAD
// -------------------------------------------

// TTDLOAD.OVL doesn't exist
SETTEXT(LANG_OVLNOTFOUND, " nenalezen, hledm originln soubory:\n")

// (DOS) neither do tycoon.exe or ttdx.exe.  %s is TTDX.EXE
SETTEXT(LANG_NOFILESFOUND, "Nemohu nalzt ani TYCOON.EXE ani %s.\n")

// (Windows) neither does GameGFX.exe.  %s is GameGFX.EXE
SETTEXT(LANG_NOFILEFOUND, "Nemohu nalzt %s.\n")

// Shown when copying tycoon.exe or ttdx.exe (first %s) to ttdload.ovl (2nd %s)
SETTEXT(LANG_SHOWCOPYING, "Kopruji %s do %s")

// Error if running the copy command fails.  %s is the command.
SETTEXT(LANG_COPYERROR_RUN, "Nelze spustit %s\n")

// Error if command returned successfully, but nothing was copied.
// %s=TTDLOAD.OVL
SETTEXT(LANG_COPYERROR_NOEXIST, "Chyba koprovn - soubor %s neexistuje.\n")

// Invalid .EXE format
SETTEXT(LANG_INVALIDEXE, "Nezjistiteln .EXE formt.\n")

// Version could not be determined
SETTEXT(LANG_VERSIONUNCONFIRMED, "Nelze zjistit verzi programu.\n")

// Shows program name (1st %s) and version (2nd %s)
SETTEXT(LANG_PROGANDVER, "Nzev programu:\n  %s\nVerze programu: %s\n")

// More than three numbers in the version string (not #.#.#)
SETTEXT(LANG_TOOMANYNUMBERS, "Verze obsahuje pli mnoho sel!\n")

// .EXE is not TTD
SETTEXT(LANG_WRONGPROGRAM, "Toto nen Transport Tycoon Deluxe.\n")

// Displays the parsed version number
SETTEXT(LANG_PARSEDVERSION, "Parsed verze je %s\n")

// The exe has been determined to be the DOS extended executable
SETTEXT(LANG_ISDOSEXTEXE, "Spustiteln v DOSu.\n")

// The exe has been determined to be the Windows executable
SETTEXT(LANG_ISWINDOWSEXE, "Spustiteln ve Windows.\n")

// The exe is of an unknown type
SETTEXT(LANG_ISUNKNOWNEXE, "Neznm spoutc formt.\n")

// The exe is the wrong one for this TTDPatch, i.e. DOS/Windows mixed up. %s=DOS or Windows
SETTEXT(LANG_NOTSUPPORTED, "Promite, tato verze TTDPatch spolupracuje jen s %s verz.\n")

// If the original .exe segment length (%lx) is too large or too small
SETTEXT(LANG_INVALIDSEGMENTLEN, "patn pvodn dlka segment %lx")

// When increasing the segment length
SETTEXT(LANG_INCREASECODELENGTH, "Nastavuji velikost programu na %s MB.\n")

// Can't write to TTDLOAD.OVL (%s) [or TTDLOADW.OVL for the Windows version]
SETTEXT(LANG_WRITEERROR, "Nelze zapisovat do %s, je nastaven jen ke ten\n")

// Installing the code loeader
SETTEXT(LANG_INSTALLLOADER, "Instaluji code loader.\n")

// TTDLOAD.OVL (%s) is invalid, needs to be deleted.
SETTEXT(LANG_TTDLOADINVALID, "Nemohu instalovat code loader")
SETTEXT(LANG_DELETEOVL, " - Zkuste vymazat %s.\n")

// TTDLOAD.OVL was verified to be correct
SETTEXT(LANG_TTDLOADOK, "%s je v podku.\n")

// Waiting for key before terminating TTDPatch after an error occured
SETTEXT(LANG_PRESSANYKEY, "Pro peruen stisknte klvesu.")

// Displayed on various warning conditions: Esc to exit, any other key to continue
SETTEXT(LANG_PRESSESCTOEXIT, "Stiskni klvesu pro pokraovn nebo Escape pro peruen.")

// Loading custom in-game texts
SETTEXT(LANG_LOADCUSTOMTEXTS, "Nahrvm obvykl hern texty.\n")

// ttdpttxt.dat is not in a valid format
SETTEXT(LANG_CUSTOMTXTINVALID, "ten %s: Chybn formt souboru.\n")

SETTEXT(LANG_CUSTOMTXTWRONGVER,
	"%s mus bt znovu vytvoen pro tuto verzi TTDPatch.\n"
	"Spuste nejnovj verzi mkpttxt.exe\n")


//-----------------------------------------------
//   COMMAND LINE HELP (-h)
//-----------------------------------------------

// Introduction, prefixed with "TTDPATCH V<version> - "
SETTEXT(LANG_COMMANDLINEHELP, "Uprav TTD a spust patchovac program %s\n"
	  "\n"
	  "Pouit: TTDPATCH [-C cfg-soubor] [volby] [cesta k CD] [-W cfg-soubor]\n"
	  "\n")

// Lines of help for all on/off switches(volby), each at most 38 chars long.
// If you need more chars just insert another line.
TEXTARRAY(halflines,) =
	{ "-a: Vechny volby krom -x",
	  "-d: Vdy uke cel datum",
	  "-f: Refitovn vlak",
	  "-g: Oprava globlnch chyb",
	  "-k: Mal letit vdy",
	  "-l: Vlakov ndra a 7x7",
	  "-n: Nov non-stop",
	  "-q: Vylepen nakldn/vykldn",
	  "-s: Povolen cheat",
	  "-v: Zobrazit aktivn volby",
	  "-w: Super-semafory automaticky",
	  "-y: Peskoit hlen neznm verze",
	  "-z: Dlouh vlaky (126 voz)",

	  "-B: Dlouh mosty",
	  "-D: Super-dynamit",
	  "-E: Pesunuto erven hlen",
	  "-F: Full load alespo jednoho typu",
	  "-G: Vbr nkladu ve stanici",
	  "-I: Vypnuta inflace",
	  "-J: Vce leti ve mst",
	  "-L: Pjit/splatit max. s 'Ctrl'",
	  "-N: Rozen News",
	  "-O: Office Tower akceptuj food",
	  "-P: Aktivace starch vozidel",
	  "-R: Auta ekajc ve front",
	  "-S: Nov modely lod",
	  "-T: Nov modely vlak",
	  "-Z: Verze s malou pamt (3.5MB)",

	  "-2: Nkter opravy pro Windows 2000",

	  "-Xb: platky v menu Local Autority",
	  "-Xd: Pidn dep do pkazu GOTO",
	  "-Xe: Nekonen hra po roce 2070",
	  "-Xf: Zefektivn pomocn vozidla",
	  "-Xg: Postupn nakldn/vykldn",
	  "-Xi: Zabrn krachovn prmyslu",
	  "-Xm: Volba Load v menu",
	  "-Xo: Cheaty za penze",
	  "-Xr: Vdy vytvoit TTDLOAD.OVL",
	  "-Xs: Zobrazen rychlosti",
	  "-Xw: Nastaven super-semafor",
	  "-Xx: Ukld a nahrv dal data",

	  "-XA: Nucen obnova vozidel s -Xa",
	  "-XE: Electrifikovan trat",
	  "-XF: Nastav experimentaln volby",
	  "-XG: Vdy nahraje novou grafiku",
	  "-XP: Nov modely letadel",
	  "-XR: Nov modely aut",
	  "-XS: Ovldn PC soupee",

	  "-Ya: Ratingy tolerant. ke vku vozidel",
	  "-Yb: Stavn vce vc na svahu",
	  "-Yc: Rzn ceny za rzn typy trat",
	  "-Ym: Umon manuln zmnu trat",
	  "-Ys: Semafor na stran, kde jezd auta",
	  "-Yt: Uke vce vc v okn mst",
	  "-Yw: Rychl prodej vagon",

	  "-YC: Stavn na behu",
	  "-YH: Vce/nov hotkeys",
	  "-YP: Letadla se skutenou rychlost",
	  "-YS: Star semafory ped rokem 1975",

	  NULL
	};
SETARRAY(halflines);

// Text describing the switches with values.  The lines have to be shorter
// than 79 chars, excluding the "\n".  Start new lines if necessary.
SETTEXT(LANG_FULLSWITCHES, "\n"
	  "-e #:    Umon rozlehlej zastvky\n"
	  "-i #:    Nastaven servisnho intervalu ve dnech\n"
	  "-x #:    Roz vehicle array na 850*#. Dal informace v manulu!\n"
	  "-mc #:   Zv rychlost vlak v kopcch a zatkch\n"
	  "-trpb #: Zv poet vlak, aut, letadel a lod\n"
	  "-A #:    Zv inteligenci soupe. Pouvejte pouze mal hodnoty.\n"
	  "-M #:    Umon vcemainovm vlakm nastavit zven rychlosti v %%.\n"
	  "-Xa #:   Automatick obnova vozidel # msce ped ukonenm jejich ivotnosti\n"
	  "-Xc #:   Sn pravdpodobnost havrie letadla\n"
	  "-Yr #:   Zmn auto-vlakov kolize na dan typ (1/2)\n"
	  "-Xt #:   Nastav maximln velikost mst\n"
	  "-XC #:   Umon vce mn a nastav jejich volby\n"
	  "-XD #:   Vybere, kter katastrofy se mohou pihodit\n"
	  "-XM #:   Umon kombinovat monorail a maglev\n"
	  "-XT #:   Nastav kolik mst bude rst rychleji a vce\n"
	  "-XX #:   Rychlost na mostech u monorail a maglev v procentech z max.rychlosti\n"
	  "-XY #:   Nastav startovn rok pro novou hru\n"
	  "-X1 #, -X2 #: Max. as ekn vlaku ped jednosmrnmi resp. obousmrnmi semafory\n"
	  "-Yo #:   Ovldn dalch voleb (viz. dokumentace)\n"
	  "-Yp #:   Umon szen vce strom najednou\n"
	  "-YB #:   Vce stavcch voleb, ovldn s parametrem\n"
	  "-YE #:   Nastav as v sec. jak dlouho bude zobrazeno erven hlen\n"
	  "-YG #:   Roz uivatelsk interface, vbr volby s parametrem\n"
	  "-YT #:   Nastav algoritmus rstu mst\n"
	  "\n"
	  "-C cfg-file:  Spust TTDPatch s tmto cfg souborem msto ttdpatch.cfg\n"
	  "-W cfg-file:  Vytvo cfg soubor se souasnou konfigurac\n"
	  "\n"
	  "Pozor na psan velkch a malch psmen!\n"
	  "\n"
	  "Pklad:  ttdpatch -fnqz -m 00 -c 13 -trpb 240 -FG -A 2 -v\n"
	  "\n"
	  "(Hint:  Jestlie vechno scrolovalo velmi rychle, vlote \"ttdpatch -h|more\")\n"
	  "\n")

// Referral to the docs, prefixed by "Copyright (C) 1999 by Josef Drexler.  "
SETTEXT(LANG_HELPTRAILER, "Vce informac naleznete v TTDPATCH.TXT.\n")


//-----------------------------------------------
//  COMMAND LINE AND CONFIG FILE PARSING
//-----------------------------------------------

// if an on/off switch has a value other than the above (%s = wrong value)
SETTEXT(LANG_UNKNOWNSTATE, "Pozor: Neznm parametr %s, nastaveno na off.\n")

// switch is unknown.  %c is '-' or '/' etc, %s is the switch char
SETTEXT(LANG_UNKNOWNSWITCH, "Neznm parametr '%c%s'. Pouijte -h pro pomoc.\n")

// cfg command %s is unknown
SETTEXT(LANG_UNKNOWNCFGLINE, "Pozor: Chybn pkaz v cfg souboru '%s'.\n")

// Names of the switches for the '-v' options
// First string is shown always, second only if set and with the given
// value of the switch in %d.
// These lines (both parts) are limited to 36 chars, also consider how large
// the expansion of the %d can be for that switch.
SWITCHTEXT(uselargerarray, "Rozen potu vozidel", " na %d*850")
SWITCHTEXT(usenewcurves, "Rychlosti v zatkch", " kd %04x")
SWITCHTEXT(usenewmountain, "Rychlosti na svahu", " kd %04x")
SWITCHTEXT(usenewnonstop, "Odlin NON-STOP", "")
SWITCHTEXT(increasetraincount, "Max. poet vlak", ": %d")
SWITCHTEXT(increaservcount, "Max. poet aut", ": %d")
SWITCHTEXT(setnewservinterval, "Servisn interval", ": %d dn")
SWITCHTEXT(usesigncheat, "Pouit cheat", "")
SWITCHTEXT(allowtrainrefit, "Povoleno refitovn vlak", "")
SWITCHTEXT(increaseplanecount, "Max. poet letadel", ": %d")
SWITCHTEXT(increaseshipcount, "Max. poet lod", ": %d")
SWITCHTEXT(keepsmallairports, "Vdy stavt mal letit", "")
SWITCHTEXT(largerstations, "Kombinovan stanice", " do %d tverc")
SWITCHTEXT(morestationtracks, "Vlakov ndra a 7x7", "")
SWITCHTEXT(longerbridges, "Dlouh mosty", "")
SWITCHTEXT(improvedloadtimes, "Vylepen nakldn/vykld.", "")
SWITCHTEXT(mammothtrains, "Mamut vlaky (max.dlka 126)", "")
SWITCHTEXT(presignals, "Super-semafory automaticky", "")
SWITCHTEXT(officefood, "Office Tower akceptuj jdlo", "")
SWITCHTEXT(noinflation, "Vypnut inflace", "")
SWITCHTEXT(maxloanwithctrl, "Pjit/splatit max. s 'Ctrl'", "")
SWITCHTEXT(persistentengines, "Aktivace starch vozidel", "")
SWITCHTEXT(fullloadany, "Full load alespo jednoho typu", "")
SWITCHTEXT(selectstationgoods, "Vbr nkladu ve stanici", "")
SWITCHTEXT(morethingsremovable, "Vce vc lze obnovit", "")
SWITCHTEXT(aibooster, "Inteligence soupe", " kd %d")
SWITCHTEXT(multihead, "Vcemainov vlaky", "rychlost: %d%%")
SWITCHTEXT(newlineup, "Auta ekajc ve front", "")
SWITCHTEXT(lowmemory, "Nzkopam؜ov verze (3.5MB)", "")
SWITCHTEXT(generalfixes, "Obecn opravy (viz. manul)", "")
SWITCHTEXT(moreairports, "Vce leti v jednom mst", "")
SWITCHTEXT(bribe, "platky v menu Local Autority", "")
SWITCHTEXT(noplanecrashes, "Havrie letadel", " kd %d")
SWITCHTEXT(showspeed, "Zobrazen rychlost vozidel", "")
SWITCHTEXT(autorenew, "Auto-obnova vozidel", " od %d msc")
SWITCHTEXT(cheatscost, "Cheaty za penze", "")
SWITCHTEXT(extpresignals, "Nastaven super-semafor", "")
SWITCHTEXT(diskmenu, "Volba Load v menu", "")
SWITCHTEXT(win2k, "Nkter opravy pro Windows 2000/XP", "")
SWITCHTEXT(feederservice, "Pomocn vozidla maj zisk", "")
SWITCHTEXT(gotodepot, "Pidn dep do pkazu GOTO", "")
SWITCHTEXT(newships, "Nov modely lod", "")
SWITCHTEXT(subsidiaries, "Ovldn soupe", "")
SWITCHTEXT(gradualloading, "Postupn nakldn/vykld.", "")
SWITCHTEXT(moveerrorpopup, "Pesunuto erven hlen", "")
SWITCHTEXT(setsignal1waittime, "Nov ekac as ped semafory", ":")
SWITCHTEXT(setsignal2waittime, "", "")				// dummy entry
SWITCHTEXT(maskdisasters, "Katastrofy", " kd %d")
SWITCHTEXT(forceautorenew, "Nucen obnova vozidel", "")
SWITCHTEXT(morenews, "Rozen News", "")
SWITCHTEXT(unifiedmaglev, "Sjednocen maglev", " kd %d")
SWITCHTEXT(newbridgespeeds, "Max rychlost na mostech", " kd %d%%")
SWITCHTEXT(eternalgame, "Nekonen hra po roce 2070", "")
SWITCHTEXT(showfulldate, "Vdy zobrazeno cel datum", "")
SWITCHTEXT(newtrains, "Nov modely vlak", "")
SWITCHTEXT(newrvs, "Nov modely aut", "")
SWITCHTEXT(newplanes, "Nov modely letadel", "")
SWITCHTEXT(signalsontrafficside, "Semafory vlevo-vpravo podle aut", "")
SWITCHTEXT(electrifiedrail, "Elektrifikovan trat", "")
SWITCHTEXT(newstartyear, "Startovn rok", ": %d")
SWITCHTEXT(newerrorpopuptime, "Trvn ervenho hlen", ": %d s")
SWITCHTEXT(newtowngrowthfactor, "Faktor rstu mst", " kd %d")
SWITCHTEXT(largertowns, "Vt msta", ", kad 1 z %d")
SWITCHTEXT(miscmods, "Mnohostrann mdy", " kd %d")
SWITCHTEXT(loadallgraphics, "Nahrn kadho souboru nov grafiky", "")
SWITCHTEXT(saveoptdata, "Uloen a nahrt rozench dat", "")
SWITCHTEXT(morebuildoptions, "Rozen stavn", " kd %d")
SWITCHTEXT(semaphoresignals, "Star semafory ped rokem 1975", "")
SWITCHTEXT(morehotkeys, "Vce voleb ovldanch klvesami", "")
SWITCHTEXT(plantmanytrees, "Szen vce strom najednou", ", kd %d")
SWITCHTEXT(morecurrencies, "Vce mn", ", kd %d")
SWITCHTEXT(manualconvert, "Manuln zmna trat", "")
SWITCHTEXT(newtowngrowthrate, "Algoritmus rstu mst", " kd %d")
SWITCHTEXT(displmoretownstats, "Vce statistik v okn mst", "")
SWITCHTEXT(enhancegui, "Rozen hern interface", " kd %d")
SWITCHTEXT(newagerating, "Rating tolerantnj ke vku vozidel", "")
SWITCHTEXT(buildonslopes, "Stavn na svahu", "")
SWITCHTEXT(buildoncoasts, "Stavn na pobe bez dynamitu", "")
SWITCHTEXT(experimentalfeatures, "Posledn experimentln monosti", ": %d")
SWITCHTEXT(tracktypecostdiff, "Rzn ceny za rzn typy trat", "")
SWITCHTEXT(planespeed, "Reln rychlost letadel", "")
SWITCHTEXT(fastwagonsell, "Rychlej prodej vagon", "")
SWITCHTEXT(newrvcrash, "Auto-vlakov kolize"," kd %d")
SWITCHTEXT(stableindustry, "Prmysl nekrachuje pi stabl. ekonom","")

// A cfg file (%s) could not be found and is ignored.
SETTEXT(LANG_CFGFILENOTFOUND, "Nemohu nalzt cfg soubor %s.  Ignoruji jej.\n")

// Couldn't write the config file
SETTEXT(LANG_CFGFILENOTWRITABLE, "Nemohu otevt %s pro zpis.\n")

// A non-comment line is longer than 32 chars, rest ignored.
SETTEXT(LANG_CFGLINETOOLONG, "POZOR!  Konfiguran dek je del ne 32 znak, zbytek ignorovn.\n")

// Shown if an obsolete switch is used. First option is %s which is the
// config name, second one is %s which is the command line char
SETTEXT(LANG_SWITCHOBSOLETE, "Volba `%s' (-%s) je nefunkn. Prosm, nepouvejte ji v pt\n"
		"verzi bude odstranna.\n")

//---------------------------------------------------
//   CONFIG FILE COMMENTS (for '-W')
//---------------------------------------------------

// This is the intro at the start of the config file.  No constraints on line lengths.
SETTEXT(CFG_INTRO,
	CFG_COMMENT "\n"
	CFG_COMMENT "Konfiguran soubor TTDPatch.cfg byl automaticky vytvoen pomoc TTDPatch -W NzevSouboru.\n"
	CFG_COMMENT "(TTDPatch %s)\n"
	CFG_COMMENT "\n"
	CFG_COMMENT "Formt volby je:\n"
	CFG_COMMENT "   Nzev = Hodnota kd\n"
	CFG_COMMENT "\n"
	CFG_COMMENT "Znak \"=\" me bt opominut a nahrazen mezerou.\n"
	CFG_COMMENT "\n"
	CFG_COMMENT "Hodnota yes/no [y/n] ano/ne, me bt zadna tmito znaky:\n"
	CFG_COMMENT "yes, y, on, 1, a, no, n, off, 0,\n"
	CFG_COMMENT "Jestlie je hodnota vynechna je volba nastavena na ano/yes.\n"
	CFG_COMMENT "\n"
	CFG_COMMENT "Pro volby s kdem je rozsah dn v poznmce\n"
	CFG_COMMENT "V ppad, e kd je opominut je volba nastavena na Default.\n"
	CFG_COMMENT "Nkter volby mohou bt vypnuty zadnm kdu, kter je vypne.\n"
	CFG_COMMENT "\n"
	CFG_COMMENT "Komente jsou vechny dky zanajc dvma lomtky.\n"
	CFG_COMMENT "\n")

// Line before previously unset switches
SETTEXT(CFG_NEWSWITCHINTRO, "**** Seznam voleb ****")

// Definitions of the cfg file comments.
// All can have a place holder %s to stand for the actual setting name,
// and all but CFG_CDPATH can have a %s *after* the %s for the command
// line switch.
// They will have the "comment" char and a space prefixed.
//
SETTEXT(CFG_SHIPS, "`%s' (-%s) Maximln poet lod.  Rozsah %ld - %ld.  Default %ld.")
SETTEXT(CFG_CURVES, "`%s' (-%s) Rychlost v zatkch 0 - normal, 1 - rychlej, 2 - nejrychlej, 3 - reln.  Jedno slo pro kad typ trat a silnici.  Default 0120.")
SETTEXT(CFG_MOUNTAINS, "`%s' (-%s) Rychlost na svahu 0 - normal, 1 - rychlej, 2 - nejrychlej, 3 - reln. Jedno slo pro kad typ trat a silnici.  Default 0120.")
SETTEXT(CFG_SPREAD, "`%s' (-%s) Rozlehlost spolench zastvek.  Rozsah %ld - %ld tverc.  Default %ld.")
SETTEXT(CFG_TRAINREFIT, "`%s' (-%s) Zpstupn refitovn main.")
SETTEXT(CFG_SERVINT, "`%s' (-%s) Poten servisn interval pro nov vozidla.  Rozsah %ld - %ld dn.  Default %ld.")
SETTEXT(CFG_NOINFLATION, "`%s' (-%s) Vypne vechny inflace, pro nkupy i pro nvratnost.")
SETTEXT(CFG_LARGESTATIONS, "`%s' (-%s) Umon pidat vce nstupi a del stanice, do 7x7.")
SETTEXT(CFG_NONSTOP, "`%s' (-%s) Odlin \"Non-stop\" volba.")
SETTEXT(CFG_PLANES, "`%s' (-%s) Maximln poet letadel.  Rozsah %ld - %ld.  Default %ld.")
SETTEXT(CFG_LOADTIME, "`%s' (-%s) Nov kalkulace asu pi nakldn a vykldn.")
SETTEXT(CFG_ROADVEHS, "`%s' (-%s) Maximln poet aut.  Rozsah %ld - %ld.  Default %ld.")
SETTEXT(CFG_SIGNCHEATS, "`%s' (-%s) Zapne cheaty.")
SETTEXT(CFG_TRAINS, "`%s' (-%s) Maximln poet vlak.  Rozsah %ld - %ld.  Default %ld.")
//*#define CFG_PLAYERS "`%s' (-%s) Nastav, kte hri mohou povat cheaty.  Seznam hr od 0 - 7"
SETTEXT(CFG_VERBOSE, "`%s' (-%s) Uke seznam voleb a jejich hodnot ped sputnm TTD.")
SETTEXT(CFG_PRESIGNALS, "`%s' (-%s) Automaticky nastavuje super-semafory.")
SETTEXT(CFG_MOREVEHICLES, "`%s' (-%s) Celkov poet vozidel na hodnota*850.  Rozsah %ld - %ld.  Default %ld.")
SETTEXT(CFG_MAMMOTHTRAINS, "`%s' (-%s) Dlouh vlaky s a 126 vagony.")
SETTEXT(CFG_FULLLOADANY, "`%s' (-%s) Umon aby vlak opustil stanici jestlie jeden z typ nkladu je naloen.")
SETTEXT(CFG_SELECTGOODS, "With `%s' (-%s) Zbo se objev ve stanici a ho nkter vozidlo vyaduje.")
SETTEXT(CFG_DEBTMAX, "`%s' (-%s) Zapne pjovn/splcen cel maximln stky s 'Ctrl'.")
SETTEXT(CFG_OFFICEFOOD, "`%s' (-%s) Office towers akceptuj jdlo (tropic/arctic scenaria).")
SETTEXT(CFG_ENGINESPERSIST, "`%s' (-%s) Zobraz ke koupi star vozidla.")
SETTEXT(CFG_CDPATH, "`%s' (dn switch) Nastav cestu k CD.")
// Note- CFG_CDPATH has no command line switch, so don't give the second %s!
SETTEXT(CFG_KEEPSMALLAP, "`%s' (-%s) Umon vdy stavt mal letit.")
SETTEXT(CFG_AIBOOST, "`%s' (-%s) Inteligence soupe.")
SETTEXT(CFG_LONGBRIDGES, "`%s' (-%s) Umon stavt mosty dlouh a 127 tverc.")
SETTEXT(CFG_DYNAMITE, "`%s' (-%s) Umon vce monost pro bourn dynamitem.")
SETTEXT(CFG_MULTIHEAD, "`%s' (-%s) Umon vce mainov vlaky s 'Ctrl'.  Parametr je max. souet rychlost main, v procentech %ld %ld, default %ld%%.")
SETTEXT(CFG_RVQUEUEING, "`%s' (-%s) Nastav aby auta ekala ve front ped stanic a neotela se.")
SETTEXT(CFG_LOWMEMORY, "`%s' (-%s) Umon aby TTDPatch bاel i s pamt do 3.5MB, ale sn maximln poet vozidel na 2x850.")
SETTEXT(CFG_GENERALFIXES, "`%s' (-%s) Odstran nkter mal chyby viz. maull.")
SETTEXT(CFG_MOREAIRPORTS, "`%s' (-%s) Umon stavbu vce ne dvou leti ve mst.")
SETTEXT(CFG_BRIBE, "`%s' (-%s) Pid monost uplcen `bribe' v local authority menu.")
SETTEXT(CFG_PLANECRCTRL, "`%s' (-%s) Umon ovldn havri letadel. Dvoucifern hodnota, default 1.")
SETTEXT(CFG_SHOWSPEED, "`%s' (-%s) Uke souasnou rychlost vozidla v jeho okn.")
SETTEXT(CFG_AUTORENEW, "`%s' (-%s) Zapne autoobnovu vozidel kdy doshnou plnovanho ukonen jejich ivotnosti. Parametr je poet msc od tohoto termnu.  Rozsah %ld a +%ld.  Default %ld.")
SETTEXT(CFG_CHEATSCOST, "`%s' (-%s) Umon aby cheaty stly penze kdy se pouij.")
SETTEXT(CFG_EXTPRESIGNALS, "`%s' (-%s) Umon mnit mezi normlnmi semafory a super-semafory pomoc 'Ctrl'.")
SETTEXT(CFG_FORCEREBUILDOVL, "`%s' (-%s) Umon aby TTDPatch zmnil pi kadm startu TTDLOAD.OVL nebo TTDLOADW.OVL.")
SETTEXT(CFG_DISKMENU, "`%s' (-%s) Pid do hernho menu funkci LOAD GAME a do scenario menu, funkci LOAD GAME a SAVE GAME (s 'Ctrl').")
SETTEXT(CFG_WIN2K, "`%s' (-%s) Udl Windows verzi TTD compatibiln s Windows 2000/XP.")
SETTEXT(CFG_FEEDERSERVICE, "`%s' (-%s) Zmn unload a profit ve stanicch akceptujcch nklad od pomocnch vozidel viz. manull.")
SETTEXT(CFG_GOTODEPOT, "`%s' (-%s) Umon pidn depa jako cl vozidla.")
SETTEXT(CFG_NEWSHIPS, "`%s' (-%s) Aktivuje nov typy lod vetn nov grafiky.")
SETTEXT(CFG_SUBSIDIARIES, "`%s' (-%s) Umon ovldat soupee pi vlastnn 75%%.")
SETTEXT(CFG_GRADUALLOADING, "`%s' (-%s) Zmn nakldn a vykldn nklad na vce realistick (tak aktivuje `loadtime').")
SETTEXT(CFG_MOVEERRORPOPUP, "`%s' (-%s) Pemst erven hlen do hornho levho rohu obrazovky.")
SETTEXT(CFG_SIGNAL1WAITTIME, "`%s' (-%s) Poet dn, po kterch se vlak oto ped jednosmrnm semaforem.  Rozsah 0 - 254, nebo 255 pro neoten. Default 70.")
SETTEXT(CFG_SIGNAL2WAITTIME, "`%s' (-%s) Poet dn, po kterch se vlak oto ped obousmrnm semaforem. Hodnota 0 - 254, nebo 255 pro neoten. Default 20.")
SETTEXT(CFG_DISASTERS, "`%s' (-%s) Nastav katastrofy, kter mohou nastat. Dvoucifern hodnota, Default 255 (vechny katastrofy).")
SETTEXT(CFG_FORCEAUTORENEW, "`%s' (-%s) Pinut vozidla zajet do depa, kdy je as na autoobnovu (viz. `autorenew').")
SETTEXT(CFG_MORENEWS, "`%s' (-%s) Hra informuje o dalch udlostech (nap. vykcen vech strom u Lumber millu v tropickm scnriu).")
SETTEXT(CFG_UNIFIEDMAGLEV, "`%s' (-%s) Umon kupovat monorail mainy v maglev depu a naopak. Kd: 1 - zmn vechny maglev na monorail; 2 - zmn vechny monorail na maglev; 3 - udruje monorail a maglev oddlen.")
SETTEXT(CFG_BRIDGESPEEDS, "`%s' (-%s) Zmn rychlostn limit na tubusovch mostech pro monorail a maglev na procento z maximln rychlosti nejrychlej mainy, kterou je mono koupit.  Rozsah %ld - %ld.  Default %ld.")
SETTEXT(CFG_ETERNALGAME, "`%s' (-%s) Umon hru i po roce 2070. Letopoet se nezastav.")
SETTEXT(CFG_SHOWFULLDATE, "`%s' (-%s) Vdy uke cel datum (i kdy hra nen zapauzovan).")
SETTEXT(CFG_NEWTRAINS, "`%s' (-%s) Aktivuje nov modely vlak vetn nov grafiky.")
SETTEXT(CFG_NEWRVS, "`%s' (-%s) Aktivuje nov modely aut vetn nov grafiky.")
SETTEXT(CFG_NEWPLANES, "`%s' (-%s) Aktivuje nov modely letadel vetn nov grafiky.")
SETTEXT(CFG_SIGNALSONTRAFFICSIDE, "`%s' (-%s) Zobraz semafory na t stran, po kter jezd auta.")
SETTEXT(CFG_ELECTRIFIEDRAIL, "`%s' (-%s) Odstran monorail nebo maglev a msto toho pid elektrifikovan trat.")
SETTEXT(CFG_STARTYEAR, "`%s' (-%s) Nastav startovn rok pro nhodnou hru a umon rozshlej vbr startovnho roku v editoru. Rozsah %ld - %ld.  Default %ld.")
SETTEXT(CFG_ERRORPOPUPTIME, "`%s' (-%s) as, po kterm automaticky zmiz erven hlen v sekundch.  Rozsah 1 - 255, ( 0 pro velmi dlouh as.  Default 10.")
SETTEXT(CFG_TOWNGROWTHLIMIT, "`%s' (-%s) Maximln mon rozsah mst. Rozsah %ld - %ld.  Default %ld.")
SETTEXT(CFG_LARGERTOWNS, "`%s' (-%s) Poet mst, ze kterch jedno roste rychleji a vce (tak aplikuje `towngrowthlimit' selektivn).  Rozsah %ld - %ld.  Default %ld (jedno msto ze ty).")
SETTEXT(CFG_MISCMODS, "`%s' (-%s) Zmn funkci nkterch voleb nebo je modifikuje viz. manul.  Rozsah dvoucifern hodnota Default 0 (dn modifikace).")
SETTEXT(CFG_LOADALLGRAPHICS, "`%s' (-%s) Pinut TTDPatch vdy nahrt vechny *.grf soubory v newgrf(w).cfg, bez ohledu na to, zda byly pouity v pedchzejcm sputn hry nebo ne.")
SETTEXT(CFG_SAVEOPTDATA, "`%s' (-%s) TTDPatch ulo pidan data na konec souboru (funguje i pro nahrvn save s pidanmi daty).")
SETTEXT(CFG_MOREBUILDOPTIONS, "`%s' (-%s) Vce monost pi stavn. Rozsah %ld - %ld. Default %ld.")
SETTEXT(CFG_SEMAPHORES, "`%s' (-%s) Ped rokem 1975 jdou postavit pouze star mechanick semafory.")
SETTEXT(CFG_MOREHOTKEYS, "`%s' (-%s) Zapnuty nov klvesy pro ovldn nkterch funkc ve he.")
SETTEXT(CFG_MANYTREES, "`%s' (-%s) Umon zasadit  vce ne jeden strom najednou, oznaenm dvou protilehlch vrchol obdllnku s Ctrl.")
SETTEXT(CFG_MORECURRENCIES,"`%s' (-%s) Zapne vce mn vetn Euro po roce 2002.  0 - jednotka je na pvodnm mst; 1 - jednotka je ped sly; 2 - jednotka je za sly. 4 - zake Euro.")
SETTEXT(CFG_MANCONVERT,"`%s' (-%s) Umon run zmnu trat umstnm novho typu trat na ji existujc tra (bez dynamitu).")
SETTEXT(CFG_NEWAGERATING, "`%s' (-%s) Rating zastvek je vce tolerantn k vku vozidel.  Vagny mohou bt a 21 let star msto 3 let.")
SETTEXT(CFG_ENHANCEGUI,"`%s' (-%s) Zmn grafick vzhled nkterch oken. Rozsah %ld - %ld.  Default %ld.")
SETTEXT(CFG_TOWNGROWTHRATEMODE, "`%s' (-%s) Umon definovat pravidla pro kalkulaci rstu mst. 0 - TTD original, 1 - TTD vylepen, 2 - uivatelsk.  Viz dokumentace.")
SETTEXT(CFG_TOWNGROWTHRATEMIN, "`%s' (dn switch) Definuje minimln rst mst. Jedn se o poet novch dom za sto let.  Aktivn pouze kdy volba `towngrowthratemode' = 2.  Rozsah %ld - %ld.  Default %ld.")
SETTEXT(CFG_TOWNGROWTHRATEMAX, "`%s' (dn switch) Definuje maximln rst mst. Jedn se o poet novch dom za sto let.  Aktivn pouze kdy volba `towngrowthratemode' = 2.  Rozsah %ld - %ld.  Default %ld.")
SETTEXT(CFG_TGRACTSTATIONEXIST, "`%s' (dn switch) Definuje kolik z existujcch aktivnch zastvek zvyuje rst mst (viz. dokumentace).  Aktivn pouze kdy volba `towngrowthratemode' = 2.  Rozsah %ld +%ld.  Default %ld.")
SETTEXT(CFG_TGRACTSTATIONS, "`%s' (dn switch) Definuje kolik zastvek zvyuje rst mst (viz. dokumentace).  Aktivn pouze kdy volba `towngrowthratemode' = 2.  Rozsah %ld - %ld.  Default %ld.")
SETTEXT(CFG_TGRACTSTATIONSWEIGHT, "`%s' (dn switch) Definuje jak aktivn zastvky pispvaj k rstu mst (viz. dokumentace).  Aktivn pouze kdy volba `towngrowthratemode' = 2.  Rozsah %ld - %ld.  Default %ld.")
SETTEXT(CFG_TGRPASSOUTWEIGHT, "`%s' (dn switch) Definuje jak efektivn odjdjc lid pispvaj k rstu mst (viz. dokumentace).  Aktivn pouze kdy volba `towngrowthratemode' = 2.  Rozsah %ld - %ld.  Default %ld.")
SETTEXT(CFG_TGRMAILOUTWEIGHT, "`%s' (dn switch) Definuje jak efektivn odjdjc pota pispv k rstu mst (viz. dokumentace).  Aktivn pouze kdy volba `towngrowthratemode' = 2.  Rozsah %ld - %ld.  Default %ld.")
SETTEXT(CFG_TGRPASSINMAX, "`%s' (dn switch) Definuje maximln poet pijdjcch lid, kter me mt efekt na rst mst (viz. dokumentace).  Aktivn pouze kdy volba `towngrowthratemode' = 2.  Rozsah %ld - %ld.  Default %ld.")
SETTEXT(CFG_TGRPASSINWEIGHT, "`%s' (dn switch) Definuje jak efektivn pijdjc lid pispvaj k rstu mst (viz. dokumentace).  Aktivn pouze kdy volba `towngrowthratemode' = 2.  Rozsah %ld - %ld.  Default %ld.")
SETTEXT(CFG_TGRMAILINOPTIM, "`%s' (dn switch) Definuje optimln populaci na kad 2 balky pjdjc poty (viz. dokumentace).  Aktivn pouze kdy volba `towngrowthratemode' = 2.  Rozsah %ld - %ld.  Default %ld.")
SETTEXT(CFG_TGRMAILINWEIGHT, "`%s' (dn switch) Definuje jak efektivn pijdjc pota pispv k rstu mst (viz. dokumentace).  Aktivn pouze kdy volba `towngrowthratemode' = 2.  Rozsah %ld - %ld.  Default %ld.")
SETTEXT(CFG_TGRGOODSINOPTIM, "`%s' (dn switch) Definuje optimln populaci na kad 2 ks zbo (viz. dokumentace).  Aktivn pouze kdy volba `towngrowthratemode' = 2.  Rozsah %ld - %ld.  Default %ld.")
SETTEXT(CFG_TGRGOODSINWEIGHT, "`%s' (dn switch) Definuje jak efektivn pijdjc zbo pispv k rstu mst (viz. dokumentace).  Aktivn pouze kdy volba `towngrowthratemode' = 2.  Rozsah %ld - %ld.  Default %ld.")
SETTEXT(CFG_TGRFOODINMIN, "`%s' (dn switch) Definuje minimln potebu jdla ve mstech ve snhem pokrytch mstech a v poutch. Kolik populace na 2 tuny pijdjcho jdla (viz. dokumentace).  Aktivn pouze kdy volba `towngrowthratemode' = 2.  Rozsah %ld - %ld.  Default %ld.")
SETTEXT(CFG_TGRFOODINOPTIM, "`%s' (dn switch) Definuje optimum populace na kad 2 tuny pijdjcho jdla (viz. dokumentace).  Aktivn pouze kdy volba `towngrowthratemode' = 2.  Rozsah %ld - %ld.  Default %ld.")
SETTEXT(CFG_TGRFOODINWEIGHT, "`%s' (dn switch) Definuje jak efektivn pijdjc jdlo pispv k rstu mst (viz. dokumentace).  Aktivn pouze kdy volba `towngrowthratemode' = 2.  Rozsah %ld - %ld.  Default %ld.")
SETTEXT(CFG_TGRWATERINMIN, "`%s' (dn switch) Definuje minimln potebu vody ve mstech v poutch. Kolik populace na 2 tuny (2000 litr) pijdjc vody (viz. dokumentace).  Aktivn pouze kdy volba `towngrowthratemode' = 2.  Rozsah %ld - %ld.  Default %ld.")
SETTEXT(CFG_TGRWATERINOPTIM, "`%s' (dn switch) Definuje optimum populace na kad 2 tuny (2000 litr) pijdjc vody v tropickm klimatu (viz. dokumentace).  Aktivn pouze kdy volba `towngrowthratemode' = 2.  Rozsah %ld - %ld.  Default %ld.")
SETTEXT(CFG_TGRWATERINWEIGHT, "`%s' (dn switch) Definuje jak efektivn pijdjc vody pispv k rstu mst v tropickm klimatu (viz. dokumentace).  Aktivn pouze kdy volba `towngrowthratemode' = 2.  Rozsah %ld - %ld.  Default %ld.")
SETTEXT(CFG_TGRSWEETSINOPTIM, "`%s' (dn switch) Definuje optimln populaci na kad 2 ks pijdjcch sladkost v dtskm klimatu (viz. dokumentace).  Aktivn pouze kdy volba `towngrowthratemode' = 2.  Rozsah %ld - %ld.  Default %ld.")
SETTEXT(CFG_TGRSWEETSINWEIGHT, "`%s' (dn switch) Definuje jak efektivn pijidjc sladkosti pispvaj k rstu mst v dtskm klimatu (viz. dokumentace).  Aktivn pouze kdy volba `towngrowthratemode' = 2.  Rozsah %ld - %ld.  Default %ld.")
SETTEXT(CFG_TGRFIZZYDRINKSINOPTIM, "`%s' (dn switch) Definuje optimln populaci na kad 2 ks pijdjcch limond v dtskm klimatu (viz. dokumentace).  Aktivn pouze kdy volba `towngrowthratemode' = 2.  Rozsah %ld - %ld.  Default %ld.")
SETTEXT(CFG_TGRFIZZYDRINKSINWEIGHT, "`%s' (dn switch) Definuje jak efektivn limondy pispvaj k rstu mst v dtskm klimatu (viz. dokumentace).  Aktivn pouze kdy volba `towngrowthratemode' = 2.  Rozsah %ld - %ld.  Default %ld.")
SETTEXT(CFG_TGRTOWNSIZEBASE, "`%s' (dn switch) Definuje zkladn poet mstskch budov pro vpoet volby `tgrtownsizefactor' (viz. dokumentace).  Aktivn pouze kdy volba `towngrowthratemode' = 2.  Rozsah %ld..%ld.  Default %ld.")
SETTEXT(CFG_TGRTOWNSIZEFACTOR, "`%s' (dn switch) Definuje, jak velik vliv m velikost mst na rst mst (viz. dokumentace). Aktivn pouze kdy volba `towngrowthratemode' = 2.  Rozsah 0 - %ld.  Default %ld (tzn. %ld procentn vliv).")
SETTEXT(CFG_TOWNMINPOPULATIONSNOW, "`%s' (dn switch) Definuje minimum populace v snhem pokrytch mstech, od kterho mohou rst bez podpory jdla. Aktivn pouze kdy jsou volby `towngrowthratemode', `towngrowthlimit' a `generalfixes' zapnuty.  Rozsah %ld - %ld.  Default %ld.")
SETTEXT(CFG_TOWNMINPOPULATIONDESERT, "`%s' (dn switch) Definuje minimum populace ve mstech na pouti, od kterho mohou rst bez podpory vodou a jdlem. Aktivn pouze kdy jsou volby `towngrowthratemode', `towngrowthlimit' a `generalfixes' zapnuty.  Rozsah %ld - %ld. Default %ld.")
SETTEXT(CFG_MORETOWNSTATS, "`%s' (-%s) Zobraz vce informac v okn msta.")
SETTEXT(CFG_BUILDONSLOPES, "`%s' (-%s) Umon stavn trat, silnic a zastvek na svahu se stejnm zkladem jako u dom.")
SETTEXT(CFG_BUILDONCOASTS, "`%s' (-%s) Umon stavn na behu bez pedchozho pouit dynamitu.")
SETTEXT(CFG_TRACKTYPECOSTDIFF, "`%s' (-%s) Rzn typy trat maj rznou cenu.")
SETTEXT(CFG_CUSMULTIPLIER, "`%s' (dn switch) Pepotvac koeficient pro vlastn mnu - custom currency CUS * 1000.  Default is 1000 (1 CUS = 1 pound).  Aktivn pouze pi zapnut `morecurrencies'.")
SETTEXT(CFG_EXPERIMENTALFEATURES, "`%s' (-%s) Zapne nov experimentln volby.")
SETTEXT(CFG_PLANESPEED, "`%s' (-%s) Zrychl letadla na jejich skutenou indikovanou rychlost (pvodn rychlost je tvrtinov oproti indikovan) a pi stavu Brake Down zredukuje rychlost na 5/8.")
SETTEXT(CFG_FASTWAGONSELL, "`%s' (-%s) Rychlej prodej vagn s Ctrl")
SETTEXT(CFG_NEWRVCRASH,"`%s' (-%s) Mn auto-vlakov kolize. Hodnota %ld znamen, e vlak po kolizi s autem bude chvli ve stavu Brake Down. Hodnota %ld vypne auto-vlakov kolize. Default %ld");
SETTEXT(CFG_STABLEINDUSTRY,"`%s' (-%s) dn prmysl nezkrachuje pi stabiln ekonomice (v menu Difficulty settings je poloka Economy nastavena na Steady).");


//----------------------------------------------------
//   SWITCH DISPLAY ('-v')
//----------------------------------------------------

// Wait for a key before displaying the switches
SETTEXT(LANG_SWWAITFORKEY, "\nStiskem Enter se spust TTD, stiskem Escape se program peru, stiskem jin klvesy se ukou volby a jejich hodnoty.")

// Introduction
SETTEXT(LANG_SHOWSWITCHINTRO, "\n"
	  "\n"
          "    Nastaven voleb:   (%c zapnuto, %c vypnuto)\n")

// Five characters: vertical line for the table; enabled switch; disabled switch;
// table heading; table heading column separator.
SETTEXT(LANG_SWTABLEVERCHAR, "+-")

// 1-way and 2-way captions after "New train wait time on red signals"
SETTEXT(LANG_SWONEWAY, "Jednosmrn: ")
SETTEXT(LANG_SWTWOWAY, "Obousmrn: ")

// Train wait time is either in days or infinite
SETTEXT(LANG_TIMEDAYS, "%d dn")
SETTEXT(LANG_INFINITETIME, "nekonen")

// Shows the load options for ttdload.  %s is the given parameters to be passed to ttdload
SETTEXT(LANG_SWSHOWLOAD, "Stiskni klvesu pro start \"TTDLOAD %s\" (Escape pro odchod).")

SETTEXT(LANG_SWABORTLOAD, "\nProgram je peruen uivatelem.\n")


//---------------------------------------
//  STARTUP AND REPORTING
//---------------------------------------

// Internal error in TTDPatch (%d is error number)
SETTEXT(LANG_INTERNALERROR, "*** Vnitn chyba TTDPatch #%d ***\n")

// Error fixing the Windows version HDPath registry entry
SETTEXT(LANG_REGISTRYERROR, "TTD nen sprvn nainstalovn (chyba registru %d)\n")

// DOS reports no memory available
SETTEXT(LANG_NOTENOUGHMEM, "Nen dost pamti pro start programu. Nyn je %s, a je poteba %d KB.\n")

// ...for starting TTD
SETTEXT(LANG_TOSTARTTTD, "pro start TTD")

// Protected mode code exceeds 32kb
SETTEXT(LANG_PROTECTEDTOOLARGE, "Ochrann md je pli rozlehl!\n")

// Swapping TTDPatch out
SETTEXT(LANG_SWAPPING, "Swapovn ukoneno.\n")

// Just before running ttdload, show this.
// 1st %s is ttdload.ovl, then %s is a space if there are options,
// and the 3rd %s contains the options
SETTEXT(LANG_RUNTTDLOAD, "Startuje %s%s%s\n")

// Error executing ttdload.  1st %s is ttdload.ovl, 2nd %s is the error message from the OS
SETTEXT(LANG_RUNERROR, "Nemohu najt %s: %s\n")

// Show the result after after running, %s is one of the following strings
SETTEXT(LANG_RUNRESULT, "Vsledek: [%s]\n")
SETTEXT(LANG_RUNRESULTOK, "OK")
SETTEXT(LANG_RUNRESULTERROR, "Chyba!")

// Messages about the graphics file ttdpatch.grf
SETTEXT(LANG_NOTTDPATCHGRF, "Nemohu najt cestu k souboru %s, vytvm przdn soubor.\n")
SETTEXT(LANG_ERRORCREATING, "Chyba pi vytven %s: %s\n")
