//
// Localization strings for TTDPatch.
//

//-------------------------------------------
//  INFO ABOUT THIS LANGUAGE
//-------------------------------------------
SETNAME("English")
COUNTRYARRAY(countries) = { -1, 0, 0x09, -1, 0 };
SETARRAY(countries);
	// english is default language (-1), and 0x09 is English in Windows

DOSCODEPAGE(437)	// The default DOS code page for this language
WINCODEPAGE(1252)	// The default Windows code page for this language
EDITORCODEPAGE(437)	// The code page of all strings in this file.

//-------------------------------------------
//  PROGRAM BLURBS
//-------------------------------------------

// First line of output is something like "TTDPatch V1.5.1 starting.\n"
// The program name and version are autogenerated, only put the " starting\n"
// here
SETTEXT(LANG_STARTING, " starting.\n")


//-------------------------------------------
//  VERSION CHECKING
//-------------------------------------------

// In the version identifier, this is for the file size
SETTEXT(LANG_SIZE, "size")

// Shown if the version is recognized
SETTEXT(LANG_KNOWNVERSION, "This version of the program has known addresses.\n")

// Warning if the version isn't recognized.  Be sure *not* to use tabs
// in the text.  All but the last lines should end in ...\n"
SETTEXT(LANG_WRONGVERSION, "\n"
	"WARNING! Your program version is not known to this program. We can now try\n"
	"         to start it anyway and determine the necessary information, but if\n"
	"         that fails, TTD may receive a Protection Fault and terminate.\n"
	"\n"
	"         Depending on how well your operating system handles a GPF, it may\n"
	"         cause your computer to lock up, and you may lose data. Please look\n"
	"         in section " VERSIONSECTION " of TTDPATCH.TXT for more information.\n"
	"\n"
	"Answer 'y' only if you really know what you are doing. YOU HAVE BEEN WARNED!\n"
	"Do you want to start TTD anyway? ")

// Keys which continue loading after the above warning. *MUST* be lower case.
// can be several different keys, e.g. one for your language "yjo"
SETTEXT(LANG_YESKEYS, "y")

// Answering anything but the above keys gives this message.
SETTEXT(LANG_ABORTLOAD, "Program load aborted.\n")

// otherwise continue loading
SETTEXT(LANG_CONTINUELOAD, "I'll try to do my best...\n")

// Warning if '-y' was used and the version is unknown
SETTEXT(LANG_WARNVERSION, "WARNING: Version is unknown!\n")


// -------------------------------------------
//    CREATING AND PATCHING TTDLOAD
// -------------------------------------------

// TTDLOAD.OVL doesn't exist
SETTEXT(LANG_OVLNOTFOUND, " not found, looking for original files:\n")

// (DOS) neither do tycoon.exe or ttdx.exe.  %s is TTDX.EXE
SETTEXT(LANG_NOFILESFOUND, "Could find neither TYCOON.EXE nor %s.\n")

// (Windows) neither does GameGFX.exe.  %s is GameGFX.EXE
SETTEXT(LANG_NOFILEFOUND, "Could not find %s.\n")

// Shown when copying tycoon.exe or ttdx.exe (first %s) to ttdload.ovl (2nd %s)
SETTEXT(LANG_SHOWCOPYING, "Copying %s to %s")

// Error if running the copy command fails.  %s is the command.
SETTEXT(LANG_COPYERROR_RUN, "Couldn't run %s\n")

// Error if command returned successfully, but nothing was copied.
// %s=TTDLOAD.OVL
SETTEXT(LANG_COPYERROR_NOEXIST, "Copy error - file %s doesn't exist.\n")

// Invalid .EXE format
SETTEXT(LANG_INVALIDEXE, "Unrecognized .EXE format.\n")

// Version could not be determined
SETTEXT(LANG_VERSIONUNCONFIRMED, "Could not determine program version.\n")

// Shows program name (1st %s) and version (2nd %s)
SETTEXT(LANG_PROGANDVER, "The program name is:\n  %s\nThe exact version is %s\n")

// More than three numbers in the version string (not #.#.#)
SETTEXT(LANG_TOOMANYNUMBERS, "Version has too many numbers!\n")

// .EXE is not TTD
SETTEXT(LANG_WRONGPROGRAM, "This is not Transport Tycoon Deluxe.\n")

// Displays the parsed version number
SETTEXT(LANG_PARSEDVERSION, "Parsed version is %s\n")

// The exe has been determined to be the DOS extended executable
SETTEXT(LANG_ISDOSEXTEXE, "This is the DOS extended executable.\n")

// The exe has been determined to be the Windows executable
SETTEXT(LANG_ISWINDOWSEXE, "This is the Windows executable.\n")

// The exe is of an unknown type
SETTEXT(LANG_ISUNKNOWNEXE, "This is not a known executable format.\n")

// The exe is the wrong one for this TTDPatch, i.e. DOS/Windows mixed up. %s=DOS or Windows
SETTEXT(LANG_NOTSUPPORTED, "Sorry, this version of TTDPatch works only with the %s version.\n")

// If the original .exe segment length (%lx) is too large or too small
SETTEXT(LANG_INVALIDSEGMENTLEN, "Invalid original segment length of %lx")

// When increasing the segment length
SETTEXT(LANG_INCREASECODELENGTH, "Setting program size to %s MB.\n")

// Can't write to TTDLOAD.OVL (%s) [or TTDLOADW.OVL for the Windows version]
SETTEXT(LANG_WRITEERROR, "Can't write to %s, is it read-only?\n")

// Installing the code loeader
SETTEXT(LANG_INSTALLLOADER, "Installing code loader.\n")

// TTDLOAD.OVL (%s) is invalid, needs to be deleted.
SETTEXT(LANG_TTDLOADINVALID, "Couldn't install code loader")
SETTEXT(LANG_DELETEOVL, " - try deleting %s.\n")

// TTDLOAD.OVL was verified to be correct
SETTEXT(LANG_TTDLOADOK, "%s is OK.\n")

// Waiting for key before terminating TTDPatch after an error occured
SETTEXT(LANG_PRESSANYKEY, "Press any key to abort.")

// Displayed on various warning conditions: Esc to exit, any other key to continue
SETTEXT(LANG_PRESSESCTOEXIT, "Press Escape to abort, or any other key to continue.")

// Loading custom in-game texts
SETTEXT(LANG_LOADCUSTOMTEXTS, "Loading custom in-game texts.\n")

// ttdpttxt.dat is not in a valid format
SETTEXT(LANG_CUSTOMTXTINVALID, "Reading %s: Invalid file format.\n")

SETTEXT(LANG_CUSTOMTXTWRONGVER,
	"%s must be remade for this version of TTDPatch.\n"
	"Please download and run the latest mkpttxt.exe program.\n")


//-----------------------------------------------
//   COMMAND LINE HELP (-h)
//-----------------------------------------------

// Introduction, prefixed with "TTDPATCH V<version> - "
SETTEXT(LANG_COMMANDLINEHELP, "Patches TTD and starts the patched program %s\n"
	  "\n"
	  "Usage: TTDPATCH [-C cfg-file] [switches] [CD Path] [-W cfg-file]\n"
	  "\n")

// Lines of help for all on/off switches, each at most 38 chars long.
// If you need more chars just insert another line.
TEXTARRAY(halflines,) =
	{ "-a:  All switches but -x",
	  "-d:  Always show full date",
	  "-f:  Make trains refittable",
	  "-g:  Some general fixes",
	  "-k:  Keep small airports",
	  "-l:  Up to 7 station platforms",
	  "-n:  New non-stop handling",
	  "-q:  Improved (un)load time algorithm",
	  "-s:  Enable the sign cheats",
	  "-v:  Verbosely show the switches",
	  "-w:  Automatic pre-signal setups",
	  "-y:  Skip unknown version query",
	  "-z:  Mammoth trains (126 cars)",

	  "-B:  Allow longer bridges",
	  "-D:  Dynamite can destroy more items",
	  "-E:  Move red error popups",
	  "-F:  Full load means any cargo type",
	  "-G:  Selectable station goods",
	  "-I:  Turn off inflation",
	  "-J:  Allow more airports per city",
	  "-L:  Borrow/repay max. with 'Ctrl'",
	  "-N:  News reports on more events",
	  "-O:  Office Tower accept food",
	  "-P:  Persistent engines if used",
	  "-R:  Road vehicles queue up",
	  "-S:  New ship models",
	  "-T:  New train models",
	  "-Z:  Low memory version (3.5MB)",

	  "-2:  Some Windows 2000 patches",

	  "-Xb: Bribe option in L.A. menu",
	  "-Xd: Add depots to vehicle orders",
	  "-Xe: Eternal games after 2070",
	  "-Xf: Feeder service w/forced unload",
	  "-Xg: Gradual loading of vehicles",
	  "-Xi: No industry closures with stable",
	  "     economy",
	  "-Xm: Load option in disk menu",
	  "-Xo: Make sign cheats cost money",
	  "-Xr: Always rebuild TTDLOAD.OVL",
	  "-Xs: Show speed in status bars",
	  "-Xw: Extended pre-signal setups",
	  "-Xx: Save and load additional data",

	  "-XA: Forced auto-renewal with -Xa",
	  "-XE: Electrified railways",
	  "-XF: Enable experimental features",
	  "-XG: Always load all new graphics",
	  "-XP: New aircraft models",
	  "-XR: New road vehicle models",
	  "-XS: Manage AI subsidiaries",

	  "-Ya: Ratings more tolerant to veh.ages",
	  "-Yb: Building more things on slopes",
	  "-Yc: Track types have different cost",
	  "-Ym: Allow manual track conversion",
	  "-Ys: Rail signals on road traffic side",
	  "-Yt: Show more stats in town window",
	  "-Yw: Faster train selling",

	  "-YC: Build directly on coasts",
	  "-YH: More/new hotkeys",
	  "-YP: Planes fly at the indicated speed",
	  "-YS: Semaphore signals before 1975",

	  NULL
	};
SETARRAY(halflines);

// Text describing the switches with values.  The lines have to be shorter
// than 79 chars, excluding the "\n".  Start new lines if necessary.
SETTEXT(LANG_FULLSWITCHES, "\n"
	  "-e #:    Increase possible station spread\n"
	  "-i #:    Default service interval is the given number of days\n"
	  "-x #:    Extend the vehicle array to 850*#. Read the documentation!\n"
	  "-mc #:   New mountain or curve handling, respectively\n"
	  "-trpb #: Increase number of trains, road vehicles, planes or ships, resp.\n"
	  "-A #:    Boost the AI by this number. Use small values only.\n"
	  "-M #:    Allow multi-headed trains, set speed increase in percent.\n"
	  "-Xa #:   Automatically renew vehicles # months after end of their life span\n"
	  "-Xc #:   Control the occurence of plane crashes\n"
	  "-Yr #:   Modify train/road veh. crashes to the given type (1/2)\n"
	  "-Xt #:   Set the maximum size a town expands to\n"
	  "-XC #:   Allow more currencies,  and set currency display options\n"
	  "-XD #:   Choose which disasters may occur\n"
	  "-XM #:   Combine monorail and maglev track systems\n"
	  "-XT #:   Set one out of how many towns grows faster and larger\n"
	  "-XX #:   New monorail and maglev bridge speeds, in percent of max. veh. speed\n"
	  "-XY #:   Set default start year for new random games\n"
	  "-X1 #, -X2 #: Max. time train waits at red one-way resp. two-way signal in days\n"
	  "-Yo #:   Control some features of other switches (see the documentation)\n"
	  "-Yp #:   Allow planting many trees, choose plant mode\n"
	  "-YB #:   More build options, control options with parameter\n"
	  "-YE #:   Set time in seconds that red error popups are displayed\n"
	  "-YG #:   Enhance the user interface, choose option with parameter\n"
	  "-YT #:   Set town growth rate algorithm\n"
	  "\n"
	  "-C cfg-file:  Read this configuration file instead of ttdpatch.cfg\n"
	  "-W cfg-file:  Creates a configuration file with the current configuration\n"
	  "\n"
	  "Capitalization is important!\n"
	  "\n"
	  "Example:  ttdpatch -fnqz -m 00 -c 13 -trpb 240 -FG -A 2 -v\n"
	  "\n"
	  "(Hint:  If everything scrolled by too fast, enter \"ttdpatch -h|more\")\n"
	  "\n")

// Referral to the docs, prefixed by "Copyright (C) 1999 by Josef Drexler.  "
SETTEXT(LANG_HELPTRAILER, "See TTDPATCH.TXT for more details.\n")


//-----------------------------------------------
//  COMMAND LINE AND CONFIG FILE PARSING
//-----------------------------------------------

// if an on/off switch has a value other than the above (%s = wrong value)
SETTEXT(LANG_UNKNOWNSTATE, "Warning: Unknown on/off state %s, set to off.\n")

// switch is unknown.  %c is '-' or '/' etc, %s is the switch char
SETTEXT(LANG_UNKNOWNSWITCH, "Unknown switch '%c%s'.  Use -h for help.\n")

// cfg command %s is unknown
SETTEXT(LANG_UNKNOWNCFGLINE, "Warning: Invalid cfg line '%s'.\n")

// Names of the switches for the '-v' options
// First string is shown always, second only if set and with the given
// value of the switch in %d.
// These lines (both parts) are limited to 36 chars, also consider how large
// the expansion of the %d can be for that switch.
SWITCHTEXT(uselargerarray, "Extend total vehicles", " to %d*850")
SWITCHTEXT(usenewcurves, "New curve handler", " for %04x")
SWITCHTEXT(usenewmountain, "New mountain handler", " for %04x")
SWITCHTEXT(usenewnonstop, "New non-stop handling", "")
SWITCHTEXT(increasetraincount, "New train count", ": %d")
SWITCHTEXT(increaservcount, "New road vehicle count", ": %d")
SWITCHTEXT(setnewservinterval, "New def.service interval", ": %d days")
SWITCHTEXT(usesigncheat, "Use Sign cheat", "")
SWITCHTEXT(allowtrainrefit, "Allow train refit", "")
SWITCHTEXT(increaseplanecount, "New aircraft count", ": %d")
SWITCHTEXT(increaseshipcount, "New ship count", ": %d")
SWITCHTEXT(keepsmallairports, "Keep small airports", "")
SWITCHTEXT(largerstations, "Incr. station spread", " to %d sq.")
SWITCHTEXT(morestationtracks, "Extensible stations", "")
SWITCHTEXT(longerbridges, "Longer bridges", "")
SWITCHTEXT(improvedloadtimes, "Improved load time calc.", "")
SWITCHTEXT(mammothtrains, "Mammoth trains (length 127)", "")
SWITCHTEXT(presignals, "Set pre-signals automatically", "")
SWITCHTEXT(officefood, "Office Towers accept food", "")
SWITCHTEXT(noinflation, "Turn off inflation", "")
SWITCHTEXT(maxloanwithctrl, "Max borrow/repay with 'Ctrl'", "")
SWITCHTEXT(persistentengines, "Persistent engines if used", "")
SWITCHTEXT(fullloadany, "Full load means any cargo", "")
SWITCHTEXT(selectstationgoods, "Selectable station goods", "")
SWITCHTEXT(morethingsremovable, "More things removable", "")
SWITCHTEXT(aibooster, "Boost AI recursion", " by %d")
SWITCHTEXT(multihead, "Multi-headed trains", ", speed-up: %d%%")
SWITCHTEXT(newlineup, "Road vehicle queueing", "")
SWITCHTEXT(lowmemory, "Low memory version (3.5MB)", "")
SWITCHTEXT(generalfixes, "General fixes (see docs)", "")
SWITCHTEXT(moreairports, "More airports allowed per town", "")
SWITCHTEXT(bribe, "Show bribe option", "")
SWITCHTEXT(noplanecrashes, "Plane crash control", ": %d")
SWITCHTEXT(showspeed, "Show speed in status bars", "")
SWITCHTEXT(autorenew, "Auto-renew engines", " at %d months")
SWITCHTEXT(cheatscost, "Sign cheats cost money", "")
SWITCHTEXT(extpresignals, "Set pre-signals with 'Ctrl'", "")
SWITCHTEXT(diskmenu, "Show load option in disk menu", "")
SWITCHTEXT(win2k, "Apply Windows 2000/XP patches", "")
SWITCHTEXT(feederservice, "Feeder service with forced unload", "")
SWITCHTEXT(gotodepot, "Add depots to vehicle orders", "")
SWITCHTEXT(newships, "New ship models", "")
SWITCHTEXT(subsidiaries, "Manage AI subsidiaries", "")
SWITCHTEXT(gradualloading, "Gradual loading of vehicles", "")
SWITCHTEXT(moveerrorpopup, "Move red error popups", "")
SWITCHTEXT(setsignal1waittime, "New train wait time on signals", ":")
SWITCHTEXT(setsignal2waittime, "", "")				// dummy entry
SWITCHTEXT(maskdisasters, "Mask of disasters", ": %d")
SWITCHTEXT(forceautorenew, "Force auto-renewal of engines", "")
SWITCHTEXT(morenews, "News reports on more events", "")
SWITCHTEXT(unifiedmaglev, "Unified maglev", ", mode %d")
SWITCHTEXT(newbridgespeeds, "Max. speed on maglev bridges", ": %d%%")
SWITCHTEXT(eternalgame, "Play forever after 2070", "")
SWITCHTEXT(showfulldate, "Always show full date", "")
SWITCHTEXT(newtrains, "New train models", "")
SWITCHTEXT(newrvs, "New road vehicle models", "")
SWITCHTEXT(newplanes, "New aircraft models", "")
SWITCHTEXT(signalsontrafficside, "Signals on 'traffic' side of track", "")
SWITCHTEXT(electrifiedrail, "Electrified railroads", "")
SWITCHTEXT(newstartyear, "Default start year", ": %d")
SWITCHTEXT(newerrorpopuptime, "New error popup timeout", ": %d sec.")
SWITCHTEXT(newtowngrowthfactor, "Change town growth factor", " to %d")
SWITCHTEXT(largertowns, "Larger towns", ", each 1 out of %d")
SWITCHTEXT(miscmods, "Miscellaneous mods", ": %d")
SWITCHTEXT(loadallgraphics, "Always load all new graphics", "")
SWITCHTEXT(saveoptdata, "Save and load optional data", "")
SWITCHTEXT(morebuildoptions, "More build options", ": %d")
SWITCHTEXT(semaphoresignals, "Semaphores before 1975", "")
SWITCHTEXT(morehotkeys, "More/new hotkeys", "")
SWITCHTEXT(plantmanytrees, "Plant many trees", ", mode %d")
SWITCHTEXT(morecurrencies, "Enable more currencies", ", flags: %d")
SWITCHTEXT(manualconvert, "Allow manual track conversion", "")
SWITCHTEXT(newtowngrowthrate, "New town growth rate algorithm", ": %d")
SWITCHTEXT(displmoretownstats, "Display more town stats", "")
SWITCHTEXT(enhancegui, "Enhanced game interface", ": %d")
SWITCHTEXT(newagerating, "Ratings more tolerant to veh. ages", "")
SWITCHTEXT(buildonslopes, "Build more things on sloped land", "")
SWITCHTEXT(buildoncoasts, "Build directly on coasts", "")
SWITCHTEXT(experimentalfeatures, "Enable experimental features", ": %d")
SWITCHTEXT(tracktypecostdiff, "Track types have different cost", "")
SWITCHTEXT(planespeed, "Use real plane speed", "")
SWITCHTEXT(fastwagonsell, "Faster train selling", "")
SWITCHTEXT(newrvcrash, "Change train/rv crashes", " (mode %d)")
SWITCHTEXT(stableindustry, "Prevent industry closedowns", "")

// A cfg file (%s) could not be found and is ignored.
SETTEXT(LANG_CFGFILENOTFOUND, "Couldn't find cfg file %s.  Ignored.\n")

// Couldn't write the config file
SETTEXT(LANG_CFGFILENOTWRITABLE, "Couldn't open %s for writing.\n")

// A non-comment line is longer than 32 chars, rest ignored.
SETTEXT(LANG_CFGLINETOOLONG, "Warning!  Configuration line is longer than 32 chars, truncated.\n")

// Shown if an obsolete switch is used. First option is %s which is the
// config name, second one is %s which is the command line char
SETTEXT(LANG_SWITCHOBSOLETE, "The switch `%s' (-%s) is obsolete. Please do not use it, it will\n"
		"be removed in a future version.\n")

//---------------------------------------------------
//   CONFIG FILE COMMENTS (for '-W')
//---------------------------------------------------

// This is the intro at the start of the config file.  No constraints on line lengths.
SETTEXT(CFG_INTRO,
	CFG_COMMENT "\n"
	CFG_COMMENT "TTDPatch Configuration File, automatically created by TTDPatch -W filename.\n"
	CFG_COMMENT "(TTDPatch %s)\n"
	CFG_COMMENT "\n"
	CFG_COMMENT "Format for the switches is:\n"
	CFG_COMMENT "   switchname = switchvalue\n"
	CFG_COMMENT "\n"
	CFG_COMMENT "The \"=\" can be omitted, as can the spaces.  Case is ignored.\n"
	CFG_COMMENT "\n"
	CFG_COMMENT "For yes/no [y/n] switches, the value can be one of:\n"
	CFG_COMMENT "   yes, y, on, 1, no, n, off, 0\n"
	CFG_COMMENT "If the value is omitted, a yes/no switch defaults to yes.\n"
	CFG_COMMENT "\n"
	CFG_COMMENT "For the switches with a value option [v], the range is given in the\n"
	CFG_COMMENT "description, as is the default if the value is omitted.  The switch can\n"
	CFG_COMMENT "be turned off by giving it one of the 'off' values.\n"
	CFG_COMMENT "\n"
	CFG_COMMENT "Comments are all lines starting with any non-alphabetical character.\n"
	CFG_COMMENT "\n")

// Line before previously unset switches
SETTEXT(CFG_NEWSWITCHINTRO, "**** New switches ****")

// Definitions of the cfg file comments.
// All can have a place holder %s to stand for the actual setting name,
// and all but CFG_CDPATH can have a %s *after* the %s for the command
// line switch.
// They will have the "comment" char and a space prefixed.
//
SETTEXT(CFG_SHIPS, "`%s' (-%s) sets the maximum number of ships.  Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_CURVES, "`%s' (-%s) sets curve speeds to normal (0), faster (1), fastest (2) or realistic (3).  One digit for each of railroad, monorail, maglev and road vehicles.  Default 0120.")
SETTEXT(CFG_MOUNTAINS, "`%s' (-%s) sets mountain speeds to normal (0), faster (1), fastest (2) or realistic (3).  One digit for each of railroad, monorail, maglev and road vehicles.  Default 0120.")
SETTEXT(CFG_SPREAD, "`%s' (-%s) makes it possible to have stations more spread out.  Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_TRAINREFIT, "`%s' (-%s) makes it possible to refit train engines.")
SETTEXT(CFG_SERVINT, "`%s' (-%s) allows to change the initial service interval for new engines.  Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_NOINFLATION, "`%s' (-%s) turns off all inflation, both for cost and revenue.")
SETTEXT(CFG_LARGESTATIONS, "`%s' (-%s) allows to add more platforms or make a station longer, up to 7x7.")
SETTEXT(CFG_NONSTOP, "`%s' (-%s) makes the \"Non-stop\" switch behave differently.")
SETTEXT(CFG_PLANES, "`%s' (-%s) sets the maximum number of planes.  Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_LOADTIME, "`%s' (-%s) enables a different calculation for load/unload times.")
SETTEXT(CFG_ROADVEHS, "`%s' (-%s) sets the maximum number of road vehicles.  Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_SIGNCHEATS, "`%s' (-%s) enables the sign cheats.")
SETTEXT(CFG_TRAINS, "`%s' (-%s) sets the maximum number of trains.  Range %ld..%ld.  Default %ld.")
//*#define CFG_PLAYERS "`%s' (-%s) set the players to be affected by the cheats.  A list of players from 0..7"
SETTEXT(CFG_VERBOSE, "`%s' (-%s) shows a summary of the switches before starting TTD.")
SETTEXT(CFG_PRESIGNALS, "`%s' (-%s) automatically sets up 'pre-signals' to improve station handling.")
SETTEXT(CFG_MOREVEHICLES, "`%s' (-%s) increases the total number of vehicles to value*850.  Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_MAMMOTHTRAINS, "`%s' (-%s) allows mammoth trains with up to 126 cars.")
SETTEXT(CFG_FULLLOADANY, "`%s' (-%s) makes a train leave a station if any type of cargo is full.")
SETTEXT(CFG_SELECTGOODS, "With `%s' (-%s) goods arrive only after the service has been inaugurated.")
SETTEXT(CFG_DEBTMAX, "`%s' (-%s) enables borrowing/repaying the maximum amount by holding down the 'Ctrl' key.")
SETTEXT(CFG_OFFICEFOOD, "`%s' (-%s) makes office towers accept food (tropic/arctic scenarios).")
SETTEXT(CFG_ENGINESPERSIST, "`%s' (-%s) keeps engines around for as long as they are in use.")
SETTEXT(CFG_CDPATH, "`%s' (no command line switch) sets the CD path.")
// Note- CFG_CDPATH has no command line switch, so don't give the second %s!
SETTEXT(CFG_KEEPSMALLAP, "`%s' (-%s) keeps small airports around forever.")
SETTEXT(CFG_AIBOOST, "`%s' (-%s) increases the AI recursion by this amount.")
SETTEXT(CFG_LONGBRIDGES, "`%s' (-%s) allows bridges of up to 127 squares length.")
SETTEXT(CFG_DYNAMITE, "`%s' (-%s) allows more things to be removed with dynamite.")
SETTEXT(CFG_MULTIHEAD, "`%s' (-%s) allows an arbitrary number of engines on a train.  Buy extra engines with 'Ctrl'.  Parameter is max. speed-up by additional engines, in percent from %ld to %ld, default %ld%%.")
SETTEXT(CFG_RVQUEUEING, "`%s' (-%s) makes road vehicles queue up in front of a station, not turn around.")
SETTEXT(CFG_LOWMEMORY, "`%s' (-%s) allows TTDPatch to run with approx. 3.5MB of memory, but makes it impossible to load games saved with a larger `morevehicles' setting.")
SETTEXT(CFG_GENERALFIXES, "`%s' (-%s) fixes various little things, see the docs for more info on what exactly it does.")
SETTEXT(CFG_MOREAIRPORTS, "`%s' (-%s) allows building more airports than the normal two per city.")
SETTEXT(CFG_BRIBE, "`%s' (-%s) adds a `bribe' option to the local authority menu.")
SETTEXT(CFG_PLANECRCTRL, "`%s' (-%s) allows you to control when planes are allowed to crash.  Bitcoded value, default 1.")
SETTEXT(CFG_SHOWSPEED, "`%s' (-%s) shows the current speed for all vehicles in the status bar of their window.")
SETTEXT(CFG_AUTORENEW, "`%s' (-%s) renews engines when serviced this number of months after they get very old.  Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_CHEATSCOST, "`%s' (-%s) makes sign cheats cost money when used.")
SETTEXT(CFG_EXTPRESIGNALS, "`%s' (-%s) allows to cycle between normal, pre-signals, exits and combined signals with 'Ctrl'.")
SETTEXT(CFG_FORCEREBUILDOVL, "`%s' (-%s) makes TTDPatch rebuild TTDLOAD.OVL or TTDLOADW.OVL every time it is started.")
SETTEXT(CFG_DISKMENU, "`%s' (-%s) adds a load option to the disk menu, and a load game (or save game with 'Ctrl') to the scenario editor.")
SETTEXT(CFG_WIN2K, "`%s' (-%s) makes the Windows version of TTD compatible with Windows 2000/XP.")
SETTEXT(CFG_FEEDERSERVICE, "`%s' (-%s) modifies forced unload and profit on a station accepting that cargo to leave the cargo at the station, not cash in.")
SETTEXT(CFG_GOTODEPOT, "`%s' (-%s) allows you to add depots to vehicles' orders.")
SETTEXT(CFG_NEWSHIPS, "`%s' (-%s) activates new ship models with new graphics.")
SETTEXT(CFG_SUBSIDIARIES, "`%s' (-%s) allows you to manage AI companies if you own 75%%.")
SETTEXT(CFG_GRADUALLOADING, "`%s' (-%s) changes the way vehicles are loaded to a more realistic gradual loading (also activates `loadtime').")
SETTEXT(CFG_MOVEERRORPOPUP, "`%s' (-%s) moves all red error popups to the top-right corner of the screen.")
SETTEXT(CFG_SIGNAL1WAITTIME, "`%s' (-%s) changes the number of days after which a train waiting on a 1-way signal turns around.  Range 0..254, or 255 to wait forever.")
SETTEXT(CFG_SIGNAL2WAITTIME, "`%s' (-%s) changes the number of days after which a train waiting on a 2-way signal turns around.  Range 0..254, or 255 to wait forever.")
SETTEXT(CFG_DISASTERS, "`%s' (-%s) allows you to choose which disasters may occur.  Bitcoded value, default 255 (all disasters).")
SETTEXT(CFG_FORCEAUTORENEW, "`%s' (-%s) forces servicing of vehicles when it is time for the auto-renewal (see `autorenew').")
SETTEXT(CFG_MORENEWS, "`%s' (-%s) generates messages/news reports on more events, see the docs for more information.")
SETTEXT(CFG_UNIFIEDMAGLEV, "`%s' (-%s) makes it possible to buy monorail engines in maglev depots or vice versa.  Mode: 1 - convert all maglev engines to monorail; 2 - convert all monorail engines to maglev; 3 - keep separate monorail and maglev.")
SETTEXT(CFG_BRIDGESPEEDS, "`%s' (-%s) increases the speed limits on tubular monorail and maglev bridges to this percentage of the highest maximum engine speed in the class.  Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_ETERNALGAME, "`%s' (-%s) allows you to keep playing forever, the date isn't reset after 2070.")
SETTEXT(CFG_SHOWFULLDATE, "`%s' (-%s) always show the full date in the status, not only when the game is paused.")
SETTEXT(CFG_NEWTRAINS, "`%s' (-%s) activates new train models with new graphics.")
SETTEXT(CFG_NEWRVS, "`%s' (-%s) activates new road vehicle models with new graphics.")
SETTEXT(CFG_NEWPLANES, "`%s' (-%s) activates new aircract models with new graphics.")
SETTEXT(CFG_SIGNALSONTRAFFICSIDE, "`%s' (-%s) displays railroad signals on the same side of track road vehicles drive on.")
SETTEXT(CFG_ELECTRIFIEDRAIL, "`%s' (-%s) removes one of the magnetic track systems (Monorail or MagLev) and replaces it with an electrified railroad system.")
SETTEXT(CFG_STARTYEAR, "`%s' (-%s) sets the default start year for random games and allows greater choice of starting years in the scenario editor.  Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_ERRORPOPUPTIME, "`%s' (-%s) changes the time after which red error popup windows automatically close.  Range 1..255 (in seconds), or 0 for a very long time.  Default 10.")
SETTEXT(CFG_TOWNGROWTHLIMIT, "`%s' (-%s) changes the factor that limits the maximum possible extent of towns.  Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_LARGERTOWNS, "`%s' (-%s) makes each one out of a given number of towns grow faster and larger (also applying `towngrowthlimit' selectively).  Range %ld..%ld.  Default %ld (one out of four towns).")
SETTEXT(CFG_MISCMODS, "`%s' (-%s) makes it posible to modify the working of some other switches, see the docs on more info.  Bitcoded value, default 0 (no modifications).")
SETTEXT(CFG_LOADALLGRAPHICS, "`%s' (-%s) forces TTDPatch to always load all .grf files in newgrf(w).cfg, regardless of whether they were used previously in a loaded game (etc.) or not.")
SETTEXT(CFG_SAVEOPTDATA, "`%s' (-%s) makes TTDPatch save and load additional (optional) data at the end of savegames.")
SETTEXT(CFG_MOREBUILDOPTIONS, "`%s' (-%s) enables more build options.  Bitcoded value, range %ld..%ld.  Default %ld.")
SETTEXT(CFG_SEMAPHORES, "`%s' (-%s) turns new signals built before 1975 into semaphore signals.")
SETTEXT(CFG_MOREHOTKEYS, "`%s' (-%s) enables new hotkeys.")
SETTEXT(CFG_MANYTREES, "`%s' (-%s) allows planting many trees at once.  Bitcoded value: 1 - can plant more than one tree on a square; 2 - plant trees over a rectangular area with 'Ctrl'; 4 - more than one tree on a square in the rectangular planting mode.  Default 3.")
SETTEXT(CFG_MORECURRENCIES,"`%s' (-%s) enables more currencies and the Euro.  Parameter: 0 - curr. symbols at default place; 1 - curr. symbols before numbers; 2 - curr. symbols after numbers.  Add 4 to the above value to disable the Euro.")
SETTEXT(CFG_MANCONVERT,"`%s' (-%s) allows manual track type conversion by placing new tracks over existing tracks.")
SETTEXT(CFG_NEWAGERATING, "`%s' (-%s) makes station ratings more tolerant to vehicle ages.  Now wagons can be up to 21 instead of 3 years old.")
SETTEXT(CFG_ENHANCEGUI,"`%s' (-%s) enhances the user interface.  Bitcoded value, range %ld..%ld.  Default %ld.")
SETTEXT(CFG_TOWNGROWTHRATEMODE, "`%s' (-%s) makes it possible to define rules for the calculation of the growth rate for towns.  Mode: 0 - TTD original, 1 - TTD extended, 2 - custom.  See the docs for more information.")
SETTEXT(CFG_TOWNGROWTHRATEMIN, "`%s' (no command line switch) defines the minimum growth rate of towns, in new houses per century.  Active only if `towngrowthratemode' is set to 2.  Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_TOWNGROWTHRATEMAX, "`%s' (no command line switch) defines the maximum growth rate of towns, in new houses per century.  Active only if `towngrowthratemode' is set to 2.  Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_TGRACTSTATIONEXIST, "`%s' (no command line switch) defines how much the existence of active stations increases the growth rate of a town (see the docs for more information).  Active only if `towngrowthratemode' is set to 2.  Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_TGRACTSTATIONS, "`%s' (no command line switch) defines how much each active station increases the growth rate of a town (see the docs for more information).  Active only if `towngrowthratemode' is set to 2.  Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_TGRACTSTATIONSWEIGHT, "`%s' (no command line switch) defines how effectively active stations contribute to the growth rate of a town (see the docs for more information).  Active only if `towngrowthratemode' is set to 2.  Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_TGRPASSOUTWEIGHT, "`%s' (no command line switch) defines how effectively transported passengers contribute to the growth rate of a town (see the docs for more information).  Active only if `towngrowthratemode' is set to 2.  Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_TGRMAILOUTWEIGHT, "`%s' (no command line switch) defines how effectively transported mail contributes to the growth rate of a town (see the docs for more information).  Active only if `towngrowthratemode' is set to 2.  Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_TGRPASSINMAX, "`%s' (no command line switch) defines the maximum number of incoming passengers that can affect growth of a town (see the docs for more information).  Active only if `towngrowthratemode' is set to 2.  Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_TGRPASSINWEIGHT, "`%s' (no command line switch) defines how effectively incoming passengers contribute to the growth rate of a town (see the docs for more information).  Active only if `towngrowthratemode' is set to 2.  Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_TGRMAILINOPTIM, "`%s' (no command line switch) defines the optimum population per each 2 bags of incoming mail (see the docs for more information).  Active only if `towngrowthratemode' is set to 2.  Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_TGRMAILINWEIGHT, "`%s' (no command line switch) defines how effectively incoming mail contributes to the growth rate of a town (see the docs for more information).  Active only if `towngrowthratemode' is set to 2.  Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_TGRGOODSINOPTIM, "`%s' (no command line switch) defines the optimum population per each 2 crates of incoming goods (see the docs for more information).  Active only if `towngrowthratemode' is set to 2.  Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_TGRGOODSINWEIGHT, "`%s' (no command line switch) defines how effectively incoming goods contribute to the growth rate of a town (see the docs for more information).  Active only if `towngrowthratemode' is set to 2.  Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_TGRFOODINMIN, "`%s' (no command line switch) defines the minimum food requirement of towns in snow-covered or desert areas, in population per 2 tons of incoming food (see the docs for more information).  Active only if `towngrowthratemode' is set to 2.  Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_TGRFOODINOPTIM, "`%s' (no command line switch) defines the optimum population per each 2 tons of incoming food (see the docs for more information).  Active only if `towngrowthratemode' is set to 2.  Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_TGRFOODINWEIGHT, "`%s' (no command line switch) defines how effectively incoming food contributes to the growth rate of a town (see the docs for more information).  Active only if `towngrowthratemode' is set to 2.  Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_TGRWATERINMIN, "`%s' (no command line switch) defines the minimum water requirement of towns in desert areas, in population per 2 tons (2,000 liters) of incoming water (see the docs for more information).  Active only if `towngrowthratemode' is set to 2.  Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_TGRWATERINOPTIM, "`%s' (no command line switch) defines the optimum population per each 2 tons (2,000 liters) of incoming water in the sub-tropical climate (see the docs for more information).  Active only if `towngrowthratemode' is set to 2.  Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_TGRWATERINWEIGHT, "`%s' (no command line switch) defines how effectively incoming water contributes to the growth rate of a town in the sub-tropical climate (see the docs for more information).  Active only if `towngrowthratemode' is set to 2.  Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_TGRSWEETSINOPTIM, "`%s' (no command line switch) defines the optimum population per each 2 bags of incoming candy (sweets) in the toyland climate (see the docs for more information).  Active only if `towngrowthratemode' is set to 2.  Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_TGRSWEETSINWEIGHT, "`%s' (no command line switch) defines how effectively incoming candy (sweets) contributes to the growth rate of a town in the toyland climate (see the docs for more information).  Active only if `towngrowthratemode' is set to 2.  Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_TGRFIZZYDRINKSINOPTIM, "`%s' (no command line switch) defines the optimum population per each 2 incoming fizzy drinks in the toyland climate (see the docs for more information).  Active only if `towngrowthratemode' is set to 2.  Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_TGRFIZZYDRINKSINWEIGHT, "`%s' (no command line switch) defines how effectively incoming fizzy drinks contribute to the growth rate of a town in the toyland climate (see the docs for more information).  Active only if `towngrowthratemode' is set to 2.  Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_TGRTOWNSIZEBASE, "`%s' (no command line switch) defines the base number of town buildings for the calculation involving `tgrtownsizefactor' (see the docs for more information).  Active only if `towngrowthratemode' is set to 2.  Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_TGRTOWNSIZEFACTOR, "`%s' (no command line switch) defines how much the size of a town influences its growth rate (see the docs for more information).  Active only if `towngrowthratemode' is set to 2.  Range %ld..%ld.  Default %ld (i.e. 25%% influence).")
SETTEXT(CFG_TOWNMINPOPULATIONSNOW, "`%s' (no command line switch) defines the minimum population to which towns in snow-covered areas can grow even without food supplies.  Active if `towngrowthratemode', `towngrowthlimit' or `generalfixes' is enabled.  Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_TOWNMINPOPULATIONDESERT, "`%s' (no command line switch) defines the minimum population to which towns in desert areas can grow even without food and water supplies.  Active if `towngrowthratemode', `towngrowthlimit' or `generalfixes' is enabled.  Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_MORETOWNSTATS, "With `%s' (-%s) additional statistics are displayed in town information windows.")
SETTEXT(CFG_BUILDONSLOPES, "`%s' (-%s) makes it possible to build tracks, roads and stations on sloped land, on a foundation like houses.")
SETTEXT(CFG_BUILDONCOASTS, "`%s' (-%s) makes it possible to build on coasts or riverbanks without having to use the dynamite tool first.")
SETTEXT(CFG_TRACKTYPECOSTDIFF, "`%s' (-%s) makes different track types have different cost.")
SETTEXT(CFG_EXPERIMENTALFEATURES, "`%s' (-%s) enables the latest experimental features.")
SETTEXT(CFG_PLANESPEED, "`%s' (-%s) makes planes fly at their indicated speed, not a quarter thereof, and reduces speed to 5/8 in case of a breakdown.")
SETTEXT(CFG_FASTWAGONSELL, "`%s' (-%s) allows faster selling of trains with the 'Ctrl' key.")
SETTEXT(CFG_NEWRVCRASH, "`%s' (-%s) changes train/road vehicle crashes.  %ld makes the train break down after the crash; %ld disables train/road vehicle crashes at all.  Default %ld.")
SETTEXT(CFG_STABLEINDUSTRY, "`%s' (-%s) prevents industries from closing down if Economy is set to Steady in Difficulty settings.")



//----------------------------------------------------
//   SWITCH DISPLAY ('-v')
//----------------------------------------------------

// Wait for a key before displaying the switches
SETTEXT(LANG_SWWAITFORKEY, "\nPress Enter to run TTD, Escape to abort, or any other key to show the settings.")

// Introduction
SETTEXT(LANG_SHOWSWITCHINTRO, "\n"
	  "\n"
	  "    Switches enabled:   (%c enabled, %c disabled)\n")

// Five characters: vertical line for the table; enabled switch; disabled switch;
// table heading; table heading column separator.
SETTEXT(LANG_SWTABLEVERCHAR, "*")

// 1-way and 2-way captions after "New train wait time on red signals"
SETTEXT(LANG_SWONEWAY, "One-way: ")
SETTEXT(LANG_SWTWOWAY, "Two-way: ")

// Train wait time is either in days or infinite
SETTEXT(LANG_TIMEDAYS, "%d day(s)")
SETTEXT(LANG_INFINITETIME, "infinite")

// Shows the load options for ttdload.  %s is the given parameters to be passed to ttdload
SETTEXT(LANG_SWSHOWLOAD, "Press any key to run \"TTDLOAD %s\" (Escape to abort).")

SETTEXT(LANG_SWABORTLOAD, "\nProgram load aborted at user request.\n")


//---------------------------------------
//  STARTUP AND REPORTING
//---------------------------------------

// Internal error in TTDPatch (%d is error number)
SETTEXT(LANG_INTERNALERROR, "*** Internal TTDPatch error #%d ***\n")

// Error fixing the Windows version HDPath registry entry
SETTEXT(LANG_REGISTRYERROR, "TTD is not installed properly (registry error %d)\n")

// DOS reports no memory available
SETTEXT(LANG_NOTENOUGHMEM, "Not enough memory available %s, need %d KB more.\n")

// ...for starting TTD
SETTEXT(LANG_TOSTARTTTD, "to start TTD")

// Protected mode code exceeds 32kb
SETTEXT(LANG_PROTECTEDTOOLARGE, "Protected mode code too large!\n")

// Swapping TTDPatch out
SETTEXT(LANG_SWAPPING, "Swapping out.\n")

// Just before running ttdload, show this.
// 1st %s is ttdload.ovl, then %s is a space if there are options,
// and the 3rd %s contains the options
SETTEXT(LANG_RUNTTDLOAD, "Starting %s%s%s\n")

// Error executing ttdload.  1st %s is ttdload.ovl, 2nd %s is the error message from the OS
SETTEXT(LANG_RUNERROR, "Couldn't execute %s: %s\n")

// Show the result after after running, %s is one of the following strings
SETTEXT(LANG_RUNRESULT, "Result: [%s]\n")
SETTEXT(LANG_RUNRESULTOK, "OK")
SETTEXT(LANG_RUNRESULTERROR, "Error!")

// Messages about the graphics file ttdpatch.grf
SETTEXT(LANG_NOTTDPATCHGRF, "Could not find patch graphics %s, generating empty file.\n")
SETTEXT(LANG_ERRORCREATING, "Error creating %s: %s\n")
