//
// Localization strings for TTDPatch.
//

//-------------------------------------------
//  INFO ABOUT THIS LANGUAGE
//-------------------------------------------
SETNAME("Finnish")
COUNTRYARRAY(countries) = { 358, 0, 0x0b, 0 };
SETARRAY(countries);
	// 358 is Finland and 0x0b is Finnish in Windows

DOSCODEPAGE(850)	// The default DOS code page for this language
WINCODEPAGE(1252)	// The default Windows code page for this language
EDITORCODEPAGE(850)	// The code page of all strings in this file.

//-------------------------------------------
//  PROGRAM BLURBS
//-------------------------------------------

// First line of output is something like "TTDPatch V1.5.1 starting.\n"
// The program name and version are autogenerated, only put the " starting\n"
// here
SETTEXT(LANG_STARTING, " kynnistyy.\n")


//-------------------------------------------
//  VERSION CHECKING
//-------------------------------------------

// In the version identifier, this is for the file size
SETTEXT(LANG_SIZE, "koko")

// Shown if the version is recognized
SETTEXT(LANG_KNOWNVERSION, "Tss ohjelman versiossa on tunnetut osoitteet.\n")

// Warning if the version isn't recognized.  Be sure *not* to use tabs
// in the text.  All but the last lines should end in ...\n"
SETTEXT(LANG_WRONGVERSION, "\n"
"VAROITUS! Ohjelman versiota ei pystytty tunnistamaan. Se voidaan tst huoli-"
"	  matta kynnist ja mritt tarvittavat tiedot, mutta jos"
"	  toimenpide eponnistuu, TTD ilmoittaa suojausvirheest ja lopettaa."
"\n"
"	  Riippuen siit, kuinka hyvin kyttjrjestelmsi ksittelee yleisi"
"	  suojausvirheit, se saattaa aiheuttaa tietokoneen jumittumisen ja"
"	  tiedon katoamista. Lisinfoa saat dokumentaatiosta (TTDPATCH.TXT),"
"	  kappale 4.1."
"\n"
"Vastaa 'k' vain, jos todella tiedt mit olet tekemss. SINUA ON VAROITETTU!"
"Haluatko tst huolimatta kynnist TTD:n? ")

// Keys which continue loading after the above warning. *MUST* be lower case.
// can be several different keys, e.g. one for your language "yjo"
SETTEXT(LANG_YESKEYS, "ky")

// Answering anything but the above keys gives this message.
SETTEXT(LANG_ABORTLOAD, "Ohjelman lataaminen keskeytetty.\n")

// otherwise continue loading
SETTEXT(LANG_CONTINUELOAD, "Yritetn version lataamista...\n")

// Warning if '-y' was used and the version is unknown
SETTEXT(LANG_WARNVERSION, "VAROITUS: Tunnistamaton versio!\n")


// -------------------------------------------
//    CREATING AND PATCHING TTDLOAD
// -------------------------------------------

// TTDLOAD.OVL doesn't exist
SETTEXT(LANG_OVLNOTFOUND, " ei ole lydettviss, etsitn alkuperisi tiedostoja:\n")

// (DOS) neither do tycoon.exe or ttdx.exe.  %s is TTDX.EXE
SETTEXT(LANG_NOFILESFOUND, "Kumpaakaan tiedostoa, TYCOON.EXE tai %s, ei lytynyt.\n")

// (Windows) neither does GameGFX.exe.  %s is GameGFX.EXE
SETTEXT(LANG_NOFILEFOUND, "%s ei lytynyt.\n")

// Shown when copying tycoon.exe or ttdx.exe (first %s) to ttdload.ovl (2nd %s)
SETTEXT(LANG_SHOWCOPYING, "Kopioidaan: %s -> %s")

// Error if running the copy command fails.  %s is the command.
SETTEXT(LANG_COPYERROR_RUN, "Komentoa '%s' ei voitu suorittaa.\n")

// Error if command returned successfully, but nothing was copied.
// %s=TTDLOAD.OVL
SETTEXT(LANG_COPYERROR_NOEXIST, "Kopiointivirhe - tiedostoa %s ei ole olemassa.\n")

// Invalid .EXE format
SETTEXT(LANG_INVALIDEXE, "Tunnistamaton .EXE -tyyppi.\n")

// Version could not be determined
SETTEXT(LANG_VERSIONUNCONFIRMED, "Ohjelman versiota ei pystytty mrittmn.\n")

// Shows program name (1st %s) and version (2nd %s)
SETTEXT(LANG_PROGANDVER, "Ohjelman nimi on %s\nTarkka versio on %s\n")

// More than three numbers in the version string (not #.#.#)
SETTEXT(LANG_TOOMANYNUMBERS, "Versiossa on liian monta numeroa!\n")

// .EXE is not TTD
SETTEXT(LANG_WRONGPROGRAM, "Tm ei ole Transport Tycoon Deluxe.\n")

// Displays the parsed version number
SETTEXT(LANG_PARSEDVERSION, "Saatu versio on %s\n")

// The exe has been determined to be the DOS extended executable
SETTEXT(LANG_ISDOSEXTEXE, "Tm on DOS-ohjelma.\n")

// The exe has been determined to be the Windows executable
SETTEXT(LANG_ISWINDOWSEXE, "Tm on Windows-ohjelma.\n")

// The exe is of an unknown type
SETTEXT(LANG_ISUNKNOWNEXE, "Tunnistamaton ohjelman tiedostotyyppi.\n")

// The exe is the wrong one for this TTDPatch, i.e. DOS/Windows mixed up. %s=DOS or Windows
SETTEXT(LANG_NOTSUPPORTED, "Tm versio TTDPatchista toimii vain %s-version kanssa.\n")

// If the original .exe segment length (%lx) is too large or too small
SETTEXT(LANG_INVALIDSEGMENTLEN, "Vr alkuperisen segmentin pituus (%lx).")

// When increasing the segment length
SETTEXT(LANG_INCREASECODELENGTH, "Asetetaan ohjelman koko: %s MB.\n")

// Can't write to TTDLOAD.OVL (%s) [or TTDLOADW.OVL for the Windows version]
SETTEXT(LANG_WRITEERROR, "Tiedostoon %s ei voi kirjoittaa (onko vain luku -tyyppinen?)\n")

// Installing the code loeader
SETTEXT(LANG_INSTALLLOADER, "Asetetaan koodin lataaja.\n")

// TTDLOAD.OVL (%s) is invalid, needs to be deleted.
SETTEXT(LANG_TTDLOADINVALID, "Koodin lataajan asetus eponnistui")

// Suggestion to delete TTDLOAD.OVL (%s) if it is invalid
SETTEXT(LANG_DELETEOVL, " - kokeile tuhota %s.\n")

// TTDLOAD.OVL was verified to be correct
SETTEXT(LANG_TTDLOADOK, "%s on OK.\n")

// Waiting for key before terminating TTDPatch after an error occured
SETTEXT(LANG_PRESSANYKEY, "Paina nappia lopettaaksesi.")

// Displayed on various warning conditions: Esc to exit, any other key to continue
SETTEXT(LANG_PRESSESCTOEXIT, "Esc lopettaa, muu jatkaa.")

// Loading custom in-game texts
SETTEXT(LANG_LOADCUSTOMTEXTS, "Lataa omat pelitekstit.\n")

// ttdpttxt.dat is not in a valid format
SETTEXT(LANG_CUSTOMTXTINVALID, "%s on vr tiedosto formaatti.\n")

SETTEXT(LANG_CUSTOMTXTWRONGVER,
	"%s pit uusia tlle versiolle TTDPatchia.\n"
	"Imuroi ja aja uusin mkpttxt.exe ohjelma.\n")


//-----------------------------------------------
//   COMMAND LINE HELP (-h)
//-----------------------------------------------

// Introduction, prefixed with "TTDPATCH V<version> - "
SETTEXT(LANG_COMMANDLINEHELP, "Pivitt TTD:n ja kynnist pivitetyn ohjelman '%s'\n"
	  "\n"
	  "Kytt: TTDPATCH [-C cfg-tiedosto] [mritteet] [CD-polku] [-W cfg-tiedosto]\n")

// Lines of help for all on/off switches, each at most 38 chars long.
// If you need more chars just insert another line.
TEXTARRAY(halflines,) =
	{ "-a:  Kaikki mritteet, paitsi -x",
	  "-d:  Nytt aina koko pivmrn",
	  "-f:  Salli veturien rahtityypin vaihto",
	  "-g:  Joitakin yleisi korjauksia",
	  "-k:  Pid pienet lentokentt",
	  "-l:  Asemiin saa jopa 7 raidetta",
	  "-n:  Uudenlainen non-stop",
	  "-q:  Paranneltu lataus-/purkualgoritmi",
	  "-s:  Salli kylttihuijauskoodit",
	  "-v:  Nyt kytetyt mritteet",
	  "-w:  Salli pre-signal -liikennevalot",
	  "-y:  Ohita tuntemattoman version kysely",
	  "-z:  Mammuttijunat (126 vaunua)",

	  "-2:  Windows 2000 pivityksi",

	  "-B:  Salli pitemmt sillat",
	  "-D:  Dynamiitilla voi tuhota enemmn",
	  "-E:  Siirr error pop-upit",
	  "-F:  Tysi lataus=joku tavara tynn",
	  "-G:  Aseman tavarat valittavissa",
	  "-I:  Inflaatio pois",
	  "-J:  Kaupunkiin enemmn lentokentti",
	  "-L:  Suurin laina/maksu 'Ctrl':lla",
	  "-N:  Enemmn uutisaiheita",
	  "-O:  Toimistot vastaanottavat ruokaa",
	  "-P:  Kytetyt konetyypit luotettavia",
	  "-R:  Autot jonottavat jos asema tynn",
	  "-S:  Uusia laivoja",
	  "-T:  Uusia junia",
	  "-Z:  Vhmuistinen versio (3.5MB)",

	  "-Xb: Lahjo optio kauunki menuun",
	  "-Xd: Lis depotit kulkureitteihin",
	  "-Xe: Ikuinen peli vuoden 2070 jlkeen",
	  "-Xf: Unload jtt tavarat aina",
	  "-Xg: Tasainen lastaus (5 kerrallaan)",
	  "-Xi: Tehtaat eivt sulkeadu",
	  "-Xm: Lataa peli mahdollisuus peliss",
	  "-Xo: Huijaukset maksavat rahaa",
	  "-Xr: TTDLOAD.OVL uusitaan aina",
	  "-Xs: Nytt ajonopeuden",
	  "-Xw: Listyt pre-signal asetukset",
	  "-Xx: Tallentaa & lataa listietoja",

	  "-XA: Pakotettu uusiminen -Xa:n kanssa",
	  "-XE: Shkistetyt rautatiet",
	  "-XF: Enable experimental features",
	  "-XG: Lataa kaikki uudet grafiikat",
	  "-XP: Uusia lentokoneita",
	  "-XR: Uusia busseja/rekkoja",
	  "-XS: Voit pelata AI-pelaajaa",

	  "-Ya: Ratings more tolerant to veh.ages",
	  "-Yb: Rakentaa enemmn juttuja mille",
	  "-Yc: Ratatyypeill on eri hinnat",
	  "-Ym: Sallii manuaalisen rata-vaihdon",
	  "-Ys: Junavalot ajopuolella",
	  "-Yt: Nytt enem. asioita kaupungeista",
	  "-Yw: Nopeampi vaunujen myynti",

	  "-YC: Rakentaa rannoille",
	  "-YH: Enemmn/uusia pikanppimi",
	  "-YP: Lentokoneet lentvt IAS nopeutta",
	  "-YS: Vanhat junavalot ennen 1975",

	  NULL
	};
SETARRAY(halflines);

// Text describing the switches with values.  The lines have to be shorter
// than 79 chars, excluding the "\n".  Start new lines if necessary.
SETTEXT(LANG_FULLSWITCHES, "\n"
	"-e #:    Kasvata mahdollista aseman kokoa (kuinka paljon voi levittyty)\n"
	"-i #:    Aseta oletushuoltovli (# on huoltovlin pituus piviss)\n"
	"-x #:    Aseta mahdollisten kulkuvlineiden mr arvoon 850*#. Lue ohjeet!\n"
	"-mc #:   Aseta ylmkien (-m) tai mutkien (-c) vaikutus ajoneuvojen nopeuteen.\n"
	"-trpb #: Kasvata junien (-t), autojen (-r), lentokoneiden (-p) tai laivojen\n"
	"         (-b) maksimimr.\n"
	"-A #:    Paranna tekoly mrll #. Kyt vain pieni arvoja.\n"
	  "-M #:    Salli moniveturiset junat.\n"
	"-Xa #:   Automaattisesti uusi ajoneuvot # kk:ta ennen niiden vanhentumista\n"
	"-Xc #:   Kontrolloi lento-onnettomuuksi\n"
	  "-Yr #:   Modifoi junien/autojen rikkoontumisia (1/2)\n"
	  "-Xt #:   Kuinka suureksi kaupunki voi kasvaa\n"
	  "-XC #:   Enemmn eri rahoja (esim Euro)\n"
	"-XD #:   Valitsee mit onnettomuuksia tapahtuu\n"
	  "-XM #:   Yhdist Monorailin ja Maglevin\n"
	  "-XT #:   Kuinka moni kaupunki yhdest kasvaa nopeammin suuremmksi\n"
	  "-XX #:   Uudet monorail ja maglev siltanopeudet, prosenttia max nopeudesta\n"
	  "-XY #:   Uusien pelien aloitusvuosi\n"
	"-X1 # / -X2 #: Max. aika mit juna odottaa yksi-/kaksipuolisissa valoissa (pivin)\n"
	  "-Yo #:   Control some features of other switches (see the documentation)\n"
	  "-Yp #:   Sallii monien puiden istuttamisen\n"
	  "-YB #:   Enemmn rakennettavaa, control options with parameter\n"	
	  "-YE #:   Kuinka kauan punaiset varoitukset ovat pll (sekunneissa)\n"
	  "-YG #:   Enhance the user interface, choose option with parameter\n"	
	  "-YT #:   Kaupunkien kasvualgoritmi\n"
	"\n"
	"-C cfg-tiedosto:  Lue annettu konfiguraatiotiedosto TTDPATCH.CFG:n sijaan\n"
	"-W cfg-tiedosto:  Luo konfiguraatiotiedosto annetuista mritteist\n"
	"\n"
	"Kirjainten koko (iso vai pieni) on merkityksellinen!\n"
	"\n"
	"Esimerkki:  ttdpatch -fnqz -m 00 -c 13 -trpb 240 -FG -A 2 -v\n"
	"\n"
	"(Vihje: Jos koko teksti ei mahtunut ruudulle, kirjoita 'ttdpatch -h|more')\n"
	"\n")

// Referral to the docs, prefixed by "Copyright (C) 1999 by Josef Drexler.  "
SETTEXT(LANG_HELPTRAILER, "Tarkemmat kuvaukset TTDPATCH.TXT:ss.\n")


//-----------------------------------------------
//  COMMAND LINE AND CONFIG FILE PARSING
//-----------------------------------------------

// if an on/off switch has a value other than the above (%s = wrong value)
SETTEXT(LANG_UNKNOWNSTATE, "Varoitus: Tuntematon arvo mritteell, asetetaan 'off'.\n")

// switch is unknown.  First %c is '-' or '/' etc, 2nd is the switch char
SETTEXT(LANG_UNKNOWNSWITCH, "Tuntematon mrite '%c%c'. Ohjeita saat kirjoittamalla 'ttdpatch -h'.\n")

// cfg command %s is unknown
SETTEXT(LANG_UNKNOWNCFGLINE, "Varoitus: Virheellinen konfiguraatiotiedoston rivi '%s'.\n")

// Names of the switches for the '-v' options
// First string is shown always, second only if set and with the given
// value of the switch in %d.
// These lines (both parts) are limited to 36 chars, also consider how large
// the expansion of the %d can be for that switch.
SWITCHTEXT(uselargerarray, "Kulkuneuvojen maksimimr", ": 850*%d")
SWITCHTEXT(usenewcurves, "Uusi mutkien ksittely", ": %04x")
SWITCHTEXT(usenewmountain, "Uusi ylmkien ksittely", ": %04x")
SWITCHTEXT(usenewnonstop, "Uudenlainen non-stop", "")
SWITCHTEXT(increasetraincount, "Uusi junien enimmismr", ": %d")
SWITCHTEXT(increaservcount, "Uusi autojen enimmismr", ": %d")
SWITCHTEXT(setnewservinterval, "Uusi oletushuoltovli", ": %d days")
SWITCHTEXT(usesigncheat, "Kyt kylttihuijauskoodeja", "")
SWITCHTEXT(allowtrainrefit, "Veturien rahtityypin vaihto", "")
SWITCHTEXT(increaseplanecount, "Uusi lentokoneiden enimmismr", ": %d")
SWITCHTEXT(increaseshipcount, "Uusi laivojen enimmismr", ": %d")
SWITCHTEXT(keepsmallairports, "Sst pienet lentokentt", "")
SWITCHTEXT(largerstations, "Aseman enimmiskoko", " %d ruutua")
SWITCHTEXT(morestationtracks, "Laajennettavat asemat", "")
SWITCHTEXT(longerbridges, "Pidemmt sillat", "")
SWITCHTEXT(improvedloadtimes, "Paranneltu latausajan lasku", "")
SWITCHTEXT(mammothtrains, "Mammuttijunat (pituus 127)", "")
SWITCHTEXT(presignals, "Kyt pre-signal -liikennev.", "")
SWITCHTEXT(officefood, "Toimistot ottavat ruokaa", "")
SWITCHTEXT(noinflation, "Ei inflaatiota", "")
SWITCHTEXT(maxloanwithctrl, "Enimmislaina/-maksu 'Ctrl':lla", "")
SWITCHTEXT(persistentengines, "Kytetyt veturityypit eivt huonone", "")
SWITCHTEXT(fullloadany, "Tysi lataus=joku tavara tynn", "")
SWITCHTEXT(selectstationgoods, "Aseman tavarat valittavissa", "")
SWITCHTEXT(morethingsremovable, "Enemmn tuhoutuvaa tavaraa", "")
SWITCHTEXT(aibooster, "Paranna tekoly", " %d:lla")
SWITCHTEXT(multihead, "Moniveturiset junat", "")
SWITCHTEXT(newlineup, "Jonottavat autot", "")
SWITCHTEXT(lowmemory, "Vhmuistinen versio (3.5MB)", "")
SWITCHTEXT(generalfixes, "Yleiskorjauksia (katso ohjeet)", "")
SWITCHTEXT(moreairports, "Enemmn lentokentti/kaupunki", "")
SWITCHTEXT(bribe, "Show bribe option", "")
SWITCHTEXT(noplanecrashes, "Plane crash control", ": %d")
SWITCHTEXT(showspeed, "Show speed in status bars", "")
SWITCHTEXT(autorenew, "Auto-renew engines", " at %d months")
SWITCHTEXT(cheatscost, "Sign cheats cost money", "")
SWITCHTEXT(extpresignals, "Set pre-signals with 'Ctrl'", "")
SWITCHTEXT(diskmenu, "Show load option in disk menu", "")
SWITCHTEXT(win2k, "Apply Windows 2000/XP patches", "")
SWITCHTEXT(feederservice, "Feeder service with forced unload", "")
SWITCHTEXT(gotodepot, "Add depots to vehicle orders", "")
SWITCHTEXT(newships, "New ship models", "")
SWITCHTEXT(subsidiaries, "Manage AI subsidiaries", "")
SWITCHTEXT(gradualloading, "Gradual loading of vehicles", "")
SWITCHTEXT(moveerrorpopup, "Move red error popups", "")
SWITCHTEXT(setsignal1waittime, "New train wait time on signals", ":")
SWITCHTEXT(setsignal2waittime, "", "")				// dummy entry
SWITCHTEXT(maskdisasters, "Mask of disasters", ": %d")
SWITCHTEXT(forceautorenew, "Force auto-renewal of engines", "")
SWITCHTEXT(morenews, "News reports on more events", "")
SWITCHTEXT(unifiedmaglev, "Unified maglev", ", mode %d")
SWITCHTEXT(newbridgespeeds, "Max. speed on maglev bridges", ": %d%%")
SWITCHTEXT(eternalgame, "Play forever after 2070", "")
SWITCHTEXT(showfulldate, "Always show full date", "")
SWITCHTEXT(newtrains, "New train models", "")
SWITCHTEXT(newrvs, "New road vehicle models", "")
SWITCHTEXT(newplanes, "New aircraft models", "")
SWITCHTEXT(signalsontrafficside, "Signals on 'traffic' side of track", "")
SWITCHTEXT(electrifiedrail, "Electrified railroads", "")
SWITCHTEXT(newstartyear, "Default start year", ": %d")
SWITCHTEXT(newerrorpopuptime, "New error popup timeout", ": %d sec.")
SWITCHTEXT(newtowngrowthfactor, "Change town growth factor", " to %d")
SWITCHTEXT(largertowns, "Larger towns", ", each 1 out of %d")
SWITCHTEXT(miscmods, "Miscellaneous mods", ": %d")
SWITCHTEXT(loadallgraphics, "Always load all new graphics", "")
SWITCHTEXT(saveoptdata, "Save and load optional data", "")
SWITCHTEXT(morebuildoptions, "More build options", ": %d")
SWITCHTEXT(semaphoresignals, "Semaphores before 1975", "")
SWITCHTEXT(morehotkeys, "More/new hotkeys", "")
SWITCHTEXT(plantmanytrees, "Plant many trees", "")
SWITCHTEXT(morecurrencies, "Enable more currencies", ", flags: %d")
SWITCHTEXT(manualconvert, "Allow manual track conversion", "")
SWITCHTEXT(newtowngrowthrate, "New town growth rate algorithm", ": %d")
SWITCHTEXT(displmoretownstats, "Display more town stats", "")
SWITCHTEXT(enhancegui, "Enhanced game interface", ": %d")
SWITCHTEXT(newagerating, "Ratings more tolerant to veh. ages", "")
SWITCHTEXT(buildonslopes, "Build more things on sloped land", "")
SWITCHTEXT(buildoncoasts, "Build directly on coasts", "")
SWITCHTEXT(experimentalfeatures, "Enable latest experimental features", ": %d")
SWITCHTEXT(tracktypecostdiff, "Track types have different cost", "")
SWITCHTEXT(planespeed, "Use real plane speed", "")
SWITCHTEXT(fastwagonsell, "Faster wagon selling", "")
SWITCHTEXT(newrvcrash, "Change train/rv crashes"," (mode %d)")
SWITCHTEXT(stableindustry, "Prevent industry closedowns","")		

// A cfg file (%s) could not be found and is ignored.
SETTEXT(LANG_CFGFILENOTFOUND, "Konfiguraatiotiedostoa '%s' ei lydy. Jatketaan ilman.\n")

// Couldn't write the config file
SETTEXT(LANG_CFGFILENOTWRITABLE, "Tiedostoa '%s' ei voitu avata.\n")

// A non-comment line is longer than 32 chars, rest ignored.
SETTEXT(LANG_CFGLINETOOLONG, "Varoitus! Konfiguraatiorivi on yli 32 merkki pitk, loppu jtetn huomiotta.\n")

// Shown if an obsolete switch is used. First option is %s which is the
// config name, second one is %c which is the command line char
SETTEXT(LANG_SWITCHOBSOLETE, "Mrite '%s' (-%c) on vanhentunut. Sen kytt kannattaa lopettaa, koska se\n"
			     "tullaan myhemmiss versioissa poistamaan.\n")

//---------------------------------------------------
//   CONFIG FILE COMMENTS (for '-W')
//---------------------------------------------------

// This is the intro at the start of the config file.  No constraints on line lengths.
SETTEXT(CFG_INTRO,
	CFG_COMMENT "\n"
	CFG_COMMENT "TTDPatch-konfiguraatiotiedosto, luodaan automaattisesti komennolla 'ttdpatch -W tiedosto'.\n"
	CFG_COMMENT "(TTDPatch %s)\n"
	CFG_COMMENT "\n"
	CFG_COMMENT "Mritteen muoto on:\n"
	CFG_COMMENT "   nimi = arvo\n"
	CFG_COMMENT "\n"
	CFG_COMMENT "Yhtsuuruusmerkin '=' ja vlit voi jtt pois. Kirjainten kokoa ei huomioida.\n"
	CFG_COMMENT "\n"
	CFG_COMMENT "Kyll/ei-mritteill (yes/no) arvo voi olla joku seuraavista:\n"
	CFG_COMMENT "yes, y, on, 1, no, n, off, 0.\n"
	CFG_COMMENT "Jos arvo jtetn mrittelemtt, kyll/ei-mritteen oletusarvona on 'yes'.\n"
	CFG_COMMENT "\n"
	CFG_COMMENT "Jotkut mritteet vaativat tietyn arvon. Tllaisten arvojoukko ja oletusarvo\n"
	CFG_COMMENT "kerrotaan mritteen kuvauksessa (oletusta kytetn, kun arvoa ei mritell).\n"
	CFG_COMMENT "Mritteen ominaisuus voidaan asettaa pois plt antamalla arvoksi joku\n"
	CFG_COMMENT "off-arvoista.\n"
	CFG_COMMENT "\n"
	CFG_COMMENT "Kaikki rivit, jotka eivt ala aakkosten kirjaimella, tulkitaan kommenteiksi.\n"
	CFG_COMMENT "\n")

// Line before previously unset switches
SETTEXT(CFG_NEWSWITCHINTRO, "**** New switches ****")

// Definitions of the cfg file comments.
// All can have a place holder %s to stand for the actual setting name,
// and all but CFG_CDPATH can have a second %s *after* the %s for the command
// line switch.
// They will have the "comment" char and a space prefixed.
//
SETTEXT(CFG_SHIPS,              "'%s' (-%s) asettaa laivojen enimmismrn. Arvovli %ld..%ld, oletus %ld.")
SETTEXT(CFG_CURVES, "`%s' (-%s) knnsnopeudet: normaali (0), nopeampi (1), nopein (2) or realistinen (3).  Yksi luku per junarata, monorail, maglev ja autot.  Oletus 0120.")
SETTEXT(CFG_MOUNTAINS, "`%s' (-%s) vuorinopeudet: normaali (0), nopeampi (1), nopein (2) tai realistinen (3).  yksi luku per junarata, monorail, maglev ja autot.  Oletus 0120.")
SETTEXT(CFG_SPREAD,             "'%s' (-%s) asettaa asemien laajennettavuuden. Arvovli %ld..%ld, oletus %ld.")
SETTEXT(CFG_TRAINREFIT,         "'%s' (-%s) mahdollistaa vetureiden rahtityypin vaihtamisen.")
SETTEXT(CFG_SERVINT,            "'%s' (-%s) asettaa uusien kulkuneuvojen oletushuoltovlin. Arvovli %ld..%ld, oletus %ld.")
SETTEXT(CFG_NOINFLATION,        "'%s' (-%s) poistaa inflaation sek hintojen ett tulojen osalta.")
SETTEXT(CFG_LARGESTATIONS,      "'%s' (-%s) sallii suuremmat asemat, kuitenkin enintn 4x7 tai 7x5.")
SETTEXT(CFG_NONSTOP,            "'%s' (-%s) muuttaa non-stopin kyttytymist.")
SETTEXT(CFG_PLANES,             "'%s' (-%s) asettaa lentokoneiden enimmismrn. Arvovli %ld..%ld, oletus %ld.")
SETTEXT(CFG_LOADTIME,           "'%s' (-%s) sallii lataus-/purkuaikojen parannetun laskemisen.")
SETTEXT(CFG_ROADVEHS,           "'%s' (-%s) asettaa autojen enimmismrn. Arvovli %ld..%ld, oletus %ld.")
SETTEXT(CFG_SIGNCHEATS,         "'%s' (-%s) sallii kylttihuijauskoodit.")
SETTEXT(CFG_TRAINS,             "'%s' (-%s) asettaa junien enimmismrn. Arvovli %ld..%ld, oletus %ld.")
SETTEXT(CFG_VERBOSE,            "'%s' (-%s) nytt yhteenvedon mritteist ennen TTD:n kynnistyst.")
SETTEXT(CFG_PRESIGNALS,         "'%s' (-%s) sallii asemien ksittely parantavien 'pre-signals' -liikennevalojen kytn.")
SETTEXT(CFG_MOREVEHICLES,       "'%s' (-%s) asettaa kulkuneuvojen yhteenlasketuksi mrksi arvo*850. Arvovli %ld..%ld, oletus %ld.")
SETTEXT(CFG_MAMMOTHTRAINS,      "'%s' (-%s) sallii mammuttijunat (enintn 126 vaunua).")
SETTEXT(CFG_FULLLOADANY,        "'%s' (-%s) muuttaa junien 'full load'-kyttytymist siten, ett juna lhtee asemalta, kun jotakin rahtityyppi on tysi lasti.")
SETTEXT(CFG_SELECTGOODS,        "'%s' (-%s): tietty tavaraa alkaa tulla asemalle vasta, kun sit aletaan vied sielt.")
SETTEXT(CFG_DEBTMAX,            "'%s' (-%s) sallii enimmismrn lainaamisen/maksamisen, kun 'Ctrl'-nappi on alhaalla.")
SETTEXT(CFG_OFFICEFOOD,         "'%s' (-%s): toimistorakennukset ottavat ruokaa vastaan (trooppiset/arktiset maat).")
SETTEXT(CFG_ENGINESPERSIST,     "'%s' (-%s) pit kulkuneuvotyypit kunnossa niin kauan, kun samaa tyyppi kytetn peliss.")
SETTEXT(CFG_CDPATH,             "'%s' (ei komentolinjamritett) asettaa CD-aseman polun.")
SETTEXT(CFG_KEEPSMALLAP,        "'%s' (-%s) sallii pienten lentokenttien ostamisen myhemminkin peliss.")
SETTEXT(CFG_AIBOOST,            "'%s' (-%s) asettaa tekolyn rekursiotason.")
SETTEXT(CFG_LONGBRIDGES,        "'%s' (-%s) sallii jopa 127 ruutua pitkt sillat.")
SETTEXT(CFG_DYNAMITE,           "'%s' (-%s) tekee useimmista asioista dynamiitilla poistettavia.")
SETTEXT(CFG_MULTIHEAD,          "'%s' (-%s) sallii useampia vetureita yhdess junassa. Ylimriset veturit ostetaan 'Ctrl'-nappi pohjassa.")
SETTEXT(CFG_RVQUEUEING,         "'%s' (-%s): autot jonottavat tynn olevan asman edess, eivtk knny ympri.")
SETTEXT(CFG_LOWMEMORY,          "'%s' (-%s) asettaa TTDPatchin kyttmn muistin rajaksi 2,5 Mb. 'morevehicles'-mritteen enimmisarvo on tllin 2.")
SETTEXT(CFG_GENERALFIXES,       "'%s' (-%s) korjaa useita pieni bugeja. Tst tarkemmin dokumentaatiossa.")
SETTEXT(CFG_MOREAIRPORTS,       "'%s' (-%s) sallii useamman kuin kahden lentokentn rakentamisen yhteen kaupunkiin.")
SETTEXT(CFG_BRIBE, "`%s' (-%s) Lis `bribe' (lahjo) napin aluevirainomais (local authority) menuun.")
SETTEXT(CFG_PLANECRCTRL, "`%s' (-%s) Antaa sinun ptt milloin ja miten lentokoneet tuhoutuvat. Bittikoodattu arvo (osa %ld.%ld ohjeissa), oletus %ld.")
SETTEXT(CFG_SHOWSPEED, "`%s' (-%s) nytt jokaisen kulkuneuvon tmnhetkisen nopeuden niiden \"status\" ikkunassa.")
SETTEXT(CFG_AUTORENEW, "`%s' (-%s) Uudistaa veturit nin monta kuukautta ennen kuin ne tulevat todella vanhoiksi.  Arvovli %ld..%ld.  Oletus %ld.")
SETTEXT(CFG_CHEATSCOST, "`%s' (-%s) tekee kylttihuijauskoodit maksullisiksi.")
SETTEXT(CFG_EXTPRESIGNALS, "`%s' (-%s) antaa vaihtaa \"pre-signal\" tyylej (pre- combi- ja exitsingalit) 'Ctrl' napin kanssa.")
SETTEXT(CFG_FORCEREBUILDOVL, "`%s' (-%s) pist TTDPatchin tekemn uuden TTDLOAD.OVL tai TTDLOADW.OVL joka kerta kun se kynnistetn.")
SETTEXT(CFG_DISKMENU, "`%s' (-%s) Lis \"lataa\" valinnan disketti menuun, ja lataa peli (tai tallenna peli 'Ctrl' napin kanssa) Scenario Editoriin.")
SETTEXT(CFG_WIN2K, "`%s' (-%s) Tekee TTD'n Windows version of TTD yhteensopivan Windows 2000/XP kanssa.")
SETTEXT(CFG_FEEDERSERVICE, "`%s' (-%s) Muuttaa unload komentoi niin, ett tavara jtetn asemalle, eik siit tule rahaa (kuten \"en-route\").")
SETTEXT(CFG_GOTODEPOT, "`%s' (-%s) allows you to add depots to vehicles' orders.")		
SETTEXT(CFG_NEWSHIPS, "`%s' (-%s) changes the ship models to a bigger variety, with more refitting options.")
SETTEXT(CFG_SUBSIDIARIES, "`%s' (-%s) allows you to manage AI companies if you own 75%%.")
SETTEXT(CFG_GRADUALLOADING, "`%s' (-%s) changes the way vehicles are loaded to a more realistic gradual loading (also activates `loadtime').")
SETTEXT(CFG_MOVEERRORPOPUP, "`%s' (-%s) moves all red error popups to the top-right corner of the screen.")
SETTEXT(CFG_SIGNAL1WAITTIME, "`%s' (-%s) changes the number of days after which a train waiting on a 1-way signal turns around.  Range 0..254, or 255 to wait forever.")
SETTEXT(CFG_SIGNAL2WAITTIME, "`%s' (-%s) changes the number of days after which a train waiting on a 2-way signal turns around.  Range 0..254, or 255 to wait forever.")
SETTEXT(CFG_DISASTERS, "`%s' (-%s) allows you to choose which disasters may occur.  Bitcoded value, default 255 (all disasters).")
SETTEXT(CFG_FORCEAUTORENEW, "`%s' (-%s) forces servicing of vehicles when it is time for the auto-renewal (see `autorenew').")
SETTEXT(CFG_MORENEWS, "`%s' (-%s) generates messages/news reports on more events, see the docs for more information.")
SETTEXT(CFG_UNIFIEDMAGLEV, "`%s' (-%s) makes it possible to buy monorail engines in maglev depots or vice versa.  Mode: 1 - convert all maglev engines to monorail; 2 - convert all monorail engines to maglev; 3 - keep separate monorail and maglev.")
SETTEXT(CFG_BRIDGESPEEDS, "`%s' (-%s) changes the speed limits on tubular monorail and maglev bridges to this percentage of the highest maximum engine speed in the class.  Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_ETERNALGAME, "`%s' (-%s) allows you to keep playing forever, the date isn't reset after 2070.")
SETTEXT(CFG_SHOWFULLDATE, "`%s' (-%s) always show the full date in the status, not only when the game is paused.")
SETTEXT(CFG_NEWTRAINS, "`%s' (-%s) activates new train models with new graphics.")
SETTEXT(CFG_NEWRVS, "`%s' (-%s) activates new road vehicle models with new graphics.")
SETTEXT(CFG_NEWPLANES, "`%s' (-%s) activates new aircract models with new graphics.")
SETTEXT(CFG_SIGNALSONTRAFFICSIDE, "`%s' (-%s) displays railroad signals on the same side of track road vehicles drive on.")
SETTEXT(CFG_ELECTRIFIEDRAIL, "`%s' (-%s) removes one of the magnetic track systems (Monorail or MagLev) and replaces it with an electrified railroad system.")
SETTEXT(CFG_STARTYEAR, "`%s' (-%s) sets the default start year for random games and allows greater choice of starting years in the scenario editor.  Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_ERRORPOPUPTIME, "`%s' (-%s) changes the time after which red error popup windows automatically close.  Range 1..255 (in seconds), or 0 for a very long time.  Default 10.")
SETTEXT(CFG_TOWNGROWTHLIMIT, "`%s' (-%s) changes the factor that limits the maximum possible extent of towns.  Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_LARGERTOWNS, "`%s' (-%s) makes each one out of a given number of towns grow faster and larger (also applying `towngrowthlimit' selectively).  Range %ld..%ld.  Default %ld (one out of four towns).")
SETTEXT(CFG_MISCMODS, "`%s' (-%s) makes it posible to modify the working of some other switches, see the docs on more info.  Bitcoded value, default 0 (no modifications).")
SETTEXT(CFG_LOADALLGRAPHICS, "`%s' (-%s) forces TTDPatch to always load all .grf files in newgrf(w).cfg, regardless of whether they were used previously in a loaded game (etc.) or not.")
SETTEXT(CFG_SAVEOPTDATA, "`%s' (-%s) makes TTDPatch save and load additional (optional) data at the end of savegames.")
SETTEXT(CFG_MOREBUILDOPTIONS, "`%s' (-%s) enables more build options. Bitcoded value, range %ld..%ld. Default %ld.")
SETTEXT(CFG_SEMAPHORES, "`%s' (-%s) turns new signals built before 1975 into semaphore signals.")
SETTEXT(CFG_MOREHOTKEYS, "`%s' (-%s) enables new hotkeys.")
SETTEXT(CFG_MANYTREES, "`%s' (-%s) allows planting more than one tree on a square, or over a rectangular area with Ctrl.")
SETTEXT(CFG_MORECURRENCIES,"`%s' (-%s) enables more currencies and the Euro.  Parameter: 0 - curr. symbols at default place; 1 - curr. symbols before numbers; 2 - curr. symbols after numbers.  Add 4 to the above value to disable the Euro.")
SETTEXT(CFG_MANCONVERT,"`%s' (-%s) allows manual track type conversion by placing new tracks over existing tracks.")
SETTEXT(CFG_NEWAGERATING, "`%s' (-%s) makes station ratings more tolerant to vehicle ages.  Now wagons can be up to 21 instead of 3 years old.")
SETTEXT(CFG_ENHANCEGUI,"`%s' (-%s) enhances the user interface.  Bitcoded value, range %ld..%ld.  Default %ld.")
SETTEXT(CFG_TOWNGROWTHRATEMODE, "`%s' (-%s) makes it possible to define rules for the calculation of the growth rate for towns.  Mode: 0 - TTD original, 1 - TTD extended, 2 - custom.  See the docs for more information.")
SETTEXT(CFG_TOWNGROWTHRATEMIN, "`%s' (no command line switch) defines the minimum growth rate of towns, in new houses per century.  Active only if `towngrowthratemode' is set to 2.  Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_TOWNGROWTHRATEMAX, "`%s' (no command line switch) defines the maximum growth rate of towns, in new houses per century.  Active only if `towngrowthratemode' is set to 2.  Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_TGRACTSTATIONEXIST, "`%s' (no command line switch) defines how much the existence of active stations increases the growth rate of a town (see the docs for more information).  Active only if `towngrowthratemode' is set to 2.  Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_TGRACTSTATIONS, "`%s' (no command line switch) defines how much each active station increases the growth rate of a town (see the docs for more information).  Active only if `towngrowthratemode' is set to 2.  Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_TGRACTSTATIONSWEIGHT, "`%s' (no command line switch) defines how effectively active stations contribute to the growth rate of a town (see the docs for more information).  Active only if `towngrowthratemode' is set to 2.  Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_TGRPASSOUTWEIGHT, "`%s' (no command line switch) defines how effectively transported passengers contribute to the growth rate of a town (see the docs for more information).  Active only if `towngrowthratemode' is set to 2.  Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_TGRMAILOUTWEIGHT, "`%s' (no command line switch) defines how effectively transported mail contributes to the growth rate of a town (see the docs for more information).  Active only if `towngrowthratemode' is set to 2.  Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_TGRPASSINMAX, "`%s' (no command line switch) defines the maximum number of incoming passengers that can affect growth of a town (see the docs for more information).  Active only if `towngrowthratemode' is set to 2.  Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_TGRPASSINWEIGHT, "`%s' (no command line switch) defines how effectively incoming passengers contribute to the growth rate of a town (see the docs for more information).  Active only if `towngrowthratemode' is set to 2.  Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_TGRMAILINOPTIM, "`%s' (no command line switch) defines the optimum population per each 2 bags of incoming mail (see the docs for more information).  Active only if `towngrowthratemode' is set to 2.  Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_TGRMAILINWEIGHT, "`%s' (no command line switch) defines how effectively incoming mail contributes to the growth rate of a town (see the docs for more information).  Active only if `towngrowthratemode' is set to 2.  Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_TGRGOODSINOPTIM, "`%s' (no command line switch) defines the optimum population per each 2 crates of incoming goods (see the docs for more information).  Active only if `towngrowthratemode' is set to 2.  Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_TGRGOODSINWEIGHT, "`%s' (no command line switch) defines how effectively incoming goods contribute to the growth rate of a town (see the docs for more information).  Active only if `towngrowthratemode' is set to 2.  Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_TGRFOODINMIN, "`%s' (no command line switch) defines the minimum food requirement of towns in snow-covered or desert areas, in population per 2 tons of incoming food (see the docs for more information).  Active only if `towngrowthratemode' is set to 2.  Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_TGRFOODINOPTIM, "`%s' (no command line switch) defines the optimum population per each 2 tons of incoming food (see the docs for more information).  Active only if `towngrowthratemode' is set to 2.  Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_TGRFOODINWEIGHT, "`%s' (no command line switch) defines how effectively incoming food contributes to the growth rate of a town (see the docs for more information).  Active only if `towngrowthratemode' is set to 2.  Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_TGRWATERINMIN, "`%s' (no command line switch) defines the minimum water requirement of towns in desert areas, in population per 2 tons (2,000 liters) of incoming water (see the docs for more information).  Active only if `towngrowthratemode' is set to 2.  Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_TGRWATERINOPTIM, "`%s' (no command line switch) defines the optimum population per each 2 tons (2,000 liters) of incoming water in the sub-tropical climate (see the docs for more information).  Active only if `towngrowthratemode' is set to 2.  Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_TGRWATERINWEIGHT, "`%s' (no command line switch) defines how effectively incoming water contributes to the growth rate of a town in the sub-tropical climate (see the docs for more information).  Active only if `towngrowthratemode' is set to 2.  Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_TGRSWEETSINOPTIM, "`%s' (no command line switch) defines the optimum population per each 2 bags of incoming candy (sweets) in the toyland climate (see the docs for more information).  Active only if `towngrowthratemode' is set to 2.  Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_TGRSWEETSINWEIGHT, "`%s' (no command line switch) defines how effectively incoming candy (sweets) contributes to the growth rate of a town in the toyland climate (see the docs for more information).  Active only if `towngrowthratemode' is set to 2.  Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_TGRFIZZYDRINKSINOPTIM, "`%s' (no command line switch) defines the optimum population per each 2 incoming fizzy drinks in the toyland climate (see the docs for more information).  Active only if `towngrowthratemode' is set to 2.  Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_TGRFIZZYDRINKSINWEIGHT, "`%s' (no command line switch) defines how effectively incoming fizzy drinks contribute to the growth rate of a town in the toyland climate (see the docs for more information).  Active only if `towngrowthratemode' is set to 2.  Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_TGRTOWNSIZEBASE, "`%s' (no command line switch) defines the base number of town buildings for the calculation involving `tgrtownsizefactor' (see the docs for more information).  Active only if `towngrowthratemode' is set to 2.  Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_TGRTOWNSIZEFACTOR, "`%s' (no command line switch) defines how much the size of a town influences its growth rate (see the docs for more information).  Active only if `towngrowthratemode' is set to 2.  Range %ld..%ld.  Default %ld (i.e. 25%% influence).")
SETTEXT(CFG_TOWNMINPOPULATIONSNOW, "`%s' (no command line switch) defines the minimum population to which towns in snow-covered areas can grow even without food supplies.  Active if `towngrowthratemode', `towngrowthlimit' or `generalfixes' is enabled.  Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_TOWNMINPOPULATIONDESERT, "`%s' (no command line switch) defines the minimum population to which towns in desert areas can grow even without food and water supplies.  Active if `towngrowthratemode', `towngrowthlimit' or `generalfixes' is enabled.  Range %ld..%ld.  Default %ld.")
SETTEXT(CFG_MORETOWNSTATS, "With `%s' (-%s) additional statistics are displayed in town information windows.")
SETTEXT(CFG_BUILDONSLOPES, "`%s' (-%s) makes it possible to build tracks, roads and stations on sloped land, on a foundation like houses.")
SETTEXT(CFG_BUILDONCOASTS, "`%s' (-%s) makes it possible to build on coasts or riverbanks without having to use the dynamite tool first.")
SETTEXT(CFG_TRACKTYPECOSTDIFF, "`%s' (-%s) makes different track types have different cost.")
SETTEXT(CFG_CUSMULTIPLIER, "`%s' (no command line switch) sets the exchange ratio for custom currency CUS * 1000.  Default is 1000 (1 CUS = 1 pound).  Active only if `morecurrencies' is enabled.")
SETTEXT(CFG_EXPERIMENTALFEATURES, "`%s' (-%s) enables the latest experimental features.")
SETTEXT(CFG_PLANESPEED, "`%s' (-%s) makes planes fly at their indicated speed, not a quarter thereof, and reduces speed to 5/8 in case of a breakdown.")
SETTEXT(CFG_FASTWAGONSELL, "`%s' (-%s) allows faster wagon selling with Ctrl")
SETTEXT(CFG_NEWRVCRASH,"`%s' (-%s) changes train/road vehicle crashes. %ld makes the train break down after the crash. %ld disables train/road vehicle crashes at all. Default: type %ld");
SETTEXT(CFG_STABLEINDUSTRY,"`%s' (-%s) prevents industries from closing down if Economy is set to Steady in Difficulty settings");


//----------------------------------------------------
//   SWITCH DISPLAY ('-v')
//----------------------------------------------------

// Wait for a key before displaying the switches
SETTEXT(LANG_SWWAITFORKEY, "\nEnter ajaa TTD:n, Esc lopettaa, muu nytt asetukset.")		

// Introduction
SETTEXT(LANG_SHOWSWITCHINTRO, "\n"
	  "\n"
	  "    Mritteet pll:   (%c pll, %c pois)\n")

// Five characters: vertical line for the table; enabled switch; disabled switch;
// table heading; table heading column separator.
SETTEXT(LANG_SWTABLEVERCHAR, "*")

// 1-way and 2-way captions after "New train wait time on red signals"
SETTEXT(LANG_SWONEWAY, "Yksisuunta: ")
SETTEXT(LANG_SWTWOWAY, "Kaksisuunta: ")

// Train wait time is either in days or infinite
SETTEXT(LANG_TIMEDAYS, "%d piv()")
SETTEXT(LANG_INFINITETIME, "loputon")

// Shows the load options for ttdload.  %s is the given parameters to be passed to ttdload
SETTEXT(LANG_SWSHOWLOAD, "Paina mit tahansa nppint jatkaaksesi komennon \"TTDLOAD %s\" ksittely\n"
			 "(Esc peruuttaa).")

SETTEXT(LANG_SWABORTLOAD, "\nOhjelman lataus keskeytetty kyttjn pyynnst.\n")


//---------------------------------------
//  STARTUP AND REPORTING
//---------------------------------------

// Internal error in TTDPatch (%d is error number)
SETTEXT(LANG_INTERNALERROR, "*** Sisine TTDPatch virhe #%d ***\n")

// Error fixing the Windows version HDPath registry entry
SETTEXT(LANG_REGISTRYERROR, "TTD ei ole asennettu oikein (rekisteri virhe %d)\n")

// DOS reports no memory available
SETTEXT(LANG_NOTENOUGHMEM, "Muisti ei riit (%s), tarvitaan %d Kb lis.\n")

// ...for starting TTD
SETTEXT(LANG_TOSTARTTTD, "TTD:n kynnistmiseen")

// Protected mode code exceeds 32kb
SETTEXT(LANG_PROTECTEDTOOLARGE, "Suojatun tilan koodi on liian suuri!\n")

// Show where the code was stored, %p is the location
SETTEXT(LANG_CODESTOREDAT, "Suojatun tilan koodi tallennettu osoitteeseen %lX.\n")

// Swapping TTDPatch out
SETTEXT(LANG_SWAPPING, "Swapataan ulos.\n")

// Just before running ttdload, show this.
// 1st %s is ttdload.ovl, then %s is a space if there are options,
// and the 2nd %s contains the options
SETTEXT(LANG_RUNTTDLOAD, "Kynnistetn %s%s%s\n")

// Error executing ttdload.  1st %s is ttdload.ovl, 2nd %s is the error message from the OS
SETTEXT(LANG_RUNERROR, "Ei voida suorittaa ohjelmaa %s: %s\n")

// Show the result after after running, %s is one of the following strings
SETTEXT(LANG_RUNRESULT, "Tulos: [%s]\n")
SETTEXT(LANG_RUNRESULTOK, "OK")
SETTEXT(LANG_RUNRESULTERROR, "Virhe!")

// Messages about the graphics file ttdpatch.grf
SETTEXT(LANG_NOTTDPATCHGRF, "Graafiikoita %s ei lytynyt, luodaan tyhj tiedosto.\n")
SETTEXT(LANG_ERRORCREATING, "Virhe %s luomisessa: %s\n")
