//
// Localization strings for TTDPatch.
//

//-------------------------------------------
//  INFO ABOUT THIS LANGUAGE
//-------------------------------------------
SETNAME("German")
COUNTRYARRAY(countries) = { 41, 43, 49, 0, 0x07, 0 };
SETARRAY(countries);
	// 41 is Switzerland, 43 is Austria, 49 is Germany
	// 0x07 is German in Windows

DOSCODEPAGE(850)	// The default DOS code page for this language
WINCODEPAGE(1252)	// The default Windows code page for this language
EDITORCODEPAGE(850)	// The code page of all strings in this file.

//-------------------------------------------
//  PROGRAM BLURBS
//-------------------------------------------

// First line of output is something like "TTDPatch V1.5.1 starting.\n"
// The program name and version are autogenerated, only put the " starting\n"
// here
SETTEXT(LANG_STARTING, " wird gestartet.\n")


//-------------------------------------------
//  VERSION CHECKING
//-------------------------------------------

// In the version identifier, this is for the file size
SETTEXT(LANG_SIZE, "Dateigre")

// Shown if the version is recognized
SETTEXT(LANG_KNOWNVERSION, "Die Adressen dieser Version sind bekannt.\n")

// Warning if the version isn't recognized.  Be sure *not* to use tabs
// in the text.  All but the last lines should end in ...\n"
SETTEXT(LANG_WRONGVERSION, "\n"
	"WARNUNG! Diese Programmversion ist unbekannt. Wir knnen versuchen, TTD\n"
	"         trotzdem zu starten, und die notwendigen Informationen nebenher\n"
	"         zu sammeln. Falls das aber fehlschlgt, wird TTD eine Schutz-\n"
	"         verletzung erzeugen und abstrzen.\n"
	"\n"
	"         Je nach Ihrem Betriebssystem kann dadurch auch der Computer\n"
	"         abstrzen und es kann zu Datenverlusten kommen. Bitte lesen Sie\n"
	"         Abschnitt 4.13 in der Datei TTDPATCH.TXT fr weitere Informationen.\n"
	"\n"
	"Antworten Sie nur dann mit 'j', wenn sie sich der Auswirkungen bewut sind.\n"
	"SIE SIND GEWARNT WORDEN!\n"
	"Mchten Sie TTD trotzdem starten? ")

// Keys which continue loading after the above warning. *MUST* be lower case.
// can be several different keys, e.g. one for your language "yjo"
SETTEXT(LANG_YESKEYS, "jy")

// Answering anything but the above keys gives this message.
SETTEXT(LANG_ABORTLOAD, "Programmstart abgebrochen.\n")

// otherwise continue loading
SETTEXT(LANG_CONTINUELOAD, "Ich werde mein Bestes geben...\n")

// Warning if '-y' was used and the version is unknown
SETTEXT(LANG_WARNVERSION, "WARNUNG! Die Version ist unbekannt.\n")


// -------------------------------------------
//    CREATING AND PATCHING TTDLOAD
// -------------------------------------------

// TTDLOAD.OVL doesn't exist
SETTEXT(LANG_OVLNOTFOUND, " nicht gefunden, suche die Originaldateien:\n")

// (DOS) neither do tycoon.exe or ttdx.exe.  %s is TTDX.EXE
SETTEXT(LANG_NOFILESFOUND, "Konnte weder TYCOON.EXE noch %s finden.\n")

// (Windows) neither does GameGFX.exe.  %s is GameGFX.EXE
SETTEXT(LANG_NOFILEFOUND, "Konnte %s nicht finden.\n")

// Shown when copying tycoon.exe or ttdx.exe (first %s) to ttdload.ovl (2nd %s)
SETTEXT(LANG_SHOWCOPYING, "Kopiere %s nach %s")

// Error if running the copy command fails.  %s is the command.
SETTEXT(LANG_COPYERROR_RUN, "Konnte %s nicht ausfhren.\n")

// Error if command returned successfully, but nothing was copied.
// %s=TTDLOAD.OVL
SETTEXT(LANG_COPYERROR_NOEXIST, "Kopierfehler - Datei %s existiert nicht.\n")

// Invalid .EXE format
SETTEXT(LANG_INVALIDEXE, "Unbekanntes .EXE-Format.\n")

// Version could not be determined
SETTEXT(LANG_VERSIONUNCONFIRMED, "Konnte die Programmversion nicht bestimmen.\n")

// Shows program name (1st %s) and version (2nd %s)
SETTEXT(LANG_PROGANDVER, "Der genaue Programmname ist:\n%s\nDie genaue Version ist %s\n")

// More than three numbers in the version string (not #.#.#)
SETTEXT(LANG_TOOMANYNUMBERS, "Die Versionsnummer hat zuviele Stellen!\n")

// .EXE is not TTD
SETTEXT(LANG_WRONGPROGRAM, "Das Programm ist nicht Transport Tycoon Deluxe.\n")

// Displays the parsed version number
SETTEXT(LANG_PARSEDVERSION, "Die verarbeitete Versionsnummer ist %s\n")

// The exe has been determined to be the DOS extended executable
SETTEXT(LANG_ISDOSEXTEXE, "Dies ist die DOS Programmdatei.\n")

// The exe has been determined to be the Windows executable
SETTEXT(LANG_ISWINDOWSEXE, "Dies ist die Windows Programmdatei.\n")

// The exe is of an unknown type
SETTEXT(LANG_ISUNKNOWNEXE, "Dies ist eine unbekannte Programmdatei.\n")

// The exe is the wrong one for this TTDPatch, i.e. DOS/Windows mixed up. %s=DOS or Windows
SETTEXT(LANG_NOTSUPPORTED, "Tut mir leid, diese TTDPatch-Version funktioniert nur mit\nder %s Version von TTD.\n")

// If the original .exe segment length (%lx) is too large or too small
SETTEXT(LANG_INVALIDSEGMENTLEN, "Ungltige Segmentlnge von %lx.")

// When increasing the segment length
SETTEXT(LANG_INCREASECODELENGTH, "Setze Programmgre auf %s MB.\n")

// Can't write to TTDLOAD.OVL (%s) [or TTDLOADW.OVL for the Windows version]
SETTEXT(LANG_WRITEERROR, "Kann Datei %s nicht schreiben, ist sie schreibgeschtzt?\n")

// Installing the code loeader
SETTEXT(LANG_INSTALLLOADER, "Installiere den Code-Lader.\n")

// TTDLOAD.OVL (%s) is invalid, needs to be deleted.
SETTEXT(LANG_TTDLOADINVALID, "Konnte den Code-Lader nicht installieren")

// Suggestion to delete TTDLOAD.OVL (%s) if it is invalid
SETTEXT(LANG_DELETEOVL, " - versuchen Sie %s\nzu lschen.\n")

// TTDLOAD.OVL was verified to be correct
SETTEXT(LANG_TTDLOADOK, "%s ist in Ordnung.\n")

// Waiting for key before terminating TTDPatch after an error occured
SETTEXT(LANG_PRESSANYKEY, "Bitte drcken Sie eine Taste um das Programm zu beenden.")

// Displayed on various warning conditions: Esc to exit, any other key to continue
SETTEXT(LANG_PRESSESCTOEXIT, "Drcken Sie Escape um abzubrechen, oder eine andere Taste um fortzufahren.")

// Loading custom in-game texts
SETTEXT(LANG_LOADCUSTOMTEXTS, "Lade bersetzte Spieltexte.\n")

// ttdpttxt.dat is not in a valid format
SETTEXT(LANG_CUSTOMTXTINVALID, "Fehler beim Lesen von %s: Ungltiges Dateiformat.\n")

SETTEXT(LANG_CUSTOMTXTWRONGVER,
	"%s mu aktualisiert werden fr diese TTDPatch-Version.\n"
	"Bitte installieren und starten Sie die aktualisierte Version von mkpttxt.exe.\n")


//-----------------------------------------------
//   COMMAND LINE HELP (-h)
//-----------------------------------------------

// Introduction, prefixed with "TTDPATCH V<version> - "
SETTEXT(LANG_COMMANDLINEHELP, "Patcht TTD und startet das vernderte Programm %s\n"
	  "\n"
	  "Verwendung: TTDPATCH [-C Kfg-Datei] [Schalter] [CD-Pfad] [-W Kfg-Datei]\n"
	  "\n")

// Lines of help for all on/off switches, each at most 38 chars long.
// If you need more chars just insert another line.
TEXTARRAY(halflines,) =
//	  |         1         2         3
//	  |12345678901234567890123456789012345678|
	{ "-a:  Alle Schalter bis auf -x an",
	  "-d:  Immer das volle Datum anzeigen",
	  "-f:  Zge umrstbar machen",
	  "-g:  Kleinere Korrekturen (s.Anl.)",
	  "-k:  Kleine Flughafen immer baubar",
	  "-l:  Bis zu 7 Bahnsteige",
	  "-n:  Neue 'Direkt' Anweisung",
	  "-q:  Verbesserte Be-/Entladezeiten",
	  "-s:  Schilder-Cheats aktiviert",
	  "-v:  Alle Schalter anzeigen",
	  "-w:  Automatische Vorsignale aktiviert",
	  "-y:  Versionsabfrage berspringen",
	  "-z:  Mammutzge (126 Wagons)",

	  "-B:  Lngere Brcken",
	  "-D:  Mehr Dinge abreibar",
	  "-E:  Rote Fehler-Fenster verschieben",
	  "-F:  Voll Beladen mit nur einem Gut",
	  "-G:  Stationsgter whlbar",
	  "-I:  Inflation abschalten",
	  "-J:  Mehr Flughfen pro Stadt",
	  "-L:  max.Kredit leihen/zahlen mit Strg",
	  "-N:  Nachrichten fr mehr Ereignisse",
	  "-O:  Brotrme akzeptieren Essen",
	  "-P:  Persistente Loks wenn benutzt",
	  "-R:  LKW/Busse warten bis Stelle frei",
	  "-S:  Neue Schiffsmodelle",
	  "-T:  Neue Eisenbahnmodelle",
	  "-Z:  Option fr wenig Speicher (3.5MB)",

	  "-2:  Windows 2000 Kompatibilitt",

	  "-Xb: Bestechungsoption im Stadtmen",
	  "-Xd: Depots in Fahrzeugsauftrgen",
	  "-Xe: Ewiges Spiel nach 2070",
	  "-Xf: Zubringerdienste",
	  "-Xg: Fahrzeuge stetig beladen",
	  "-Xi: Keine Industrie schliet bei",
	  "     ruhiger Wirtschaft",
	  "-Xm: Ladeoption im Diskettenmen",
	  "-Xo: Schilder-Cheats kosten Geld",
	  "-Xr: TTDLOAD.OVL immer neu erstellen",
	  "-Xs: Fahrzeuggeschwindigkeit anzeigen",
	  "-Xw: Erweiterte Vorsignale",
	  "-Xx: Zustzl. Daten speichern u. laden",

	  "-XA: Erzwungene Erneuerung mit -Xa",
	  "-XE: Eisenbahn mit Oberleitung",
	  "-XF: Experimentelle Features",
	  "-XG: Alle neuen Grafiken einbinden",
	  "-XP: Neue Flugzeugmodelle",
	  "-XR: Neue Straenfahrzeugmodelle",
	  "-XS: Tochterfirmen verwalten",

	  "-Ya: Bahnhofsbewertungen toleranter",
	  "     bezglich Waggonalter",
	  "-Yb: Mehr Baumglichk. an Steigungen",
	  "-Yc: Schienentypen kosten verschieden",
	  "-Ym: Manueller Schienenumbau",
	  "-Ys: Signale auf Straenverkehrsseite",
	  "-Yt: Mehr Statistiken im Stadtfenster",
	  "-Yw: Schnellerer Waggon-Verkauf",

	  "-YC: Baumglichkeit direkt an Kste",
	  "-YH: Mehr Tastenbelegungen",
	  "-YP: Flugzeugbewegung m.angeg.Geschw.",
	  "-YS: Formsignale vor 1975",

	  NULL
	};
SETARRAY(halflines);

// Text describing the switches with values.  The lines have to be shorter
// than 79 chars, excluding the "\n".  Start new lines if necessary.
SETTEXT(LANG_FULLSWITCHES, "\n"
	  "-e #:    Mgliche Stationsgre erhhen\n"
	  "-i #:    Standardmiger Wartungszeitraum in Tagen\n"
	  "-x #:    Fahrzeuganzahl auf 850*# vervielfachen. Lesen Sie die Anleitung!\n"
	  "-mc #:   Neues Verhalten an Steigungen bzw. in Kurven\n"
	  "-trpb #: Maximale Fahrzeugnummer erhhen, fr Zge/Autos/Flugzeuge/Schiffe.\n"
	  "-A #:    Computergegner um diesen (kleinen!) Wert verbessern.\n"
	  "-M #:    Zustzliche Loks fr Zge, Geschwindigkeitserhhung in Prozent.\n"
	  "-Xa #:   Fahrzeuge werden autom. erneuert, # Monate nach Ende der Lebensdauer.\n"
	  "-Xc #:   Steuert die Hufigkeit von Flugzeugabstrzen\n"
	  "-Yr #:   Ereignis bei Kollision von Zug und Straenfahrzeug whlen (1/2)\n"
	  "-Xt #:   Maximale Gre des Stadtwachstums\n"
	  "-XC #:   Mehr Whrungen, und zustzliche Darstellungsmglichkeiten\n"
	  "-XD #:   Wahl welche Katastophen sich ereignen knnen\n"
	  "-XM #:   Kombiniertes Einschienen- und Schwebebahnsystem\n"
	  "-XT #:   Eine aus jeweils sovielen Stdten hat greres Wachstum\n"
	  "-XX #:   Neue Geschwindigkeitsbegrenzungen fr Brcken von Einschienenbahn und\n"
	  "         Schwebebahn, in Prozent der jeweils hchsten Geschwindigkeit\n"
	  "-XY #:   Neues Anfangsjahr fr Zufallsspiele\n"
	  "-X1 #, -X2 #: Max. Wartezeit in Tagen bei roten Ein- bzw. Zweiwegsignalen\n"
	  "-Yo #:   nderung der Einstellungen bestimmter Features (siehe Anleitung)\n"
	  "-Yp #:   Bume in groen Rechtecken anpflanzen, Moduseinstellung\n"
	  "-YB #:   Mehr Baumglichkeiten, Auswahl der Mglichkeiten\n"
	  "-YE #:   Zeit in Sekunden wie lange rote Fehlerfenster angezeigt werden\n"
	  "-YG #:   Verbesserungen der Benutzeroberflche, Auswahl der Einstellungen\n"
	  "-YT #:   Auswahl der Stadtwachstumsberechnung\n"
	  "\n"
	  "-C Kfg-Datei:  Diese Konfigurationsdatei lesen, statt ttdpatch.cfg\n"
	  "-W Kfg-Datei:  Konfigurationsdatei erzeugen, mit der aktuellen Einstellung\n"
	  "\n"
	  "Gro-/Kleinschreibung ist wichtig!\n"
	  "\n"
	  "Beispiel: ttdpatch -fnqz -m 00 -c 13 -trpb 240 -v\n"
	  "\n"
	  "(Hinweis: Falls der Text schon oben weggescrollt wurde, versuchen Sie mal\n"
	  "          \"ttdpatch -h|more\")\n")

// Referral to the docs, prefixed by "Copyright (C) 1999 by Josef Drexler.  "
SETTEXT(LANG_HELPTRAILER, "Lesen Sie TTDPATCH.TXT fr weitere \nInformationen.\n")


//-----------------------------------------------
//  COMMAND LINE AND CONFIG FILE PARSING
//-----------------------------------------------

// if an on/off switch has a value other than the above (%s = wrong value)
SETTEXT(LANG_UNKNOWNSTATE, "Warnung: Unbekannter an/aus-Wert %s, wird auf aus gesetzt.\n")

// switch is unknown.  %c is '-' or '/' etc, %s is the switch char
SETTEXT(LANG_UNKNOWNSWITCH, "Unbekannter Schalter '%c%s'. Der Schalter -h zeigt eine Hilfe an.\n")

// cfg command %s is unknown
SETTEXT(LANG_UNKNOWNCFGLINE, "Warnung: Ungltige Konfigurationsanweisung '%s'.\n")

// Names of the switches for the '-v' options
// First string is shown always, second only if set and with the given
// value of the switch in %d.
// These lines (both parts) are limited to 36 chars, also consider how large
// the expansion of the %d can be for that switch.
//	|         1         2         3
//	|123456789012345678901234567890123456|
SWITCHTEXT(uselargerarray, "Gesamtzahl Fahrzeuge erhhen", ": %d*850")
SWITCHTEXT(usenewcurves, "Neue Behandlung von Kurven", " fr %04x")
SWITCHTEXT(usenewmountain, "Neue Behandlung von Bergen", " fr %04x")
SWITCHTEXT(usenewnonstop, "Neue 'Direkt' Anweisung", "")
SWITCHTEXT(increasetraincount, "Neue maximale Zuganzahl", ": %d")
SWITCHTEXT(increaservcount, "Neue maximale Autoanzahl", ": %d")
SWITCHTEXT(setnewservinterval, "Neues Wartungsintervall", ": %d Tage")
SWITCHTEXT(usesigncheat, "Schildercheats aktiviert", "")
SWITCHTEXT(allowtrainrefit, "Zge umrstbar", "")
SWITCHTEXT(increaseplanecount, "Neue maximale Flugzeuganz.", ": %d")
SWITCHTEXT(increaseshipcount, "Neue maximale Schiffsanz.", ": %d")
SWITCHTEXT(keepsmallairports, "Kleine Flughfen behalten", "")
SWITCHTEXT(largerstations, "Grere Bahnhofsdistanz", ", %d Felder")
SWITCHTEXT(morestationtracks, "Erweiterbare Bahnhfe", "")
SWITCHTEXT(longerbridges, "Lngere Brcken", "")
SWITCHTEXT(improvedloadtimes, "Verbesserte Be- und Entladezeiten", "")
SWITCHTEXT(mammothtrains, "Mammutzge (max. Lnge 127)", "")
SWITCHTEXT(presignals, "Vorsignale automatisch verwenden", "")
SWITCHTEXT(officefood, "Brotrme akzeptieren Essen", "")
SWITCHTEXT(noinflation, "Inflation abschalten", "")
SWITCHTEXT(maxloanwithctrl, "Max. Kredit mit 'Strg'", "")
SWITCHTEXT(persistentengines, "Persistente Fahrzeuge", "")
SWITCHTEXT(fullloadany, "Beladen mit jeder Gterart", "")
SWITCHTEXT(selectstationgoods, "Whlbare Stationsgter", "")
SWITCHTEXT(morethingsremovable, "Mehr Zeug abreibar", "")
SWITCHTEXT(aibooster, "Computer-Rekursion erhhen", " um %d")
SWITCHTEXT(multihead, "Zge mit mehr Loks", ", Geschw. +%d%%")
SWITCHTEXT(newlineup, "LKW/Busse warten bis Stelle frei", "")
SWITCHTEXT(lowmemory, "Version f. wenig Speicher (3.5MB)", "")
SWITCHTEXT(generalfixes, "Korrektur kleinerer Fehler (s.Anl.)", "")
SWITCHTEXT(moreairports, "Mehr als 2 Flughfen pro Stadt", "")
SWITCHTEXT(bribe, "Bestechungsoption im Stadtmen", "")
SWITCHTEXT(noplanecrashes, "Flugzeugabstrze", ": %d")
SWITCHTEXT(showspeed, "Fahrzeuggeschwindigkeit anzeigen", "")
SWITCHTEXT(autorenew, "Fahrzeuge autom. erneuern", ", %d Mon.")
SWITCHTEXT(cheatscost, "Schildercheats kosten Geld", "")
SWITCHTEXT(extpresignals, "Erweiterte Vorsignale mit 'Strg'", "")
SWITCHTEXT(diskmenu, "Ladeoption im Diskettenmen", "")
SWITCHTEXT(win2k, "Windows 2000/XP Kompatibilitt", "")
SWITCHTEXT(feederservice, "Zubringerdienste", "")
SWITCHTEXT(gotodepot, "Depots in Fahrzeugsauftrgen", "")
SWITCHTEXT(newships, "Neue Schiffsmodelle", "")
SWITCHTEXT(subsidiaries, "Tochterfirmen verwalten", "")
SWITCHTEXT(gradualloading, "Fahrzeuge stetig be/entladen", "")
SWITCHTEXT(moveerrorpopup, "Rote Fehler-Fenster verschieben", "")
SWITCHTEXT(setsignal1waittime, "Neue Wartezeit bei roten Signalen", ":")
SWITCHTEXT(setsignal2waittime, "", "")				// dummy entry
SWITCHTEXT(maskdisasters, "Katastrophenauswahl", ": %d")
SWITCHTEXT(forceautorenew, "Erzwungene Fahrzeugerneuerung", "")
SWITCHTEXT(morenews, "Nachrichten ber mehr Ereignisse", "")
SWITCHTEXT(unifiedmaglev, "Kombinierte Schwebebahn", ", Art %d")
SWITCHTEXT(newbridgespeeds, "Max.Geschw. auf Schwebebahnbr.", ":%3d%%")
SWITCHTEXT(eternalgame, "Ewiges Spiel nach 2070", "")
SWITCHTEXT(showfulldate, "Immer das volle Datum anzeigen", "")
SWITCHTEXT(newtrains, "Neue Eisenbahnmodelle", "")
SWITCHTEXT(newrvs, "Neue Straenfahrzeugmodelle", "")
SWITCHTEXT(newplanes, "Neue Flugzeugmodelle", "")
SWITCHTEXT(signalsontrafficside, "Signale auf Seite des Straenverk.", "")
SWITCHTEXT(electrifiedrail, "Eisenbahn mit Oberleitung", "")
SWITCHTEXT(newstartyear, "Neues Startjahr", ": %d")
SWITCHTEXT(newerrorpopuptime, "Anzeigedauer von Fehlern", ": %d Sek.")
SWITCHTEXT(newtowngrowthfactor, "Stadtwachstumsgrenze", " %d")
SWITCHTEXT(largertowns, "Grere Stdte", ", jeweils 1 von %d")
SWITCHTEXT(miscmods, "Verschiedene Einstellungen", ": %d")
SWITCHTEXT(loadallgraphics, "Alle neuen Grafiken einbinden", "")
SWITCHTEXT(saveoptdata, "Zustzliche Daten laden u. speichern", "")
SWITCHTEXT(morebuildoptions, "Mehr Baumglichkeiten", ": %d")
SWITCHTEXT(semaphoresignals, "Formsignale vor 1975", "")
SWITCHTEXT(morehotkeys, "Neue Tastaturbelegungen", "")
SWITCHTEXT(plantmanytrees, "Viele Bume schnell pflanzen", ", Art %d")
SWITCHTEXT(morecurrencies, "Mehr Whrungen", ", Einstellung %d")
SWITCHTEXT(manualconvert, "Manueller Schienenumbau", "")
SWITCHTEXT(newtowngrowthrate, "Neuer Stadtwachstumsalgorithmus", ": %d")
SWITCHTEXT(displmoretownstats, "Mehr Statistiken fr Stdte", "")
SWITCHTEXT(enhancegui, "Verbesserungen d.Benutzeroberfl.", ": %d")
SWITCHTEXT(newagerating, "Bewertung toleranter bzgl. Alter", "")
SWITCHTEXT(buildonslopes, "Mehr Baumglichkeiten an Steigungen", "")
SWITCHTEXT(buildoncoasts, "Direkt an der Kste bauen", "")
SWITCHTEXT(experimentalfeatures, "Experimentalfeatures aktivieren", ": %d")
SWITCHTEXT(tracktypecostdiff, "Schienentypen haben untersch. Kosten", "")
SWITCHTEXT(planespeed, "Flugzeug fliegen mit angeg. Geschw.", "")
SWITCHTEXT(fastwagonsell, "Vereinfachter Zugverkauf", "")
SWITCHTEXT(newrvcrash, "ndere Zug/KFZ-Kollision",", Art %d")
SWITCHTEXT(stableindustry, "Verhindere Industrieschlieung","")

// A cfg file (%s) could not be found and is ignored.
SETTEXT(LANG_CFGFILENOTFOUND, "Konfigurationsdatei %s nicht vorhanden, wurde ignoriert.\n")

// Couldn't write the config file
SETTEXT(LANG_CFGFILENOTWRITABLE, "Konnte %s nicht schreiben.\n")

// A non-comment line is longer than 32 chars, rest ignored.
SETTEXT(LANG_CFGLINETOOLONG, "Warnung! Konfigurationszeile ist lnger als 32 Zeichen, wurde abgeschnitten.\n")

// Shown if an obsolete switch is used. First option is %s which is the
// config name, second one is %s which is the command line char
SETTEXT(LANG_SWITCHOBSOLETE, "Der Schalter `%s' (-%s) ist veraltet. Bitte verwenden sie ihn\n"
		"nicht mehr, er wird in einer zuknftigen Version entfernt werden.\n")

//---------------------------------------------------
//   CONFIG FILE COMMENTS (for '-W')
//---------------------------------------------------

// This is the intro at the start of the config file.  No constraints on line lengths.
SETTEXT(CFG_INTRO,
	CFG_COMMENT "\n"
	CFG_COMMENT "TTDPatch Konfigurationsdatei, automatisch erzeugt von TTDPatch -W Dateiname.\n"
	CFG_COMMENT "(TTDPatch %s)\n"
	CFG_COMMENT "\n"
	CFG_COMMENT "Format der Schalter:\n"
	CFG_COMMENT "   Schaltername = Schalterwert\n"
	CFG_COMMENT "\n"
	CFG_COMMENT "Das \"=\" kann weggelassen werden. Gro-/Kleinschreibung ist egal.\n"
	CFG_COMMENT "\n"
	CFG_COMMENT "Fr an/aus Schalter kann man einen der folgenden Werte angeben:\n"
	CFG_COMMENT "   yes, y, on, 1, no, n, off, 0\n"
	CFG_COMMENT "Falls der Wert nicht angegeben wird, wird der an/aus Schalter aktiviert.\n"
	CFG_COMMENT "\n"
	CFG_COMMENT "Fr Schalter mit einem Wert ist der zulssige Bereich fr jeden Schalter\n"
	CFG_COMMENT "bei der Beschreibung angegeben, genau wie der jeweilige Standardwert.\n"
	CFG_COMMENT "Diese Schalter knnen abgeschalten werden indem man einen der 'aus' Werte.\n"
	CFG_COMMENT "angibt (auer 0).\n"
	CFG_COMMENT "\n"
	CFG_COMMENT "Kommentare sind alle Zeilen die nicht mit einem Buchstaben beginnen.\n"
	CFG_COMMENT "\n")

// Line before previously unset switches
SETTEXT(CFG_NEWSWITCHINTRO, "**** Neue Einstellungen ****")

// Definitions of the cfg file comments.
// All can have a place holder %s to stand for the actual setting name,
// and all but CFG_CDPATH can have a %s *after* the %s for the command
// line switch.
// They will have the "comment" char and a space prefixed.
//
SETTEXT(CFG_SHIPS, "`%s' (-%s) erhht die maximal verfgbaren Schiffe.  Bereich %ld..%ld.  Standard %ld.")
SETTEXT(CFG_CURVES, "`%s' (-%s) stellt Geschwindigkeit in Kurven auf normal (0), schneller (1), volle Geschwindigkeit (2) oder realistisch (3).  Je eine Ziffer fr Eisenbahn, Einschienenbahn/Eisenbahn mit Oberleitung, Schwebebahn und Straenfahrzeuge.  Standard 0120.")
SETTEXT(CFG_MOUNTAINS, "`%s' (-%s) stellt das Fahrverhalten an Steigungen auf normal (0), schneller (1), volle Geschwindigkeit (2) oder realistisch (3).  Je eine Ziffer fr Eisenbahn, Einschienenbahn/Eisenbahn mit Oberleitung, Schwebebahn und Straenfahrzeuge.  Standard 0120.")
SETTEXT(CFG_SPREAD, "`%s' (-%s) ermglicht weiter ausgebreitete Stationen.  Bereich %ld..%ld.  Standard %ld.")
SETTEXT(CFG_TRAINREFIT, "`%s' (-%s) ermglicht es Zge umzursten.")
SETTEXT(CFG_SERVINT, "`%s' (-%s) stellt ein anderes standardmiges Wartungsintervall ein, fr neue Fahrzeuge.  Bereich 1..%ld Tage.  Standard %ld (ca. %ld Jahre).")
SETTEXT(CFG_NOINFLATION, "`%s' (-%s) schaltet die Inflation ab, sowohl fr Ausgaben als auch fr Einknfte.")
SETTEXT(CFG_LARGESTATIONS, "`%s' (-%s) ermglicht es bestehende Bahnhfe zu erweitern, indem man zustzliche Bahnsteige anfgt, auf bis zu 7x7.")
SETTEXT(CFG_NONSTOP, "Mit `%s' (-%s) verhlt sich der \"Non-stop\" Befehl anders.")
SETTEXT(CFG_PLANES, "`%s' (-%s) erhht die maximal verfgbaren Flugzeuge.  Bereich %ld..%ld.  Standard %ld.")
SETTEXT(CFG_LOADTIME, "`%s' (-%s) aktiviert eine verbesserte, realistischere Berechnung der Be- und Entladezeiten.")
SETTEXT(CFG_ROADVEHS, "`%s' (-%s) erhht die maximal verfgbaren Autos.  Bereich %ld..%ld.  Standard %ld.")
SETTEXT(CFG_SIGNCHEATS, "`%s' (-%s) aktiviert die Schilder-Cheats.")
SETTEXT(CFG_TRAINS, "`%s' (-%s) erhht die maximal verfgbaren Zge.  Bereich %ld..%ld.  Standard %ld.")
SETTEXT(CFG_VERBOSE, "`%s' (-%s) zeigt eine Zusammenfassung aller Schalter bevor das Spiel gestartet wird.")
SETTEXT(CFG_PRESIGNALS, "`%s' (-%s) ermglicht es Vorsignale automatisch zu verwenden, fr effizientere Bahnhfe.")
SETTEXT(CFG_MOREVEHICLES, "`%s' (-%s) vergrert die mgliche Gesamtzahl aller Fahrzeuge auf das angegebene Vielfache von 850.  Bereich %ld..%ld.  Standard %ld.")
SETTEXT(CFG_MAMMOTHTRAINS, "`%s' (-%s) ermglicht Mammutzge mit bis zu 126 Wagons.")
SETTEXT(CFG_FULLLOADANY, "Mit `%s' (-%s) verlt ein Zug den Bahnhof wenn die erste Art Ladung voll ist.")
SETTEXT(CFG_SELECTGOODS, "Mit `%s' (-%s) erscheint eine Art Ladung erst dann am Bahnhof, wenn einmal ein entsprechender Zug eingefahren ist.")
SETTEXT(CFG_DEBTMAX, "`%s' (-%s) ermglicht es den maximalen Kredit aufzunehmen bzw. zurckzuzahlen, indem man 'Strg' drckt.")
SETTEXT(CFG_OFFICEFOOD, "Mit `%s' (-%s) akzeptieren Brotrme auch Essen (im tropischen bzw. arctischen Klima).")
SETTEXT(CFG_ENGINESPERSIST, "Mit `%s' (-%s) ist es mglich, alle Fahrzeuge zu kaufen die man im Besitz hat, auch veraltete.")
SETTEXT(CFG_CDPATH, "`%s' (ohne Schalter in der Befehlszeile) setzt den Pfad wo TTD nach der CD sucht.")
// Note- CFG_CDPATH has no command line switAch, so don't give %s!
SETTEXT(CFG_KEEPSMALLAP, "Mit `%s' (-%s) kann man immer kleine Flughfen bauen.")
SETTEXT(CFG_AIBOOST, "`%s' (-%s) erhht die KI Rekursion um diesen Betrag. Sollte nur um jeweils eins erhht werden oder der Computer wird sehr langsam.")
SETTEXT(CFG_LONGBRIDGES, "`%s' (-%s) ermglicht Brcken mit einer Lnge von bis zu 127 Quadraten.")
SETTEXT(CFG_DYNAMITE, "`%s' (-%s) ermglicht es, mehr Dinge zu entfernen, z.B. Straen in Stdten.")
SETTEXT(CFG_MULTIHEAD, "`%s' (%ld%s) erlaubt zustzliche Lokomotiven zu kaufen, mit 'Strg'.  Der Parameter ist die maximale Erhhung der Geschwindigkeit, in Prozent.  Bereich %ld, Standard %ld.")
SETTEXT(CFG_RVQUEUEING, "`%s' (-%s) lt LKWs und Busse an der Haltestelle warten bis ein Platz frei wird, statt umzudrehen.")
SETTEXT(CFG_LOWMEMORY, "`%s' (-%s) begrenzt den TTDPatch-Speicher auf 3.5MB, und reduziert die maximale Fahrzeuganzahl auf den Faktor 2.")
SETTEXT(CFG_GENERALFIXES, "`%s' (-%s) korrigiert mehrere kleinere Fehler in TTD, siehe die TTDPatch Anleitung was genau gendert wird.")
SETTEXT(CFG_MOREAIRPORTS, "`%s' (-%s) erlaubt mehr als zwei Flughfen pro Stadt.")
SETTEXT(CFG_BRIBE, "`%s' (-%s) erweitert das Stadtmen um eine Bestechungsoption.")
SETTEXT(CFG_PLANECRCTRL, "`%s' (-%s) ermglicht es einzustellen, wann Flugzeuge abstrzen knnen. Bitkodierter Wert, Standard 1.")
SETTEXT(CFG_SHOWSPEED, "`%s' (-%s) zeigt die aktuelle Geschwindigkeit eines Fahrzeugs im Fahrzeugfenster an.")
SETTEXT(CFG_AUTORENEW, "`%s' (-%s) erneuert Fahrzeuge die zu alt werden, zu der angegebenen Anzahl von Monaten vor (negativ) oder nach (positiv) der Lebensdauer.  Bereich %ld..%ld, Standard %ld.")
SETTEXT(CFG_CHEATSCOST, "Mit `%s' (-%s) kosten manche der Schildercheats wie RENEW und TRACKS soviel Geld wie sie verbrauchen.")
SETTEXT(CFG_EXTPRESIGNALS, "`%s' (-%s) ermglicht erweiterte Vorsignale, indem jedes Signals mittels der 'Strg' Taste zwischen Vorsignal, -Ausfahrt und kombinierten Signalen umstellen kann.")
SETTEXT(CFG_FORCEREBUILDOVL, "`%s' (-%s) lt TTDPatch bei jedem Start die Datei TTDLOAD.OVL oder TTDLOADW.OVL komplett neu erstellen.")
SETTEXT(CFG_DISKMENU, "`%s' (-%s) erweitert das Diskettenmen um eine Ladeoption, und den Szenarieneditor um eine Speicheroption (mit 'Strg').")
SETTEXT(CFG_WIN2K, "`%s' (-%s) aktiviert die Windows 2000/XP Kompatibilittspatches.")
SETTEXT(CFG_FEEDERSERVICE, "`%s' (-%s) ermglicht Zubringerdienste mithilfe der \"Entladen\" Anweisung.")
SETTEXT(CFG_GOTODEPOT, "`%s' (-%s) ermglicht es, Fahrzeuge zu bestimmten Depots zu schicken")
SETTEXT(CFG_SUBSIDIARIES, "`%s' (-%s) ermglicht es andere Firmen zu verwalten von denen man 75%% der Anteile besitzt.")
SETTEXT(CFG_GRADUALLOADING, "`%s' (-%s) ndert den Ladevorgang so da Fahrzeuge nicht pltzlich sondern stetig beladen werden (aktiviert `loadtime' ebenfalls).")
SETTEXT(CFG_MOVEERRORPOPUP, "`%s' (-%s) verschiebt alle roten Fehler-Fenster in die rechte obere Ecke des Bildschirms.")
SETTEXT(CFG_GOTODEPOT, "`%s' (-%s) ermglicht es, Depots, Werften und Hangare als Fahrzeugbefehle anzugeben.")
SETTEXT(CFG_NEWSHIPS, "`%s' (-%s) ermglicht neue Schiffe mit neuen Grafiken.")
SETTEXT(CFG_SUBSIDIARIES, "`%s' (-%s) ermglichst es Firmen zu verwalten, von denen man 75%% der Anteile besitzt.")
SETTEXT(CFG_GRADUALLOADING, "`%s' (-%s) verndert den Be- und Entladevorgang so da nur jeweils 5-10 Frachteinheiten pro Fahrzeug gleichzeitig be- oder entladen werden (aktiviert automatisch auch `loadtime').")
SETTEXT(CFG_MOVEERRORPOPUP, "`%s' (-%s) verschiebt die roten Fehlermeldungen in eine Ecke des Bildschirms, wo sie nicht stren.")
SETTEXT(CFG_SIGNAL1WAITTIME, "`%s' (-%s) ndert die Anzahl der Tage, die ein Zug an einem roten Einwegsignal wartet.  Bereich 0..254, oder 255 um ewig zu warten.")
SETTEXT(CFG_SIGNAL2WAITTIME, "`%s' (-%s) ndert die Anzahl der Tage, die ein Zug an einem roten Zweiwegsignal wartet.  Bereich 0..254, oder 255 um ewig zu warten.")
SETTEXT(CFG_DISASTERS, "`%s' (-%s) ermglicht die Wahl, welche Katastrophen passieren knnen.  Bitkodierter Wert, Standard 255 (alle Katastrophen).")
SETTEXT(CFG_FORCEAUTORENEW, "`%s' (-%s) erzwingt die sofortige Erneuerung von alten Fahrzeugen, nicht erst wenn die nchste Wartung fllig ist.")
SETTEXT(CFG_MORENEWS, "`%s' (-%s) erzeugt Nachrichten fr zustzliche Ereignisse.  Bitte lesen Sie das Handbuch fr genaue Informationen.")
SETTEXT(CFG_UNIFIEDMAGLEV, "`%s' (-%s) ermglicht den Kauf von Schwebebahnfahrzeugen in Einschienenbahndepots und umgekehrt.  Einstellung 1: Alle Fahrzeuge auf Einschienenbahn umstellen, 2: Alle auf Schwebebahn umstellen, 3: Sowohl Einschienenbahn als auch Schwebebahn beibehalten.  Standard: 3.")
SETTEXT(CFG_BRIDGESPEEDS, "`%s' (-%s) ndert die Geschwindigkeitsbegrenzung auf Brcken von Einschienen- und Schwebebahn auf soviel Prozent des jeweils schnellsten Fahrzeugs.  Bereich %ld..%ld.  Standard %ld.")
SETTEXT(CFG_ETERNALGAME, "`%s' (-%s) ermglicht das ewige Spiel, das Datum wird nach 2070 nicht zurckgesetzt")
SETTEXT(CFG_SHOWFULLDATE, "`%s' (-%s) zeigt immer das volle Datum in der Statuszeile an, nicht nur im Pausenmodus.")
SETTEXT(CFG_NEWTRAINS, "`%s' (-%s) ermglicht neue Zugmodelle mit neuen Grafiken.")
SETTEXT(CFG_NEWRVS, "`%s' (-%s) ermglicht neue Straenfahrzeugmodelle mit neuen Grafiken.")
SETTEXT(CFG_NEWPLANES, "`%s' (-%s) ermglicht neue Flugzeugmodelle mit neuen Grafiken.")
SETTEXT(CFG_SIGNALSONTRAFFICSIDE, "`%s' (-%s) zeigt Eisenbahnsignale auf der Seite des Straenverkehrs an.")
SETTEXT(CFG_ELECTRIFIEDRAIL, "`%s' (-%s) ersetzt entweder Einschienen- oder Schwebebahn durch Eisenbahn mit Oberleitung.")
SETTEXT(CFG_STARTYEAR, "`%s' (-%s) setzt das Startjahr fr neue Spiele, und erlaubt eine grere Auswahl an Jahren im Szenarieneditor.  Bereich %ld..%ld.  Standard %ld.")
SETTEXT(CFG_ERRORPOPUPTIME, "`%s' (-%s) setzt die Zeit, wie lange rote Fehlerfenster angezeigt werden, in Sekunden.  Bereich 1..255 oder 0 fr eine sehr lange Zeit.  Standard 10.")
SETTEXT(CFG_TOWNGROWTHLIMIT, "`%s' (-%s) ndert die maximale Ausdehnung von Stdten.  Bereich %ld..%ld.  Standard %ld.")
SETTEXT(CFG_LARGERTOWNS, "`%s' (-%s) lt je eine aus sovielen Stdten schneller und grer wachsen.  Bereich %ld..%ld.  Standard %ld (one out of four towns).")
SETTEXT(CFG_MISCMODS, "`%s' (-%s) ermglicht es, die Arbeitsweise bestimmter Features zu verndern.  Bitkodierter Wert. Standard 0 (keine nderungen).")
SETTEXT(CFG_LOADALLGRAPHICS, "`%s' (-%s) bindet alle neuen Grafiken in bestehende Spiele ein, egal ob sie frher in Verwendung waren oder nicht.")
SETTEXT(CFG_SAVEOPTDATA, "`%s' (-%s) speichert und ldt zustzliche (nicht unbedingt bentigte, aber ntzliche) Daten ber den Spielstand.")
SETTEXT(CFG_MOREBUILDOPTIONS, "`%s' (-%s) ermglicht zustzliche Baumglichkeiten. Bitkodierter Wert, Bereich %ld..%ld. Standard %ld.")
SETTEXT(CFG_SEMAPHORES, "`%s' (-%s) verwendet Formsignale vor 1975 und Lichtsignale danach (oder umgekehrt mit Strg).")
SETTEXT(CFG_MOREHOTKEYS, "`%s' (-%s) aktiviert zustzliche Tastaturbelegungen.")
SETTEXT(CFG_MANYTREES, "`%s' (-%s) ermglicht es, Bume in einem gren Quadrat zu pflanzen (mit Strg), sowie zustzliche Bume einem Feld hinzuzufgen.")
SETTEXT(CFG_MORECURRENCIES,"`%s' (-%s) aktiviert zustzliche Whrungen und den Euro.  Parameter 0: Whrungssymbole am blichen Platz, oder 1: immer vor der Zahl, oder 2: immer nach der Zahl.  Addition von 4 deaktiviert den Euro.")
SETTEXT(CFG_MANCONVERT,"`%s' (-%s) ermglicht den Umbau von Schienen auf einen anderen Typ indem man sie einfach berbaut.")
SETTEXT(CFG_NEWAGERATING, "`%s' (-%s) macht Bahnhofsbewertungen toleranter gegenber dem Alter von Waggons, die nun bis zu 21 statt nur 3 Jahre alt sein drfen.")
SETTEXT(CFG_ENHANCEGUI,"`%s' (-%s) aktiviert Verbesserungen der Benutzeroberflche.  Bitkodierter Wert.  Bereich %ld..%ld.  Standard %ld.")
SETTEXT(CFG_TOWNGROWTHRATEMODE, "`%s' (-%s) whlt die Art der Berechnung von Stadtwachstum.  Modus 0: Standard von TTD, 1: TTD modifiziert, 2: komplett angepat.")
SETTEXT(CFG_TOWNGROWTHRATEMIN, "`%s' (ohne Schalter in der Befehlszeile) setzt die minimale Wachstumsrate von Stdten, in Husern pro Jahrhundert.  Nur aktiv wenn `towngrowthratemode' auf 2 gesetzt ist.  Bereich %ld..%ld.  Standard %ld.")
SETTEXT(CFG_TOWNGROWTHRATEMAX, "`%s' (ohne Schalter in der Befehlszeile) setzt die maximale Wachstumsrate von Stdten, in Husern pro Jahrhundert.  Nur aktiv wenn `towngrowthratemode' auf 2 gesetzt ist.  Bereich %ld..%ld.  Standard %ld.")
SETTEXT(CFG_TGRACTSTATIONEXIST, "`%s' (ohne Schalter in der Befehlszeile) definiert wie sehr aktive Bahnhfe das Stadtwachstum beeinflussen.  Nur aktiv wenn `towngrowthratemode' auf 2 gesetzt ist.  Bereich %ld..%ld.  Standard %ld.")
SETTEXT(CFG_TGRACTSTATIONS, "`%s' (ohne Schalter in der Befehlszeile) definiert wie sehr jeder einzelne aktive Bahnhof das Stadtwachstum erhht.  Nur aktiv wenn `towngrowthratemode' auf 2 gesetzt ist.  Bereich %ld..%ld.  Standard %ld.")
SETTEXT(CFG_TGRACTSTATIONSWEIGHT, "`%s' (ohne Schalter in der Befehlszeile) definiert wie effektiv aktive Bahnhfe zum Stadtwachstum beitragen.  Nur aktiv wenn `towngrowthratemode' auf 2 gesetzt ist.  Bereich %ld..%ld.  Standard %ld.")
SETTEXT(CFG_TGRPASSOUTWEIGHT, "`%s' (ohne Schalter in der Befehlszeile) definiert wie effektiv der Abtransport von Passagieren zum Stadtwachstum beitrgt.  Nur aktiv wenn `towngrowthratemode' auf 2 gesetzt ist.  Bereich %ld..%ld.  Standard %ld.")
SETTEXT(CFG_TGRMAILOUTWEIGHT, "`%s' (ohne Schalter in der Befehlszeile) definiert wie effektiv der Abtransport von Post zum Stadtwachstum beitrgt.  Nur aktiv wenn `towngrowthratemode' auf 2 gesetzt ist.  Bereich %ld..%ld.  Standard %ld.")
SETTEXT(CFG_TGRPASSINMAX, "`%s' (ohne Schalter in der Befehlszeile) definiert die maximale Anzahl von ankommenden Passagieren, die zum Stadtwachstum beintragen.  Nur aktiv wenn `towngrowthratemode' auf 2 gesetzt ist.  Bereich %ld..%ld.  Standard %ld.")
SETTEXT(CFG_TGRPASSINWEIGHT, "`%s' (ohne Schalter in der Befehlszeile) definiert wie effektiv ankommende Passagiere zum Stadtwachstum beitragen.  Nur aktiv wenn `towngrowthratemode' auf 2 gesetzt ist.  Bereich %ld..%ld.  Standard %ld.")
SETTEXT(CFG_TGRMAILINOPTIM, "`%s' (ohne Schalter in der Befehlszeile) definiert die optimale Bevlkerung pro 2 angelieferte Postscke.  Nur aktiv wenn `towngrowthratemode' auf 2 gesetzt ist.  Bereich %ld..%ld.  Standard %ld.")
SETTEXT(CFG_TGRMAILINWEIGHT, "`%s' (ohne Schalter in der Befehlszeile) definiert wie effektiv angelieferte Post zum Stadtwachstum beitrgt.  Nur aktiv wenn `towngrowthratemode' auf 2 gesetzt ist.  Bereich %ld..%ld.  Standard %ld.")
SETTEXT(CFG_TGRGOODSINOPTIM, "`%s' (ohne Schalter in der Befehlszeile) definiert die optimale Bevlkerung pro 2 angelieferte Gterkisten.  Nur aktiv wenn `towngrowthratemode' auf 2 gesetzt ist.  Bereich %ld..%ld.  Standard %ld.")
SETTEXT(CFG_TGRGOODSINWEIGHT, "`%s' (ohne Schalter in der Befehlszeile) definiert wie effektiv angelieferte Gter zum Stadtwachstum beitragen.  Nur aktiv wenn `towngrowthratemode' auf 2 gesetzt ist.  Bereich %ld..%ld.  Standard %ld.")
SETTEXT(CFG_TGRFOODINMIN, "`%s' (ohne Schalter in der Befehlszeile) definiert die minimale Essensversorgung fr Wachstum von Stdten in Schnee- oder Wstengebieten, in Bevlkerung je 2 Tonnen angelieferten Essens.  Nur aktiv wenn `towngrowthratemode' auf 2 gesetzt ist.  Bereich %ld..%ld.  Standard %ld.")
SETTEXT(CFG_TGRFOODINOPTIM, "`%s' (ohne Schalter in der Befehlszeile) definiert die optimale Bevlkerung pro 2 Tonnen angeliefertem Essen.  Nur aktiv wenn `towngrowthratemode' auf 2 gesetzt ist.  Bereich %ld..%ld.  Standard %ld.")
SETTEXT(CFG_TGRFOODINWEIGHT, "`%s' (ohne Schalter in der Befehlszeile) definiert wie effektiv angeliefertes Essen zum Stadtwachstum beitrgt.  Nur aktiv wenn `towngrowthratemode' auf 2 gesetzt ist.  Bereich %ld..%ld.  Standard %ld.")
SETTEXT(CFG_TGRWATERINMIN, "`%s' (ohne Schalter in der Befehlszeile) definiert die minimale Wasserversorgung fr Wachstum von Stdten in Wstengebieten, in Bevlkerung je 2 Tonnen (2000 Liter) angelieferten Wassers.  Nur aktiv wenn `towngrowthratemode' auf 2 gesetzt ist.  Bereich %ld..%ld.  Standard %ld.")
SETTEXT(CFG_TGRWATERINOPTIM, "`%s' (ohne Schalter in der Befehlszeile) definiert die optimale Bevlkerung pro 2 Tonnen (2000 Liter) angeliefertem Wasser.  Nur aktiv wenn `towngrowthratemode' auf 2 gesetzt ist.  Bereich %ld..%ld.  Standard %ld.")
SETTEXT(CFG_TGRWATERINWEIGHT, "`%s' (ohne Schalter in der Befehlszeile) definiert wie effektiv angeliefertes Wasser zum Stadtwachstum beitrgt.  Nur aktiv wenn `towngrowthratemode' auf 2 gesetzt ist.  Bereich %ld..%ld.  Standard %ld.")
SETTEXT(CFG_TGRSWEETSINOPTIM, "`%s' (ohne Schalter in der Befehlszeile) definiert die optimale Bevlkerung pro 2 Scke Bonbons im Toyland-Klima.  Nur aktiv wenn `towngrowthratemode' auf 2 gesetzt ist.  Bereich %ld..%ld.  Standard %ld.")
SETTEXT(CFG_TGRSWEETSINWEIGHT, "`%s' (ohne Schalter in der Befehlszeile) definiert wie effektiv angelieferte Bonbons zum Stadtwachstum beitragen.  Nur aktiv wenn `towngrowthratemode' auf 2 gesetzt ist.  Bereich %ld..%ld.  Standard %ld.")
SETTEXT(CFG_TGRFIZZYDRINKSINOPTIM, "`%s' (ohne Schalter in der Befehlszeile) definiert die optimale Bevlkerung pro 2 Limonaden im Toyland-Klima.  Nur aktiv wenn `towngrowthratemode' auf 2 gesetzt ist.  Bereich %ld..%ld.  Standard %ld.")
SETTEXT(CFG_TGRFIZZYDRINKSINWEIGHT, "`%s' (ohne Schalter in der Befehlszeile) definiert wie effektiv angelieferte Limonade zum Stadtwachstum beitrgt.  Nur aktiv wenn `towngrowthratemode' auf 2 gesetzt ist.  Bereich %ld..%ld.  Standard %ld.")
SETTEXT(CFG_TGRTOWNSIZEBASE, "`%s' (ohne Schalter in der Befehlszeile) definiert die Basisanzahl von Gebuden fr die Berechnung bezglich `tgrtownsizefactor'.  Nur aktiv wenn `towngrowthratemode' auf 2 gesetzt ist.  Bereich %ld..%ld.  Standard %ld.")
SETTEXT(CFG_TGRTOWNSIZEFACTOR, "`%s' (ohne Schalter in der Befehlszeile) definiert wie sehr die Stadtgre das Stadtwachstum beeinflut.  Nur aktiv wenn `towngrowthratemode' auf 2 gesetzt ist.  Bereich %ld..%ld.  Standard %ld (i.e. 25%% influence).")
SETTEXT(CFG_TOWNMINPOPULATIONSNOW, "`%s' (ohne Schalter in der Befehlszeile) definiert die maximale Bevlkerung, bis zu welcher Stdte im Schnee auch ohne Essen wachsen knnen.  Aktiv wenn entweder `towngrowthratemode', `towngrowthlimit' oder `generalfixes' an sind.  Bereich %ld..%ld.  Standard %ld.")
SETTEXT(CFG_TOWNMINPOPULATIONDESERT, "`%s' (ohne Schalter in der Befehlszeile) definiert die maximale Bevlkerung, bis zu welcher Stdte in der Wste auch ohne Essen und Wasser wachsen knnen.  Aktiv wenn entweder `towngrowthratemode', `towngrowthlimit' oder `generalfixes' an sind.  Bereich %ld..%ld.  Standard %ld.")
SETTEXT(CFG_MORETOWNSTATS, "`%s' (-%s) aktiviert zustzliche Statistiken im Stadtfenster.")
SETTEXT(CFG_BUILDONSLOPES, "`%s' (-%s) ermglicht den Bau von Schienen, Straen, Bahnhfen und Depots quer zur Steigung, auf Fundamenten wie fr Huser.")
SETTEXT(CFG_BUILDONCOASTS, "`%s' (-%s) ermglicht es direkt auf Kstenfelder und an Flssen zu bauen, ohne erst das Wasser zu entfernen.")
SETTEXT(CFG_TRACKTYPECOSTDIFF, "`%s' (-%s) gibt jedem der drei Schienenarten unterschiedliche Baukosten.")
SETTEXT(CFG_EXPERIMENTALFEATURES, "`%s' (-%s) aktiviert die neuesten experimentellen Features.")
SETTEXT(CFG_PLANESPEED, "`%s' (-%s) lt Flugzeuge sich mit der angegeben Geschwindigkeit fortbewegen, statt einem Viertel davon.  Ebenso wird die Geschwindigkeit bei Pannen auf 5/8 reduziert.")
SETTEXT(CFG_FASTWAGONSELL, "`%s' (-%s) ermglicht den Verkauf von vielen Waggons auf einmal mittel Strg.")
SETTEXT(CFG_NEWRVCRASH,"`%s' (-%s) ndert was bei einer Zug-Straenfahrzeug-Kollision passiert.  Bei Auswahl %ld hat der Zug eine Panne.  Bei Auswahl %ld sind Kollisionen vllig deaktiviert.  Standard: %ld.");
SETTEXT(CFG_STABLEINDUSTRY,"`%s' (-%s) verhindert die Schlieung von Industrien wenn die Wirtschaft auf ruhig gestellt ist in den Schwierigkeitseinstellungen.")


//----------------------------------------------------
//   SWITCH DISPLAY ('-v')
//----------------------------------------------------

// Wait for a key before displaying the switches
SETTEXT(LANG_SWWAITFORKEY, "\nDrcken Sie Enter um TTD zu starten, Escape um abzubrechen oder eine andere\nTaste um die Einstellungen anzusehen.")

// Introduction
SETTEXT(LANG_SHOWSWITCHINTRO, "\n"
	  "\n"
	  "    Aktivierte Schalter:   (%c aktiviert, %c deaktiviert)\n")

// Five characters: vertical line for the table; enabled switch; disabled switch;
// table heading; table heading column separator.
SETTEXT(LANG_SWTABLEVERCHAR, "*")

// 1-way and 2-way captions after "New train wait time on red signals"
SETTEXT(LANG_SWONEWAY, "Einweg: ")
SETTEXT(LANG_SWTWOWAY, "Zweiweg: ")

// Train wait time is either in days or infinite
SETTEXT(LANG_TIMEDAYS, "%d Tag(e)")
SETTEXT(LANG_INFINITETIME, "ewig")

// Shows the load options for ttdload.  %s is the given parameters to be passed to ttdload
SETTEXT(LANG_SWSHOWLOAD, "Drcken Sie eine Taste um \"TTDLOAD %s\" zu starten, oder Esc um abzubrechen.")


SETTEXT(LANG_SWABORTLOAD, "\nProgrammstart abgebrochen.\n")


//---------------------------------------
//  STARTUP AND REPORTING
//---------------------------------------

// Internal error in TTDPatch (%d is error number)
SETTEXT(LANG_INTERNALERROR, "*** Interner TTDPatch-Fehler #%d ***\n")

// Error fixing the Windows version HDPath registry entry
SETTEXT(LANG_REGISTRYERROR, "TTD wurde nicht korrekt installiert (Registry-Fehler %d)\n")

// DOS reports no memory available
SETTEXT(LANG_NOTENOUGHMEM, "Nicht genug Speicher verfgbar %s, brauche %d KB zustzlich.\n")

// ...for starting TTD
SETTEXT(LANG_TOSTARTTTD, "um TTD zu starten")

// Protected mode code exceeds 32kb
SETTEXT(LANG_PROTECTEDTOOLARGE, "Der Protected Mode Code ist zu gro!\n")

// Swapping TTDPatch out
SETTEXT(LANG_SWAPPING, "Gebe Speicher frei.\n")

// Just before running ttdload, show this.
// 1st %s is ttdload.ovl, then %s is a space if there are options,
// and the 2nd %s contains the options
SETTEXT(LANG_RUNTTDLOAD, "Starte %s%s%s\n")

// Error executing ttdload.  1st %s is ttdload.ovl, 2nd %s is the error message from the OS
SETTEXT(LANG_RUNERROR, "Konnte %s nicht ausfhren: %s\n")

// Show the result after after running, %s is one of the following strings
SETTEXT(LANG_RUNRESULT, "Ergebnis: [%s]\n")
SETTEXT(LANG_RUNRESULTOK, "In Ordnung")
SETTEXT(LANG_RUNRESULTERROR, "Fehler!")

// Messages about the graphics file ttdpatch.grf
SETTEXT(LANG_NOTTDPATCHGRF, "Konnte die Patch-Grafikdatei %s nicht finden, erzeuge eine leere Datei.\n")
SETTEXT(LANG_ERRORCREATING, "Konnte %s nicht erstellen: %s\n")

