//
//	Catches a GPF, and generates a useful error message
//	in CRASH###.TXT
//



#if WINTTDX
uvard prevexceptionhandler
uvard isbadreadptr

win2kexceptionhandler:
	push ebp
	mov ebp,esp

	pusha
	push es
	push ebp
	push ds
	cld

	mov esi,[ebp+8]
	mov eax,[esi]
	mov ebp,[esi+4]
	add ebp,0x7c

	%define .gs [ebp+0x10]
	%define .fs [ebp+0x14]
	%define .es [ebp+0x18]
	%define .ds [ebp+0x1c]
	%define .edi [ebp+0x20]
	%define .esi [ebp+0x24]
	%define .ebx [ebp+0x28]
	%define .edx [ebp+0x2c]
	%define .ecx [ebp+0x30]
	%define .eax [ebp+0x34]
	%define .ebp [ebp+0x38]
	%define .eip [ebp+0x3c]
	%define .cs [ebp+0x40]
	%define .flags [ebp+0x44]
	%define .esp [ebp+0x48]
	%define .ss [ebp+0x4c]

	push dword .flags
	push dword .ss
	push dword .gs
	push dword .fs
	push dword .es
	push dword .ds
	push dword .ebp
	push dword .esp
	push dword .edi
	push dword .esi
	push dword .edx
	push dword .ecx
	push dword .ebx
	push dword .eax
	push dword [eax]	// exception code


#else
	// address of the original code
	uvard gpfhookaddr, 2	// offset,segment

catchgpf:

	// we don't want to touch the divide by zero exception,
	// that one's handled properly anyway.
	cmp dword [esp+0x10],byte 0
	jne short .good

.stop:
	mov ds,[esp+4]	// previous code seg

	mov ds,[word 0x2f6e]	// replaced by this call
	mov [word 0x17e8],eax
	iret


.good:

	// the stack structure is like this: (at least on Win98)
	// (counted from EBP as saved later on by the enter instruction)
	// +34	faultss
	// +30	faultesp	esp and ss when the fault occured
	// +2c	faultflags
	// +28	faultcs
	// +24	faulteip	flags, cs, and eip at the fault location
	// +20	??
	// +1c	lidtcs
	// +18	lidteip		a call gate to somewhere?
	// +14  fault
	// +10	ds		ds as saved by the DOS extender fault handler
	// +0c	flags
	// +08	cs
	// +04	eip		flags, cs and eip of the DOS extender fault handler
	// +00	faultebp	(isn't modified yet)

	%define .flags [ebp+0x2c]
	%define .ss [ebp+0x34]
	%define .ebp [ebp]
	%define .esp [ebp+0x30]
	%define .eip [ebp+0x24]
	%define .cs [ebp+0x28]
	%define .ds [ebp+0x10]
	%define .exc [ebp+0x14]

	enter 0,0	// save ebp and setup temp. stack frame

	pusha
	push es

	push ds		// save it for later
	cld

	// -----------------------
	//	Prepare data
	// -----------------------


	// Store the value of every register at the time the crash
	// occurred.  Store them on the stack, in the order that they're
	// going to get printed out.
	push dword .flags
	push dword .ss
	push gs
	push fs
	push es
	push dword .ds
	push dword .ebp
	push dword .esp
	push edi
	push esi
	push edx
	push ecx
	push ebx
	push eax

	// Restore the original GPF handler code
	// so that our code is never used again

	verw word [gpfhookaddr+4]
	jnz short .cantrestorehandler
	les edi,[gpfhookaddr]
	mov esi,originalgpfcode
	mov ecx,11
	rep movsb

.cantrestorehandler:
#endif


	sti

	// -----------------------
	// 	Print data
	// -----------------------

	// Now we print the data into the template, and then
	// pop the printed data off the stack

	mov esi,currentversion+version.size
	push ds
	pop es
	mov edi,gpfttdv	// Store TTD version (.EXE file size)
	mov ebx,1
	call hexdwords

	mov edi,gpferr	// Store exception code
#if WINTTDX
	pop eax		// exception code
	mov cl,8
#else
	mov eax,.exc
	mov cl,2
#endif
	call hexnibbles

	lea esi,.eip
	push ss
	pop ds
	mov edi,gpfeip	// Store fault location, CS:EIP
	mov bl,1
	call hexdwords

	sub edi,byte 15	// to gpfcs
	mov bl,1
	call hexwords

	mov esi,esp
	mov edi,gpfeax	// Store EAX, EBX, ECX, EDX
	mov bl,4
	call hexdwords

	mov edi,gpfesi	// Store ESI, EDI, ESP, EBP
	mov bl,4
	call hexdwords

	mov edi,gpfds	// Store DS, ES, FS, GS, SS
	mov bl,5
	call hexwords

	mov bl,1
	call hexdwords			// Store EFLAGS

	lea esi,[esp+8*4]
	mov edi,gpflim
	mov bl,5
	call seglimits

	lea esi,[esp+8*4]
	mov edi,gpfar
	mov bl,5
	call segrights

	add esp,byte 14*4			// remove values from stack

	// See if we can access the segment at the original CS, so
	// that we can record the code at CS:EIP

	verr word .cs
	jnz short .nocode
	mov edi,gpfcode
	mov bl,16
	mov ds,.cs
	mov esi,.eip
	call hexbytes

.nocode:
	// Same as above but now the stack at the original SS:ESP

	verr word .ss
	jnz short .nostack
	mov edi,gpfstk
	mov bl,8*4
	mov ds,.ss
	mov esi,.esp
	call hexdwords

.nostack:
	// And finally our own stack, as provided by the OS and the
	// DOS Extender, so that we might figure out why some crashes
	// don't show useful values

	// First store our stack's location

	push ss
	push ss
	pop ds
	push ebp
	mov esi,esp
	mov edi,gpfhesp
	mov bl,1
	call hexdwords

	sub edi,byte 15	// to gpfhss
	mov bl,1
	call hexwords

	add esp,byte 2*4

	// Now dump our stack

	mov edi,gpfhstk
	mov bl,8*4
	mov esi,ebp
	call hexdwords

	pop ds

	// ------------------------
	//     Write to file
	// ------------------------

	// Now we write the output to a CRASH###.TXT file, the first one
	// that doesn't exist
	//

	mov eax,"000."

.openagain:

	mov dword [gpffno],eax

#if WINTTDX
	// unfortunately TTDWin doesn't support int 21/ah=5b
	push 0			// hTemplateFile
	push 128		// dwFlagsandAttributes = FILE_ATTRIBUTE_NORMAL
	push 1			// dwCreationDisposition = CREATE_NEW (fail if it exists)
	push 0			// lpSecurityAttributes
	push 0			// dwShareMode
	push 0x40000000		// dwDesiredAccess = GENERIC_WRITE
	push gpffile		// lpFilename
	call [0x4233b8]		// CreateFile()
	test eax,eax
	jns .isopen
#else
	mov ah,0x5b
	xor ecx,ecx
	mov edx,gpffile
	CALLINT21		// create new file
	jnc short .isopen
#endif

	mov eax,dword [gpffno]

	add eax,0x10000
	cmp eax,("9." << 16) + 0xffff	// allow crash009.txt too
	jbe .openagain

	sub eax,10 << 16
	inc ah
	cmp ah,"9"
	jbe .openagain

	mov ah,"0"
	inc al
	cmp al,"9"
	jbe .openagain
	jmp short .bailout

.isopen:
#if WINTTDX
	push eax

	push 0				// lpOverlapped
	push tempvar			// lpBytesWritten
	push gpfdumpend - gpftext	// nBytestoWrite
	push gpftext			// lpBuffer
	push eax			// hFile
	call [0x4233c0]			// WriteFile()

					// eax=hFile still on stack
	call [0x4233bc]			// CloseHandle()
#else
	push eax
	mov bx,ax

	mov ah,0x40
	mov ecx,gpfdumpend - gpftext
	mov edx,gpftext
	CALLINT21		// write to file

	mov ah,0x3e
	pop ebx
	CALLINT21		// close file
#endif

.bailout:

	// --------------------------
	//	Done, return.
	// --------------------------

	// Restore all registers before returning to the original handler

#if WINTTDX
	pop ebp
#endif

	pop es
	popa

	leave

#if WINTTDX
	jmp dword [prevexceptionhandler]

noprevexceptionhandler:
	xor eax,eax	// EXCEPTION_CONTINUE_SEARCH
	ret
#else
	jmp .stop
#endif
; endp catchgpf

	// make sure we don't accidentally cause a GPF ourselves!
	// Check the segment limit, and reduce the number of output
	// values if necessary

checkbounds:
#if WINTTDX
	pusha

	shl ebx,cl
.tryagain:
	push ebx

	push ebx	// number of bytes
	push esi	// pointer
	call [isbadreadptr]
	pop ebx
	test eax,eax
	jz .canreadall

	sub ebx,4
	jnc .tryagain

.badreg:
	popa
	pop eax
	ret

.canreadall:
	popa
	ret
#else
	mov eax,ds
	lsl eax,eax
	jnz short .badreg	// bail if no access rights

	inc eax		// we *can* read the very last byte

	// calculate maximum ebx from the segment limit
	sub eax,esi
	jb short .badreg

	shr eax,cl
	jz short .badreg	// bail if zero values available

	cmp ebx,eax	// is ebx within that limit?
	jna short .goodofs

	mov ebx,eax

.goodofs:
	ret

.badreg:
	// can't get any useful bytes out of this, so bail.
	pop eax		// clear caller eip from stack
	ret		// and return to caller's caller
#endif
; endp checkbounds

	// print the num least significant hexnibbles of the value in eax
	// in:	eax=value to print
	//	cl=number of digits to print
	// modifies edi
	// destroys eax,ecx,edx
hexnibbles:

	xchg edx,eax
	xor eax,eax

	mov al,cl

	// number of bits to skip = (8-@@num)*4
	mov cl,8
	sub cl,al
	shl cl,2

	rol edx,cl	// skip the digits that aren't to be printed
	mov ecx,eax
.nextdigit:
	rol edx,4
	mov al,dl
	and al,0xf
	mov al,[cs:hexdigits+eax]
	stosb
	loop .nextdigit

	ret
; endp hexnibbles 

	// print ebx byte values from ds:esi
hexbytes:
	mov cl,0
	call checkbounds
.nextbyte:
	lodsb
	mov cl,2
	call hexnibbles
	inc edi
	dec ebx
	jnz .nextbyte
	ret
; endp hexbytes 

	// print ebx word values from ds:esi, advancing esi by four each time
hexwords:
	mov cl,2
	call checkbounds
.nextword:
	lodsd		// on the stack it's all dwords
	mov cl,4	// but only print a word
	call hexnibbles
	add edi,byte 2+4
	dec ebx
	jnz .nextword
	ret
; endp hexwords 

	// print ebx dword values from ds:esi
hexdwords:
	mov cl,2
	call checkbounds
.nextdword:
	lodsd
	mov cl,8
	call hexnibbles
	add edi,byte 2
	dec ebx
	jnz .nextdword
	ret
; endp hexdwords 

	// print segment limits
seglimits:
	mov cl,2
	call checkbounds
.nextdword:
	lodsd
	lsl eax,eax
	jnz short .notvalid

	mov cl,8
	call hexnibbles
	sub edi,8

.notvalid:
	add edi,10
	dec ebx
	jnz .nextdword
	ret
; endp seglimits

	// print segment access rights
segrights:
	mov cl,2
	call checkbounds
.nextdword:
	lodsd
	lar eax,eax
	jnz short .notvalid

	mov cl,8
	call hexnibbles
	sub edi,8

.notvalid:
	add edi,10
	dec ebx
	jnz .nextdword
	ret
; endp segrights 


// the original handler's code
var originalgpfcode
	mov ds,[cs:dword 0x2f6e]
	mov [word 0x17e8],eax


var gpffile,	db "CRASH"
var gpffno,	db "###.TXT",0

// The output template

var gpftext,	db "TTD V"
var gpfttdv,	db      "######## Crash Log by"
var ttdpatchversion, db			     " TTDPatch ",TTDPATCHVERSION,13,10,13,10

		db "Exception "
#if WINTTDX
var gpferr,	db 	     "######## at "
#else
var gpferr,	db 	     "## at "
#endif
var gpfcs,	db		   "####:"
var gpfeip,	db			"########",13,10,13,10

		db "EAX       EBX       ECX       EDX",13,10
var gpfeax,	db "########  ########  ########  ########",13,10,13,10

		db "ESI       EDI       ESP       EBP",13,10
var gpfesi,	db "########  ########  ########  ########",13,10,13,10

		db "DS        ES        FS        GS        SS        Flags",13,10
var gpfds,	db "####      ####      ####      ####      ####      ########",13,10
var gpflim,	db "########  ########  ########  ########  ######## (Segment limits)",13,10
var gpfar,	db "########  ########  ########  ########  ######## (Access rights)",13,10,13,10

		db "Bytes at CS:EIP",13,10
var gpfcode,	db "xx xx xx xx xx xx xx xx xx xx xx xx xx xx xx xx",13,10,13,10

		db "Stack Dump:",13,10
var gpfstk,	db "########  ########  ########  ########  ########  ########  ########  ########",13,10
		db "########  ########  ########  ########  ########  ########  ########  ########",13,10
		db "########  ########  ########  ########  ########  ########  ########  ########",13,10
		db "########  ########  ########  ########  ########  ########  ########  ########",13,10

		db 13,10,"Handler Stack Dump (at "
var gpfhss,	db				"####:"
var gpfhesp,	db				     "########):",13,10
var gpfhstk,	db "########  ########  ########  ########  ########  ########  ########  ########",13,10
		db "########  ########  ########  ########  ########  ########  ########  ########",13,10
		db "########  ########  ########  ########  ########  ########  ########  ########",13,10
		db "########  ########  ########  ########  ########  ########  ########  ########",13,10

var gpfdumpend

	// Define TTDPatch version as a DWORD
	// MMmrbbbb  MM=major  m=minor  r=revision  bbbb=build
var ttdpatchvercode
	dd (TTDPATCHVERSIONMAJOR<<24)+(TTDPATCHVERSIONMINOR<<20)+(TTDPATCHVERSIONREVISION<<16)+TTDPATCHVERSIONBUILD
