// Feeder service
// Forced unload on a station that accepts that type of cargo
// will leave the cargo at the station, not deliver it there

// called when deciding whether or not and how to unload
// in:	ebx=station
//	ecx=cargotype*8
//	esi=waggon
//	edi=engine
// out:	carry=regular unload
//	nc+zero=no unload
//	nc+nz=forced unload
// safe:eax edx

unloadaccepts:
	// did we unload already?
	test byte [edi+veh.modflags],1 << MOD_DIDUNLOAD
	jnz short .nounload

	cmp byte [numvehstillunloading],0
	jne .done

	push esi

	// clear that flag if not using gradualloading and there is no
	// more cargo in any waggons
	testflags gradualloading
	jc .nocargo

	mov esi,edi
	cmp word [esi+veh.currentload],0
	ja short .morecargo

.next:
	movzx esi,word [esi+veh.nextunitidx]
	cmp si,byte -1
	je short .nocargo
	shl esi,vehicleshift
	add esi,[veharrayptr]
	cmp word [esi+veh.currentload],byte 0
	ja short .morecargo
	jmp .next

.nocargo:
	pop esi
	or byte [edi+veh.modflags],1 << MOD_DIDUNLOAD
	jmp short .done

.morecargo:
	pop esi

.done:
	test byte [edi+veh.currorder],0x20	// forced unload?
	jz short .notforced

	push byte PL_ORG+PL_NOTTEMP
	call ishumanplayer
	jnz short .aiforcedunload


.forcedunload:
	// forced unload (no matter whether it accepts or not)
	clc
	or esi,esi	// clear zero flag
	ret

	// forced unload is used by the AI at every station
	// make it work like it used to before
.aiforcedunload:
	test byte [ebx+station.cargos+stationcargo.amount+1+ecx],0x80	// accepts?
	jz short .forcedunload		// standard forced unload if station doesn't accept
	// else fall through to regular unload

.notforced:
	test byte [ebx+station.cargos+stationcargo.amount+1+ecx],0x80	// accepts?
	jz short .dontunload

	// not forced, and accepts -> regular unload
	stc
	ret

	// not forced, doesn't accept -> no unload
.dontunload:
	dec byte [numvehstillunloading]

.nounload:
	clc
	test al,0	// set zero flag
	ret
; endp unloadaccepts

// called when a consist enters a new station
// need to remember so that we only try unloading once

checkunload:

enterstation:		// train, truck, bus
	mov word [esi+veh.currorder],3
	jmp short resetloadcycle

// same for planes
enterairport:
	mov al,byte [esi+veh.targetairport]
	mov byte [esi+veh.laststation],al
	jmp short resetloadcycle

// and ships
enterdock:
	mov ax,word [esi+veh.currorder]
	mov byte [esi+veh.laststation],ah
	// jmp short resetloadcycle

resetloadcycle:
	and byte [esi+veh.modflags],~ (1 << MOD_NOTDONEYET)

	// clear "did unload already" flag if we have something to unload
	or byte [esi+veh.modflags],1 << MOD_DIDUNLOAD

	push edi
	mov edi,esi

.next:
	cmp word [esi+veh.currentload],byte 0
	je short .noload

	and byte [edi+veh.modflags],~ (1 << MOD_DIDUNLOAD) 	// clear "did unload already" flag

.noload:

	// reset unload/load cycle for gradualloading
	or byte [esi+veh.modflags],1 << MOD_MORETOUNLOAD

	mov si,word [esi+veh.nextunitidx]
	cmp si,byte -1
	je short .done

	movzx esi,si
	shl esi,vehicleshift
	add esi,[veharrayptr]
	jmp .next

.done:
	mov esi,edi
	pop edi
	ret
; endp checkunload 


// calculate profit of a forced unload, add it to this consist
//
// in:	esi=waggon
//	edi=engine
forcedunloadprofit:
	test byte [esi+veh.modflags],1 << MOD_DIDCASHIN 	// did we do this already?
	jnz short .didpayalready

	push byte PL_ORG+PL_NOTTEMP
	call ishumanplayer
	jne short .done

	pusha
	mov al,byte [esi+veh.cargosource]
	mov ah,byte [edi+veh.laststation]	// current station actually
	mov bx,word [esi+veh.currentload]
	mov ch,byte [esi+veh.cargotype]
	mov dl,byte [esi+veh.cargotransittime]
	call transferprofit
	sub dword [edi+veh.profit],eax
	popa

	or byte [esi+veh.modflags],1 << MOD_DIDCASHIN

.didpayalready:
	cmp ax,word [esi+veh.currentload]
	jb short .done		// more cargo left

	and byte [esi+veh.modflags],~ (1 << MOD_DIDCASHIN)

.done:
	jmp forcedunload
; endp forcedunloadprofit 

// calculate profit when picking up cargo en-route, and subtract from this consist
//
// in:	esi=waggon
//	edi=engine
pickupcargo:
	cmp ax,dx
	jbe short .notall
	mov ax,dx
.notall:

	pusha
	mov bp,ax

	// was it en-route?
	mov al,byte [ecx+station.cargos+stationcargo.enroutefrom+ebx]
	mov ah,byte [edi+veh.laststation]	// current station actually

	cmp al,ah
	je short .done

	// is en-route
	mov dl,byte [ecx+station.cargos+stationcargo.enroutetime+ebx]
	mov bx,bp
	shl ecx,5	// ecx=cargotype*8 ==> ch=cargotype
	call transferprofit
	add dword [edi+veh.profit],eax

.done:
	popa
	ret
; endp pickupcargo 

// find out profit for cargo in transit
// (replicates a part of TTD's [acceptcargofn])
//
// in:	al, ah: source and destination stations
//	bx: amount
//	ch: cargo type
//	dl: time in transit
// out:	eax=profit (a negative number)
// preserves:esi,edi
transferprofit:
	// find out the distance between stations
	push ebx
	mov ebp,[stationarrayptr]
	movzx ebx,ah
	imul bx,station_size
	mov ebx,[ebx+ebp+station.XY]
	mov ah,station_size
	mul ah
	movzx eax,ax
	mov eax,[eax+ebp+station.XY]

	sub al,bl
	jnc .xpos
	neg al

.xpos:
	sub ah,bh
	jnc .ypos
	neg ah

.ypos:
	add al,ah
	mov ah,0		// doesn't touch flags
	adc ah,ah
	pop ebx

	// calculate the profit
	// split cargo in parts up to 255 units each for [calcprofitfn]
	xor ebp,ebp

.calcloop:
	mov cl,0xff
	cmp bx,0xff
	jae .haveamount
	mov cl,bl

.haveamount:
	sub bl,cl
	sbb bh,0

	pusha
	call [calcprofitfn]
	add [esp+8],eax		// add to EBP on stack
	popa

	or bx,bx
	jnz .calcloop

	xchg eax,ebp
	ret
; endp transferprofit 
