
// train "full" if any cargo type is full


	// this determines whether a train/plane is full when full load is set
	// in:   esi=engine
	// safe: eax,edi
	// out:  carry set=full, not set=not full
checkfull:
	push ebx
	push ecx

	xor ebx,ebx
	xor ecx,ecx

	mov edi,esi
.nextwaggon:
	mov ax,word [edi+veh.capacity]
	or ax,ax
	jz short .nocargo

	test byte [edi+veh.modflags],0	// set to "1 shl MOD_NOTDONEYET" if gradualloading activated
ovar fullloadtest,-1
	jnz short .notfull

	cmp ax,word [edi+veh.currentload]
	movzx eax,byte [edi+veh.cargotype]
	je short .isfull

	bts ecx,eax	// mark this cargo type as not full
.isfull:
	bts ebx,eax	// mark this cargo type as existing
.nocargo:
	movzx edi,word [edi+veh.nextunitidx]
	cmp di,byte -1
	je short .traindone
	shl edi,vehicleshift
//	add edi,index
	add edi,[veharrayptr]
	jmp .nextwaggon

.traindone:
	xor ebx,ecx	// clear those cargo types that aren't full
		// now ebx has a bit set for every type that is full
	jz short .notfull
	stc
	jmp short .exit
.notfull:
	clc
.exit:
	pop ecx
	pop ebx
	ret
; endp checkfull 

