//
// Allow adding depots/hangars/shipyards to vehicle orders
//

#define DEPOTORDER 0a2h		// 2 + 20 + 80
#define DEPOTIFSERVICE 40h


// check whether target tile is a valid "goto" target
// in:	edi=landscape index
// out:	carry if it's a depot (not a hangar!)
//	zero if it's a station (or a hangar)
//	if it's a depot, also:
//	ecx=0
//	dh=depot number (or station number for planes), dl=DEPOTORDER
//	edi=pointer into depot array
//	otherwise:
//	ecx=1
//	dl=1
checkgotostation:
	xor ecx,ecx
	testflags gotodepot
	jnc .nodepot
	mov al,[landscape4(di)]
	mov ah,[landscape5(di)]
	and al,0xf0
	cmp al,0x10
	jz near .train

	cmp al,0x20
	jz near .road

	cmp al,0x60
	jz near .water

	cmp al,0x50
	jz near .planeorstation

.nodepot:
	test byte [expswitches],8	// skip vehicle check if feature isn't enabled
	jz .novehicle_nopop
	pusha
	call findvehontile	// is there a vehicle?
	jz .novehicle
	movzx ebx,word [esi+6]	// get the current vehicle from the window data
	shl ebx,vehicleshift
	add ebx,[veharrayptr]
	cmp edi,ebx	// can't click to the vehicle itself
	je .novehicle
	mov dl,[edi+veh.class]	// only same class
	cmp dl,[ebx+veh.class]
	jne .novehicle
	mov dl,[edi+veh.owner]	// and same owner
	cmp dl,[ebx+veh.owner]
	jne .novehicle
	cmp byte [ebx+veh.class],0x11	// prevent bus/truck combination
	jne .rvcheckdone
	
	cmp byte [ebx+veh.cargotype],0
	setz dl
	cmp byte [edi+veh.cargotype],0
	setz dh
	cmp dl,dh
	jne .novehicle

.rvcheckdone:
	mov edx,ebx		// delete old schedule
	call dword [delvehschedule]
	push byte CTRL_DEFAULT
	call ctrlkeystate
	jnz .copy		// if Ctrl isn't pressed, do a normal copy instead of sharing
	call shareorders
	jmp short .continue
.copy:
	call copyorders
.continue:
	popa
	mov byte [esi+0x22],0xff	// clear order selection in the orders window
	call redrawscreen	// the window of the other veh. should be refreshed as well
	pop eax			// return to TTD code at a farther point than normally
	add eax,0xc7+8*WINTTDX
	jmp eax

.novehicle:
	popa
.novehicle_nopop:
	mov dl,1
	inc ecx
	cmp al,0x50
	clc
	ret

.yep:
	mov dl,DEPOTORDER
	stc
	ret

.planeorstation:
	cmp ah,0x41
	je short .hangar

	cmp ah,0x20
	jne .nodepot

.hangar:
	mov dl,DEPOTORDER
	inc ecx
	ret

.train:
	and ah,0xcc
	cmp ah,0xc0
	jne .nodepot
	jmp short .finddepot

.road:
	and ah,0x2c
	cmp ah,0x20
	jne .nodepot
	jmp short .finddepot

.water:
	cmp ah,0x80
	jb .nodepot
	je short .finddepot

	cmp ah,0x81
	je short .decedi

	cmp ah,0x83
	jb short .finddepot
	ja .nodepot

	// address to find is only one of the two squares of a shipyard,
	// so adjust edi by 100 or 1 accordingly
	sub di,0x100
	jmp short .finddepot

.decedi:
	dec edi

	// go through list of all depots to find out which one this is
.finddepot:
	push esi
	mov esi,depotarray
	inc ch

.nextdepot:
	cmp word [esi+depot.XY],di
	je short .foundit

	add esi,byte depot_size
	loop .nextdepot
	pop esi
	jmp .nodepot

.foundit:
	mov edi,esi
	pop esi
	mov dh,cl
	neg dh
	xor ecx,ecx
	jmp .yep
; endp checkgotostation 

// share orders between two vehicles
// in:	edi -> source vehicle
//	edx -> target vehicle
// destroys ecx
// the orders of the target vehicle should be freed already
shareorders:
	mov ecx,[edi+veh.scheduleptr]
	mov [edx+veh.scheduleptr],ecx	
	mov cl,[edi+veh.totalorders]
	mov [edx+veh.totalorders],cl
	mov byte [edx+veh.currorderidx],0
	mov word [edx+veh.currorder],0x100
	ret

// copy orders from one vehicle to another
// in:	edi -> source vehicle
//	edx -> target vehicle
// destroys many things
// the orders of the target vehicle should be freed already
copyorders:
	cmp dword [scheduleheapfree],scheduleheapend-2	// we need at least two bytes for a terminator
	ja .exit			// (if allocating fails later on, a red error message will pop up)
	mov esi,edi	// save the orders just like the source vehicle would be about to be sold
	mov edi,soldvehorderbuff
	mov byte [skipsharingcheck],1	// save shared orders normally
	call dword [savevehordersfn]
	mov byte [skipsharingcheck],0
	mov esi,[scheduleheapfree]	// set scheduleptr to a new, empty schedule
	mov word [esi],0
	mov [edx+veh.scheduleptr],esi
	add dword [scheduleheapfree],2
	mov byte [edx+veh.currorderidx],0	// set vehicle fields accordingly
	mov byte [edx+veh.totalorders],0
	mov word [edx+veh.currorder],0x100
	mov esi,edx				// and copy the saved orders to the target
	mov edi,soldvehorderbuff
	call dword [copyvehordersfn]
	and word [soldvehorderbuff],0		// prevent newly bought vehicles getting this schedule
.exit:
	ret

// check whether a "goto" target has the right owner
// in:	=out from checkgotostation
// out:	ah=owner
//	cmp ah,10
checkgotoowner:
	jecxz .depot

	mov ah,byte [edi+station.owner]

.gotit:
	cmp ah,0x10
	ret

.depot:
	push edi
	movzx edi,word [edi+depot.XY]
	mov ah,[landscape1+edi]
	pop edi
	jmp .gotit
; endp checkgotoowner 

// check whether a target is the right vehicle type
// in:	ah=bit in stationfacilities that must be set
// out:	zero flag = wrong type
//	not zero = right type
checkgototype:
	jecxz .depot

	test byte [edi+station.facilities],ah
	ret

.depot:
	and eax,byte 0x13
	mov ah,byte [depottypes+eax-0x10]
	push edi
	movzx edi,word [edi+depot.XY]
	xor ah,[landscape5(di)]
	pop edi

	and ah,~ 3
	cmp ah,4
	jb short .isright
	and ah,0	// set zero
.isright:
	ret
; endp checkgototype 

var depottypes, db 0xc0,0x20,0x80,0x10

// show an order in the order list
// in:  ax=order
//	bp=order & 00e0h
//	esi=window
//	edi=vehicle
// out:	zf=1 if regular station, 0 if not
// safe:eax,esi,edi,ebp
showorder:
	cmp bp,byte 2
	je short .depotorder
	cmp bp,byte 1
	ret

.depotorder:
	mov esi,edi
	movzx ebp,ah
	push ds
	pop es
	mov edi,textrefstack+1
	and eax,byte DEPOTIFSERVICE
	shr eax,6
	add ax,ourtext(gotodepot)
	stosw

	movzx eax,byte [esi+veh.class]
	push eax	// saved on stack: vehicle type
	push edi	// saved on stack: textrefstack+3
	inc edi
	inc edi

	cmp al,0x13
	jne short .noaircraft

	imul esi,ebp,station_size
	add esi,stationarray
	mov ax,word [esi+station.name]
	stosw
	mov ebp,dword [esi+station.townptr]
	movzx esi,word [esi+station.airportXY]
	jmp short .gotthecity

.noaircraft:
	imul esi,ebp,byte 6
	add esi,depotarray
	mov ebp,dword [esi+depot.townptr]
	movzx esi,word [esi+depot.XY]

	or esi,esi	// does the depot/airport actually exist?
	jnz short .gotthecity
	inc esi			// clear ZF
	pop esi			// restored from stack: textrefstack+3
	mov word [esi-2],6	// empty string
	pop eax			// clear vehicle type from the stack
	ret

.gotthecity:
	mov ax,word [ebp+town.citynametype]
	stosw
	mov eax,dword [ebp+town.citynameparts]
	stosd
	pop esi		// restored from stack: textrefstack+3
	pop eax		// restored from stack: vehicle type
	add ax,ourtext(gototraindepot)-0x10
	mov [esi],ax

	// NOTE: our text indices are always nonzero, so the last ADD clears ZF
	ret
; endp showorder 

// figure out whether a ship order has the right player and isn't too far
// in:	edi=vehicle
// out: cy or zf if not human, or human and not too far
//	nc and nz otherwise
isshiporder:
	push edx
	mov dl,byte [edi+veh.owner]
	push byte PL_PLAYER
	mov [esp+1],dl
	call ishumanplayer
	je short .human

.done:
	stc
	pop edx
	ret

	// have to check that the station is not too far,
	// taking depots into account
.human:
	or bh,bh
	jz short .done

	pop edx

	movzx ebp,bh
	shl ebp,1
	add ebp,dword [edi+veh.scheduleptr]

	push eax
	mov eax,[ebp-2]
	and al,0x1f
	cmp al,1
	jb .done
	cmp al,2
	ja .done

	push eax
	mov byte [esp+3],0xe
	call getofsptr
	pop eax
	mov eax,[eax]

	push edx
	mov byte [esp+3],0xe
	call getofsptr
	pop ebp

	sub al,[ebp]
	jae short .notneg1
	neg al

.notneg1:
	sub ah,[ebp+1]
	jae short .notneg2
	neg ah

.notneg2:
	add al,ah
	setc ah
	cmp ax,0x82

	pop eax
	ret

; endp isshiporder 

// set order type.  For AI, set DL to 1, for humans leave it
// then store DX in [EBP]
setordertype:
	call isrealhumanplayer
	je short .ishuman
	mov dl,1
.ishuman:
	mov [ebp],dx
	ret
; endp setordertype 

// figure out target of a command
// in:	command on stack
//	high byte of dword is offset of facility is desired
// out:	ptr to target on stack
getofsptr:
	push eax
	mov eax,[esp+8]
	and al,0x1f
	cmp al,1
	je short .station
	jnb short .mightbedepot

.bad:
	and dword [esp+8],byte 0

.done:
	pop eax
	ret

.mightbedepot:
	cmp al,2
	jne .bad

	// depot
	movzx eax,ah
	imul eax,byte 6
	add eax,depotarray
	mov [esp+8],eax
	jmp .done

.station:
	movzx eax,ah
	imul eax,station_size
	add eax,stationarray
	xchg eax,[esp+8]
	sar eax,24
	add [esp+8],eax
	jmp .done
; endp getofsptr 

// called when a train arrives at a target and
// gets a new order ready
// in:	ax=new order
//	esi=vehicle
// out:	carry if depot
//	ax=bx=new target if depot
newordertarget:
	mov word [esi+veh.target],-1
	and al,0x1f
	cmp al,2
	je short .todepot

.notyet:
	clc
	ret

.todepot:
	// check whether we need maintenance...
	test byte [esi+veh.currorder],DEPOTIFSERVICE
	jz short .always

	push eax
	call needsmaintcheck.always
	pop eax
	jna short .always

.skiporder:
	// not yet, or target doesn't exist; advance order pointer
	call advanceorders
	mov word [esi+veh.currorder],0		// force to check commands again
	clc
	mov al,0
	ret

.always:
	movzx ebx,ah
	imul ebx,byte 6
	mov eax,[depotarray+ebx]
	or ax,ax
	jz short .skiporder

	mov ebx,eax
	mov byte [esi+veh.laststation],-1
	stc
	ret
; endp newordertarget 

// called when a train arrives at a depot
// check whether it's a manual automatic or by order
// in:	on stack=vehicle
//	al=order type
// out:	zf if not manual
//	nz if manual
arriveatdepot:
	push esi
	mov esi,[esp+8]
	test al,0x20
	jnz short .byorder
	test al,0x40
	jz short .done

	or word [esi+veh.vehstatus],byte 2
.done:
	pop esi
	ret 4

.byorder:
	call advanceorders
	xor al,al	// clear zero
	jmp .done
; endp arriveatdepot 


	// advance order pointer
advanceorders:
	mov al,byte [esi+veh.currorderidx]
	inc al
	cmp al,byte [esi+veh.totalorders]
	jb short .good
	mov al,0
.good:
	mov byte [esi+veh.currorderidx],al
	ret
; endp advanceorders 

// called when the skip button is pressed
// make sure the vehicle doesn't insist on
// going to the same depot
// in:	dl=new command (check if <=totalcommands)
//	edi=vehicle
// out:	dl=new command
skipbutton:
	cmp dl,byte [edi+veh.totalorders]
	jb short .nottoolarge
	mov dl,0

.nottoolarge:
	mov word [edi+veh.currorder],0		// force to check commands again
	ret
; endp skipbutton 

// called when an order is selected in the order list
// don't disable "full load" for depots -- we use it for "only if service"
// also enable "Delete" for the "End of orders" entry (or if nothing is selected - we can't tell at this point)
// in:	[ebx]=new order type
// out:	zf if regular order
//	nz otherwise
//	eax=8 for non-depot orders
//	eax=9 for depot orders
selectorder:
	movzx eax,byte [ebx]
	and al,0x1f
	cmp al,1
	je short .ok

	test byte [expswitches],8
	jz .notend
	cmp word [ebx],0	// is it the terminating zero in the order list?
	jne .notend
	and byte [esi+0x1e],~0x20	// Enable Delete button

.notend:
	cmp al,2
	jne short .ok

	add al,7	// set to 9, and clear zero flag
	ret

.ok:
	mov al,8
	ret
; endp selectorder 

// called when any of the order buttons is pressed (full load, unload, nonstop)
// allow "full load" for depot orders too
// in:	dh=order type
//	dl=button type (0 for full load)
// out:	zf if it's ok
//	nz if it's not possible to set the option
//	dh="and" mask: not 20h if full load, ff if depot
fullloadbutton:
	and dh,0x1f
	cmp dh,1
	je short .regular

	cmp dh,2
	jne short .notok

	or dl,dl
	jnz short .notok

	mov dh,0xff	// otherwise don't clear any bits

.notok:
	ret

.regular:
	mov dh,~ 0x20	// for regular full load, clear "unload" bit
	ret
; endp fullloadbutton 


// called when an aircraft leaves a hangar
// in:	esi=vehicle
// out:	ah=[vehicle+b]
//	al=[vehicle+a]&1fh
//	carry flag if it's a depot not on the order list
//	al=1 if it's a depot on the order list
leavehangar:
	mov ax,word [esi+veh.currorder]
	and al,0x1f
	cmp al,1
	jne short .notregularstation

	ret

.notregularstation:
	cmp al,2
	je short .depot

	clc
	ret

.depot:
	test byte [esi+veh.currorder],0x20
	jnz short .onlist

	stc
	ret

.onlist:
	mov al,1
	ret
; endp leavehangar 


// called before checking if an aircraft has a new order ready,
// to exclude service orders
// in:	ESI->vehicle
// out:	AL=current order & 1fh, check will be skipped if AL>=2
// safe:EBX
isgoingtohangar:
	mov ax,word [esi+veh.currorder]	// overwritten by...
	and al,0x1f			// ... the runindex call
	cmp al,2
	jne short .continue

	test byte [esi+veh.currorder],0x20	// scheduled?
	jz short .continue
	mov al,1		// con TTD's routine into thinking it's a regular order

	// Note: after the CMP AL,2 (see codefragment oldisgoingtohangar),
	// the value in AL is not used again

.continue:
	ret
; endp isgoingtohangar 


// called when an aircraft gets a new order ready
// in:	esi=vehicle
//	ax=new order
//	ebx->new order
// out:	word[esi+0ah]=new order
//	ZF=1:if in flight, set new flight target to AH
// safe:al,ebx
newaircrafttarget:
	mov bx,ax
	and al,0x1f
	cmp al,2
	jne short .isstation

	test bl,DEPOTIFSERVICE
	jz short .isOK

	call needsmaintcheck.always	// ** destroys AH, but saves EBX
	mov al,1			// make sure we leave with ZF set
	jna short .restoretarget

	call advanceorders
	xor bx,bx		// force to check commands again
	mov al,0		// and never set the flight target

.restoretarget:
	mov ah,bh
.isstation:
	cmp al,1
.isOK:
	mov word [esi+veh.currorder],bx
	ret
; endp newaircrafttarget 


// called when an aircraft decides whether to taxi or fly to the next
// destination
// in:	ESI=vehicle, AL=byte[ESI+0Ah]&1Fh, AH=DL=byte[ESI+66h], EBX=station
//	(note: AL<3 and AL<>0 here)
// out:	AH+=9, AL=7, ZF=1 if target is at a different airport
nextplaneorder:
	add ah,9

	mov al,byte [esi+veh.currorder+1]
	xor al,byte [esi+veh.targetairport]
	// now AL=0 if the same airport, nonzero otherwise;  reverse the test
	sub al,1
	sbb al,al

	mov al,7
	ret
; endp nextplaneorder 


// if heading for depot, don't mess with the 'out' way status
// in:	same as nextplaneorder
// out:	ZF=0 if the aircraft will use the 'out' way
// safe:CX
nextplaneorder0:
	cmp byte [esi+veh.subclass],0	// overwritten
	jz .done

	mov cl,byte [esi+veh.currorder+1]
	cmp cl,byte [esi+veh.targetairport]

.done:
	ret
; endp nextplaneorder0


// called when a station is deleted,
// to invalidate the associated orders in vehicles' schedules
// in:	DX=current order
//	EBP->next order
//	EDI->current vehicle
//	AL=number of station being deleted
// out:	ZF set if it's a station order, clear otherwise
// safe:AH,BX,DL
isdelstationorder:
	and dl,0x1f		// overwritten by...
	cmp dl,1		// ... the runindex call
	je short .done

	cmp dl,2
	jne short .done

	cmp byte [edi+veh.class],0x13

.done:
	ret
; endp isdelstationorder 


// called when a depot is being removed, to find that depot in the depot array
// in:	ESI = depotofs-6
//	DI = coord of depot being removed
//	stack: depot vehicle type minus 1 (see codefragment newremovedepotfromarray and init.ah)
// out: ESI -> this depot in the array
// safe:none
removedepotfromarray:
	push ecx
	mov ch,[esp+8]
	mov cl,-1
.loop:
	inc ecx			// note: will increment CH the first time
	add esi,byte 6		// these 3 instructions...
	cmp di,[esi]		// ... are overwritten by...
	jnz short .loop		// ... the new codefragment

	pusha
	mov esi,[veharrayptr]

.vehloop:
	cmp byte [esi+veh.class],ch
	jne short .nextvehicle

	call resetvehorderifdepot
	mov bx,word [esi+veh.idx]
	mov al,0x10
	call dword [invalidatehandle]

.nextvehicle:
	sub esi,byte -vehiclesize
	cmp esi,[veharrayendptr]
	jb short .vehloop

	call isrealhumanplayer
	popa
	jnz short .done

	call invalidatelastremoveddepot
	mov [landscape3+ttdpatchdata.lastremoveddepotnumber],cx
	mov [landscape3+ttdpatchdata.lastremoveddepotcoord],di
.done:
	pop ecx
	ret 4
; endp removedepotfromarray 


// Auxiliary procedure: force vehicle to re-check its orders if it's heading for the removed depot
// in:	esi->vehicle; cl=depot number
// uses:eax
resetvehorderifdepot:
	// check vehicle's current order
	mov eax,dword [esi+veh.currorder]
	and al,0x1f
	cmp al,2
	jne short .done
	cmp ah,cl
	jne short .done

	// current order no longer valid, force re-check
	mov word [esi+veh.currorder],0

.done:
	ret
; endp resetvehorderifdepot 


// lastremoveddepot* no longer valid, clear all vehicle orders that refer to it
invalidatelastremoveddepot:
	cmp byte [landscape3+ttdpatchdata.lastremoveddepottype],0
	jz short .done

	pusha
	mov cl,[landscape3+ttdpatchdata.lastremoveddepotnumber]
	mov esi,[veharrayptr]

	// check all vehicles
.vehloop:
	cmp byte [esi+veh.class],0
	je short .nextvehicle
	mov edx,dword [esi+veh.scheduleptr]
	cmp edx,byte -1
	je short .checkcurrent

	// check vehicle's schedule
.nextorder:
	mov eax,[edx]
	or ax,ax
	jz short .checkcurrent
	inc edx
	inc edx
	and al,0x1f
	cmp al,2
	jne short .nextorder
	cmp ah,cl
	jne short .nextorder

	mov word [edx-2],0x100	// turn into an empty order
	mov bx,word [esi+veh.idx]
	mov al,0x10
	call dword [invalidatehandle]
	jmp short .nextorder

.checkcurrent:
	call resetvehorderifdepot

.nextvehicle:
	sub esi,byte -vehiclesize
	cmp esi,[veharrayendptr]
	jb short .vehloop

	// finally, clear the last removed depot information
	and dword [landscape3+ttdpatchdata.lastremoveddepotnumber],byte 0
	popa
.done:
	ret
; endp invalidatelastremoveddepot


uvarb newlyplaceddepottype

// mark type of depot a player tries to place
// also adjust cost if on a slope (see slopebld.asm)
// in:	stack: depot vehicle type
//	EBP = cost
// safe:ESI?
marknewdepottype:
	push eax
	mov al,[esp+8]
	mov byte [newlyplaceddepottype],al

	cmp al,0x12
	jae .adjusted
	cmp ebp,0x80000000		// don't adjust the cost if action not possible
	jz .adjusted
	cmp byte [depotbuildslopemap],0
	jz .adjusted
	add ebp,[raiselowercost]

.adjusted:
	mov bx,[esp+12]			// simulated POP BX
	cmp ebp,0x80000000		// overwritten by runindex call
	pop eax
	ret 6
; endp marknewdepottype 


// find either the last removed depot or an unused slot
// in:	ESI -> depot array
//	CX:word[esp+4] = coords
//	BL&1 zero if just checking, nonzero otherwise
// out:	ZF=1 if found
//	ESI -> slot if ZF=1
// safe:(E)AX
findnewdepotsslot:
	call isrealhumanplayer
	jnz short .newdepot

	mov al,byte [newlyplaceddepottype]
	cmp al,[landscape3+ttdpatchdata.lastremoveddepottype]
	jne short .newhumandepot

	mov ax,[esp+4]
	push edx

	// convert coordinates in CX:AX to one byte in DX, similar to how TTD does it
	rol cx,8
	mov dx,cx
	rol cx,8
	or dx,ax
	ror dx,4

	// check if the new depot is within 5 squares of the last removed one
	mov ax,[landscape3+ttdpatchdata.lastremoveddepotcoord]
	sub al,dl
	jnc short .lpos
	neg al
.lpos:
	sub ah,dh
	jnc short .hpos
	neg ah
.hpos:
	pop edx
	add al,ah
	jc short .newhumandepot
	cmp al,5
	ja short .newhumandepot

	// OK, the depot is being placed back

	movzx eax,byte [landscape3+ttdpatchdata.lastremoveddepotnumber]
	imul eax,byte 6
	cmp word [esi+eax],byte 0	// safety check -- is the slot still empty?
	jnz short .newhumandepot

	add esi,eax
	test bl,1
	jz short .done

	// Notify all vehicles that use this depot

	call refreshdepotschedules

	// done, mark last removed depot info as invalid and return

	mov byte [landscape3+ttdpatchdata.lastremoveddepottype],0	// depot is restored
	jmp short .checkslot		// will immediately set ZF and abort

	// Depot is not a replacement

.newhumandepot:
	call invalidatelastremoveddepot

.newdepot:
	// search for an unused slot -- replicate the overwritten TTD code
	// but in a slightly different way, with AL as a counter
	// also skip the last removed depot so that AI doesn't build over it
	mov al,1
	mov ah,[landscape3+ttdpatchdata.lastremoveddepotnumber]
	inc ah
	cmp byte [landscape3+ttdpatchdata.lastremoveddepottype],0
	jnz short .depotloop
	mov ah,0

.depotloop:
	cmp al,ah
	je short .nextdepot
.checkslot:
	cmp word [esi+depot.XY],byte 0
	jz short .done
.nextdepot:
	add esi,byte 6
	add al,1
	jnc short .depotloop
	inc ax			// guaranteed to clear ZF
.done:
	ret
; endp findnewdepotsslot 


// notify all vehicles that use the replaced depot in their schedules
refreshdepotschedules:
	pusha
	mov ecx,[landscape3+ttdpatchdata.lastremoveddepotnumber]	// number in CL, type in CH
	mov esi,[veharrayptr]

.vehloop:
	cmp byte [esi+veh.class],ch
	jne short .nextvehicle
	mov edi,dword [esi+veh.scheduleptr]
	cmp edi,byte -1
	je short .nextvehicle

	// check vehicle's schedule
.nextorder:
	mov eax,[edi]
	or ax,ax
	jz short .nextvehicle
	inc edi
	inc edi
	and al,0x1f
	cmp al,2
	jne short .nextorder
	cmp ah,cl
	jne short .nextorder

	mov bx,word [esi+veh.idx]
	mov al,0x10
	call dword [invalidatehandle]
	jmp short .nextorder

.nextvehicle:
	sub esi,byte -vehiclesize
	cmp esi,[veharrayendptr]
	jb short .vehloop

	popa
	ret
; endp refreshdepotschedules 


// called when an order is copied from a sold vehicle to a recently bought one
// the order might be a special one indicating shared orders (see format at savevehorders)
// in:	dx, ax = order
// out:	dx=order to set
//	al=special bits to set (e.g. 40=full load)
//	zero flag if order is ok to add
//	nz if not
copyoldorder:
	test byte [expswitches],8
	jz .nosharedcheck
	cmp dx,-1	// is it a special command?
	je .sharedorders

.nosharedcheck:
	and dl,0x1f
	cmp dl,1
	je short .done

	testflags gotodepot
	jc .mightbedepot
	cmp dl,1
	ret

.mightbedepot:
	cmp dl,2
	je short .isdepot
.done:
	ret

.isdepot:
	mov dl,DEPOTORDER
	and al,~ DEPOTORDER
	test al,0	// set zero flag
	ret

.sharedorders:
	add edi,2	// skip two bytes - this order is two bytes longer than other commands
	pusha
	movzx edi,word [edi]	// find the source vehicle
	shl edi,vehicleshift
	add edi,[veharrayptr]
	cmp byte [edi+veh.class],0	// is it still valid?
	je .exit
	
	mov edx,esi
	call dword [delvehschedule]	// delete old schedule
	call shareorders
	call redrawscreen

.exit:
	popa
	or dl,dl
	ret
	
; endp copyoldorder 

// called when clicking on the depot button if the target is already a depot
// if currorder is set to 0x100, it will be changed to the current entry in the orders list
// in: esi -> vehicle
// out: currorder updated
// safe:???
canceldepot:
	test byte [esi+veh.currorder],0x20	// is currorder a "go to depot" order?
	jz .nodepotorder
	push eax	// yes, skip it to allow manual sending with the next click
	mov al,[esi+veh.currorderidx]
	inc al
	cmp al,[esi+veh.totalorders]
	jb .nowrap
	xor al,al
.nowrap:
	mov [esi+veh.currorderidx],al
	pop eax

.nodepotorder:
	mov word [esi+veh.currorder],0x100	// overridden by the call
	ret

// Delete the schedule of the vehicle
// The new version checks for shared schedules
delvehicleschedule:
	mov ebp,[edx+veh.scheduleptr]	// overwritten
	call isscheduleshared
	jc .abort
	movzx esi,byte [edx+veh.totalorders]	// overwritten
	ret

.abort:
	pop ebx	// remove our return address (ebx would have been overwritten anyway)
	ret	// return to the caller's caller

// selects text to show in orders window
// in:	ax: order entry
//	edi -> vehicle
// out:	zf clear to show default text
//	zf set to show our text
//	bx: text ID if using own text
// safe: ebp,esi,edi,???
showendoforders:
	or ax,ax
	jnz .exit
	mov bx,0x882a	// - - End of orders - -
	mov ebp,[edi+veh.scheduleptr]
	call isscheduleshared
	jnc .exit
	mov bx,ourtext(endofsharedorders)
	cmp al,al
.exit:
	ret

// called in the schedule-adjusting loop when an order is inserted or deleted
// we notify the other vehicles that use the same schedule about the change
// in:	edi -> vehicle whose orders are being changed
//	esi -> vehicle entry to adjust if needed
//	ebp -> order being inserted/deleted
// out: nz if veh. entry is valid (valid class and scheduleptr)
// safe: ax,cx,edx

adjustorders:
	cmp byte [esi+veh.class],0	//overwritten by the
	je .exit
	cmp dword [esi+veh.scheduleptr],byte -1	// runindex call
	je .exit
	cmp esi,edi	// the source vehicle will be notified later
	je .exit
	mov edx,[edi+veh.scheduleptr]
	cmp edx,[esi+veh.scheduleptr]
	je .shared
	test ebp,ebp	// clear zf
.exit:
	ret

.shared:
	mov dl,[edi+veh.totalorders]	// adjust totalorders
	mov [esi+veh.totalorders],dl
	pop edx				// get our return address
	push edx
	pusha
// Here comes a nasty, but small solution: we call the remainder of the parent function from here,
// instead of reproducing its behaviour for other vehicles.
// The problem is, that it pops 4 bytes from the stack before returning, so it would pop
// the return address and return to the wrong place. Because of this, we put an extra return address
// to the stack, so the function will pop the return address placed by the call and return to the
// second, manually placed return address.
	mov edi,esi	// make the function believe that the current vehicle was the modified one
	add edx,0x1c
	push addr(.return)
	call edx
.return:
	popa
	ret	// zf doesn't matter - this vehicle won't be adjusted anyway (scheduleptr<=ebp)

// Called when Delete is pressed in the orders window
// Make deleting the end marker possible, doing this will reset orders
// (This will work if nothing is selected as well)
// in:	edi -> vehicle (after the first overwritten instruction)
//	al: order number
// out: cf set if order number is ok
// safe: eax,ecx,bl
deletepressed:
	add edi,[veharrayptr]		// overwritten
	cmp al,[edi+veh.totalorders]	// exit if it's not the terminator entry ("End of orders")
	jne .end
	or byte [esi+0x1a],0x20		// make "Delete" pushed
	or byte [esi+4],5		// but make it release after the click
	cmp dword [scheduleheapfree],scheduleheapend-2	// don't do it if there's not enough heap
	ja .deny					// for the new terminator order

	pusha
	mov edx,edi
	call dword [delvehschedule]	// delete old orders (the function handles shared orders properly)
	mov ebx,[scheduleheapfree]	// create the terminator order
	and word [ebx],0
	mov [edi+veh.scheduleptr],ebx	// and assign it to the vehicle
	add dword [scheduleheapfree],2
	mov byte [edi+veh.totalorders],0	// set vehicle fields accordingly
	mov byte [edi+veh.currorderidx],0
	mov word [edi+veh.currorder],0x100
	call redrawscreen	// redraw the entire screen, because other order windows might have changed
				// ("End of shared orders" -> "End of orders")
	popa

.deny:
	clc
.end:
	ret

uvarb skipsharingcheck	// if nonzero, shared orders are saved like non-shared ones (new veh. won't be shared)

// saves the orders of a vehicle to a buffer
// for shared orders, it saves a special sequence (-1, other veh. number, 0) that can be recognized
// by the restore procedure
// in:	esi -> vehicle
//	edi -> buffer
// safe: ebp,eax
savevehorders:
	mov ebp,[esi+veh.scheduleptr]	// overwritten
	cmp byte [skipsharingcheck],0
	jne .normal
	mov eax,[veharrayptr]

.checkveh:
	cmp byte [eax+veh.class],0	// is it valid?
	jz .nextveh
	cmp ebp,[eax+veh.scheduleptr]	// does it share its orders with our vehicle?
	jnz .nextveh
	cmp esi,eax			// don't check itself
	je .nextveh

	mov word [edi],-1	// found another vehicle sharing this schedule - save a -1 prefix and its number...
	mov ax,[eax+veh.idx]
	mov [edi+2],ax
	and word [edi+4],0	// ... and a terminator
	ret

.nextveh:
	sub eax,byte -vehiclesize
	cmp eax,[veharrayendptr]
	jb .checkveh

.normal:
	mov ax,[ebp]	// here comes the old code - the runindex call didn't fit outside the loop,
	cmp ax,0x100	// so I used a jump instead and copied the remaining code here
	je .dontsave
	mov [edi],ax
	add edi,2

.dontsave:
	add ebp,2
	or ax,ax
	jnz .normal
	ret
