
// New loadtime calculation

calcloadtime:

	// esi = index to train engine
	// edi = index to station data
	// dh = number of station platforms
	// dl = total number of vehicles in the train
	// ax = (total cargo (un)loaded + 20)*2

	// ok to use: bx, cx

	push edi

	xor dl,dl
	xor ebx,ebx
	mov edi,esi

	movzx eax,ax
	shr eax,1
	sub eax,byte 20
	or eax,eax
	jns short .notnegative
	xor eax,eax	// shouldn't be here unless something is wrong
.notnegative:

		// find total train capacity
.nextwaggon:
	movzx ecx,word [edi+veh.capacity]
	add ebx,ecx
	or ecx,ecx
	jz short .nocargo
	inc dl
.nocargo:
	movzx edi,word [edi+veh.nextunitidx]
	cmp di,byte -1
	je short .knowitall
	shl edi,vehicleshift
//	add edi,index
	add edi,[veharrayptr]
	jmp .nextwaggon

.knowitall:
	// now
	// dl = total number of vehicles with cargo capacity
	// eax = total cargo (un)loaded
	// ebx = total train capacity

	or dl,dl
	jz short .nodividebyzerothanks

	// find how much is loaded into every vehicle
	push edx
	movzx ebx,dl
	xor edx,edx
	add eax,ebx	// to round up
	dec eax
	div ebx		// to get sufficient precision
	pop edx

	// now eax is the time taken for the load/unload process
	// calc back to the other format (and double time to make up the change)
.nodividebyzerothanks:
	shl eax,3
	add eax,byte 10
	mov ebx,eax

.checkexcess:		// if train doesn't fit completely, double the time
	sub dl,dh
	jle short .noexcess
	add eax,ebx
	jmp .checkexcess	// maybe too long still (2 platforms, >8 cars)

.noexcess:
	pop edi
	ret
; endp calcloadtime 


forcedunload:
	add [ebp+8],ax
	add ax,dx		// now ax=new+old
	sub dx,ax		// and dx=-new
	cmp ax,0xfff
	ret
; endp forcedunload 



// called when a vehicle's loading/unloading time is modified
//
// in:	esi=vehicle
//	ah=special commands (full load/unload etc.)
// out:	nz if time not done yet
//	zero+carry if loading/unloading done
//	zero+nc if load/unload more cargo

loadtimedone:
	dec word [esi+veh.loadtime]
	jnz short .haveit

	// load time expired, see if we need to unload/load more cargo
	test byte [esi+veh.modflags],1 << MOD_NOTDONEYET
	jnz short .haveitz

	// not done if full load is set
	test ah,0x40
	stc
	jz short .haveit

.haveitz:
	test al,0	// set zero flag

.haveit:
	ret
; endp loadtimedone


uvarw totalloadamount		// how much cargo to load/unload at a time for gradualloading
uvarb numvehstillunloading	// number of vehicles not yet done with unloading
uvarb numvehloadable		// number of vehicles that can be process in this round

// loading/unloading speed by vehicle type
var loadwaittime, db 8,4,2,4


// called at the beginning of one load/unload cycle
//
// in:	esi=vehicle
// safe:ecx edi, maybe others

startloadcycle:
	push ebx
	and byte [esi+veh.modflags],~ (1 << MOD_NOTDONEYET)

	mov al,255

	cmp byte [esi+veh.class],0x10
	jne .gotnumveh

	movzx edi,byte [esi+veh.laststation]
	imul di,station_size
	add edi,[stationarrayptr]
	mov al,[edi+station.platforms]
	shr al,3
	add al,al	// now al=number of wagons that can be serviced each round

.gotnumveh:
	mov [numvehloadable],al
	mov edi,esi
	xor ecx,ecx
	movzx eax,al

.nextveh:
	cmp word [edi+veh.capacity],0
	je .nocargo

	sub al,1	// can't use dec, because it doesn't set carry
	adc al,0	// make sure it stays at zero
	jc .toolong

	movzx ebx,byte [esi+veh.vehtype]
	mov bl,[loadamount+ebx]
	add cx,bx

.toolong:
	cmp word [edi+veh.currentload],0
	je .notunloading

	test byte [edi+veh.modflags],1 << MOD_MORETOUNLOAD
	jz .notunloading

	inc ah

.notunloading:

.nocargo:
	movzx edi,word [edi+veh.nextunitidx]
	cmp di,-1
	je .done

	shl edi,vehicleshift
	add edi,[veharrayptr]
	jmp .nextveh

.done:
	// now cx=maximum amount of cargo that can be moved in each round
	// by all waggons that fit in the station

	// with MISCMODS_GRADUALLOADBYWAGON,
	// - amount of waggons is unlimited
	// - totalloadamount is sum of cargo that can be moved by the
	//   waggons that fit in the station
	//   (small bug: this doesn't give the right number if the first
	//    waggons have small loadamount, and the remaining ones have
	//    a large loadamount or vice versa)
	// - amount each waggon can load is unlimited
	//
	// without MISCMODS_GRADUALLOADBYWAGON
	// - amount of waggons is limited by how many fit in the station
	// - total amount is unlimited
	// - amount each waggon can load is limited by loadamount[vehtype]
	//

	test byte [miscmodsflags],MISCMODS_GRADUALLOADBYWAGON
	jnz .bywaggon

	or ecx,byte -1
	jmp short .setamounts

.bywaggon:
	mov byte [numvehloadable],0xff

.setamounts:
	mov [totalloadamount],cx
	mov [numvehstillunloading],ah
	pop ebx
	ret
; endp startloadcycle

// called when a vehicle decides whether to load or unload cargo at a station
//
// in:	esi=vehicle
//	edi=engine
// out:	zero flag set if unloading is done and loading should be attempted
// safe:eax ebx ecx edx

unloadingdone:
	and byte [esi+veh.modflags],~ (1 << MOD_NOTDONEYET)
	btr dword [esi+veh.modflags],MOD_MORETOUNLOAD
	jnc short .donez

	// wasn't done last time, maybe this time
	cmp word [esi+veh.currentload],byte 0
	jmp short .done

.donez:
	test al,0	// set zero

.done:
	ret
; endp unloadingdone

// called to find out the maximum amount that can be loaded/unloaded now
//
// in:	esi=vehicle
//	ax=amount available in vehicle
// out: ax=max. load amount
// uses:--
maxloadamount:
	cmp byte [numvehloadable],0
	jnz .stillloading

	xor ax,ax
	ret

.stillloading:
	push ebx
	test byte [miscmodsflags],MISCMODS_GRADUALLOADBYWAGON
	jnz .notbywagon

	movzx ebx,byte [esi+veh.vehtype]
	mov bl,[loadamount+ebx]

	cmp bx,[totalloadamount]
	jbe .nottoomuch

.notbywagon:
	mov bx,[totalloadamount]

.nottoomuch:
	cmp ax,bx
	jbe .stillnottoomuch

	mov ax,bx

.stillnottoomuch:
	pop ebx
	ret


// called when unloading without forced unloading
//
// in:	esi=vehicle
//	edi=engine
//	bx=[esi.currentload]
// safe:nothing

regularunloadamount:
	push edi

	or byte [esi+veh.modflags],(1 << MOD_MORETOUNLOAD)+(1 << MOD_NOTDONEYET)
	or edi,byte -1
	xchg eax,edi
	call maxloadamount
	xchg eax,edi

	cmp di,[esi+veh.currentload]
	jb .stillnottoomuch

	mov di,[esi+veh.currentload]
	dec byte [numvehstillunloading]		// vehicle will be empty

.stillnottoomuch:
	sub [esi+veh.currentload],di
	sub [totalloadamount],di

	pop edi

	bts dword [esi+veh.modflags],MOD_DIDCASHIN
	jc short .dontcashin

	call dword [acceptcargofn]
	add [ebp+4],eax

.dontcashin:

	cmp word [esi+veh.currentload],byte 0
	jne short .notemptyyet

	and byte [esi+veh.modflags],~ ((1 << MOD_MORETOUNLOAD)+(1 << MOD_DIDCASHIN))

.notemptyyet:
	or byte [ebp+0xf],1
	ret
; endp regularunloadamount


// same but forced unload
//
// in:	esi, edi as above
//	ax=current load
// out:	ax=amount to unload

forcedunloadamount:
	call maxloadamount

	cmp ax,word [esi+veh.currentload]
	jb .notdoneyet

	dec byte [numvehstillunloading]		// vehicle will be empty
	jmp short .nomoreleft

.notdoneyet:
	or byte [esi+veh.modflags],(1 << MOD_MORETOUNLOAD)+(1 << MOD_NOTDONEYET)

.nomoreleft:
	sub [totalloadamount],ax
	jmp $+0x1000	// will be set later; to jump to either forcedunloadprofit
			// or forcedunload
ovar forcedunloadamountjmp,-4
; endp forcedunloadamount


// called after a round of loading/unloading is done, to calculate
// the time till this round is completed
//
// in:	esi=vehicle
// out:	nz
// safe:eax ebx ecx edx

calcgradualloadtime:
	// pause a longer time (20) just before taking off
	// otherwise the time is loadwaittime*MAXLOADAMOUNT

	mov esi,[ebp]

	movzx ebx,byte [esi+veh.class]

	mov al,5
	mul byte [loadwaittime+ebx-0x10]

	mov word [ebp+8],ax

	test byte [esi+veh.modflags],1 << MOD_NOTDONEYET
	jnz short .notdone

	mov byte [ebp+8],20

	or esi,esi	// clear zero

.notdone:
	ret
; endp calcgradualloadtime 


// called when the game decides whether to load something into a vehicle
//
// in:	esi=vehicle
//	edi=engine
// out:	zero flag clear if loading

doloading:
	test byte [esi+veh.modflags],1 << MOD_MORETOUNLOAD
	jnz short .done	// still unloading

	test byte [miscmodsflags],MISCMODS_GRADUALLOADBYWAGON
	jz .doload

	cmp byte [numvehstillunloading],0
	jne short .done

.doload:
	and byte [esi+veh.modflags],~ (1 << MOD_NOTDONEYET)

	test byte [edi+veh.currorder],0x20	// forced unload set?

.done:
	ret
; endp doloading

// called when deciding on the amount of cargo to load
//
// in:	esi=vehicle
//	edi=engine
//	ax=remaining capacity
//	dx=cargo available
// out:	ax=amount to load

getloadamount:
	test byte [edi+veh.currorder],0x40
	jz short .notfulload

	// check whether we're done loading
	or ax,ax
	jz short .notfulload

	// consist not done with loading yet
	// even if we're not loading cargo right now (full load order)
	or byte [edi+veh.modflags],1 << MOD_NOTDONEYET

.notfulload:
	cmp ax,dx
	jbe short .enough
	mov ax,dx

.enough:
	or ax,ax
	jz short .nothing

	call checkrandomcargotrigger

	or byte [esi+veh.modflags],1 << MOD_NOTDONEYET

.nothing:
	call maxloadamount

	sub [totalloadamount],ax

var loadamountjmp
	ret       	// maybe turned into a jmp if feederservice also on
	dd pickupcargo - ($+4)
; endp getloadamount


checkrandomcargotrigger:
	cmp word [esi+veh.currentload],0
	jne .notnewload

	// update random graphics if vehicle was empty and gets cargo
	push eax
	mov al,1
	call randomtrigger
	pop eax

.notnewload:
	ret


// same as above, but only used to randomize the graphics for a new load
newloadrandomize:
	cmp ax,dx
	jbe short .enough
	mov ax,dx
.enough:
	or ax,ax
	jz short .nothing

	call checkrandomcargotrigger

.nothing:
	ret


// called when one vehicle has been loaded/unloaded, and
// advances to next vehicle if any
//
// in:	esi=current vehicle
//	several useful values on stack frame
// out:	esi=next vehicle number
//	zero flag if no more vehicles
// safe:eax ebx ecx edx edi

loadnextveh:
	cmp word [esi+veh.capacity],byte 0
	je short .good		// skip vehicles with no capacity

	mov edi,[ebp]

	// copy MOD_NOTDONEYET to consist
	mov al,byte [esi+veh.modflags]
	and al,1 << MOD_NOTDONEYET
	or byte [edi+veh.modflags],al

	test byte [miscmodsflags],MISCMODS_GRADUALLOADBYWAGON
	jnz .good

	// only unload as many train vehicles at a time as fit in the station
	cmp byte [esi+veh.class],0x10
	jne short .good

	// if the vehicle is done, it doesn't count
	test al,1 << MOD_NOTDONEYET
	jz short .good

	sub byte [numvehloadable],1
	adc byte [numvehloadable],0

.good:
	mov si,word [esi+veh.nextunitidx]
	cmp si,byte -1
	ret
; endp loadnextveh 
