// Helper functions needed by the morecurrencies patch
// The main code is in newcurrcode.ah

// Called when copying entries from dropdownlist1 to dropdownlist2.
// By default, dropdownlist1 contains words defining texts, then -1 as terminator.
// We add a new feature: if the first item is -2, then the next two items will
// point to a buffer to use instead of dropdownlist1
// NOTE: dropdownlist2 can't store more than 20 items, so the longest possible custom
// dropdown list is 19 items and one terminator
// in: ebx is zero
// out: ebx should be one more than the items copied
// safe: ax
copydropdownstack:
	push eax
	push cx
	push edx
	mov edx,[dropdownstack2]
	cmp word [tempvar],-2
	je .ourlist
	mov eax,tempvar
	jmp short .copy
.ourlist:
	mov eax,[tempvar+2]
.copy:
	mov cx,[eax+ebx*2]
	mov [edx+ebx*2],cx
	inc ebx
	cmp cx,-1
	jne .copy
	pop edx
	pop cx
	pop eax
	ret

// Currencies are in order: pound, dollar, franc, deutschmark, yen, peseta, hungarian forint,
// polish zloty, austrian shilling, belgian franc, danish krone, finnish markka, greek drachma,
// swiss franc, dutch guilder, italian lira, swedish krona, russian rubel, euro

// All of these can be changed with ttdpttxt.dat

// Texts to show in the currency dropdown list, terminated by -1
// The last but one -1 will be changed to Euro after 2002 if it's enabled
var currtextlist,dw 0x133,0x134,0x135,0x136,0x137,0x138,ourtext(curr_HUF),ourtext(curr_PLN),
dw ourtext(curr_ATS),ourtext(curr_BEF),ourtext(curr_DKK),ourtext(curr_FIM),ourtext(curr_GRD),
dw ourtext(curr_CHF),ourtext(curr_NLG),ourtext(curr_ITL),ourtext(curr_SEK),ourtext(curr_RUB),-1,-1

// Currency multipliers. Their last three decimal digits will be assumed to be after the decimal point,
// so 1234567 will mean 1234.567
var currmultis,dd 1000,2000,10000,4000,200000,200000,375620,6079,19410,56890,10480,8380,
dd 480470,2160,3110,2730580,13090,4859,2000

// Currency options: thousand separator char in the low byte, the high byte is 1 if currency symbol should
// be shown after the number.
var curropts,dw "," , "," , "." , "." , "," , "." , 0x100 | "." , 0x100 | " " , "," , "," , "," , "," , "," ,
dw "," , "," , "," , "," , 0x100 | " " , ","

// What currency symbol to use if it's before and after the number. Two separate lists are needed because
// if a symbol needs to be separated with a space, the positon of the space will be different.
// All symbols are stored in a dword, and can be maximum four chars long
var currsymsbefore,dd 0xA3,"$","FF ","DM ",0xA5,"Pt","Ft ","zl ","ATS ","BEF ","DKK ","FIM ",
dd "GRD ","CHF ","NLG ","ITL ","SEK ","rur ",0x9e
var currsymsafter,dd 0xA3,"$"," FF"," DM",0xA5,"Pt"," Ft"," zl"," ATS"," BEF"," DKK"," FIM",
dd " GRD"," CHF"," NLG"," ITL"," SEK"," rur",0x9e

// If nonzero, the year when Euro will be introduced instead of the currency
var eurointr, dw 0,0,2002,2002,0,2002,2008,2008,2002,2002,0,2002,2002,0,2002,2002,0,0,0

// bitmask of what currencies are disabled
uvard disabledcurrs



// Updates disabledcurrs according to the current year and eurointr
updatecurrlist:

// do it only if both euro and morecurrencies are enabled
	test byte [morecurropts],1<<CURR_OPT_NOEURO
	jnz .dontneed
	testflags morecurrencies
	jc .doit
.dontneed:
	ret

.beforeeuro:
	mov [disabledcurrs],eax	// enable all currencies (eax is zero)...
	or word [currtextlist+CURR_EURO*2],-1	// ... but hide Euro
	getcurr ebx
	cmp ebx,currcount-1
	jne .noteuro

// The current currency was Euro (this might happen when jumping back in time with cht:Year)
// Change it to pounds

	and byte [currency],0
	mov byte [landscape3+ttdpatchdata.realcurrency],1

.noteuro:
	popa
	ret

.doit:
	pusha
	xor eax,eax
	mov bl,[currentyear]
	xor bh,bh
	add bx,1920
	cmp bx,2002
	jb .beforeeuro
	mov ecx,currcount-1	// check everything except Euro

.convertcurr:
	dec ecx
	mov dx,[eurointr+ecx*2]
	or dx,dx	// Will it ever be changed?
	jz .next
	cmp dx,bx	// Was it changed by now?
	ja .next
	bts eax,ecx	// This currency was changed to Euro - disable it
.next:
	or ecx,ecx
	jnz .convertcurr

	mov word [currtextlist+CURR_EURO*2],ourtext(curr_EUR)	// Show Euro

	mov [disabledcurrs],eax	// update disabled currencies list
	getcurr ebx
	bt eax,ebx	// Did the current currency get disabled by the change?
	jnc .end

	and byte [currency],0	// If it did, change current currency to Euro
	mov byte [landscape3+ttdpatchdata.realcurrency],currcount

.end:
	popa
	ret

// Called when a currency is selected in the Game options dialog box
// [currency] is updated already
// In: al: index of selected currency in the dropdown list (zero-based)
// Out: the same
// safe: ???
currselect:
	cmp al,5
	jbe .noreset
// If it's a non-default currency, reset the old TTD variable because it would make TTD crash
	mov byte [currency],0
.noreset:
// Store index+1 in the new currency variable in landscape3
	inc al
	mov [landscape3+ttdpatchdata.realcurrency],al
	dec al
	mov ebx,5	// overwritten by the
	call dword [ebp+4]	// runindex call
	ret

// Called when filling the dropdown list of currencies.
// Uses the new feature of copydropdownstack to specify a new list.
// Out: dx should contain the index of the currently selected item.
//	ebx is a mask for the disabled items
// safe: ???
fillcurrlist:
	getcurr dx
	mov word [tempvar],-2
	mov dword [tempvar+2],currtextlist
	mov ebx,[disabledcurrs]
	ret

// Called when deciding the text to show in the currency dropdown box
// Out: ax: text to show
// safe: ???
whatcurrtoshow:
	push ebx
	getcurr ebx
	mov ax,[currtextlist+ebx*2]
	pop ebx
	ret

// New Year: check if it's the euro introduction year (2002)
// out:	ZF set = it's 2050
// safe:everything except ESP
isspecialyear:
	test byte [morecurropts],1<<CURR_OPT_NOEURO
	jnz .check2050
	cmp byte [currentyear],82
	jnz .check2050

	mov dx,ourtext(eurointroduced)
	mov ebx,0x40001			// category 4 = "economy changes"
	call dword [newsmessagefn]

.check2050:
	call updatecurrlist

	cmp byte [currentyear],130	// overwritten
	ret


// Euro glyph in three font sizes
var euroglyph
	incbin "euro_emb.dat"
