
// More news items

// Generate a news report when a large UFO is destroyed
// in:	ESI -> XCOM aircraft
//	EDI -> UFO
// safe:(E)AX,EBX,CX,DX,EBP (well, we PUSHA anyway)
largeufodestroynews:
	mov	word [esi+veh.currorder],1		// overwritten by runindex call
	mov	dx,ourtext(ufodestroyed)
	call	newsmsgwithnearesttown
	ret
; endp largeufodestroynews 

// Shows a news message with the given text centered on the given vehicle.
// textrefstack contains the closest town
// in:	edi: vehicle
//	dx: message ID
newsmsgwithnearesttown:
	pusha

	// find the nearest town and store its name
	// this is about how TTD does it when a large UFO lands
	push	edi
	mov	ax,word [edi+veh.target]
	mov	ebp,dword [mainhandlertable]
	mov	ebp,[ebp+(3*8)]
	xor	ebx,ebx
	mov	bl,1
	call	dword [ebp+4]		// returns the nearest town ptr in EDI and distance in BP; scrambles BX,ESI
	mov	esi,textrefstack
	mov	ax,word [edi+town.citynametype]
	mov	[esi],ax
	mov	eax,dword [edi+town.citynameparts]
	mov	[esi+2],eax
	pop	edi

	// now set coordinates and invoke the news/message handler
	movzx	eax,word [edi+veh.xpos]
	movzx	ecx,word [edi+veh.ypos]
	mov	ebx,eax
	shr	ebx,4
	shl	ecx,4
	mov	bh,ch
	shr	ecx,4
	mov	[newsitemparam],ebx
	mov	ebx,0x20502
	call	dword [newsmessagefn]

	popa
	ret

// Watching production of lumber mills works this way:
// We count the number of treecuts since the last unsuccessful one in the field that would contain
// the production rate of the second cargo. Since lumber mills product only one thing, our counter
// won't make problems (it will modify the production counter of the second cargo, but this isn't used
// anyway). We notify the player only if there were at least four successful cuts before an unsuccessful one.
// This way we can avoid multiple warnings caused by cutting the few baby trees that grow sometimes
// in the otherwise empty area.

// Called at the end of tree-finding loop for lumber mills. If no trees were found, the procedure exits here.
// esi points to the lumber mill in the industry array
// safe:none

lmillcuttree1:
	sub bx,0x101	// owerwritten
	cmp cl,41	// by the runindex call
	jnb .outoftrees
	ret		// haven't finished the loop yet

.outoftrees:
	cmp byte [esi+industry.prodrates+1],4
	jbe .notenough
 
	push eax
	push ebx
	push ecx

	mov ecx,textrefstack

	// fill the text stack with the needed information
	// first the city name
	mov eax, [esi+industry.townptr]
	mov bx, [eax+town.citynametype]
	mov [ecx],bx
	mov eax, [eax+town.citynameparts]
	mov [ecx+2],eax

	// then the industry name
	movzx ax, byte [esi+industry.type]
	add ax, 0x4802
	mov [ecx+6],ax

	// make parameters for newsmessagefn
	movzx ebx,word [esi+industry.XY]
	movzx eax,bl
	movzx ecx,bh
	mov [newsitemparam],ebx
	shl eax,4
	shl ecx,4
	add eax,16
	add ecx,16
	mov ebx,0x40502		// category 4 = "economy changes"
	mov dx,ourtext(lmilloutoftrees)

	// and show the message
	call dword [newsmessagefn]
	pop ecx
	pop ebx
	pop eax
	
.notenough:
	and byte [esi+industry.prodrates+1],0	// reset counter
	clc	// need to clear carry to exit the loop
	ret

// Called after successfully cutting a tree.
// safe: none
lmillcuttree2:
	add word [esi+industry.amountswaiting],45	// overwritten
	jae .noprodoverflow				// by the

	mov word [esi+industry.amountswaiting],0xffff	// runindex call

.noprodoverflow:
	add byte [esi+industry.prodrates+1],1	// inc wouldn't set the flags
	jae .nocutcountoverflow

	mov byte [esi+industry.prodrates+1],0xff

.nocutcountoverflow:
	ret

// News message when a crashed Zeppelin has been cleared from an airport
// in:	esi -> Zeppelin about to be cleared
//	edi -> station where the Zeppelin is
// safe: eax,ebx,ecx,edx

clearzeppelin:
	btr word [edi+station.airportstat],7 // overwritten by the call
	mov dx,ourtext(zeppelincleared)
	mov ebx,edi
	call newsmsgwithstation
	ret

// The same with crashed aircrafts
// in:	esi -> aircraft to be cleared
//	ebx -> station where the aircraft is
// safe: eax,ebx,ecx,edx

clearcrashedaircraft:
	btr word [ebx+station.airportstat],ax // overwritten by the call
	mov dx,ourtext(aircraftcleared)
	call newsmsgwithstation
	ret

// Shows a news message with the given text centered on the given vehicle
// textrefstack contains the name of the given station
// in:	ebx -> station
//	dx: message ID
//	esi -> vehicle
// destroys eax,ebx,ecx,edx
newsmsgwithstation:
	push dx
	mov edx,textrefstack
	mov eax,[ebx+station.name]
	mov [edx],eax
	mov ecx,[ebx+station.townptr]
	mov eax,[ecx+town.citynametype]
	mov [edx+2],eax
	mov eax,[ecx+town.citynameparts]
	mov [edx+4],eax
	movzx eax,word [esi+veh.xpos]
	movzx ecx,word [esi+veh.ypos]
	mov ebx,eax
	shr ebx,4
	shl ecx,4
	mov bh,ch
	shr ecx,4
	mov [newsitemparam],ebx
	mov ebx,0x20502
	pop dx
	call dword [newsmessagefn]
	ret

uvarw lastcleardate	// used to prevent multiple news messages when multiple trains are cleared

// called for every wagon of the crashed train being cleared
// in:	esi -> wagon being cleared
//	edi -> wagon before [esi] in the consist
// safe: eax,ecx,edx,ebp
clearcrashedtrain:
	mov word [edi+veh.nextunitidx],-1	// overwritten by the runindex call
	cmp esi,edi
	jne .exit
	mov ax,[lastcleardate]
	add ax,3
	mov cx,[currentdate]
	cmp ax,cx
	ja .exit

	mov [lastcleardate],cx

	mov	dx,ourtext(traincleared)
	call	newsmsgwithnearesttown
.exit:
	ret
