
// Multi-headed engines

lastheadaddspower equ 4		// after this many heads, speed doesn't increase
addpowerbase equ (1 << (lastheadaddspower-1))-1

	// calculate the power and speed of a train,
	// allowing multi-head configs
	//
	// in:	esi=vehicle
	// out: (set esi+veh.realpower and esi+veh.maxspeed),eax=real power
	// safe:eax,ebx,edx must be
proc calcpowerandspeed
	local newpower,newspeed,engines

	_enter

	push edi
	mov edi,dword [enginepowerstable]
	movzx eax,word [esi+veh.vehtype]
	movzx eax,word [edi+eax*2]		// if multihead is off use power from the table
	testflags multihead
	jnc near .storerealpower

	or dword [%$newspeed],byte -1
	and dword [%$newpower],byte 0
	and dword [%$engines],byte 0

	// calculate by how much we need to adjust the speed of
	// normally dual-headed engines
	//
	// newspeed is lowest speed * 65536
	//

	mov eax,100*addpowerbase
	push eax

	movzx ebx,byte [multihdspeedup]
	lea ebx,[ebx*4+eax]
	xor edx,edx

	shl eax,16
	idiv ebx

	// now eax=fraction of 65536 that we for dual-headed engines

	push esi

.nextvehicle:
	movzx ebx,word [esi+veh.vehtype]
	movzx ecx,word [edi+ebx*2]
	or ecx,ecx
	jz short .noengine
	inc dword [%$engines]

	test byte [edi+ebx+numheadsfrompower],1
	movzx ebx,word [edi+ebx*2+speedfrompower]

	mov edx,0x10000
	jz short .defaultonehead
	shr ecx,1	// has by two heads by default, adjust.

	// ebx is default speed, and by multihdspeedup*4/7 too high

	mov edx,eax

.defaultonehead:
	imul ebx,edx
	add [%$newpower],ecx	// add to power

	cmp [%$newspeed],ebx	// and find lowest speed
	jb short .notfaster
	mov [%$newspeed],ebx

.notfaster:

.noengine:
	movzx esi,word [esi+veh.nextunitidx]
	cmp si,byte -1
	je short .havetraininfo
	shl esi,byte vehicleshift
	add esi,[veharrayptr]
	jmp .nextvehicle

.havetraininfo:
	pop esi
	mov eax,[%$newspeed]	// Note: newspeed is *10000h

	mov cl,lastheadaddspower
	sub cl,[%$engines]

	jnb short .good

	mov cl,0

.good:
		// edi = addpowerbase minus one bits for each engine not added
	mov edi,addpowerbase
	shr edi,cl
	shl edi,cl	// now edi=0, 4, 6, 7 for 1, 2, 3, 4 or more engines


	movzx edx,byte [multihdspeedup]
	imul edi,edx

	pop ecx		// =addpowerbase*100

	add edi,ecx	// now edi=addpowerbase*100%+(0..addpowerbase)*multihdspeedup

	imul edi	// i.e. edi=addpowerbase times the speed percentage

		// check for overflow
		// Augh, overflow happens if edx>ecx/2 b/o sign bit
	mov ebx,ecx
	shr ebx,1
	adc ebx,byte 0	// round up
	cmp edx,ebx
	jb short .nottoofast

	lea edx,[ebx-1]
	or eax,byte -1

.nottoofast:
	idiv ecx		// and divide by 700 to get the actual speed
	shr eax,16
	adc ax,0		// round up
	jns short .nottoobig
	mov ax,0x7fff

.nottoobig:
	mov word [esi+veh.maxspeed],ax
	mov eax,[%$newpower]

.storerealpower:
	mov dword [esi+veh.realpower],eax
	pop edi
	_ret
endproc calcpowerandspeed

	// called to calculate the acceleration, depending on weight
	//
	// in:	esi=vehicle
	//	ebp=weight
	//
	// out:	(set esi.accel)
	// safe:eax,ebx,ebp
calcaccel:
	call calcpowerandspeed		// replace by mov when power works

	mov dh,cl
	mov cl,[esi+veh.tracktype]
	add cl,cl
	mov dl,[mountaintype]
	shr dl,cl
	and dl,3
	cmp dl,3
	mov cl,dh
	je .storeweight		// for realistic acceleration, store the weight instead

	xor edx,edx
	or ebp,ebp
	jz short .baddivision
	div ebp
	shl eax,2
	jnz short .goodaccel
	add eax,byte 1
.goodaccel:
	cmp eax,0xffff
	jb short .nottoolarge
	mov eax,0xffff
.nottoolarge:
	mov word [esi+veh.fullaccel],ax
	cmp ax,0xff
	jb short .nottoolargeforabyte
	mov ax,0xff
.nottoolargeforabyte:
	mov byte [esi+veh.acceleration],al
.baddivision:
	ret

.storeweight:
	// find weight of each individual vehicle (not the whole consist)
	push esi

	mov ebx,[cargoweightfactors]

.next:
	movzx eax,word [esi+veh.currentload]
	movzx edx,byte [esi+veh.cargotype]
	mov dl,[ebx+edx]

	imul eax,edx
	shr eax,4
	cmp eax,0x7fff
	ja .tooheavy

	movzx edx,byte [esi+veh.vehtype]
	add edx,[enginepowerstable]
	movzx dx,byte [edx+weightfrompower]
	add ax,dx
	jc .tooheavy

	cmp ah,0x7f
	jbe .nottooheavy

.tooheavy:
	mov ax,0x7fff

.nottooheavy:
	neg ax

	mov [esi+veh.fullweight],ax

	movzx esi,word [esi+veh.nextunitidx]
	cmp si,byte -1
	je .done
	shl esi,vehicleshift
	add esi,[veharrayptr]
	jmp .next
.done:
	pop esi
	ret

; endp calcaccel

	//
	// called when buying new rr vehicle. checks if
	// engine type is one of the waggons for this class
	//
	// in:	eax=class
	//	 bx=engine type
	// out:	cf if waggon
	// safe:eax,ecx
checknewtrainisengine:
	bt [isengine],bx
	jnb short .isgood

	// so in theory it's an engine. check ctrl
	mov eax,[esp+4]
	push dword [eax+6]
	call wantmultihead
	stc
	jnz short .isgood

	// ok, so ctrl is pressed -> treat it as a waggon
	testflags multihead	// but only if the multihead option is on (see patches.ah)
	cmc
.isgood:
	ret
; endp checknewtrainisengine

	// called when attaching a waggon
	// check if current vehicle is the second head of a train engine
	// (which it can only be if multihead is off)
	//
	// in:	esi=sprite type
	//	edi=vehicle
	// out:	zero flag if not second head
	// safe:eax esi edi
	//
attachwaggon:
	xchg eax,esi
	cmp al,0xfd	// fd=first head, fe="reversed" head, ff=second head
	jnb .gotit

	cmp word [dword eax+1],0
ovar railvehspriteofs, -5

.gotit:
	jz .notsecondhead

	// looks like a second head
	call isrealhumanplayer
	jnz .notsecondhead		// AIs never buy the second head separately

	// is multihead on?
	testflags multihead

	// now if carry we set zero; otherwise we clear zero
	cmc
	sbb al,al

.notsecondhead:
	ret
; endp attachwaggon


	// check if we want to buy an additional head
	// in single player: Ctrl is pressed
	// in multi player: engine exists in this depot
	//
	// in:	on stack=depot location
	// out: zf is multihead, nz if not
wantmultihead:
	cmp byte [numplayers],1
	jne short .multi

	push byte CTRL_DEFAULT
	call ctrlkeystate
	ret 4

.multi:
	push eax
	push ebx
	mov ebx,[esp+0xc]
	mov eax,[veharrayptr]

.donext:
	cmp byte [eax+veh.class],0x10
	jne short .nextveh
	cmp byte [eax+veh.subclass],0
	jne short .nextveh
	cmp word [eax+veh.XY],bx
	jne short .nextveh
	cmp byte [eax+veh.movementstat],0x80
	je short .done		// have a train in depot; zf set

.nextveh:
	sub eax,byte -veh_size
	cmp eax,[veharrayendptr]
	jb short .donext

	// no train found, it's not multihead: clear zf
	or al,1

.done:
	pop ebx
	pop eax
	ret 4
; endp wantmultihead 


	//
	// called when buying new rr vehicle, checks the
	// speed. if zero, it's a waggon
	//
	// in:	edx=engine type
	// out:	zr if waggon
	// safe:-
checknewtrainhasspeed:
	push ebx
	mov ebx,dword [enginepowerstable]
	cmp word [edx*2+ebx+speedfrompower],byte 0
	jz short .isgood

	// it's an engine
	mov ebx,ecx
	shl ebx,8
	or bx,ax
	shr ebx,4
	push ebx
	call wantmultihead
.isgood:
	pop ebx
	ret
; endp checknewtrainhasspeed 

	//
	// called when a rr vehicle is moved inside a depot window
	// in:	edx->last vehicle in consist
	//	flags from cmp [edx+veh.subclass],0
	// out:	cf set if edx->second engine
	// safe:eax,ebx,ecx,ebp
movedcheckiswaggonui:
	jz .done		// after a cmp, if zf=1 then cf=0

	testmultiflags multihead
	jnz .done

	movzx eax,word [edx+veh.vehtype]
	bt [isengine],eax

.done:
	ret

	// called when waggons are reordered
	// in:	edi->vehicle
	// out:	return regularly if it's a waggon, otherwise do a special jmp
	// safe:eax edx edi
movedcheckiswaggon:
	movzx eax,word [edi+veh.vehtype]
	bt [isengine],eax
	jc .isengine

.iswaggon:
	ret

.isengine:
	// it's an engine

	testflags multihead
	jnc .reallyisengine


	// first check if it is to be turned
	push esi
	movzx esi,word [edi+veh.vehtype]
	add esi,dword [enginepowerstable]

	// Ctrl determines which way the engine faces
	push byte CTRL_DEFAULT
	call ctrlkeystate
	mov ah,[esi+spritefrompower]
	setz al

	// if engine normally has two heads (or is a new sprite),
	// add 2 to sprite number
	// otherwise add 1 (always only if Ctrl key was pressed)
	cmp ah,0xfd
	jae .hasotherengine

	test byte [esi+numheadsfrompower],1
	jz short .hasnootherengine

.hasotherengine:
	add al,al

.hasnootherengine:
	add ah,al
	mov byte [edi+veh.spritetype],ah

	pop esi

	cmp dword [edi+veh.scheduleptr],byte -1
	je short .iswaggon

	// it's really an engine, return to somewhere else
.reallyisengine:
	mov dword [esp],0
ovar movedcheckiswaggonjump,-4	// location where to jump if it's not a waggon sprite
	ret

; endp movedcheckiswaggon

	//
	// called when displaying the train info window
	//
	// in:	esi=engine
	// out:	eax=power
	// safe:-
getoldpower:
	movzx eax,word [esi+veh.vehtype]
	shl eax,1
	add eax,dword [enginepowerstable]
	movzx eax,word [eax]
	ret
; endp getoldpower 


// Note: getrailvehiclebasevalue is a part of getvehiclebasevalue in servint.asm

// multiply EBX by EDX and shift the result to the right by 8 bits, overflow-safe
// destroys EDX
imulebxedxshr8:
	xchg eax,ebx
	imul edx
	shrd eax,edx,8
	xchg ebx,eax
	ret
; endp imulebxedxshr8 



// calculate train maintenance cost, allowing for multiple engines
// in:	esi=first engine
// out:	edx:eax=cost
proc trainmaintcost
	local cost1,cost2

	_enter

	push esi
	and dword [%$cost1],byte 0
	and dword [%$cost2],byte 0
	mov edi,dword [enginepowerstable]

.nextvehicle:
	movzx ebx,word [esi+veh.vehtype]
	bt dword [isengine],ebx
	jnc short .notengine

	movzx eax,byte [ebx+0x10000]
ovar trainmaintcostarray,-4

	mov dl,[edi+ebx+numheadsfrompower]

	mov ebx,[ebx*4 +0x10000]
ovar trainmaintbasecostarray,-4

	imul eax,dword [ebx]

	test dl,1
	jz short .onehead

	// two-heads have double the cost stored
	shr eax,1

.onehead:

	add [%$cost1],eax
	adc dword [%$cost2],byte 0

.notengine:
	movzx esi,word [esi+veh.nextunitidx]
	cmp si,byte -1
	je short .done
	shl esi,vehicleshift
	add esi,[veharrayptr]
	jmp .nextvehicle

.done:
	mov eax,[%$cost1]
	mov edx,[%$cost2]

	pop esi
	_ret
endproc // trainmaintcost

	// called when TTD decides what sound effect to play
	//
	// in:	esi=vehicle
	// out:	al=[esi+0x48]; cmp al,8
	// safe:eax ebx ecx edx edi ebp
decidesound:
	push eax

	movzx eax,word [esi+veh.vehtype]
	mov al,[trainsmoketype+eax]
	cmp al,8
	call $
ovar sounddecision,-4

	pop eax
	ret

	// called when a train vehicle enters a tunnel
	// steam engines should blow their whistle
	//
	// in:	edi=vehicle
	// safe:?
tunnelsound:
	push eax
	movzx eax,byte [edi+veh.vehtype]
	cmp byte [trainsmoketype+eax],8
	pop eax
	jb near $+6
ovar playtunnelsound,-4
	ret

	// called when TTD decides whether a train should
	// show steam, smoke or sparks
	//
	// in:	esi=first vehicle in consist
	// out:	esi
	//	carry must be set
	// safe:eax,ebx,(esi)
decidesmoke:
	push esi
	push edi
	mov edi,esi

.again:
	movzx ebx,word [esi+veh.vehtype]
	bt dword [isengine],ebx
	jnc .nextvehicle

	mov al,[trainsmoketype+ebx]
	mov ah,[edi+veh.modflags]
	and ah,1<<MOD_SHOWSMOKE		// 1<<MOD_SHOWSMOKE is 16
	xor ah,31			// so that ah is either 15 or 31

	// for now, always same amount of smoke, not doubled under pressure
	mov ah,31

	test byte [miscmodsflags+1],MISCMODS_MORESTEAM>>8
	jz .notmoresteam

	shr ah,2			// and now it's 7 or 15

.notmoresteam:
	// is a train engine; show appropriate effect
	push edi
	call $+5
ovar showsteamsmoke,-4
	pop edi

.nextvehicle:
	movzx esi,word [esi+veh.nextunitidx]
	cmp si,byte -1
	je short .done

	shl esi,7
	add esi,[veharrayptr]
	jmp .again

.done:
	pop edi
	pop esi
	and byte [esi+veh.modflags],~(1<<MOD_SHOWSMOKE)
	stc
	ret
; endp steamsmoke


	// find out whether we should show diesel smoke
	//
	// in:	esi=vehicle
	//	edi=engine
	// out:	carry=do not smoke
doesdieselsmoke:
	bt dword [edi+veh.modflags],MOD_SHOWSMOKE
	jc .gotit

	cmp word [edi+veh.speed],41
.gotit:
	cmc
	ret


	// calculate probability that an electric spark is emitted
	//
	// in:	same as above
	// out:	carry=do emit spark
sparkprobab:
	call [randomfn]
	test byte [edi+veh.modflags],1<<MOD_SHOWSMOKE
	jz .heavyduty

	cmp ax,0x5b0	// 2.22 % (regular)
	ret

.heavyduty:
	cmp ax,0x1c70	// 11.1 % (engine uses much power)
	ret


// make the AI buy both heads of dual-headed engines
// but humans only the first head
// in:	EDI -> first head
//	EBX = vehicle type
// out:	ZF set = don't buy second engine
// safe:ESI
buysecondengine:
	call isrealhumanplayer
	jz .done

	mov esi,[enginepowerstable]
	test byte [esi+numheadsfrompower+ebx],1

.done:
	ret
