
// Persistent engines


// Find all engines that are currently in use
// in:	ebp-100h=pointer to a memory chunk that's totalengines bytes large
//	(will be initialized automatically)
// out:	each of these bytes is 1 if that engine is in use, 0 otherwise
// destroys eax, ecx, esi
findusedengines:
	%define .engineuse ebp-totalvehtypes/8

		// clear @@engineuse array (can't use edi...)
	xor eax,eax
	lea ecx,[eax+totalvehtypes/4/8]	// mov ecx,... in 3 bytes
.clearnextengine:
	mov [.engineuse+ecx*4-4],eax
	loop .clearnextengine

		// now ecx=0, good for later.

		// determine engines that are in use
	mov esi,[veharrayptr]
.nextvehicle:
	mov eax,dword [esi+veh.class]
	cmp al,0x10
	jb short .vehicleloop
	cmp al,0x13
	ja short .vehicleloop
	jb short .notaplane

	// ignore airplane mail compartment and heli rotor
	cmp ah,4
	jae short .vehicleloop

.notaplane:
	mov cl,byte [esi+veh.vehtype]
	bts [.engineuse],ecx	// cool, bts automatically calculates the dword offset!

.vehicleloop:
	sub esi,byte -vehiclesize	//add esi,vehiclesize
	cmp esi,[veharrayendptr]
	jb .nextvehicle

	// assume all waggons are used
	mov cl,0
	movzx eax,byte [climate]
	mov esi,dword [vehtypedataptr]

.nextenginetype:
	bt dword [isengine],ecx
	jc short .skip

	// available in this climate?
	bt dword [esi+vehtypeinfo.climates],eax
	jnc short .skip

	// not an engine; assume the waggon is in use
	bts [.engineuse],ecx

.skip:
	add esi,byte vehtypeinfo_size
	inc cl
	jns short .nextenginetype	// no waggons above vehtype 115 anyway

	ret
; endp findusedengines 

	// called every month to determine new/outdated engines and
	// reliabilies
	//
	// safe to use: esi, eax, ebx, ecx
	// must set at exit: esi=enginestruct, cx=0
proc monthlyengineloop
	slocal engineuse,dword,totalvehtypes/4/8

	_enter

	call findusedengines

		// Engines that are used cannot get to within 2 years of the
		// end of their second phase.  If they are, set them back
	mov esi,vehtypearray
	push esi
	xor ecx,ecx
	push ecx
.nextengine:
	bt [%$engineuse],ecx
	jnc short .engineloop

		// this engine is in use, so check it
	mov ax,word [esi+vehtype.engineage]
	mov bx,word [esi+vehtype.durphase1]
	add bx,word [esi+vehtype.durphase2]
	sub bx,byte 24		// 2 years before
	cmp ax,bx
	jb short .engineloop	// not old enough yet
	mov word [esi+vehtype.engineage],bx	// set age back
	mov word [esi+vehtype.playeravail],-1
	and byte [esi+vehtype.availinfo],~ 3
	or byte [esi+vehtype.availinfo],1	// make it available if it wasn't

.engineloop:
	add esi,byte vehtype_size
	add cl,1
	jnc .nextengine			// 0x100 vehtypes

	pop ecx
	pop esi
	_ret
endproc // monthlyengineloop


// called when a new vehicle is available for exclusive testing
// skip the testing if it's a train waggon
//
// in:	cx=vehicle index
//	esi=index into vehtypearray
// out:	carry set if it's an engine
newvehavailable:
	or byte [esi+vehtype.inclimate],2
	mov byte [esi+vehtype.availinfo],1
	bt [isengine],cx
	ret

// called after a new vehicle announcement window has been set up
//
// in:	ebx=vehtype
// out:	 bx=text index (885B for engines, ourtext for wagons)
// safe:eax, ebx
shownewrailveh:
	bt [isengine],ebx
	jc .isok

	mov eax,[textrefstack+14]
	mov [textrefstack+6],eax

	// fix cost to use waggon base cost
	mov eax,dword [enginepowerstable]
	movzx eax,byte [eax+ebx+costfrompower]
	imul eax,[waggonbasevalue]
	shr eax,8
	mov [textrefstack],eax

	mov bx,ourtext(newwagoninfo)
	jmp short .iswagon

.isok:
	mov bx,0x885b

.iswagon:
	jmp near $+5
ovar doshownewrailveh, -4
