//
// plane motion patches
//

//
// called when plane moves
//
// in:	edi=vehicle ptr
// out:
// safe:eax,ebx,ecx,edx,esi,ebp
moveplane:
	cmp byte [edi+veh.subclass],2
	jna .realplane
	ret	// don't move shadows and rotors directly

.realplane:
	mov esi,edi
	call isplaneinflight
	sbb ecx,ecx
	and ecx,3
	inc ecx

	test byte [esi+veh.vehstatus],1<<7
	jz .domove

	// crashed plane, just process once
	mov cl,1

.domove:
	push ecx
	call $
ovar .doit, -4
	pop ecx
	loop .domove
	ret



//
// find effective plane speed
//
// in:	ax=plane speed after acceleration
//	bx=top speed
//	esi=vehicle ptr
//	flags from test[esi+veh.vehstatus],0x40
// out:	bx=effective top speed for motion
// safe:eax ebx
planebreakdownspeed:
	jnz .brokendown
	ret

.brokendown:
	// normally TTD just limits the speed to 27 = 216 mph
	// now we make that 5/8 of the top speed
	movzx ebx,bx
	lea ebx,[ebx*5]
	shr ebx,3
	ret


//
// decide whether plane is in air or on runway accelerating/decelarating
//
// in:	esi=vehicle ptr
// out:	carry set if in flight
// uses:--
isplaneinflight:
	push eax
	test byte [esi+veh.vehstatus],$80
	jnz .notinflight
	// in flight only if veh.aircraftop is 7..9 or >= 13
	mov al,[esi+veh.aircraftop]
	cmp al,7
	jb .notinflight
	cmp al,10
	jb .onrunway
	cmp al,13
	jb .notinflight
	cmp al,18	// 18:always in flight
	je .inflight

.onrunway:
	mov al,[esi+veh.movementstat]
		// not in flight unless movementstat is 13, 15, or 21+
		// for 13 and 21 only when facing in direction of runway
	cmp al,13
	jb .notinflight
	je .checkdirection

	cmp al,15
	je .checkdirection

	cmp al,21
	ja .inflight
	jb .notinflight

.checkdirection:
	cmp byte [esi+veh.direction],1
	je .inflight

.notinflight:
	clc
	pop eax
	ret

.inflight:
	stc
	pop eax
	ret
