
// New default service interval

	// called to find out whether a vehicle needs maintenance
	// -> fix "Y2K" bug if maintenance beyond 16 bit date
	//
	// in:	esi=vehicle offset
	// out:	CF|ZF=0 (cc=A) if not yet, 1 (cc=NA) otherwise
	// safe: (e)ax
needsmaintcheck:
	push ebx

	// see if there are any depots in the vehicle orders
	// if so, don't do maintenance otherwise

	mov ebx,dword [esi+veh.scheduleptr]
	mov ah,byte [esi+veh.totalorders]

	or ah,ah
	jz short .nocommands

.nextcommand:
	mov al,[ebx]
	and al,0x1f
	cmp al,2
	je short .itsadepot
	add ebx,byte 2
	dec ah
	jnz .nextcommand

.nocommands:

	call isittooold
	jna short .tooold

.normalcheck:
	movzx eax,word [esi+veh.lastmaintenance]
	movzx ebx,word [esi+veh.serviceinterval]
	add eax,ebx
	movzx ebx,word [currentdate]
	cmp eax,ebx

.done:
	pop ebx
	ret

.always:
	// always allow maintenance even if there's a depot in the orders
	push ebx
	jmp .nocommands

.itsadepot:
	cmp al,1
	pop ebx
	ret

.tooold:
	testflags forceautorenew
	jnc .normalcheck

	call isvehicleobsolete
	jna short .normalcheck	// engine is obsolete, send to depot only for maintenance

	mov al,0
	push edx
	push edi
	call dorenewconsist	// check how much it's going to cost
	pop edi
	pop edx
	call getvehicleownersdata
	cmp dword [eax+player.cash],ebx
	jl short .normalcheck	// not enough money, send to depot only for maintenance

	// OK, so the vehicle can be sent to depot for autorenewal

	stc			// satisfy the NA condition
	jmp short .done
; endp needsmaintcheck 


	// automatically replace engines when they get too old
	//
	// called just before an engine receives maintenance
	// in:	EDI -> vehicle struct
	// out:	AX = current date
autoreplacetrainorrv:
	xchg esi,edi
	call autoreplaceengine
	xchg esi,edi
	ret
; endp autoreplacetrainorrv 

	// in:	ESI -> vehicle struct
	// out:	AX = current date
autoreplaceengine:
	testflags autorenew
	jc .checkautorenew

	// just entered a depot, but without auto-renew
	// only update random sprites, and exit

	call .updaterandomsprite
	mov ax,[currentdate]
	ret

.checkautorenew:
	// check if manually sent to depot
	mov al,byte [esi+veh.currorder]
	and al,0x7f

	// want to skip age check with cf=zf=0 if al==42

	add al,(0x7f-0x42)
	add al,1		// will set OF if and only if AL was 42h after the AND above
	jo short .dontcheckage	// in this case AL==80h now, so CF=ZF=0

	call .updaterandomsprite
	call isittooold

.dontcheckage:
	mov ax,[currentdate]		// this is what this code replaces
	jna short .tooold
	ret

.updaterandomsprite:
	// update random triggers
	push esi
.updatenext:
	mov al,2
	call randomtrigger
	movzx esi,word [esi+veh.nextunitidx]
	cmp si,byte -1
	je .updatedone
	shl esi,vehicleshift
	add esi,[veharrayptr]
	jmp .updatenext

.updatedone:
	pop esi
	ret

.tooold:
	pusha

	call dword [getymd]
	mov cl,al

	call isvehicleobsolete
	jna short .nomoney

	mov al,0	// check first
	call dorenewconsist

	call getvehicleownersdata
	cmp dword [eax+player.cash],ebx
	jl short .nomoney	// not enough money

	mov al,byte [esi+veh.owner]
	mov byte [currentexpensetype],expenses_newvehs
	call addexpensestoplayer

	mov al,1
	call dorenewconsist

	or ebx,ebx
	jz short .nomoney	// show no cost, it's zero anyway

	movzx eax,word [esi+veh.xpos]
	movzx ecx,word [esi+veh.ypos]
	call dword [makerisingcost]

.nomoney:
	popa
	ret
; endp autoreplaceengine 


	// calculate cost and do the renewing
	// in:	esi -> engine
	//	al = 0 if checking cost, 1 if renewing
	//	cl = current year (used only if al!=0)
	// out:	ebx,edi = cost
	// uses:edx
dorenewconsist:
	push esi
	xor edi,edi	// cost

	// so we need to replace this engine and the waggons too

.vehicleloop:
	call getvehiclecost

	// now add to cost but subtract current value to get the difference
	add edi,edx
	sub edi,dword [esi+veh.value]

	or al,al
	je short .nextvehicle	// just checking cost

	mov dword [esi+veh.value],edx
	mov word [esi+veh.age],0
	mov byte [esi+veh.yearbuilt],cl

	bt dword [isengine],ebx
	jnc short .nextvehicle

	// reset reliability decay speed (note, getvehiclecost sets ebx=enginetype)
	imul ebx,byte vehtype_size
	add ebx,vehtypearray
	mov bx,word [ebx+vehtype.reliabdecrease]
	mov word [esi+veh.reliabilityspeed],bx

	// reset breakdown counters
	mov byte [esi+veh.breakdownthreshold],0

	// reset depreciation counter
	mov byte [esi+veh.daycounter],0

.nextvehicle:
	// process waggons only if it's a train (duh)
	cmp byte [esi+veh.class],0x10
	jne short .done

	movzx esi,word [esi+veh.nextunitidx]
	cmp si,byte -1
	je short .done
	shl esi,vehicleshift
	add esi,[veharrayptr]
	jmp .vehicleloop

.done:
	mov ebx,edi
	pop esi
	ret
; endp dorenewconsist 


	// determines whether an engines is too old and needs to
	// be replaced automatically
	// in:	esi=vehicle pointer
	// out:	CF=ZF=0(cc=A):not too old; cc=NA:too old
	// uses:ax
isittooold:
	testflags autorenew
	// !! testflags expands to BT, which leaves ZF undefined !!
	jc short .checkage
	or al,1		// CF=ZF=0
	ret

.checkage:
	mov al,byte [replaceage]
	mov ah,30	// 30 days per month
	imul ah
	add ax,word [esi+veh.maxage]
	cmp ax,word [esi+veh.age]
	ret
; endp isittooold 


	// determines whether an engine is getting (or already has got) obsolete
	// (in which case it's not a good idea to renew it automatically)
	// in:	ESI -> vehicle pointer
	// out:	CF|ZF=1 (cc=NA) if obsolete, cc=A otherwise
	// uses:AX,EBX
isvehicleobsolete:
	movzx ebx,word [esi+veh.vehtype]
	imul ebx,byte vehtype_size
	add ebx,vehtypearray
	mov ax,word [ebx+vehtype.durphase1]
	add ax,word [ebx+vehtype.durphase2]
	sub ax,12		// max. 1 year before phase 3
	cmp ax,word [ebx+vehtype.engineage]
	ret
; endp isvehicleobsolete 



var vehiclebasevaluepointers
	dd roadvehbasevalue
	dd shipbasevalue
	dd aircraftbasevalue

// get base value of a vehicle
// in:	 esi -> vehicle
//	 ebx = word [esi+46h]  (enginetype)
// out:  edx = base value
// 	 eax = [esi.vehicletype]
getvehiclebasevalue:
	movzx eax,byte [esi+veh.class]

// use this entry point if EAX aready set
// does not need ESI
getvehiclebasevalueentry2:
	cmp al,0x10
	jne short getrailvehiclebasevalue.notrailvehicle

// railway vehicle, determine whether it's engine or waggon
// does not need EAX either
getrailvehiclebasevalue:
	bt dword [isengine],ebx
	jnc short .iswaggon

	// engine, check if it's two-headed
	mov edx,dword [enginepowerstable]
	test byte [edx+ebx+numheadsfrompower],1
	mov edx,[enginebasevalue]
	jnz short .twoheaded
	ret
.twoheaded:
	sar edx,1
	ret

.iswaggon:
	mov edx,[waggonbasevalue]
	ret

.notrailvehicle:
	mov edx,dword [vehiclebasevaluepointers+(eax-0x11)*4]
	mov edx,[edx]
	ret
; endp getvehiclebasevalue 


// get cost multiplier of a vehicle
// in:	 eax = vehicle type
//	 ebx = engine type
// out:  eax = cost multiplier
// note: final cost = (base value)*(multiplier)/256
getvehiclecostmult:
	mov eax,dword [vehiclecosttables+(eax-0x10)*4]
	movzx eax,byte [ebx+eax]
	ret
; endp getvehiclecostmult 


// get cost of a vehicle
// in:	 esi -> vehicle
// out:	 edx = cost
//	 ebx = [esi.enginetype]
// Note: does not check vehicle type, do not use on special vehicles like plane's mail compartment
getvehiclecost:
	push eax
	movzx ebx,word [esi+veh.vehtype]
	call getvehiclebasevalue
	call getvehiclecostmult
	imul edx
	shrd eax,edx,8
	mov edx,eax
	pop eax
	ret
; endp getvehiclecost 


// get pointer to the vehicle owner's structure
// in:	esi -> vehicle
// out:	eax -> player struct
// uses:-
getvehicleownersdata:
	movzx eax,byte [esi+veh.owner]
	imul eax,player_size
	add eax,[playerarrayptr]
	ret
; endp getvehicleownersdata 
