
// subsidiary management
// when owner of 75% of shares clicks on HQ, take over company
// temporarily

// called when "view HQ" or "build HQ" button is pressed
// in:	ebx=player struct of player whose window is open
//	esi=window struct; [esi+6]=player whose window this is
// out:	carry if the company was taken over
//	otherwise, result of cmp [ebx.hqlocation],-1
// safe:eax ecx edx

clickhq:
	xor edx,edx

	push ecx
	param_call ishumanplayer,PL_RETURNCURRENT
	mov eax,ecx
	pop ecx

	jnz short .done

	adc edx,byte 0

	call countshares

	mov cl,[esi+6]
	mov ch,[landscape3+ttdpatchdata.orgpl1+edx]

	// is it maybe the player going back to his original company?
	cmp cl,ch
	je short .goingback

	// no, so see if he owns 75%
	cmp ah,3
	jb short .done

	// yes it's a takeover
	mov al,[esi+6]

.setplayer:
	mov [human1+edx],al
	call redrawscreen
	stc
	ret

	// only going back if org.player is not same as current player
.goingback:
	mov al,ch
	cmp [human1+edx],al
	jne short .setplayer

.done:
	cmp word [ebx+player.hqlocation],byte -1		// was overwritten by call
	clc
	ret
; endp clickhq 


// counts shares current player owns from player stored at ebx
// in:	al=curplayer
//	ebx=player window
// out:	ah=number of shares
// destroys ecx

countshares:
	mov ah,0
	xor ecx,ecx

.nextshare:
	cmp byte [ebx+player.shareowners+ecx],al
	jne short .notowner

	inc ah

.notowner:
	inc ecx
	cmp cl,4
	jb short .nextshare
	ret
; endp countshares 

	align 4
uvard playerwndbase
uvarb manageaiwindow,0x79


// called whenever a player window is redrawn
//
// in:	esi=windows struct
//	ebx=player
// out: no zero flag
// safe:eax ecx edx
redrawplayerwindow:
	mov al,[human1]
	mov ah,[landscape3+ttdpatchdata.orgpl1]

	mov edx,dword [playerwndbase]		// Human Player, "View HQ"

	cmp al,[esi+6]
	je short .ishuman

	cmp ah,[esi+6]
	je short .domanage

	add edx,byte 0x61				// AI Player, "View HQ"

	// is an AI company; can we take it over?

	call countshares
	cmp ah,3

	jb short .nope

.domanage:
	mov edx,manageaiwindow	// AI Player, "Manage"

.nope:
	mov [esi+0x24],edx
	jmp short .done

.ishuman:
	// decide whether to show "Build HQ" or "View HQ"
	cmp word [ebx+player.hqlocation],byte -1
	jne short .setit

	sub edx,byte 0x61				// Human Player, "Build HQ"

.setit:
	mov [esi+0x24],edx

.done:
	or al,1
	ret
; endp redrawplayerwindow 
