//
// Show vehicle speed in vehicle caption
//



// Makes text handler use our own string and sets up the data array

// in:	?
// out:	bx=text number, edi as in TTD code
// safe:bx,ebp

trainspeed:
	mov ebp,textrefstack
	cmp bh,0xa0
	je short .hangarspeed
	cmp bh,0x90	// bx=9017: Road Depot; 981B: Ship Depot; A013: Hangar
	jae short .otherdepotspeed
	cmp bl,0x10	// bx=8810: Heading for (station)
	je short .stationspeed
	cmp bl,0x11	// bx=8811: Heading for (depot)
	je short .traindepotspeed
	cmp bl,0x22	// bx=8822: No orders
	je short .noorderspeed

.done:
	mov edi,0
ovar trainspeed_edi,-4
	jmp $+256	// to force tasm to generate a far jump
ovar trainspeed_dest,-4

.hangarspeed:
	add ebp,byte 2	// otherwise the same as other hangars

.otherdepotspeed:
	add ebp,byte 6
	shr ebx,11
	and ebx,byte 7	// now ebx=2 for road; 3 for ship; 4 for hangar
	add ebx,ourtext(headingfordepot2)-2
	jmp short .changeitkeepbx

.noorderspeed:
	mov [ebp],bx		// show text "No orders" as destination
	add ebp,byte 2
	jmp short .changeit

.stationspeed:
	add ebp,byte 2

.traindepotspeed:
	add ebp,byte 6	// the adds are cumulative so that this is 8 really

.changeit:
	and bx,byte 1	// show first "headingfor" text for 8810, 8822 and the
			// second one for 8811
	add bx,ourtext(headingfor)

.changeitkeepbx:
	push ebx

	push edi
	call getspeed
	pop dword [ebp]	// store speed for text handler

	push eax

	and dword [ebp+2],0

	cmp byte [edi+veh.vehtype],ROADVEHBASE
	jae .dontshow

	mov ah,cl
	mov cl,[edi+veh.tracktype]
	add cl,cl
	mov al,[mountaintype]
	shr al,cl
	and al,3
	cmp al,3
	mov cl,ah
	jne .notrealistic

	// calculate tractive effort and acceleration
	push dword [edi+veh.speed]
	xchg esi,edi
	call trainaccelerate
	xchg esi,edi
	pop dword [edi+veh.speed]

	mov eax,[lasttractiveeffort]
	shr eax,8
	mov [ebp+2],ax
	imul eax,[lastaccel],100
	jmp short .showaccel

.notrealistic:
	movzx eax,word [edi+veh.fullaccel]
	test eax,eax
	jnz .ok
	mov al,[edi+veh.acceleration]
.ok:
	imul eax,50		// not 100 because realistic accel. is *2

.showaccel:
	sar eax,8
	mov [ebp+4],ax

.dontshow:
	mov al,[ebp]
	sub al,[ebp+2]
	sub al,[ebp+4]		// refresh window if any of speed, TE, or acc changes

.checkspeed:
	cmp al,[edi+veh.lastspeed]
	je .nochange

.alwaysshow:
	mov [edi+veh.lastspeed],al

	mov ax,0x48d		// invalidate and redraw status bar
	mov bx,word [edi+veh.idx]
	call dword [invalidatehandle]

.nochange:

	pop eax
	pop ebx
	jmp .done

; endp trainspeed

var speedfactors, db 3,4,4,2

// Calculates the speed of a vehicle
// It needs to be divided by 1.6 as well as taken *2 for planes
// Calling syntax:
//	push <vehicle-offset>
//	call getspeed
//	pop <speed>
// i.e. the speed is left at the top of the stack to be popped into where
// ever you need it.  This makes it safe to use this function even when no
// registers are safe to overwrite.
getspeed:
	enter 0,0
	pusha
	mov esi,[ebp+8]

	movzx eax,byte [esi+veh.class]
	cmp al,0x10
	jne short .notrain

	// if [esi+loadtime] is not zero, the train is waiting for something
	// in such a case the speed is cycling wildly but is really zero
	cmp word [esi+veh.loadtime],byte 0
	jne short .waiting
	cmp byte [esi+0x62],0x80	// check if in depot
	jne short .notwaiting

.waiting:
	xor ebx,ebx
	jmp short .done

.notrain:
.notwaiting:
	movzx ebx,word [esi+veh.speed]
	cmp al,0x13
	jne short .noplane
	call isplaneinflight	// planes in flight have a totally different formula
	jc .airplaneinflight

.noplane:
	mov cl,byte [speedfactors+eax-0x10]
	mov eax,ebx
	shl ebx,2		// convert to mph ( = speed*5/8 )
	add ebx,eax
	shr ebx,cl

.done:
	mov [ebp+8],ebx
	popa
	leave
	ret

.airplaneinflight:
	shl ebx,3
	jmp .done
; endp getspeed 
