//
// new sprites for all vehicles, if available
//

// called when TTD decides which sprite should be used for any
// particular type of orientation and spritenum of a ship
// in:	esi=vehicle
//	edi=sprite id
//	bx=direction
// out:	bx=sprite number
// safe:edi
getshipsprite:
	call getsprite1
	jnc .gotit

	add edi,[orgshipspritebase]
	add bx,[edi]
.gotit:
	ret

// same but for trains
//
// out:	carry set if TTD needs to do the final three adjustments to bx
// safe:eax ebx; *not* edi
gettrainsprite:
	xor edi,2		// swap fd and ff
	push edi
	call getsprite1
	jnc .gotit

	pop eax
	cmp edi,eax
	jne .dontxor		// if we had fd/ff and got a default sprite

	xor edi,2

.dontxor:
	// fake multiheads have an odd sprite number
	btr edi,0		// need bt not test to get bit value in carry flag
	sbb eax,eax		// now eax=0 if not fake multihead, or -1 if it is
	lea bx,[ebx+eax*4]	// now add 0 or -4 (which is the same as +4 here because of the "and" below)

	mov eax,[orgtrainspritebase]

	add bx,[eax+edi]	// flip multihead
	and bx,[eax+edi-0x94]	// mask symmetric engines

	stc
	ret

.gotit:
	pop edi
	xor edi,2
	ret

// and the road vehicles
//
// out:	flags for "ja" if we have new sprites or veh. is full
getrvsprite:
	call getsprite1
	ja .gotit

	mov eax,[orgrvspritebase]

	add bx,[eax+edi]

	mov ax,[esi+veh.capacity]
	shr ax,1
	cmp ax,[esi+veh.currentload]

.gotit:
	ret

// and planes
getplanesprite:
	call getsprite1
	jnc .gotit

	add edi,[orgplanespritebase]
	add bx,[edi]

.gotit:
	ret

getshadowsprite:
	push esi
	mov esi,[esp+8]
	call getplanesprite
	pop esi
	ret

// called when displaying a ship in the purchase list
// similar as above, but using ax instead of bx, and
// ebx instead of edi
//
// in:	ebx=spritenum
//	ebp=enginenum
//	ax=direction
// out:	ax=spritebase+direction
// safe:ebp
displayship:
	call getsprite2
	jnc .gotit

	add ebx,[orgshipspritebase]
	add ax,[ebx]
.gotit:
	ret

// and the first train engine
display1stengine:
	xor ebx,2		// swap fd and ff
	push ebx
	call getsprite2
	jnc .gotit

	cmp ebx,[esp]
	jne .dontxor		// if we had fd/ff and got a default sprite

	xor ebx,2
.dontxor:

	add ebx,[orgtrainspritebase]
	and ax,[ebx-0x94]
	add ax,[ebx+0x94]

.gotit:
	pop ebx
	xor ebx,2
	ret

// and the second train engine (if any)
display2ndengine:
	push ebx

	call getsprite2
	jnc .gotit

	add ebx,[orgtrainspritebase]
	add ax,[ebx+2]
	and ax,[ebx+2-0x94]
	add ax,[ebx+2+0x94]

.gotit:
	pop ebx
	ret

// and road vehicles
displayrv:
	call getsprite2
	jnc .gotit

	add ebx,[orgrvspritebase]
	add ax,[ebx]

.gotit:
	ret


// and planes
displayplane:
	call getsprite2
	jnc .gotit

	add ebx,[orgplanespritebase]
	add ax,[ebx]

.gotit:
	ret


// called by all vehicle sprite handlers
//
// in:	esi=vehicle
//	edi=sprite id
//	bx=direction
//
// out:	carry set: couldn't get new sprite, use old one
//	carry clear: use new sprite
//	if carry set, edi=new sprite id
//	if carry clear, bx=new sprite number
getsprite1:
	cmp edi,0xfd
	je short .newspritereversed
	ja short .newsprites
	ret

.newspritereversed:
	xor bl,4

.newsprites:
	push eax

	movzx eax,byte [esi+veh.vehtype]
	call getnewsprite
	jc short .badsprite

	add bx,ax
	pop eax
	ret

	// uh oh, vehicle has sprite FD..FF but there are no new graphics...
.badsprite:
	pop eax
	movzx edi,word [esi+veh.vehtype]
	movzx edi,byte [defvehsprites+edi]

	// must have carry set here!
	ret

// same as getsprite1 but for the display handlers
//
// in:	ebx=spritenum
//	ebp=enginenum
//	ax=direction
// out:	ax=spritebase+direction
getsprite2:
	cmp bl,0xfd
	je .newspritereversed
	ja .newsprites
	ret

.newspritereversed:
	xor al,4

.newsprites:
	push ebx
	push esi

	mov ebx,eax	// direction
	mov eax,ebp	// veh.type
	xor esi,esi	// no vehicle

	call getnewsprite

	pop esi

	// now ax=sprite base, bx=new (or old) direction

	jc short .badsprite

	add ax,bx
	pop ebx
	ret

.badsprite:
	mov eax,ebx
	pop ebx
	movzx ebx,byte [defvehsprites+ebp]

	// must have carry set here!
	ret
; endp getsprite2



// display rotor for heli in hangar
//
// in:	edi=rotor vehicle
// out:	bx=rotor sprite base
disprotor1:
	xchg edi,esi
	call getrotorsprite
	sub dx,5
	xchg edi,esi
	ret

// display rotor for heli in purchase list or new or exclusive vehicle message
//
// in:	ebp=vehtype
// out:	bx=rotor sprite base
disprotor2:
	push esi
	xor esi,esi
	mov eax,ebp
	call getrotorsprite
	pop esi
	sub dx,5
	ret

// check if rotor slowing down is in right position to stop
//
// in:	esi=rotor vehicle
// out:	cmp esi+veh.cursprite,stop position
checkrotor:
	call getrotorsprite
	lea ax,[eax+ebx-1]
	cmp [esi+veh.cursprite],ax
	ret

// initialize sprite for newly bought vehicle
//
// in:	esi=rotor vehicle
// out:	bx=rotor sprite base
initrotor:
	push ebx
	call getrotorsprite
	mov [esi+veh.cursprite],bx
	pop ebx
	ret

// slowly stop rotor
// in, out: same
stoprotor:
	call getrotorsprite
	cmp bx,[esi+veh.cursprite]
	ret

// and advance rotor to next sprite
// in, out: same
advancerotor:
	call checkrotor
	jb .doinc

	inc bx
	ret

.doinc:
	mov bx,[esi+veh.cursprite]
	inc bx
	ret

getrotorsprite:
	test esi,esi
	jz .checkrotor

	push esi
	movzx esi,word [esi+veh.engineidx]
	shl esi,7
	add esi,[veharrayptr]
	movzx eax,byte [esi+veh.vehtype]
	pop esi

.checkrotor:
	cmp byte [wagonoverride+eax],0
	jne .isnewsprite

.regsprite:
	mov bx,0xf3d
	mov ax,4
	ret

.isnewsprite:
	bts esi,31
	mov bh,-1
	call getnewsprite
	jc .regsprite
	xchg ax,bx
	ret


	// figure out the actual sprite
	// in:
	//	eax=engine type
	//	 bx=direction
	//	esi=vehicle struct or 0 if none available
	//
	// out:	ax=new sprite base
	// 	carry flag set if these sprites aren't actually available

getnewsprite:
	push edx
	push ecx
	push ebx
#if !WINTTDX
	push es		// we need to set ES properly
	push ds
	pop es
#endif
	cmp byte [wagonoverride+eax],1
	je .wagonoverride
	ja .rotoroverride

.nooverride:
	mov edx,[vehids+eax*8+4]
	mov eax,[vehids+eax*8]
	test eax,eax
	jg near .havedata	// jump if not zero and SF==OF (overflow=zero from "or")

	// data isn't actually available, must be bogus sprite number
.baddata:
#if !WINTTDX
	pop es
#endif
	pop ebx
	pop ecx
	pop edx
	stc
	ret

	// override for helicopter rotor
	// get rotor graphics if esi has sign bit set
	// use regular engine graphics if esi is empty or an engine
.rotoroverride:
	btr esi,31
	jnc .nooverride

	mov ebx,eax
	jmp short .dooverride


	// wagon override bit was set
	// see if the current engine has an override and if so,
	// use it instead of the current cargo ID
.wagonoverride:
	test esi,esi
	jz .nooverride

	movzx ebx,word [esi+veh.engineidx]
	shl ebx,vehicleshift
	add ebx,[veharrayptr]
	movzx ebx,word [ebx+veh.vehtype]

.dooverride:
	mov edx,[vehids+ebx*8+4]
	mov ebx,[vehids+ebx*8]
	test ebx,ebx
	jle .nooverride		// engine has no special graphics

	movzx ecx,word [ebx-5]
	mov bl,[ebx-3]
	xor bl,0x80
	js .nooverride		// no override for this engine

	// ok, so we have an override; the engine sprite number is
	// in ecx and the number of override action 3 entries is in bl

	push esi

	mov esi,[edx+spriteblock.spritelist]
	push edi
	push eax
	lea esi,[esi+ecx*4]
	mov edi,[esi]
	test edi,edi
	jle .isbad

	movzx edi,byte [edi+1]	// veh class
	sub al,[vehbase+edi]			// search for id in class

.trynextaction:
	add esi,4
	mov edi,[esi]
	test edi,edi
	jg .notbad

.isbad:
	pop eax
	pop edi
	pop esi
	jmp .nooverride

.notbad:
	movzx ecx,byte [edi-4]
	add edi,3

	repne scasb
	je .gotit

	dec bl
	jnz .trynextaction
	jmp .isbad

.gotit:
	pop eax
	mov eax,[esi]
	pop edi
	inc eax
	pop esi
	inc eax

.havedata:
	movzx ebx,byte [eax-6]
	inc eax
	add eax,ebx
	//
	// now eax-1 points to veh.ID=>cargo ID mapping
	// [eax]=number of cargo types
	// [eax+1+n*3]=cargo type	(n=0..num-1)
	// [eax+2+n*3]=cargo ID
	// [eax+1+num*3]=default ID
	//
	mov bl,0xff		// bl = climate-corrected cargo type
	test esi,esi
	jz short .usedefault

	movzx ebx,byte [climate]
	lea ebx,[ebx+ebx*2]		// need to multiply by 12 = 3*4
	movzx ecx,byte [esi+veh.cargotype]
	mov bl,[cargotypes+ebx*4+ecx]

.usedefault:
	movzx ecx,byte [eax]
	jecxz .foundit		// only the default; no others available

	inc eax

.nextcargo:
	cmp bl,[eax]
	je short .foundit
	add eax,3
	loop .nextcargo

	dec eax

.foundit:
	movzx ebx,word [eax+1]

.gotcargoid:
	// now ebx = cargo ID sprite number
	//
	// follow randomized and variational cargo IDs until
	// we reach a real cargo ID
	//
	mov eax,[edx+spriteblock.spritelist]
	test eax,eax
	jle .baddata

	mov ebx,[eax+ebx*4]

	test ebx,ebx
	jle .baddata

	mov al,[ebx+3]
	sub al,0x80
	jb .gottheid
	ja .variational

.regrandom:
	push esi

.random:	// random cargo ID
	xor eax,eax
	test esi,esi
	jz .firstrandom

	mov al,[esi+veh.vehtype]
	mov cl,[ebx+4]
	mov [randomtriggers+eax],cl	// record current triggers

	mov al,[esi+veh.random]
	mov cl,[ebx+5]
	shr al,cl
	and al,[ebx+6]

.firstrandom:
	movzx ebx,word [ebx+7+eax*2]
	pop esi
	jmp .gotcargoid

.enginerandom:
	test esi,esi
	jz .regrandom

	push esi
	movzx esi,word [esi+veh.engineidx]
	shl esi,vehicleshift
	add esi,[veharrayptr]
	jmp .random

.variational:	// variational cargo ID
	cmp al,2	// 80 subtracted already; 82 was engine variational
	jb .regvariational
	ja .enginerandom	// and 83 is engine random

	test esi,esi
	jnz .variationalengine	// no vehicle, ergo no engine either!

.regvariational:
	call getvariational
	jmp .gotcargoid

.variationalengine:
	push esi
	movzx esi,word [esi+veh.engineidx]
	shl esi,vehicleshift
	add esi,[veharrayptr]
	call getvariational
	pop esi
	jmp .gotcargoid

.gottheid:
	// see if direction is special (e.g. rotor)
	test byte [esp+5-4*WINTTDX],0x80
	jz .notspecialdir

	// it's special, we only return the sprite base and the number of sprites
	mov ax,[ebx+5]
	movzx cx,byte [ebx-1]

#if !WINTTDX
	pop es
#endif

	pop ebx
	lea cx,[eax+ecx+2]		// upper bits of eax undefined, so set cx only
	cmp [numactsprites],cx		// sets carry if cx is too large
					// also zero must be clear
	pop ecx
	pop edx
	ret

.notspecialdir:
	// now ebx=pointer to sprite with cargo ID definition
	movzx ecx,byte [ebx-1]
	push ecx	// store AND mask for later

	add ebx,3	// skip action, veh-type, and cargo-id

	mov cl,[ebx]
	inc ebx

	test esi,esi
	jz short .noload

	movzx eax,word [esi+veh.engineidx]
	shl eax,vehicleshift
	add eax,[veharrayptr]
	cmp byte [eax+veh.totalorders],0
	je short .notloading

	mov al,byte [eax+veh.currorder]
	and al,0x1f

	cmp al,3
	jne short .notloading

	mov eax,ecx
	mov cl,[ebx]
	lea ebx,[ebx+2*eax]	// skip load states in motion

.notloading:
	movzx eax,word [esi+veh.capacity]
	cdq
	jecxz .nodiv
	idiv ecx
.nodiv:
	mov ecx,eax
	mov eax,edx	// rounding error

	add eax,ecx

		// now eax=capacity/divisions + modulus
		// ecx=capacity/divisions
		// so that eax + divisions * ecx is equal to capacity

	inc ebx

.nextstage:
	cmp word [esi+veh.currentload],ax
	jle short .done

	add ebx,byte 2
	add eax,ecx
	jmp .nextstage

.noload:		// if load info not available, use max. load
			// here, ebx points to <num-loadingtypes>
	lea ebx,[ebx+1+ecx*2]

.done:
	mov ax,[ebx]
	lea bx,[eax+1]
	cmp [numactsprites],bx		// sets carry if bx is too large
					// also zero must be clear
	pop ecx
#if !WINTTDX
	pop es
#endif
	pop ebx
	jb .notgood

	and ebx,ecx		// apply AND mask to direction, but only
				// if the sprite was valid
.notgood:
	pop ecx
	pop edx
	ret
; endp getnewsprite

	// find variational cargo ID from list
	// in:	ebx=variation cargo ID definition
	//	esi=vehicle or 0 if none
	// out:	ebx=new cargo ID sprite number
	// safe:eax ebx ecx

getvariational:
	add ebx,8
	movzx eax,byte [ebx-4]	// variable
	test al,al
	jns .externalvar

	test esi,esi
	jz .gotrange

	mov eax,[esi+eax-0x80]
	jmp short .gotval

.externalvar:
	mov eax,[externalvars+eax*4]
	mov eax,[eax]

.gotval:
	mov cl,[ebx-3]
	shr eax,cl
	and al,[ebx-2]

	movzx ecx,byte [ebx-1]

.nextrange:
	cmp al,[ebx+2]
	jb .toolow
	cmp al,[ebx+3]
	jbe .gotrange

.toolow:
	add ebx,4
	loop .nextrange

.gotrange:
	movzx ebx,word [ebx]
	ret

	// process data for special ship properties
	// in:	eax=special prop-num
	//	ebx=offset
	//	ecx=num-info
	//	esi=data
	// out:	-
	// safe:eax ebx ecx edx edi

procshipdata:
	// ship refit cargo

	lea edi,[newrefit+(ebx+SHIPBASE-ROADVEHBASE)*4]
	rep movsd
	ret
; endp procshipdata

	// Same but for trains
proctraindata:
	cmp al,0x1A
	je .shuffle

	adc al,-0x1A	// now 19 => 0, 1B => 1, 1C => 2 etc.
	mov ah,NTRAINTYPES
	mul ah

	lea edi,[trainsmoketype+ebx+eax]

	rep movsb
	ret

.shuffle:
	// shuffle vehicle

.shufflenext:
	push ecx

	lodsb

	push esi

#if 0
	// this doesn't quite work yet
	// should consider each track type separately, also waggons and
	// engines separately
	// maybe I won't make this possible after all because it's so complicated
	cmp al,0xff
	jne .gotit

	push ebx

	// find place to insert from date of introduction (sort by date)
	imul ebx,vehtypeinfo_size
	mov esi,[vehtypedataptr]
	mov bx,[esi+ebx+vehtypeinfo.baseintrodate]	// bx=cur veh intro date
	mov cl,NTRAINTYPES
	mov ch,cl
	xor edx,edx

	// find smallest baseintrodate which is above bx

	or eax,byte -1
.checknext:
	bt [isengine],edx
	jnc .findnext		// skip waggons

	cmp [esi+vehtypeinfo.baseintrodate],bx
	jb .findnext

	cmp [esi+vehtypeinfo.baseintrodate],ax
	ja .findnext

	mov ax,[esi+vehtypeinfo.baseintrodate]
	mov ch,cl

.findnext:
	inc edx
	add esi,vehtypeinfo_size
	dec cl
	jnz .checknext

	xor eax,eax
	xchg al,ch

	pop ebx

.gotit:
#endif
	mov ah,al

	call doshufflevehicle

	pop esi
	pop ecx
	inc ebx
	loop .shufflenext
	ret

proc doshufflevehicle
	slocal tablecopy,byte,NTRAINTYPES

	_enter

	// make copy of sort table on stack to avoid problem of copy directions

	mov esi,vehsorttable
	push esi
	lea edi,[%$tablecopy]
	push edi

	mov cl,NTRAINTYPES
	rep movsb

	pop esi		// pop in reverse order
	pop edi

	// now bl=vehicle ID to move, ah=vehicle ID before which to insert
	//     esi=%$tablecopy, edi=vehsorttable

	mov cl,NTRAINTYPES

.shufflenextveh:
	lodsb

	cmp al,ah
	jne .notinsert

	mov [edi],bl		// insert vehicle here
	inc edi

.notinsert:
	cmp al,bl
	je .doremove		// remove from where it was

	stosb

.doremove:
	loop .shufflenextveh

	_ret
endproc


	// And the road vehicles
procrvdata:
	cmp al,0x16
	jne .notdword
	shl ecx,2
	shl ebx,2
.notdword:
	sub al,0x13
	mov ah,NROADVEHTYPES
	imul ah
	lea edi,[rvpowers+eax+ebx]

	rep movsb
	ret


	// go through all ships, figure out the valid cargo types, and if
	// there is more than one, make the ship refittable
shipsrefittable:
	testflags newships
	jc short .isnewships
	ret

.isnewships:
	pusha

	xor edi,edi
	mov esi,dword [specificpropertybase+2*4]
	add esi,byte NSHIPTYPES

	movzx edx,byte [climate]
	mov ebx,dword [scenariocargo+edx*4]
	imul edx,byte 12

.nextship:
	xor eax,eax

	cmp [esi+edi],al
	je .goodcargo	// not refittable

	mov ebp,dword [newrefit+(edi+SHIPBASE-ROADVEHBASE)*4]
	and ebp,ebx

	// count number of bits set
	lea ecx,[eax+32]

	push ebp
.nextbit:
	shr ebp,1
	adc al,0
	loop .nextbit

	pop ebp

	cmp al,1
	seta byte [esi+edi]

	mov al,byte [esi+edi+NSHIPTYPES*3]
	mov al,byte [cargotypes+edx+eax]
	bt ebp,eax

	jc short .goodcargo

	// the default cargo is not available in this climate
	bsf eax,ebp
	mov al,byte [cargoid+eax]
	mov [esi+edi+NSHIPTYPES*3],al

.goodcargo:
	inc edi
	cmp edi,byte NSHIPTYPES
	jb .nextship

	popa
	ret
; endp shipsrefittable


	// called when redrawing a ship refitting window
	// in:	esi=window handle; [esi+6] = veh.
	//	ebp=climate
	// out:	ebp=something to use in shiprefitnextcargo below
	// safe:eax,ebx
initshiprefit:
	movzx eax,word [esi+6]
	shl eax,7
	add eax,[veharrayptr]
	movzx eax,word [eax+veh.vehtype]
	mov eax,[newrefit+(eax-ROADVEHBASE)*4]
	and eax,[scenariocargo+ebp*4]
	mov dword [currentshiprefitting],eax
	xor ebp,ebp
	ret
; endp initshiprefit

	// called when drawing the next available refitting cargo
	// in:	esi=window handle
	//	ebp from initshiprefit; incremented after each call
	// out:	al=new cargo type, of ff if no more
	//	zero flag if no more
shiprefitnextcargo:

.nextcargo:
	shr dword [currentshiprefitting],1
	jc short .gotit
	jz short .done

	inc ebp
	jmp .nextcargo

.done:
	mov al,-1
	ret

.gotit:
	mov eax,ebp			// clears higher bits of eax
	mov al,byte [cargoid+eax]
	cmp al,-1
	ret
; endp shiprefitnextcargo


	// go through all vehicles, and for those with new graphics,
	// find the correct sprite number
resetnewsprites:
	pusha
	mov esi,[veharrayptr]
.nextveh:
	mov al,[esi+veh.class]
	cmp al,0x10
	jb .skipveh
	cmp al,0x13
	ja .skipveh
	cmp byte [esi+veh.spritetype],0xfd
	jb .skipveh

	// has new graphics; find the right sprite number

	and eax,3
	movzx ebx,byte [esi+veh.direction]
	call [orgsetsprite+eax*4]

.skipveh:
	sub esi,byte -vehiclesize
	cmp esi,[veharrayendptr]
	jb .nextveh
	popa
	ret
; endp resetnewsprites


	align 4

var externalvars		// for variational cargo IDs and action 7/9
	dd currentdate		// 00	80 (first number var.cargoID;
	dd currentyear		// 01	81  second number action 7/9 param-num)
	dd currentmonth		// 02	82
	dd climate		// 03	83
	dd grfstage		// 04	84
	dd patchflagsfixed	// 05	85
	dd roadtrafficside	// 06	86
	dd 0			// 07	87 (unused)
	dd spriteblockptr	// n/a	88 (slightly hackish)
	dd datefract		// 09	89
	dd animcounter		// 0A	8A


var orgsetspriteofs, db -7, -7, -5, -5
var orgsetsprite, times 4 dd -1

	// vehicle classes are in different order in TTD/Win and TTD/DOS
#if WINTTDX
var orgspritebases
	var orgplanespritebase, dd -1
	var orgrvspritebase, dd -1
	var orgtrainspritebase, dd -1
	var orgshipspritebase, dd -1

var newspritehandlers
	dd addr(newgetplanesprite_start)
	dd addr(newgetrvsprite_start)
	dd addr(newgettrainsprite_start)
	dd addr(newgetshipsprite_start)

var newspritehandlersize
	db newgetplanesprite_end-newgetplanesprite_start
	db newgetrvsprite_end-newgetrvsprite_start
	db newgettrainsprite_end-newgettrainsprite_start
	db newgetshipsprite_end-newgetshipsprite_start

var newdisplayhandlers
	dd addr(newdisplayplane_start)
	dd addr(newdisplayrv_start)
	dd addr(newdisplay2ndeng_start)
	dd addr(newdisplayship_start)

var newdisplayhandlersize
	db newdisplayplane_end-newdisplayplane_start
	db newdisplayrv_end-newdisplayrv_start
	db newdisplay2ndeng_end-newdisplay2ndeng_start
	db newdisplayship_end-newdisplayship_start

var vehclassorder, db 3,1,0,2	// planes, roadvehs, trains, ships
#else
var orgspritebases
	var orgtrainspritebase, dd -1
	var orgrvspritebase, dd -1
	var orgshipspritebase, dd -1
	var orgplanespritebase, dd -1

var newspritehandlers
	dd addr(newgettrainsprite_start)
	dd addr(newgetrvsprite_start)
	dd addr(newgetshipsprite_start)
	dd addr(newgetplanesprite_start)

var newspritehandlersize
	db newgettrainsprite_end-newgettrainsprite_start
	db newgetrvsprite_end-newgetrvsprite_start
	db newgetshipsprite_end-newgetshipsprite_start
	db newgetplanesprite_end-newgetplanesprite_start

var newdisplayhandlers
	dd addr(newdisplay2ndeng_start)
	dd addr(newdisplayrv_start)
	dd addr(newdisplayship_start)
	dd addr(newdisplayplane_start)

var newdisplayhandlersize
	db newdisplay2ndeng_end-newdisplay2ndeng_start
	db newdisplayrv_end-newdisplayrv_start
	db newdisplayship_end-newdisplayship_start
	db newdisplayplane_end-newdisplayplane_start
#endif

uvard currentshiprefitting
uvarb randomtriggers,256


	// sprites used if vehicle has sprite FF but no new graphics available
uvarb defvehsprites,256

var newshipgrfid
	dd 0
	db 8,THISGRFVERSION	// action,version
	dd 'JD01'		// grf-id
	db 0,0			// description, copyright

var newshipinfo
	dd 0
	db 0,SHIPACTION,10,11,0	// action 0, ships, 10 properties, 11 ships, offset 0

	// order of the ships:
	// 00 oil tanker (1st)          (OT)
	// 01 oil tanker (2nd)          --> LNG tanker  (LNG)
	// 02 ferry (1st)               (FE)
	// 03 ferry (2nd)               --> passenger liner (PL)
	// 04 hovercraft                (HO)
	// 05 toyland ferry (1st)       --> reefer (RF)
	// 06 toyland ferry (2nd)       --> livestock carrier (LC)
	// 07 freighter (1st)           --> general cargo vessel (GCV)
	// 08 freighter (2nd)           --> bulk freighter (BF)
	// 09 toyland freighter (1st)   --> container carrier (CC)
	// 0A toyland freighter (2nd)   --> piece goods carrier (PGC)


	//	OT 	LNG	FE	PL	HO	RF	LC	GCV	BF	CC	PGC

			// first property: year of introduction
	db 0 //	1928	1980	1926	1985	1968	1968	1972	1925	1960	1970	1962
	dw	0xb6a,	0x559a,	0x890,	0x5cbc,	0x4369,	0x447b,	0x4a30,	0x723,	0x3911,	0x4756,	0x3bec

			// next property: climates available
	db 6,	7,	7,	15,	15,	15,	6,	3,	15,	7,	15,	7

			// sprite id if new graphics not available
	db 8,	2,	2,	4,	4,	6,	0,	0,	0,	0,	0,	0

			// refittable? (should be overriden by refit cargos anyway...)
	db 9,	0,	0,	1,	0,	1,	1,	0,	1,	1,	1,	1

			// cost (255=max)
	db 10,	158,	190,	96,	255,	148,	180,	175,	110,	160,	210,	170

			// running costs
	db 15,	150,	130,	90,	255,	190,	190,	180,	165,	160,	120,	170

			// speed in mph*3.2
	// mph:	21.5	25.5	23	34	70	26.5	24	21.5	23	25.5	23
	db 11,	69,	82,	73,	108,	224,	85,	77,	69,	74,	82,	74

			// default cargo type
	db 12,	3,	3,	0,	0,	0,	12,	4,	5,	6,	5,	7

			// capacity
	db 13
	dw	300,	450,	100,	500,	100,	280,	360,	190,	360,	450,	360

			// refittable cargo
	db 17
	dd		8	// OT: oil
	dd		8	// LNG:oil
	dd	        5	// FE: passengers, mail
	dd		1	// PL: passengers
	dd		5	// HO: passengers, mail
	dd	  0x4203000	// RF: cooled cargo (food, fruit, toffee, fizzy drinks)
	dd	       0x10	// LC: livestock
	dd	~ 0x408009	// GCV:all but passengers and liquid cargo
	dd	     0x4142	// BF: coal, grain, iron ore, copper ore
	dd        0x4203020	// CC: goods, cooled cargo
	dd	    0x10a80	// PGC:wood, steel, paper, rubber


oldshiprefitlist equ 0x7FEFFF6	// TTD default for all refittable ship types
