
# Awk program to generate the station array
#
# To select the max. number of platforms and length, change
# the definitions in the BEGIN block

function makeopenrow(len,type)
{
	row="A";
	into=int( (len-1)/2 );
	for (i=0;i<into;i++) row=row "," 0;
	row=row "," type;
	for (i=0;i<len-into-1;i++) row=row "," 0;
	return gensub("A,","","",row);
}

function makeroofedrow(len,type)
{
	row="A";
	if (len==1)
		row=row "," 6-type;
	else {
		into=int((len-1)/4);
		if (into>0) {
			for (i=0;i<into;i++) row=row "," 0;
			for (i=0;i<len-2*into;i++) row=row "," type;
			for (i=0;i<into;i++) row=row "," 0;
		} else
			for (i=0;i<len;i++) row=row "," type;
	}
	return gensub("A,","","",row);
}

function makestation(num,len)
{
	print "var lrg" num "x" len

	currow=0;
	while (currow<num) {
		if ( ((currow == 0) && (num % 2)) || (len==1) ) {
			type=2;
			if ( (len == 1) && (currow != int((num-1)/2)) ) type=0;
			print "\t db "makeopenrow(len,type);
			currow++;
		} else {
			print "\t db "makeroofedrow(len,4);
			print "\t db "makeroofedrow(len,6);
			currow+=2;
		}
		stationname = "";
	}
	print
}

BEGIN {
	print "// This is a generated file. Do not edit.";
	print "// Edit awk/stations.awk instead.";
	print

	nrows=7;
	nlen=7;

	# define the actual arrays
	for (rows=1;rows<=nrows;rows++)
		for (len=1;len<=nlen;len++)
			makestation(rows,len);

	# generate an array of pointers to each array
	print
	print "align 4"
	for (rows=1;rows<=nrows;rows++) {
		ptrname="var lrg" rows "ptr, dd "
		for (len=1;len<=nlen;len++) {
			printf "%slrg%dx%d",ptrname,rows,len;
			ptrname=", ";
		}
		print
	}

	# and finally an array of pointers to the above array of pointers
	print
	print "var largestationpointers"
	printf "\tdd "

	for (rows=1;rows<=nrows;rows++) {
		printf "%slrg%dptr",comma,rows;
		comma=", ";
	}
	print
}

