#!/usr/bin/perl -w

my $curnode;
my %node;
my $menu;

print STDERR "Scanning .texi for \@node, \@section and \@anchor commands\n";
# scan .texi file for @node and @sectioning commands
my $lastsec;
while (<>) {
	/^\@(chapter|section|subsection) (.*)$/ and
		$node{$2} = $lastsec = {title=>$1, name=>$2};
	/\@anchor{(.*?)}/ and
		 $node{$1} = $lastsec;
} continue { last if eof };

print STDERR "Scanning .etxt for section numbers\n";
# now scan .etxt for section numbers
while (<>) {
	/^ *([\d.]+) (.*)$/ and exists $node{$2} and
		$node{$2}{number}=$1;
} continue { last if eof };

seek ARGV, 0, 0; $.=0;

print STDERR "Reading file again and doing replacements\n";
# and read it again, now doing the actual work
$_=<>;$_=<>;
my $index=0;
while (<>) {
#print STDERR "Line $.: $_";
	/^\37/ and do { $_=<>; last if /^Tag Table/; next; };
	/^\* Menu:/ and do {
		print "Overview\n" unless $index;
		$menu=1; $_=<>;
		$index = 1 if $index;
		next;
	};

	/^Index$/ and do {
#		print STDERR "End of menu handling\n";
		$index=2;
	};

	/(^\* |\*Note\s)(.*?)(::|$)/ and do {
		/(.)(.)(.)/;
		my ($head,$note,$tail);
		if ($index) {
			#$_ .= <> while !
			/^(\* .*?:\s)(\s*)\s{0,8}(\S.*?).$/s or die "Huh??";
			($head,$note,$tail)=($1,$3,$2);
		} else {
			$_ .= <> while !/(^\* |\*Note\s)(.*?)(::)/s;# or die "Huh?";
			($head,$note,$tail)=($1,$2,$3);
		}

		$note =~ s/^( +)//g and $head .= $1;
		my $cur=$note;
		$cur =~ tr/\n/ /d;
		$cur =~ s/ +/ /g;

		next unless (exists $node{$cur});
# {
#			$node{$cur}{title} = "unnumbered";
#		}
		next unless ($node{$cur}{number});
# {
#			$node{$cur}{number} = "0E0";
#		}
#		die "Got $_ but don't have $cur" unless exists $node{$cur};
#		die "Have $cur but not the $node{$cur}{title} number" 
#			unless $node{$cur}{number};

		s/\Q$head\E// unless $index;
		if ($index) {
#			print STDERR "Writing entry for $cur\n";
			print "$head$tail$node{$cur}{number}  $note\n";
			next;
		} elsif  ($menu) {
			print "\n$node{$cur}{number} ";
			s/:: (.*)$/\n/s;
			print;
			$_=$1;
			chomp;
			while (length $_ > 50) {
				s/^(.{0,60}(?: |$))//s;
				print "    $1\n";
			}
			chomp;
			print "    $_\n" if $_;
			next;
		}

		s/\Q${note}\E::/$node{$cur}{title} $node{$cur}{number}/;
		print;
		next;
	};

	$menu = 0;
	$index = 0 if $index == 1;
	print;
}

