;
; This file contains the new in-game texts in all five language versions
; Note: Edit all the texts in iso-8859-1
;
; -------------------------------------
;     Text definitions
; -------------------------------------
;
;
; How to make a new entry:
; 	- add one here, before the "last" entry
;		entry <entryname>
;	- add the text for each language, prefixed with a
;	  letter for the language name and an underscore.
;	  These texts must be within their respective language
;	  block.  Example:
;		a_<entryname> db "Hello!"
;		g_<entryname> db "Hallo!"
;		f_<entryname> db "Bonjour!"
;	- all text must use the iso-8859-1 codepage
;	- then use it in the assembly code with ourtext(<entryname>)
;
;
; Note: adding, removing or changing the order of entries here will invalidate
;	all ttdpttxt.dat files, so only make changes if they're really
;	necessary

	entry bribetext
	entry bribedesc
	entry bribefailed1
	entry bribefailed2
	entry headingfor
	entry headingfordepot1
	entry headingfordepot2
	entry headingfordepot3
	entry headingfordepot4
	entry withsignals
	entry wplainsignals
	entry wpresignals
	entry wpresigexits
	entry wprecombined
	entry presigautomatic
	entry presigmanual
	entry vehmulttoolow1
	entry vehmulttoolow2
	entry rchunknotloaded1
	entry rchunknotloaded2
	entry loadgame
	entry gotodepot
	entry gotodepotonly

	; must be order train, road, ship, air
	entry gototraindepot
	entry gotoroaddepot
	entry gotoshipdepot
	entry gotoairdepot

	entry cannotcheat
	entry cheatinvalidparm
	entry cheatunknown
	entry cheatobsolete1
	entry cheatobsolete2

	entry managedby1
	entry managedby2

	entry manage

	entry newwagoninfo
	entry railwaywagon
	entry monorailwagon
	entry maglevwagon

	entry ufodestroyed

	entry rvweightinfo
	entry rvweightpurchasewindow

	entry grfloaderror
	entry toomanysprites
	entry outofmemory
	entry wronggrfversion
	entry toomanyspritestotal
	entry filenotfound
	entry invalidsprite

	entry elecrailconstitle
	entry elecrailconsmenu

	entry lmilloutoftrees

	entry eurointroduced

	entry curr_HUF
	entry curr_PLN
	entry curr_ATS
	entry curr_BEF
	entry curr_DKK
	entry curr_FIM
	entry curr_GRD
	entry curr_CHF
	entry curr_NLG
	entry curr_ITL
	entry curr_SEK
	entry curr_RUB
	entry curr_EUR

	entry townlastmonthaccepted

	entry aircraftcleared
	entry zeppelincleared
	entry traincleared

	entry endofsharedorders

	; the following two should probably remain the last entries
	; because they aren't really text, but rather a list of key codes

	entry hotkeylistdos
	entry hotkeylistwin	; must immediately follow hotkeylistdos

; "last" always must be the last entry, as a guard entry

	entry last


; -----------------------------------
;	Language data
; -----------------------------------


; **************
;    American
; **************

newlanguage american,a,2,496543,1695744

a_bribetext db "Bribe the local authority",0

a_bribedesc db 94h,80h,13,90h,"  "
	db "Bribe the local authority to increase your rating, "
	db "at the risk of a severe penalty if caught."
	db 13,"  Cost: ",7fh,0

a_bribefailed1 db 94h,"Your attempted bribery has been",0
a_bribefailed2 db 94h,"discovered by a regional investigator.",0

a_headingfor db 95h,80h,", ",84h,0
a_headingfordepot1 db 95h,80h," Train Depot, ", 84h,0
a_headingfordepot2 db 95h,80h," Road Depot, ", 84h,0
a_headingfordepot3 db 95h,80h," Ship Depot, ", 84h,0
a_headingfordepot4 db 95h,80h," Hangar, ", 84h,0

a_withsignals db "Railroad track with ",80h," (",80h,")",0
a_wplainsignals db "plain signals",0
a_wpresignals db "pre-signals",0
a_wpresigexits db "pre-signal exits",0
a_wprecombined db "combined signals",0
a_presigautomatic db "automatic",0
a_presigmanual db "manual",0

a_vehmulttoolow1 db 94h,"Warning: Game saved with veh. multiplier ",7eh,".",0
a_vehmulttoolow2 db 94h,"Removed ",7eh," vehicles in ",7eh," consists and ",7eh," special objects.",0

a_rchunknotloaded1 db 94h,"Warning: Game uses some features of",0
a_rchunknotloaded2 db 94h,"TTDPatch that are disabled or not present in this version. Data may be lost.",0

a_loadgame db "Load game",0

a_gotodepot db "Go to ",80h,0
a_gotodepotonly db "Service at ",80h,0
a_gototraindepot db 80h," Train Depot",0
a_gotoroaddepot db 80h," Road Depot",0
a_gotoshipdepot db 80h," Ship Depot",0
a_gotoairdepot db 80h," Hangar",0

a_cannotcheat db 94h,"Cannot carry out sign cheat action",0
a_cheatinvalidparm db 94h,"Invalid parameter",0
a_cheatunknown db 94h,"Unknown sign cheat",0
a_cheatobsolete1 db 94h,"Note: Cht: ",80h," is obsolete.",0
a_cheatobsolete2 db 94h,"Use Cht: ",80h," instead.",0

a_managedby1 db " (temp. Player 1)",0
a_managedby2 db " (temp. Player 2)",0

a_manage db 98h,"Manage",0

a_newwagoninfo db 98h,"Cost: ",7fh,
	db "    Weight: ",7ch,"t",13
	db "Capacity: ",80h,0

a_railwaywagon db "railroad wagon",0
a_monorailwagon db "monorail wagon",0
a_maglevwagon db "maglev wagon",0

a_ufodestroyed db 98h,0fh,"'UFO' destroyed in huge explosion near ",80h,"!",0

a_rvweightinfo db 98h,"Weight: ", 95h,7ch,".",7dh,"t   "
	db 98h,"Power: ", 95h,7ch,"hp   "
	db 80h,0

a_rvweightpurchasewindow db 98h,"Cost: ", 8ah, 7fh
	db 98h,"   Speed: ", 8ah, 84h, 13
	db 98h,"Running Cost: ", 8ah, 7fh, "/yr", 13
	db 98h,"Power: ", 8ah, 7ch,"hp"
	db 98h,"   Weight: ", 8ah, 7dh,".",7dh,"t", 13
	db 98h,"Capacity: ", 8ah, 80h, 13
	db 98h,"Designed: ", 8ah, 7eh
	db 98h,"   Life: ", 8ah, 7ch, " years",13
	db 98h,"Max. Reliability: ", 8ah, 7dh, "%", 0

a_grfloaderror db 94h,"Error loading new graphics:",0
a_toomanysprites db 94h,"More sprites than specified (file ",80h,").",0
a_outofmemory db 94h,"Out of memory (file ",80h,").",0
a_wronggrfversion db 94h,"Wrong .grf version (file ",80h,").",0
a_toomanyspritestotal db 94h,"Cannot load more sprites (from file ",80h,").",0
a_filenotfound db 94h,"File ",22h,80h,22h," not found.",0
a_invalidsprite db 94h, "File ", 22h,80h,22h," has invalid sprite #",7ch,".",0

a_elecrailconstitle db 94h,"Electrified Railroad Construction",0
a_elecrailconsmenu db "Electr. railroad construction",0

a_lmilloutoftrees db 98h,0fh,80h," ",80h," ran out of nearby trees!",0

a_eurointroduced db 98h,0fh,"Monetary union!",0dh,0dh,"European countries switch from national currencies to Euro!",0

a_curr_HUF db "Hungarian Forint (Ft)",0,0,0,0,0,0
a_curr_PLN db "Polish Zloty (zl)",0,0,0,0,0,0
a_curr_ATS db "Austrian Shilling (ATS)",0,0,0,0,0,0
a_curr_BEF db "Belgian Franc (BEF)",0,0,0,0,0,0
a_curr_DKK db "Danish Krone (DKK)",0,0,0,0,0,0
a_curr_FIM db "Finnish Markka (FIM)",0,0,0,0,0,0
a_curr_GRD db "Greek Drachma (GRD)",0,0,0,0,0,0
a_curr_CHF db "Swiss Franc (CHF)",0,0,0,0,0,0
a_curr_NLG db "Dutch Guilder (NLG)",0,0,0,0,0,0
a_curr_ITL db "Italian Lira (ITL)",0,0,0,0,0,0
a_curr_SEK db "Swedish Krona (SEK)",0,0,0,0,0,0
a_curr_RUB db "Russian Rubel (RUB)",0,0,0,0,0,0
a_curr_EUR db "Euro (",0x9E,")",0,0,0,0,0,0

a_townlastmonthaccepted db 98h,"Cargo accepted last month at all stations:",0

a_aircraftcleared db 98h,0fh,"Remnants of the recent plane crash have been cleared from ",80h,"!",0
a_zeppelincleared db 98h,0fh,"Remnants of the recent Zeppelin crash have been cleared from ",80h,"!",0
a_traincleared db 98h,0fh,"Remnants of the recent train crash have been cleared near ",80h,"!",0

a_endofsharedorders db 1,0xa,"- - End of shared orders - -",0

a_hotkeylistdos db "x",0xFF,0xFF,0xFF,"!@#$t%1234567890-=",1eh,5ch,0
a_hotkeylistwin db "x",0xFF,0xFF,0xFF,"!@#$t%1234567890-=`",5ch,0

a_last equ $

secondlanguage

; **************
;    English
; **************

newlanguage english,e,2,496601,1696256
; for the most part same as american...

e_bribetext db "Bribe the local authority",0

e_bribedesc db 94h,80h,13,90h,"  "
	db "Bribe the local authority to increase your rating, "
	db "at the risk of a severe penalty if caught."
	db 13,"  Cost: ",7fh,0

e_bribefailed1 db 94h,"Your attempted bribery has been",0
e_bribefailed2 db 94h,"discovered by a regional investigator.",0

e_headingfor db 95h,80h,", ",84h,0
e_headingfordepot1 db 95h,80h," Train Depot, ", 84h,0
e_headingfordepot2 db 95h,80h," Road Depot, ", 84h,0
e_headingfordepot3 db 95h,80h," Ship Depot, ", 84h,0
e_headingfordepot4 db 95h,80h," Hangar, ", 84h,0

e_withsignals db "Railway track with ",80h," (",80h,")",0
e_wplainsignals db "plain signals",0
e_wpresignals db "pre-signals",0
e_wpresigexits db "pre-signal exits",0
e_wprecombined db "combined signals",0
e_presigautomatic db "automatic",0
e_presigmanual db "manual",0

e_vehmulttoolow1 db 94h,"Warning: Game saved with veh. multiplier ",7eh,".",0
e_vehmulttoolow2 db 94h,"Removed ",7eh," vehicles in ",7eh," consists and ",7eh," special objects.",0

e_rchunknotloaded1 db 94h,"Warning: Game uses some features of",0
e_rchunknotloaded2 db 94h,"TTDPatch that are disabled or not present in this version. Data may be lost.",0

e_loadgame db "Load game",0

e_gotodepot db "Go to ",80h,0
e_gotodepotonly db "Service at ",80h,0
e_gototraindepot db 80h," Train Depot",0
e_gotoroaddepot db 80h," Road Depot",0
e_gotoshipdepot db 80h," Ship Depot",0
e_gotoairdepot db 80h," Hangar",0

e_cannotcheat db 94h,"Cannot carry out sign cheat action",0
e_cheatinvalidparm db 94h,"Invalid parameter",0
e_cheatunknown db 94h,"Unknown sign cheat",0
e_cheatobsolete1 db 94h,"Note: Cht: ",80h," is obsolete.",0
e_cheatobsolete2 db 94h,"Use Cht: ",80h," instead.",0

e_managedby1 db " (temp. Player 1)",0
e_managedby2 db " (temp. Player 2)",0

e_manage db 98h,"Manage",0

e_newwagoninfo db 98h,"Cost: ",7fh,
	db "    Weight: ",7ch,"t",13
	db "Capacity: ",80h,0

e_railwaywagon db "railway wagon",0
e_monorailwagon db "monorail wagon",0
e_maglevwagon db "maglev wagon",0

e_ufodestroyed db 98h,0fh,"'UFO' destroyed in huge explosion near ",80h,"!",0

e_rvweightinfo db 98h,"Weight: ", 95h,7ch,".",7dh,"t   "
	db 98h,"Power: ", 95h,7ch,"hp   "
	db 80h,0

e_rvweightpurchasewindow db 98h,"Cost: ", 8ah, 7fh
	db 98h,"   Speed: ", 8ah, 84h, 13
	db 98h,"Running Cost: ", 8ah, 7fh, "/yr", 13
	db 98h,"Power: ", 8ah, 7ch,"hp"
	db 98h,"   Weight: ", 8ah, 7dh,".",7dh, "t", 13
	db 98h,"Capacity: ", 8ah, 80h, 13
	db 98h,"Designed: ", 8ah, 7eh
	db 98h,"   Life: ", 8ah, 7ch, " years",13
	db 98h,"Max. Reliability: ", 8ah, 7dh, "%", 0

e_grfloaderror db 94h,"Error loading new graphics:",0
e_toomanysprites db 94h,"More sprites than specified (file ",80h,").",0
e_outofmemory db 94h,"Out of memory (file ",80h,").",0
e_wronggrfversion db 94h,"Wrong .grf version (file ",80h,").",0
e_toomanyspritestotal db 94h,"Cannot load more sprites (from file ",80h,").",0
e_filenotfound db 94h,"File ",22h,80h,22h," not found.",0
e_invalidsprite db 94h, "File ", 22h,80h,22h," has invalid sprite #",7ch,".",0

e_elecrailconstitle db 94h,"Electrified Railway Construction",0
e_elecrailconsmenu db "Electr. railway construction",0

e_lmilloutoftrees db 98h,0fh,80h," ",80h," ran out of nearby trees!",0

e_eurointroduced db 98h,0fh,"Monetary union!",0dh,0dh,"European countries switch from national currencies to Euro!",0

e_curr_HUF db "Hungarian Forint (Ft)",0,0,0,0,0,0
e_curr_PLN db "Polish Zloty (zl)",0,0,0,0,0,0
e_curr_ATS db "Austrian Shilling (ATS)",0,0,0,0,0,0
e_curr_BEF db "Belgian Franc (BEF)",0,0,0,0,0,0
e_curr_DKK db "Danish Krone (DKK)",0,0,0,0,0,0
e_curr_FIM db "Finnish Markka (FIM)",0,0,0,0,0,0
e_curr_GRD db "Greek Drachma (GRD)",0,0,0,0,0,0
e_curr_CHF db "Swiss Franc (CHF)",0,0,0,0,0,0
e_curr_NLG db "Dutch Guilder (NLG)",0,0,0,0,0,0
e_curr_ITL db "Italian Lira (ITL)",0,0,0,0,0,0
e_curr_SEK db "Swedish Krona (SEK)",0,0,0,0,0,0
e_curr_RUB db "Russian Rubel (RUB)",0,0,0,0,0,0
e_curr_EUR db "Euro (",0x9E,")",0,0,0,0,0,0

e_townlastmonthaccepted db 98h,"Cargo accepted last month at all stations:",0

e_aircraftcleared db 98h,0fh,"Remnants of the recent plane crash have been cleared from ",80h,"!",0
e_zeppelincleared db 98h,0fh,"Remnants of the recent Zeppelin crash have been cleared from ",80h,"!",0
e_traincleared db 98h,0fh,"Remnants of the recent train crash have been cleared near ",80h,"!",0

e_endofsharedorders db 1,0xa,"- - End of shared orders - -",0

e_hotkeylistdos db "x",0xFF,0xFF,0xFF,"!",22h,0xa3,"$t%1234567890-=",1eh,5ch,0
e_hotkeylistwin db "x",0xFF,0xFF,0xFF,"!",22h,0xa3,"$t%1234567890-=~",5ch,0

e_last equ $


; **************
;     German
; **************

newlanguage german,g,2,499583,1699328

g_bribetext db "Stadtverwaltung bestechen",0

g_bribedesc db 94h,80h,13,90h
	db "Bestechen Sie die Stadtverwaltung fr eine bessere "
	db "Bewertung, mit dem Risiko einer schweren Strafe falls "
	db "Sie erwischt werden."
	db 13,"  Kosten: ",7fh,0

g_bribefailed1 db 94h,"Ihr Bestechungsversuch wurde aufgedeckt",0
g_bribefailed2 db 94h,"durch eine staatliche Untersuchung.",0

g_headingfor db 95h,80h,", ",84h,0
g_headingfordepot1 db 95h,80h,"-Zugdepot, ", 84h,0
g_headingfordepot2 db 95h,80h," Fahrzeugdepot, ", 84h,0
g_headingfordepot3 db 95h,80h," Schiffswerft, ", 84h,0
g_headingfordepot4 db 95h,80h," Halle, ", 84h,0

g_withsignals db "Gleise mit ",80h," (",80h,")",0
g_wplainsignals db "normalen Signalen",0
g_wpresignals db "Vorsignalen",0
g_wpresigexits db "Vorsignalausfahrten",0
g_wprecombined db "kombinierten Signalen",0
g_presigautomatic db "automatisch",0
g_presigmanual db "manuell",0

g_vehmulttoolow1 db 94h,"Warnung: Spielstand wurde mit Fahrzeuganzahl-Faktor ",7eh,0
g_vehmulttoolow2 db 94h,"gespeichert. ",7eh," Fahrzeuge in ",7eh," Einheiten und ",7eh," spezielle Objekte wurden entfernt.",0

g_rchunknotloaded1 db 94h,"Warning: Game uses some features of",0
g_rchunknotloaded2 db 94h,"TTDPatch that are disabled or not present in this version. Data may be lost.",0

g_loadgame db "Spiel laden",0

g_gotodepot db "Nach ",80h,0
g_gotodepotonly db "Wartung in ",80h,0
g_gototraindepot db 80h," Zugdepot",0
g_gotoroaddepot db 80h," Strassendepot",0
g_gotoshipdepot db 80h," Schiffswerft",0
g_gotoairdepot db 80h," Flugzeughalle",0

g_cannotcheat db 94h,"Kann Schilder-Cheat nicht ausfhren",0
g_cheatinvalidparm db 94h,"Ungltiger Parameter",0
g_cheatunknown db 94h,"Unbekannter Schilder-Cheat",0
g_cheatobsolete1 db 94h,"Achtung: Cht: ",80h," ist veraltet.",0
g_cheatobsolete2 db 94h,"Benutzen Sie stattdessen Cht: ",80h,".",0

g_managedby1 db " (Spieler 1 temp.)",0
g_managedby2 db " (Spieler 2 temp.)",0

g_manage db 98h,"Verwalten",0

g_newwagoninfo db 98h,"Kosten: ",7fh,
	db "    Gewicht: ",7ch,"t",13
	db "Kapazitt: ",80h,0

g_railwaywagon db "Waggon",0
g_monorailwagon db "Einschienenbahnwaggon",0
g_maglevwagon db "Schwebebahnwaggon",0

g_ufodestroyed db 98h,0fh,"'UFO' zerstrt in groer Explosion bei ",80h,"!",0

g_rvweightinfo db 98h,"Gewicht: ", 95h,7ch,".",7dh,"t   "
	db 98h,"Leistung: ", 95h,7ch,"PS   "
	db 80h,0

g_rvweightpurchasewindow db 98h,"Kosten: ", 8ah, 7fh
	db 98h,"   Geschwindigkeit: ", 8ah, 84h, 13
	db 98h,"Betriebskosten: ", 8ah, 7fh, "/Jahr", 13
	db 98h,"Leistung: ", 8ah, 7ch,"PS"
	db 98h,"   Gewicht: ", 8ah, 7dh,".",7dh, "t", 13
	db 98h,"Kapazitt: ", 8ah, 80h, 13
	db 98h,"Entwurf: ", 8ah, 7eh
	db 98h,"   Zeit: ", 8ah, 7ch, " Jahre",13
	db 98h,"Max. Zuverlssigkeit: ", 8ah, 7dh, "%", 0

g_grfloaderror db 94h,"Fehler beim Laden der Grafiken:",0
g_toomanysprites db 94h,"Mehr Eintrge als angegeben (Datei ",80h,").",0
g_outofmemory db 94h,"Zu wenig Speicher (Datei ",80h,").",0
g_wronggrfversion db 94h,"Falsche .grf Version (Datei ",80h,").",0
g_toomanyspritestotal db 94h,"Kann nicht mehr Sprites laden (ab Datei ",80h,").",0
g_filenotfound db 94h,"Datei ",80h," nicht gefunden.",0
g_invalidsprite db 94h, "Datei ", 22h,80h,22h," hat ungltiges Sprite #",7ch,".",0

g_elecrailconstitle db 94h,"Gleisbau mit Oberleitung",0
g_elecrailconsmenu db "Eisenbahnbau mit Oberleitung",0

g_lmilloutoftrees db 98h,0fh,80h," ",80h," stellt Produktion ein mangels Bumen!",0

g_eurointroduced db 98h,0fh,"Whrungsunion!",0dh,0dh,"Landeswhrungen durch Euro ersetzt!",0

g_curr_HUF db "Ungarische Forint (Ft)",0,0,0,0,0,0
g_curr_PLN db "Polnische Zloty (zl)",0,0,0,0,0,0
g_curr_ATS db "sterreichische Schilling (ATS)",0,0,0,0,0,0
g_curr_BEF db "Belgische Franken (BEF)",0,0,0,0,0,0
g_curr_DKK db "Dnische Kronen (DKK)",0,0,0,0,0,0
g_curr_FIM db "Finnische Mark (FIM)",0,0,0,0,0,0
g_curr_GRD db "Griechische Drachmen (GRD)",0,0,0,0,0,0
g_curr_CHF db "Schweizer Franken (CHF)",0,0,0,0,0,0
g_curr_NLG db "Niederlndische Gulden (NLG)",0,0,0,0,0,0
g_curr_ITL db "Italienische Lira (ITL)",0,0,0,0,0,0
g_curr_SEK db "Schwedische Kronen (SEK)",0,0,0,0,0,0
g_curr_RUB db "Russische Rubel (RUB)",0,0,0,0,0,0
g_curr_EUR db "Euro (",0x9E,")",0,0,0,0,0,0

g_townlastmonthaccepted db 98h,"Angelieferte Fracht im letzten Monat:",0

g_aircraftcleared db 98h,0fh,"Die Trmmer des Flugzeugabsturzes bei ",80h," sind nun gerumt worden.",0
g_zeppelincleared db 98h,0fh,"Die Trmmer des Zeppelinabsturzes bei ",80h," sind nun gerumt worden.",0
g_traincleared db 98h,0fh,"Die Trmmer des Zugzusammensstosses bei ",80h," sind nun gerumt worden.",0

g_endofsharedorders db 1,0xa,"- - End of shared orders - -",0

g_hotkeylistdos db "x",0xFF,0xFF,0xFF,"!",0x22,"-$t%1234567890",0xdf,1eh,5ch,0
g_hotkeylistwin db "x",0xFF,0xFF,0xFF,"!",0x22,"$t%1234567890-=~]",0

g_last equ $


; **************
;     French
; **************

newlanguage french,f,2,505759,1707008

f_bribetext db "Corrompre les autorits locales",0

f_bribedesc db 94h,80h,13,90h,"  "
	db "Paye les autorits locales pour augmenter votre cote, "
	db "au risque de vous faire coincer."
	db 13,"  Co",0fbh,"t: ",7fh,0

f_bribefailed1 db 94h,"Votre tentative de corruption a t",0
f_bribefailed2 db 94h,"dcouverte par un investigateur rgional.",0

f_headingfor db 95h,80h,", ",84h,0
f_headingfordepot1 db 95h,"Dpot de train ",0e0h," ",80h,", ", 84h,0
f_headingfordepot2 db 95h,"Dpot routier ",0e0h," ",80h,", ", 84h,0
f_headingfordepot3 db 95h,"Dpot maritime ",0e0h," ",80h,", ", 84h,0
f_headingfordepot4 db 95h,80h," Hangar, ", 84h,0

f_withsignals db "Voie ferres avec ",80h," (",80h,")",0
f_wplainsignals db "signaux rguliers",0
f_wpresignals db "pr-signaux",0
f_wpresigexits db "sortie-signaux",0
f_wprecombined db "signaux hybrides",0
f_presigautomatic db "automatiques",0
f_presigmanual db "manuels",0

f_vehmulttoolow1 db 94h,"Attention : partie sauve avec un nombre total de vhicules multipli par ",7eh,".",0
f_vehmulttoolow2 db 94h," ",7eh," composants de ",7eh," vhicules et ",7eh," objets spciaux ont t retirs.",0

f_rchunknotloaded1 db 94h,"Attention : la partie utilise des options de",0
f_rchunknotloaded2 db 94h,"TTDPatch qui sont dsactives ou non prsentes dans cette version, des informations peuvent etre perdues.",0

f_loadgame db "Charger le jeu",0

f_gotodepot db "Aller  ",80h,0
f_gotodepotonly db "Service au ",80h,0
f_gototraindepot db "Dpot de train ",0e0h," ",80h,0
f_gotoroaddepot db "Dpot routier ",0e0h," ",80h,0
f_gotoshipdepot db "Dpot maritime ",0e0h," ",80h,0
f_gotoairdepot db "Hangar ",80h,0

f_cannotcheat db 94h,"Ne peut excuter la triche",0
f_cheatinvalidparm db 94h,"Paramtre invalide",0
f_cheatunknown db 94h,"Triche inconnue",0
f_cheatobsolete1 db 94h,"Remarque: Cht: ",80h," est dsuet.",0
f_cheatobsolete2 db 94h,"Utilisez plutt Cht: ",80h,".",0

f_managedby1 db " (Joueur 1 prov.)",0
f_managedby2 db " (Joueur 2 prov.)",0

f_manage db 98h,"Contrler",0

f_newwagoninfo db 98h,"Cost: ",7fh,
	db "    poids: ",7ch,"t",13
	db "Capacit: ",80h,0

f_railwaywagon db "wagon",0
f_monorailwagon db "wagon monorail",0
f_maglevwagon db "wagon maglev",0

f_ufodestroyed db 98h,0fh,"'OVNI' detruit dans une grande explosion pres de ",80h,"!",0


f_rvweightinfo db 98h,"Poids: ", 95h,7ch,".",7dh,"t   "
	db 98h,"Puissance: ", 95h,7ch,"CV   "
	db 80h,0

f_rvweightpurchasewindow db 98h,"Cost: ", 8ah, 7fh
	db 98h,"   vitesse: ", 8ah, 84h, 13
	db 98h,"Cot: ", 8ah, 7fh, "/anne", 13
	db 98h,"Puissance: ", 8ah, 7ch,"CV"
	db 98h,"   poids: ", 8ah, 7dh,".",7dh, "t", 13
	db 98h,"Capacit: ", 8ah, 80h, 13
	db 98h,"Modle: ", 8ah, 7eh
	db 98h,"   Vie: ", 8ah, 7ch, " annes",13
	db 98h,"Fiabilit max: ", 8ah, 7dh, "%", 0

f_grfloaderror db 94h,"Erreur en chargeant les nouveaux graphiques:",0
f_toomanysprites db 94h,"Il y a plus de sprites que ce qui est spcifi (fichier ",80h,").",0
f_outofmemory db 94h,"Pas assez de mmoire (fichier ",80h,").",0
f_wronggrfversion db 94h,"Mauvaise version de .grf (fichier ",80h,").",0
f_toomanyspritestotal db 94h,"Ne peut pas charger plus de sprites (du fichier ",80h,").",0
f_filenotfound db 94h,"Fichier ",22h,80h,22h," non trouv.",0
f_invalidsprite db 94h, "Fichier ", 22h,80h,22h," a le sprite #",7ch," invalide.",0

f_elecrailconstitle db 94h,"Construction de voie ferre lectrique",0
f_elecrailconsmenu db "construction voie lectrique",0

f_lmilloutoftrees db 98h,0fh,80h," ",80h," manque d'arbre proches!",0

f_eurointroduced db 98h,0fh,"Union montaire!",0dh,0dh,"Les pays europens passe  l'Euro!",0

f_curr_HUF db "Florin hongrois (Ft)",0,0,0,0,0,0
f_curr_PLN db "Zloty Polonais(Zl)",0,0,0,0,0,0
f_curr_ATS db "AShilling Australien (ATS)",0,0,0,0,0,0
f_curr_BEF db "Franc Belge (BEF)",0,0,0,0,0,0
f_curr_DKK db "Couronne danoise (DKK)",0,0,0,0,0,0
f_curr_FIM db "Mark finlandais (FIM)",0,0,0,0,0,0
f_curr_GRD db "Drachme grec (GRD)",0,0,0,0,0,0
f_curr_CHF db "Franc Suisse(CHF)",0,0,0,0,0,0
f_curr_NLG db "Florin hollandais (NLG)",0,0,0,0,0,0
f_curr_ITL db "Lire italienne (ITL)",0,0,0,0,0,0
f_curr_SEK db "Couronne suisse (SEK)",0,0,0,0,0,0
f_curr_RUB db "Rouble russe (RUB)",0,0,0,0,0,0
f_curr_EUR db "Euro (",0x9E,")",0,0,0,0,0,0

f_townlastmonthaccepted db 98h,"Marchandises acceptes par toutes les stations le mois dernier :",0

f_aircraftcleared db 98h,0fh,"Les dbris du rcent crash d'avion de ",80h," ont t retirs!",0
f_zeppelincleared db 98h,0fh,"Les dbris du rcent crash de Zepplin de ",80h," ont t retirs!",0
f_traincleared db 98h,0fh,"Les dbris du rcent accident de train prs de ",80h," ont t dblays!",0

f_endofsharedorders db 1,0xa,"- - Fin de commande partage - -",0

f_hotkeylistdos db "x",0xFF,0xFF,0xFF,"!",0x22,0x9C,"$t%1234567890-=",1eh,5ch,0
f_hotkeylistwin db "x",0xFF,0xFF,0xFF,"1234t5&",0xE9,0x22,"'(-",0xE8,"_",0xE7,")=$",0xB2,"*",0

f_last equ $


; **************
;    Spanish
; **************

newlanguage spanish,s,2,506237,1707520

s_bribetext db "Sobornar la autoridad local",0

s_bribedesc db 94h,80h,13,90h," "
	db "Sobornar la autoridad local para aumentar su ranking, "
	db "con el riesgo de una severa penalizacin si es descubierto."
	db 13," Coste: ",7fh,0

s_bribefailed1 db 94h,"Su intento de soborno ha sido",0
s_bribefailed2 db 94h,"descubierto por un investigador regional.",0

s_headingfor db 95h,80h,", ",84h,0
s_headingfordepot1 db 95h,80h," Cocheras de Ferrocarril, ", 84h,0
s_headingfordepot2 db 95h,80h," Garaje de Carretera, ", 84h,0
s_headingfordepot3 db 95h,80h," Estacin Martima, ", 84h,0
s_headingfordepot4 db 95h,80h," Hangar, ", 84h,0

s_withsignals db "Vas de ferrocarril con ",80h," ",80h,0
s_wplainsignals db "seales planas",0
s_wpresignals db "pre-seales",0
s_wpresigexits db "salidas pre-seal",0
s_wprecombined db "seales combinadas",0
s_presigautomatic db "automticas",0
s_presigmanual db "manuales",0

s_vehmulttoolow1 db 94h,"Advertencia: juego guardado con multiplicador de veh. de ",7eh,".",0
s_vehmulttoolow2 db 94h,"Removidos ",7eh," vehculos en ",7eh," grupos  y ",7eh," objetos especiales.",0

s_rchunknotloaded1 db 94h,"Advertencia: el juego utiliza algunas caractersticas de",0
s_rchunknotloaded2 db 94h,"TTDPatch que no estan activadas o disponibles en esta versin. Podra perder datos.",0

s_loadgame db "Cargar Juego",0

s_gotodepot db "Ir a ",80h,0
s_gotodepotonly db "Mantenimiento en ",80h,0
s_gototraindepot db 80h," Cocheras de Ferrocarril",0
s_gotoroaddepot db 80h," Garaje de Carretera",0
s_gotoshipdepot db 80h," Estacin Martima",0
s_gotoairdepot db 80h," Hangar",0

s_cannotcheat db 94h,"No se puede ejecutar el cdigo trampa",0
s_cheatinvalidparm db 94h,"Parmetro invalido",0
s_cheatunknown db 94h,"Cdigo trampa desconocido",0
s_cheatobsolete1 db 94h,"Nota: Cht: ",80h," es obsoleto.",0
s_cheatobsolete2 db 94h,"Use en cambio Cht: ",80h,0

s_managedby1 db " (Jugador 1 temp.)",0
s_managedby2 db " (Jugador 2 temp.)",0

s_manage db 98h,"Manejar",0

s_newwagoninfo db 98h,"Coste: ",7fh,
	db "    Peso: ",7ch,"t",13
	db "Capacidad: ",80h,0

s_railwaywagon db "carro ferroviario",0
s_monorailwagon db "carro de monorriel",0
s_maglevwagon db "carro maglev",0

s_ufodestroyed db 98h,0fh,"'OVNI' destruido en enorme explosin cerca de  ",80h,"!",0

s_rvweightinfo db 98h,"Peso: ", 95h,7ch,".",7dh,"t   "
	db 98h,"Potencia: ", 95h,7ch,"cv   "
	db 80h,0

s_rvweightpurchasewindow db 98h,"Coste: ", 8ah, 7fh
	db 98h,"   Velocidad: ", 8ah, 84h, 13
	db 98h,"Coste de operacin: ", 8ah, 7fh, "/ao", 13
	db 98h,"Potencia: ", 8ah, 7ch,"cv"
	db 98h,"   Peso: ", 8ah, 7dh,".",7dh, "t", 13
	db 98h,"Capacidad: ", 8ah, 80h, 13
	db 98h,"Diseo: ", 8ah, 7eh
	db 98h,"   Vida: ", 8ah, 7ch, " aos",13
	db 98h,"Fiabilidad Max.: ", 8ah, 7dh, "%", 0

s_grfloaderror db 94h,"Error cargando nuevos grficos:",0
s_toomanysprites db 94h,"Error cargando nuevos grficos: (archivo ",80h,").",0
s_outofmemory db 94h,"Sin memoria (archivo ",80h,").",0
s_wronggrfversion db 94h,"Versin .grf incorrecta (archivo ",80h,").",0
s_toomanyspritestotal db 94h,"No se pueden cargar ms dibujos (desde archivo ",80h,").",0
s_filenotfound db 94h,"Archivo ",22h,80h,22h," no encontrado.",0
s_invalidsprite db 94h, "El archivo ", 22h,80h,22h," contiene un dibujo invlido #",7ch,".",0

s_elecrailconstitle db 94h,"Construccin de va electrificada",0
s_elecrailconsmenu db "Construccin de va Electr.",0

s_lmilloutoftrees db 98h,0fh,80h," ",80h," se qued sin rboles aledaos!",0

s_eurointroduced db 98h,0fh,"Unin monetaria!",0dh,0dh,"Los paises europeos cambian sus monedas nacionales por el Euro!",0

s_curr_HUF db "Forint Hngaro (Ft)",0,0,0,0,0,0
s_curr_PLN db "Zloty Polaco (zl)",0,0,0,0,0,0
s_curr_ATS db "Schilling Austriaco (ATS)",0,0,0,0,0,0
s_curr_BEF db "Franco Belga (BEF)",0,0,0,0,0,0
s_curr_DKK db "Corona Danesa (DKK)",0,0,0,0,0,0
s_curr_FIM db "Marco Finlandes (FIM)",0,0,0,0,0,0
s_curr_GRD db "Dracma Griego (GRD)",0,0,0,0,0,0
s_curr_CHF db "Franco Suizo (CHF)",0,0,0,0,0,0
s_curr_NLG db "Florn Holands (NLG)",0,0,0,0,0,0
s_curr_ITL db "Lira Italiana (ITL)",0,0,0,0,0,0
s_curr_SEK db "Corona Sueca (SEK)",0,0,0,0,0,0
s_curr_RUB db "Rublo Ruso (RUB)",0,0,0,0,0,0
s_curr_EUR db "Euro (",0x9E,")",0,0,0,0,0,0

s_townlastmonthaccepted db 98h,"Carga aceptada el mes anterior en todas las estaciones:",0

s_aircraftcleared db 98h,0fh,"Los restos de un reciente accidente areo han sido retirados de",80h,"!",0
s_zeppelincleared db 98h,0fh,"Los restos de un reciente accidente de Zeppelin han sido retirados de ",80h,"!",0
s_traincleared db 98h,0fh,"Los restos del reciente accidente de tren han sido retirados de ",80h,"!",0

s_endofsharedorders db 1,0xa,"- - Fin de pedidos compartidos - -",0

s_hotkeylistdos db "x",0xFF,0xFF,0xFF,"!",0x22,"$%t&1234567890'",0xa1,1eh,5ch,0
s_hotkeylistwin db "x",0xFF,0xFF,0xFF,"!",0x22,0xb7,"$t%1234567890'",0xa1,0xba,0xe7,0

s_last equ $
