//
// Localization strings for TTDPatch.
//

//-------------------------------------------
//  INFO ABOUT THIS LANGUAGE
//-------------------------------------------
SETNAME("Danish")
COUNTRYARRAY(countries) = { 45, 0, 0x06, 0 };
SETARRAY(countries);
	// 45 is Denmark, and 0x06 is Danish in Windows

DOSCODEPAGE(850)	// The default DOS code page for this language
WINCODEPAGE(1252)	// The default Windows code page for this language
EDITORCODEPAGE(850)	// The code page of all strings in this file.

//-------------------------------------------
//  PROGRAM BLURBS
//-------------------------------------------

// First line of output is something like "TTDPatch V1.5.1 starting.\n"
// The program name and version are autogenerated, only put the " starting\n"
// here
SETTEXT(LANG_STARTING, " starter.\n")


//-------------------------------------------
//  VERSION CHECKING
//-------------------------------------------

// In the version identifier, this is for the file size
SETTEXT(LANG_SIZE, "strrelse")

// Shown if the version is recognized
SETTEXT(LANG_KNOWNVERSION, "Denne version af programmet har kendte adresser.\n")

// Warning if the version isn't recognized.  Be sure *not* to use tabs
// in the text.  All but the last lines should end in ...\n"
SETTEXT(LANG_WRONGVERSION, "\n"
	"ADVARSEL! Din program version er ukendt for programmet. Du kan prve\n"
	"          at starte det alligevel og bestemme den ndvendige information, men hvis\n"
	"          dette gr galt, vil TTD terminere med en beskyttelsesfejl (Protection Fault).\n"
	"\n"
	"          Dit system kan resikere at g ned med evt. datatab til flge, alt efter \n"
	"          hvor godt dit operativsystem hndterer en beskyttelsesfejl (GPF).\n"
	"          Se ogs afsnit " VERSIONSECTION " i TTDPATCH.TXT for yderligere information.\n"
	"\n"
        "Svar kun 'j' (ja), hvis du er helt sikker p hvad du gr. NU ER DU ADVARET!\n"
	"Vil du alligevel starte TTD? ")

// Keys which continue loading after the above warning. *MUST* be lower case.
// can be several different keys, e.g. one for your language "yjo"
SETTEXT(LANG_YESKEYS, "j")

// Answering anything but the above keys gives this message.
SETTEXT(LANG_ABORTLOAD, "Programindlsning afbrudt.\n")

// otherwise continue loading
SETTEXT(LANG_CONTINUELOAD, "Jeg skal gre mit bedste...\n")

// Warning if '-y' was used and the version is unknown
SETTEXT(LANG_WARNVERSION, "Advarsel: versionen er ukendt!\n")


// -------------------------------------------
//    CREATING AND PATCHING TTDLOAD
// -------------------------------------------

// TTDLOAD.OVL doesn't exist
SETTEXT(LANG_OVLNOTFOUND, " ej fundet, leder efter originale filer:\n")

// (DOS) neither do tycoon.exe or ttdx.exe.  %s is TTDX.EXE
SETTEXT(LANG_NOFILESFOUND, "kunne hverken finde TYCOON.EXE eller %s.\n")

// (Windows) neither does GameGFX.exe.  %s is GameGFX.EXE
SETTEXT(LANG_NOFILEFOUND, "Kunne ikke finde %s.\n")

// Shown when copying tycoon.exe or ttdx.exe (first %s) to ttdload.ovl (2nd %s)
SETTEXT(LANG_SHOWCOPYING, "Kopierer %s til %s")

// Error if running the copy command fails.  %s is the command.
SETTEXT(LANG_COPYERROR_RUN, "Kunne ikke afvikle %s\n")

// Error if command returned successfully, but nothing was copied.
// %s=TTDLOAD.OVL
SETTEXT(LANG_COPYERROR_NOEXIST, "Kopieringsfejl - filen %s eksisterer ikke.\n")

// Invalid .EXE format
SETTEXT(LANG_INVALIDEXE, "Forkert .EXE format.\n")

// Version could not be determined
SETTEXT(LANG_VERSIONUNCONFIRMED, "Kunne ikke bestemme program version.\n")

// Shows program name (1st %s) and version (2nd %s)
SETTEXT(LANG_PROGANDVER, "Programnavnet er:\n  %s\nDen njagtige version er %s\n")

// More than three numbers in the version string (not #.#.#)
SETTEXT(LANG_TOOMANYNUMBERS, "Versionen har for mange tal!\n")

// .EXE is not TTD
SETTEXT(LANG_WRONGPROGRAM, "Dette er ikke Transport Tycoon Deluxe.\n")

// Displays the parsed version number
SETTEXT(LANG_PARSEDVERSION, "Oversat version er %s\n")

// The exe has been determined to be the DOS extended executable
SETTEXT(LANG_ISDOSEXTEXE, "Dette er et DOS udviddet eksekverbart program (extended executable).\n")

// The exe has been determined to be the Windows executable
SETTEXT(LANG_ISWINDOWSEXE, "Dette er et Windows program.\n")

// The exe is of an unknown type
SETTEXT(LANG_ISUNKNOWNEXE, "Dette er ikke et kendt eksekverbart format.\n")

// The exe is the wrong one for this TTDPatch, i.e. DOS/Windows mixed up. %s=DOS or Windows
SETTEXT(LANG_NOTSUPPORTED, "Beklager, men denne version af TTDPatch virker kun med %s versionen.\n")

// If the original .exe segment length (%lx) is too large or too small
SETTEXT(LANG_INVALIDSEGMENTLEN, "Forkert original segment. Lngde: %lx")

// When increasing the segment length
SETTEXT(LANG_INCREASECODELENGTH, "Setter program strrelse til %s MB.\n")

// Can't write to TTDLOAD.OVL (%s) [or TTDLOADW.OVL for the Windows version]
SETTEXT(LANG_WRITEERROR, "Kan ikke skrive til %s, er den ikke skrivbar (read-only)?\n")

// Installing the code loeader
SETTEXT(LANG_INSTALLLOADER, "Installerer kodeindlseren.\n")

// TTDLOAD.OVL (%s) is invalid, needs to be deleted.
SETTEXT(LANG_TTDLOADINVALID, "Kunne ikke installere kodeindlseren")
SETTEXT(LANG_DELETEOVL, " - prv at slette %s.\n")

// TTDLOAD.OVL was verified to be correct
SETTEXT(LANG_TTDLOADOK, "%s er OK.\n")

// Waiting for key before terminating TTDPatch after an error occured
SETTEXT(LANG_PRESSANYKEY, "Tryk en tast for at afbryde.")

// Displayed on various warning conditions: Esc to exit, any other key to continue
SETTEXT(LANG_PRESSESCTOEXIT, "Tryk Escape for at annullere, eller en vilkrlig tast for at fortstte")

// Loading custom in-game texts
SETTEXT(LANG_LOADCUSTOMTEXTS, "Henter srlige tekster til spillet.\n")

// ttdpttxt.dat is not in a valid format
SETTEXT(LANG_CUSTOMTXTINVALID, "Lser %s: Ugyldigt fil format.\n")

SETTEXT(LANG_CUSTOMTXTWRONGVER,
	"%s skal laves om for denne version af TTDPatch.\n"
	"Download og kr venligst den seneste version af mkpttxt.exe.\n")


//-----------------------------------------------
//   COMMAND LINE HELP (-h)
//-----------------------------------------------

// Introduction, prefixed with "TTDPATCH V<version> - "
SETTEXT(LANG_COMMANDLINEHELP, "Patcher TTD og starter det patchede program %s\n"
	  "\n"
	  "Syntaks: TTDPATCH [-C cfg-fil] [parametre] [CD sti] [-W cfg-fil]\n"
	  "\n")

// Lines of help for all on/off switches, each at most 38 chars long.
// If you need more chars just insert another line.
TEXTARRAY(halflines,) =
	{ "-a:  Alle parametre p nr -x",
	  "-d:  Vis altid den fulde dato",
	  "-f:  Gr togenes last konfigurerbar",
	  "-g:  Generelle fejlrettelser",
	  "-k:  Behold sm lufthavne",
	  "-l:  Op til 7 parroner",
	  "-n:  Ny non-stop hndtering",
	  "-q:  Forbedret lsning/lodsningstids",
          "     algoritme",
	  "-s:  Tillad skilte-snydekoder ",
          "     (sign cheats)",
	  "-v:  Vis parameterne med detaljer",
	  "-w:  Automatisk indstilling af ",
          "     fremskudt signal indstillinger",
	  "-y:  Skip ukendt versions sprgsml",
	  "-z:  Mammut tog (126 vogne)",

	  "-B:  Tillad lange broer",
	  "-D:  Dynamit kan sprnge flere ting",
	  "-E:  Flyt de rde fejlmeddelelser",
	  "-F:  'Full load' (fuld last) betyder",
          "     'af en enkel lastttype'",
	  "-G:  Valgbare godstyper p station",
	  "-I:  Fjern inflation",
	  "-J:  Tillad flere lufthavne pr. by",
	  "-L:  Ln/tilbagebetal max. med 'Ctrl'",
	  "-N:  Nyheder p flere begivenheder",
	  "-O:  Kontorbygninger vil modtage mad",
	  "-P:  Lokomotiver i brug er blivende",
	  "-R:  Kretjer venter i k",
	  "-S:  Nye skibsmodeller",
	  "-T:  Nye tog modeller",
	  "-Z:  Version med lavt",
          "     hukommelsesforbrug(3.5MB)",

	  "-2:  En del Windows 2000 patches",

	  "-Xb: Bestikkelse af lokale myndigheder",
	  "-Xd: Tilfjelse af remiser p togruten",
	  "-Xe: Uendeligt spil efter 2070",
	  "-Xf: Tvungen lodsning ved transport",
          "     mellem flere kretjer",
	  "-Xg: Gradvis lastning af fartjer",
	  "-Xi: Ingen industrier lukker pga. ",
          "     drlig konomi",
	  "-Xm: Load mulighed i disk menu",
	  "-Xo: Skilte-snydekoder (sign cheats)",
          "     koste penge",
	  "-Xr: Genudregn altid TTDLOAD.OVL",
	  "-Xs: Vis hastighed i status bar",
	  "-Xw: Extra fremskudt signal opsttning",
	  "-Xx: Gemmer og henter yderligere data",

	  "-XA: Tvunget auto-fornyelse med -Xa",
	  "-XE: Elektrificerede jernbaner",
	  "-XF: Aktivere eksperimentielle dele",
	  "-XG: Hent altid nye grafikelementer",
	  "-XP: Nye fly modeller",
	  "-XR: Nye kretjer",
	  "-XS: F kontrol over AI tilskud",

	  "-Ya: Klassificering mere tolerant",
          "     overfor vognalder",
	  "-Yb: Bygge flere ting p skrninger",
	  "-Yc: Sportyper har forskellig pris",
	  "-Ym: Tillad manuel sportype ndring",
	  "-Ys: Togsignaler i samme side som",
          "     krselsretning",
	  "-Yt: Flere statistikker i byvinduet",
	  "-Yw: Hurtigere vognsalg",

	  "-YC: Byg direkte p kyster",
	  "-YH: Flere/nye genvejstaster",
	  "-YP: Fly bevger sig den viste hastig.",
	  "-YS: Semaforesignaler fr 1975",

	  NULL
	};
SETARRAY(halflines);

// Text describing the switches with values.  The lines have to be shorter
// than 79 chars, excluding the "\n".  Start new lines if necessary.
SETTEXT(LANG_FULLSWITCHES, "\n"
	  "-e #:    Forg maksimal afstand mellem stationsenheder\n"
	  "-i #:    Standard service interval i dage\n"
	  "-x #:    Udvid fartjs fortegnelse til 850*#. Ls frst dokumentationen!\n"
	  "-mc #:   Ny hhv. bjerg(m) og kurve(c) hndtering\n"
	  "-trpb #: Forg max antallet af hhv. tog (t), biler (r), fly(p) eller skibe(s) \n"
	  "-A #:    Forbedrer AI'ens evne (lille vrdier, lille forbedring). Brug kun sm vrdier.\n"
	  "-M #:    Tillad tog med forspand, st hast.forgelse i procent\n"
	  "-Xa #:   Forny automatisk fartjer # mneder efter deres estimerede livsforlb\n"
	  "-Xc #:   Kontroller hyppigheden af flystyrt\n"
	  "-Yr #:   ndre tog/kretj kollisions type (1/2)\n"
	  "-Xt #:   St den maksimale bystrrelse til\n"
	  "-XC #:   Tillad flere valutaer, og vlg hvordan valutaen skal vises\n"
	  "-XD #:   Vlg hvilke katastrofer der m indtrffe\n"
	  "-XM #:   Foren monorail og maglev sporsystemer\n"
	  "-XT #:   Bestem en ud af hvormange byer der skal vokse hurtigere og strre\n"
	  "-XX #:   Nye monorail og maglev brohastigheder, i procent af max loko.hastighed\n"
	  "-XY #:   St standard startr for nye vilkrlige (random) spil\n"
	  "-X1 #, -X2 #: max tid (i dage) et tog venter hhv ved en-vejs og to-vejs signaler\n"
	  "-Yo #:   Kontrollere forskellige elementer i andre kontaker (jvf. dokumentation)\n"
	  "-Yp #:   Tillad plantning af mange trer, vlg plantemetode\n"
	  "-YB #:   Flere bygge muligheder, vlg mulighederne vha. parametre\n"
	  "-YE #:   Bestem hvor lnge (i sek.) de rde fejlvinduer bliver vist\n"
	  "-YG #:   Forbedre brugerfladen, vlg mulighederne vha. parametre\n"
	  "-YT #:   Bestem algoritmen der styrer byernes vkst\n"
	  "\n"
	  "-C cfg-fil:  indls denne konfigurationsfil i stedet for ttdpatch.cfg\n"
	  "-W cfg-fil:  laver en konfigurationsfil med nuvrende konfiguration\n"
	  "\n"
	  "Husk, at store/sm bogstaver har vigtig betydning!\n"
	  "\n"
	  "Ekspempel:  ttdpatch -fnqz -m 00 -c 13 -trpb 240 -FG -A 2 -v\n"
	  "\n"
	  "(Hint:  Hvis der ikke er plads nok p skrmen til at se alt hvad der blev udskrevet, skriv\"ttdpatch -h|more\")\n"
	  "\n")

// Referral to the docs, prefixed by "Copyright (C) 1999 by Josef Drexler.  "
SETTEXT(LANG_HELPTRAILER, "Se TTDPATCH.TXT for yderligere detaljer.\n")


//-----------------------------------------------
//  COMMAND LINE AND CONFIG FILE PARSING
//-----------------------------------------------

// if an on/off switch has a value other than the above (%s = wrong value)
SETTEXT(LANG_UNKNOWNSTATE, "Advarsel: Ukendt tnd/sluk status %s, sat til slukket.\n")

// switch is unknown.  %c is '-' or '/' etc, %s is the switch char
SETTEXT(LANG_UNKNOWNSWITCH, "Ukendt parameter '%c%s'.  Brug -h for hjlp.\n")

// cfg command %s is unknown
SETTEXT(LANG_UNKNOWNCFGLINE, "Advarsel: Ulovlig cfg linie '%s'.\n")

// Names of the switches for the '-v' options
// First string is shown always, second only if set and with the given
// value of the switch in %d.
// These lines (both parts) are limited to 36 chars, also consider how large
// the expansion of the %d can be for that switch.
SWITCHTEXT(uselargerarray, "Udvid antallet af vogne", " til %d*850")
SWITCHTEXT(usenewcurves, "Ny kurve hndtering", " for %04x")
SWITCHTEXT(usenewmountain, "Ny bjerg hndtering", " for %04x")
SWITCHTEXT(usenewnonstop, "Ny non-stop hndtering", "")
SWITCHTEXT(increasetraincount, "Nyt tog antal", ": %d")
SWITCHTEXT(increaservcount, "Nyt bil antal", ": %d")
SWITCHTEXT(setnewservinterval, "Nyt std. service interval", ": %d dage")
SWITCHTEXT(usesigncheat, "Brug skilte-snydekoder (sign cheats)", "")
SWITCHTEXT(allowtrainrefit, "Tillad konfigurering af togenes last", "")
SWITCHTEXT(increaseplanecount, "Nyt fly antal", ": %d")
SWITCHTEXT(increaseshipcount, "Nyt skibs antal", ": %d")
SWITCHTEXT(keepsmallairports, "Behold sm lufthavne", "")
SWITCHTEXT(largerstations, "Forg stationspredning", " til %d felter")
SWITCHTEXT(morestationtracks, "Udviddede stationer", "")
SWITCHTEXT(longerbridges, "Lngere broer", "")
SWITCHTEXT(improvedloadtimes, "Forbedret lsnings tidsudregning", "")
SWITCHTEXT(mammothtrains, "Mammut tog (lngde 127)", "")
SWITCHTEXT(presignals, "Set fremskudte signaler automatisk", "")
SWITCHTEXT(officefood, "Kontorbygninger vil modtage mad", "")
SWITCHTEXT(noinflation, "Fjern inflation", "")
SWITCHTEXT(maxloanwithctrl, "Max ln/tilbagebetal 'Ctrl'", "")
SWITCHTEXT(persistentengines, "Blivende lokomotiver hvis brugt", "")
SWITCHTEXT(fullloadany, "Full load glder for n lastttype", "")
SWITCHTEXT(selectstationgoods, "Valgbare godstyper p station", "")
SWITCHTEXT(morethingsremovable, "Flere ting kan fjernes/bortsprnges", "")
SWITCHTEXT(aibooster, "Forg AI tilbagevenden", " med %d")
SWITCHTEXT(multihead, "Tog med forspand", ", hast.forg.: %d%%")
SWITCHTEXT(newlineup, "Kretjsopmarchering i k", "")
SWITCHTEXT(lowmemory, "Lavhukommelsesversion (3.5MB)", "")
SWITCHTEXT(generalfixes, "Generelle fejlrettelser (se doku.)", "")
SWITCHTEXT(moreairports, "Flere lufthavne tilladt pr. by", "")
SWITCHTEXT(bribe, "Vis bestikkelses mulighed", "")
SWITCHTEXT(noplanecrashes, "Flystyrts hyppighedskontrol", ": %d")
SWITCHTEXT(showspeed, "Hvis hastighed i status bar", "")
SWITCHTEXT(autorenew, "Autoforny lokomotiver", " hver %d. mned")
SWITCHTEXT(cheatscost, "Skilte-snydekoder koster penge", "")
SWITCHTEXT(extpresignals, "Indstil fremskudte signaler med Ctrl", "")
SWITCHTEXT(diskmenu, "Vis hente muligheder i disk menu", "")
SWITCHTEXT(win2k, "Anvend Windows 2000/XP patches", "")
SWITCHTEXT(feederservice, "Fdningsservice med tvungen lodsning", "")
SWITCHTEXT(gotodepot, "Tilfj remiser til togruten", "")
SWITCHTEXT(newships, "Nye skibsmodeller", "")
SWITCHTEXT(subsidiaries, "F kontrol over AI tilskud", "")
SWITCHTEXT(gradualloading, "Gradvis lastning af fartjer", "")
SWITCHTEXT(moveerrorpopup, "Flyt de rde fejlmeddelelser", "")
SWITCHTEXT(setsignal1waittime, "Nye togventetider ved signal", ":")
SWITCHTEXT(setsignal2waittime, "", "")				// dummy entry
SWITCHTEXT(maskdisasters, "Liste over katastrofer", ": %d")
SWITCHTEXT(forceautorenew, "Tvungen autofornyelse af lokomotiver", "")
SWITCHTEXT(morenews, "Nyheder om flere begivenheder", "")
SWITCHTEXT(unifiedmaglev, "Foren maglev", ", mode %d")
SWITCHTEXT(newbridgespeeds, "Max hastighed p maglev-broer", ": %d%%")
SWITCHTEXT(eternalgame, "Uendeligt spil efter 2070", "")
SWITCHTEXT(showfulldate, "Vis altid den fulde dato", "")
SWITCHTEXT(newtrains, "Nye togmodeller", "")
SWITCHTEXT(newrvs, "Nye kretjer", "")
SWITCHTEXT(newplanes, "Nye flymodeller", "")
SWITCHTEXT(signalsontrafficside, "Signaler i 'krselsretningen'", "")
SWITCHTEXT(electrifiedrail, "Elektrificerede jernbaner", "")
SWITCHTEXT(newstartyear, "standard start r", ": %d")
SWITCHTEXT(newerrorpopuptime, "Ny fejlvindue visningstid", ": %d sec.")
SWITCHTEXT(newtowngrowthfactor, "Bestem byernes vkst faktor", " to %d")
SWITCHTEXT(largertowns, "Strre byer", ", each 1 out of %d")
SWITCHTEXT(miscmods, "Forskellige ndringer", ": %d")
SWITCHTEXT(loadallgraphics, "Hent altid alle nye grafikelementer", "")
SWITCHTEXT(saveoptdata, "Gemmer og henter yderligere data", "")
SWITCHTEXT(morebuildoptions, "Flere byggemuligheder", ": %d")
SWITCHTEXT(semaphoresignals, "Semafore fr 1975", "")
SWITCHTEXT(morehotkeys, "Flere/nye genvejstaster", "")
SWITCHTEXT(plantmanytrees, "Plant mange trer", "")
SWITCHTEXT(morecurrencies, "Tillad flere valutaer", ", flags: %d")
SWITCHTEXT(manualconvert, "Tillad manuel sportype ndring", "")
SWITCHTEXT(newtowngrowthrate, "Ny by vkst algoritme", ": %d")
SWITCHTEXT(displmoretownstats, "Vis flere statistiker om byerne", "")
SWITCHTEXT(enhancegui, "Forbedret brugerflade i sillet", ": %d")
SWITCHTEXT(newagerating, "Ratings bedre i forhld til vognalder", "")
SWITCHTEXT(buildonslopes, "Bygge flere ting p skrninger", "")
SWITCHTEXT(buildoncoasts, "Byg direkte p kyster", "")
SWITCHTEXT(experimentalfeatures, "Aktivere seneste eksperiment. dele", ": %d")
SWITCHTEXT(tracktypecostdiff, "Sportyper har forskellig pris", "")
SWITCHTEXT(planespeed, "Brug reele flyhastighed", "")
SWITCHTEXT(fastwagonsell, "Hurtigere vognsalg", "")
SWITCHTEXT(newrvcrash, "ndre tog/bil kollision"," (mode %d)")
SWITCHTEXT(stableindustry, "Forhindre industrilukninger","")

// A cfg file (%s) could not be found and is ignored.
SETTEXT(LANG_CFGFILENOTFOUND, "Kunne ikke finde cfg fil %s.  Ignoreret.\n")

// Couldn't write the config file
SETTEXT(LANG_CFGFILENOTWRITABLE, "Kunne ikke bne %s for skrivning.\n")

// A non-comment line is longer than 32 chars, rest ignored.
SETTEXT(LANG_CFGLINETOOLONG, "Advarsel!  Linie i konfigurationen er lngere end 32 karakterer, trunkeret.\n")

// Shown if an obsolete switch is used. First option is %s which is the
// config name, second one is %s which is the command line char
SETTEXT(LANG_SWITCHOBSOLETE, "Parametren `%s' (-%s) er forldet. Undg venligst at bruge den.\n"
		"Den vil blive fjernet i fremtidige versioner.\n")

//---------------------------------------------------
//   CONFIG FILE COMMENTS (for '-W')
//---------------------------------------------------

// This is the intro at the start of the config file.  No constraints on line lengths.
SETTEXT(CFG_INTRO,
	CFG_COMMENT "\n"
	CFG_COMMENT "TTDPatch Konfigurations Fil, automatisk opbygget af TTDPatch -W filnavn.\n"
	CFG_COMMENT "(TTDPatch %s)\n"
	CFG_COMMENT "\n"
	CFG_COMMENT "Format for parametrene er:\n"
	CFG_COMMENT "   parameternavn = parametervrdi\n"
	CFG_COMMENT "\n"
	CFG_COMMENT "\"=\"-tegnet og mellemrum kan udelades.  Forskel p store/sm bogstaver ignoreres.\n"
	CFG_COMMENT "\n"
	CFG_COMMENT "For ja/nej [j/n] paramtetre, kan vrdien vre en af:\n"
	CFG_COMMENT "   yes, y, on, 1, no, n, off, 0\n"
	CFG_COMMENT "Hvis der ikke er udfyldt noget for en ja/nej parameter, antages den standard til at vre ja hvis intet er angivet.\n"
	CFG_COMMENT "\n"
	CFG_COMMENT "For parametre med vrdi mulighed [v], er intervallet beskrevet\n"
	CFG_COMMENT "i kommentarerne, lige som standardvrdien hvis ingen er angivet.  Parametren kan\n"
	CFG_COMMENT "sls fra ved at give den en af 'fra' vrdierne.\n"
	CFG_COMMENT "\n"
	CFG_COMMENT "Kommentarer i linier startes med et tegn som ikke er et bogstav.\n"
	CFG_COMMENT "\n")

// Line before previously unset switches
SETTEXT(CFG_NEWSWITCHINTRO, "**** Nye kontakter ****")

// Definitions of the cfg file comments.
// All can have a place holder %s to stand for the actual setting name,
// and all but CFG_CDPATH can have a %s *after* the %s for the command
// line switch.
// They will have the "comment" char and a space prefixed.
//
SETTEXT(CFG_SHIPS, "`%s' (-%s) forger max. antallet af skibe.  Intervallet er %ld..%ld.  Standard %ld.")
SETTEXT(CFG_CURVES, "`%s' (-%s) Stter kurverhastighed til normal (0), hurtig (1), hurtigst (2) eller realistist (3). Et ciffer for hver jernbane, monorail, maglev og kretjer. Standard 0120.") 
SETTEXT(CFG_MOUNTAINS, "`%s' (-%s) Stter bjerghastighed til normal (0), hurtig (1), hurtigst (2) eller realistist (3). Et ciffer for hver jernbane, monorail, maglev og kretjer. Standard 0120.")  
SETTEXT(CFG_SPREAD, "`%s' (-%s) gr det muligt at have stationsenheder spredt mere ud.  Interval  %ld..%ld.  Standard %ld.")
SETTEXT(CFG_TRAINREFIT, "`%s' (-%s) gr det muligt at omkonfigurere lasten p lokomotiver.")
SETTEXT(CFG_SERVINT, "`%s' (-%s) Tillader at stte frste service interval for nye lokomotiver.  Interval  %ld..%ld.  Standard %ld.")
SETTEXT(CFG_NOINFLATION, "`%s' (-%s) fjerner inflation, bde for indtgter og udgifter.")
SETTEXT(CFG_LARGESTATIONS, "`%s' (-%s) tillader at give stationer flere perroner eller spor, op til 7x7.")
SETTEXT(CFG_NONSTOP, "`%s' (-%s) fr \"Non-stop\" ordren til at opfre sig anderledes.")
SETTEXT(CFG_PLANES, "`%s' (-%s) forger max antal fly.  Interval %ld..%ld.  Standard %ld.")
SETTEXT(CFG_LOADTIME, "`%s' (-%s) giver en anderledes udregning af tid for lsning/lodsning.")
SETTEXT(CFG_ROADVEHS, "`%s' (-%s) forger max antal kretjer.  Interval  %ld..%ld.  Standard %ld.")
SETTEXT(CFG_SIGNCHEATS, "`%s' (-%s) tillader skiltesnydekoder (sign cheats).")
SETTEXT(CFG_TRAINS, "`%s' (-%s) forger max antal tog.  Interval  %ld..%ld.  Standard %ld.")
//*#define CFG_PLAYERS "`%s' (-%s) stter hvilke(n) spiller(e) der skal pvirkes af snydekoderne.  Det er en liste af spillere i intervallet  0..7"
SETTEXT(CFG_VERBOSE, "`%s' (-%s) viser opsummering af parametre inden TTD startes.")
SETTEXT(CFG_PRESIGNALS, "`%s' (-%s) Stter fremskudte signaler ('pre-signals') op automatisk for at forbedre stationshndtering.")
SETTEXT(CFG_MOREVEHICLES, "`%s' (-%s) forger max antal fartjer til vrdi*850.  Interval  %ld..%ld.  Standard %ld.")
SETTEXT(CFG_MAMMOTHTRAINS, "`%s' (-%s) tillader mammut tog med op til 126 vogne.")
SETTEXT(CFG_FULLLOADANY, "`%s' (-%s) fr tog til at forlade stationen hvis vogne til hvilken som helst godstype er fyldt.")
SETTEXT(CFG_SELECTGOODS, "With `%s' (-%s) gods ankommer kun nr der frste gang har vret forsgt at hente denne type fra den givne station.")
SETTEXT(CFG_DEBTMAX, "`%s' (-%s) tillader at betale/lne max belb ved at holde 'Ctrl' tasten nede.")
SETTEXT(CFG_OFFICEFOOD, "`%s' (-%s) fr kontorbygninger til at modtage mad (tropiske/arktiske scenarier).")
SETTEXT(CFG_ENGINESPERSIST, "`%s' (-%s) srger for, at lokomotivtyper er tilgngelige, s lnge mindst en af denne type er i drift.")
SETTEXT(CFG_CDPATH, "`%s' (ingen kommandolinieparameter) indstiller CD stien.")
// Note- CFG_CDPATH has no command line switch, so don't give the second %s!
SETTEXT(CFG_KEEPSMALLAP, "`%s' (-%s) srger for, at man altid kan bygge sm lufthavne.")
SETTEXT(CFG_AIBOOST, "`%s' (-%s) forger AI genankomst med denne vrdi.")
SETTEXT(CFG_LONGBRIDGES, "`%s' (-%s) tillader broer med op til 127 felters lngde.")
SETTEXT(CFG_DYNAMITE, "`%s' (-%s) tillader, at flere ting kan fjernes med dynamit.")
SETTEXT(CFG_MULTIHEAD, "`%s' (%ld%s) tillader et arbitrrt antal lokomotiver p et tog. Kb ekstra lokomotiver med 'Ctrl'.  Parameter er max hastighedsforgelse pr. lokomotiv, i procent fra %ld, standard %ld%%.")
SETTEXT(CFG_RVQUEUEING, "`%s' (-%s) tillader, at kretjer stiller sig i k ved en station, i stedet for at vende om.")
SETTEXT(CFG_LOWMEMORY, "`%s' (-%s) tillader TTDPatch at kre med 3.5MB hukommelse, men reducerer max udviddelsen af antal kretjer med 2(*850).")
SETTEXT(CFG_GENERALFIXES, "`%s' (-%s) retter diverse forskellige smting, se dokumentationen for yderligere detaljer.")
SETTEXT(CFG_MOREAIRPORTS, "`%s' (-%s) tillader at man kan bygge flere lufthavne end de normale to pr. by.")
SETTEXT(CFG_BRIBE, "`%s' (-%s) tillader at bestikke de lokale myndigheder, dette er et nyt menu punkt under lokale myndigheder (local authorities).")
SETTEXT(CFG_PLANECRCTRL, "`%s' (-%s) tillader kontrol med, hvornr/tit fly styrter. Bitkodet vrdi, standard 1.")
SETTEXT(CFG_SHOWSPEED, "`%s' (-%s) viser hastigheden for fartjer i status baren i deres vindue.")
SETTEXT(CFG_AUTORENEW, "`%s' (-%s) fornyer automatisk lokomitiver nr de bliver alt for gamle (very old).  Interval  %ld..%ld.  Standard %ld.")
SETTEXT(CFG_CHEATSCOST, "`%s' (-%s) srger for, at det koster penge, nr skiltesnydekoder (sign cheats) bruges.")
SETTEXT(CFG_EXTPRESIGNALS, "`%s' (-%s) giver mulighed for at skifte mellem normale, fremskude, udlbs- og kombinerede signaler med 'Ctrl'.")
SETTEXT(CFG_FORCEREBUILDOVL, "`%s' (-%s) srger for, at TTDPatch genkompilerer TTDLOAD.OVL eller TTDLOADW.OVL hver gang programmet startes.")
SETTEXT(CFG_DISKMENU, "`%s' (-%s) tilfjer et Hent (Load) menupunkt til disk menuen, og en hent spil (eller gem spil med 'Ctrl' til scenarie opbygningsprogrammet.")
SETTEXT(CFG_WIN2K, "`%s' (-%s) gr Windows versionen af TTD kompatibel med Windows 2000/XP.")
SETTEXT(CFG_FEEDERSERVICE, "`%s' (-%s) modificerer tvungen lodsning og profit p en station s godset kan forlade stationen i stedet for at give indtgt lige nu og her.")
SETTEXT(CFG_GOTODEPOT, "`%s' (-%s) tillader at tilfje en remise/garage/dok til fartjers ordrer.")
SETTEXT(CFG_NEWSHIPS, "`%s' (-%s) ndrer skibsmodellerne og giver flere mulige skibe og flere mulige ombygningsmuligheder (refit).")
SETTEXT(CFG_SUBSIDIARIES, "`%s' (-%s) tillader dig at styre AI firmaer hvis du ejer 75%% af aktierne.")
SETTEXT(CFG_GRADUALLOADING, "`%s' (-%s) ndrer mden fartjer lsses til en mere realistisk og gradvis metode (aktiverer ogs ladetid, `loadtime').")
SETTEXT(CFG_MOVEERRORPOPUP, "`%s' (-%s) flytter alle rde fejlmeddelelser til verste hjre hjrne.")
SETTEXT(CFG_SIGNAL1WAITTIME, "`%s' (-%s) ndre det antal dage et tog venter ved et en-vejssignal fr det vender om. Interval 0..254, eller  255 for at venter evigt.")
SETTEXT(CFG_SIGNAL2WAITTIME, "`%s' (-%s) ndre det antal dage et tog venter ved et to-vejssignal fr det vender om. Interval 0..254, eller  255 for at venter evigt.")
SETTEXT(CFG_DISASTERS, "`%s' (-%s) tillader valg af hvilke katastrofer der m indtrffe. Bitkode vrdi, standard 255 (all katastrofer).")
SETTEXT(CFG_FORCEAUTORENEW, "`%s' (-%s) tvinger et kretj til vrksted nr det er tid til auto-fornyelse (jvf `autorenew').")
SETTEXT(CFG_MORENEWS, "`%s' (-%s) genere beskeder/nyheder om flere begivenheder, se ogs dokumentationen for mere information.")
SETTEXT(CFG_UNIFIEDMAGLEV, "`%s' (-%s) gr det muligt at kbe monorail lokomotiver i maglev depoter og omvendt. indstilling: 1 - ndre alle maglev lokomotiver til monorail; 2 - ndre alle monorail lokomotiver til maglev; 3 - holder monorail og maglev adskilt.")                                         
SETTEXT(CFG_BRIDGESPEEDS, "`%s' (-%s) ndre hastigheden p monorail og maglev rrbroer til denne procentdel af den hjeste lokomotivhastighed i dens klasse. Interval %ld..%ld. Standard %ld.")
SETTEXT(CFG_ETERNALGAME, "`%s' (-%s)  tallader uendelige spil - datoen bliver ikke nulstillet efter 2070.")
SETTEXT(CFG_SHOWFULLDATE, "`%s' (-%s) vis altid den fulde dato i statusbaren, og ikke kun nr spillet bliver sat p pause.")
SETTEXT(CFG_NEWTRAINS, "`%s' (-%s) aktivere nye togmodeller med nye grafikellementer.")
SETTEXT(CFG_NEWRVS, "`%s' (-%s) aktivere nye kretjsmodeller med nye grafikellementer.")
SETTEXT(CFG_NEWPLANES, "`%s' (-%s) aktivere nye flymodeller med nye grafikellementer.")
SETTEXT(CFG_SIGNALSONTRAFFICSIDE, "`%s' (-%s) viser jernbaresignaler i samme side som kretjerne krer.")
SETTEXT(CFG_ELECTRIFIEDRAIL, "`%s' (-%s) fjerne et af de magnetiske sporsystemer (monorail eller maglev) og erstatter det med et elektrificeret jernbane system.")
SETTEXT(CFG_STARTYEAR, "`%s' (-%s) bestemmer det normale startr for vilkrlige (random) spil og giver strre muligheder for startr i scenario editoren. Interval %ld..%ld. Standard %ld.")
SETTEXT(CFG_ERRORPOPUPTIME, "`%s' (-%s) ndre det tidsrum de rde popup vinduer bliver vist. Interval 1..255 (i sekunder) , eller 0 for meget lang tid. Standard 10.")
SETTEXT(CFG_TOWNGROWTHLIMIT, "`%s' (-%s) ndre den faktor der betemmer hvor store byer kan blive. Interval %ld..%ld. Standard %ld.")
SETTEXT(CFG_LARGERTOWNS, "`%s' (-%s) gr at en by ud af den givne antal, vokser huritgere og strre (tilfjer ogs `towngrowthlimit'). Interval 1..32. Standard %ld (%ld ud af %ld byer).") 
SETTEXT(CFG_MISCMODS, "`%s' (-%s) gr det muligt at ndre effekten af andre kontakter, se dokumentation for mere info. Bitkode vrdi, standard 0 (ingen ndring).")
SETTEXT(CFG_LOADALLGRAPHICS, "`%s' (-%s) tvinger TTDPatch til at hente alle .grf filer i newgrf(w).cfg, uanset om de har vret brugt fr i spillet eller ej.")
SETTEXT(CFG_SAVEOPTDATA, "`%s' (-%s) gr at TTDPatch gemmer og henter yderligere (valgfrit) data i slutningen af de gemte spil.")
SETTEXT(CFG_MOREBUILDOPTIONS, "`%s' (-%s) giver flere bygge muligheder. Bitkode vrdi, interval %ld..%ld. Standard %ld.")
SETTEXT(CFG_SEMAPHORES, "`%s' (-%s) ndre nye signaler bygget fr 1975 til semafore signaler.")
SETTEXT(CFG_MOREHOTKEYS, "`%s' (-%s) aktivere nye genvejstaster.")
SETTEXT(CFG_MANYTREES, "`%s' (-%s) tillader plantning af mere end et tr i hvert felt, eller over et retangulrt omrder vha Ctrl.")
SETTEXT(CFG_MORECURRENCIES,"`%s' (-%s) giver flere valutaer og Euroen. Parametre: 0 - valutasymboler p deres normale plads; 1 - valutasymboler fr tallene; 2 - valutasymboler efter tallene. lg 4 til de ovenstende vrdi for at sl Euroen fra.")
SETTEXT(CFG_MANCONVERT,"`%s' (-%s) tillader manuel sporndring ved at placere de nye spor ovenp de eksisterende spor.")
SETTEXT(CFG_NEWAGERATING, "`%s' (-%s) gr stationsandelen (ratings) mere tolerent overfor vognalder. Nu kan vogenen vre 21 istedet for 3 r gamle.")
SETTEXT(CFG_ENHANCEGUI,"`%s' (-%s) forbedre brugergrnsefladen. Bitkode vrdi, interval %ld..%ld. Standard %ld.")
SETTEXT(CFG_TOWNGROWTHRATEMODE, "`%s' (-%s) gr det muligt at definere reglerne der ligger til grund for udregningen af udvidelseshastigheden for byer. Indstilling: 0 - TTD original, 1 - TTD udvidet, 2 - personlig. Jvf. dokumentationen.")
SETTEXT(CFG_TOWNGROWTHRATEMIN, "`%s' (ikke en kommandolinie kontakt) definere den mindste voksehastighed for byer, ved nye huse per rhundrede. Kun aktiv hvis `towngrowthratemode' er sat til 2. Interval %ld..%ld. Standard %ld.")
SETTEXT(CFG_TOWNGROWTHRATEMAX, "`%s' (ikke en kommandolinie kontakt) definere den strste voksehastighed for byer, ved nye huse per rhundrede. Kun aktiv hvis `towngrowthratemode' er sat til 2. Interval %ld..%ld. Standard %ld.")
SETTEXT(CFG_TGRACTSTATIONEXIST, "`%s' (ikke en kommandolinie kontakt) definere hvor meget tilstedevrelsen af en aktiv station betyder for byens vkst (jvf dokumentation for mere information). Kun aktiv hvis towngrowthratemode' er sat til 2. Interval %ld..%ld. Standard %ld.")
SETTEXT(CFG_TGRACTSTATIONS, "`%s' (ikke en kommandolinie kontakt) definere hvor meget hver aktive station styrker byens vkst (jvf dokumentation for mere information). Kun aktiv hvis towngrowthratemode' er sat til 2. Interval %ld..%ld. Standard %ld.")
SETTEXT(CFG_TGRACTSTATIONSWEIGHT, "`%s' (ikke en kommandolinie kontakt) definere hvor effektivt aktive stationer medvirker til byens vkst (jvf dokumentation for mere information). Kun aktiv hvis towngrowthratemode' er sat til 2. Interval %ld..%ld. Standard %ld.")
SETTEXT(CFG_TGRPASSOUTWEIGHT, "`%s' (ikke en kommandolinie kontakt) definere hvor effektivt transporterede passagere medvirker til byens vkst (jvf dokumentation for mere information). Kun aktiv hvis towngrowthratemode' er sat til 2. Interval %ld..%ld. Standard %ld.")
SETTEXT(CFG_TGRMAILOUTWEIGHT, "`%s' (ikke en kommandolinie kontakt) definere hvor effektivt transporterede post medvirker til byens vkst (jvf dokumentation for mere information). Kun aktiv hvis towngrowthratemode' er sat til 2. Interval %ld..%ld. Standard %ld.")
SETTEXT(CFG_TGRPASSINMAX, "`%s' (ikke en kommandolinie kontakt) definere det maximum antal af ankomne passagere der kan  medvirker til byens vkst (jvf dokumentation for mere information). Kun aktiv hvis towngrowthratemode' er sat til 2. Interval %ld..%ld. Standard %ld.")
SETTEXT(CFG_TGRPASSINWEIGHT, "`%s' (ikke en kommandolinie kontakt) definere hvor effektivt ankomne passagere medvirker til byens vkst (jvf dokumentation for mere information). Kun aktiv hvis towngrowthratemode' er sat til 2. Interval %ld..%ld. Standard %ld.")
SETTEXT(CFG_TGRMAILINOPTIM, "`%s' (ikke en kommandolinie kontakt) definere den optimale befolkning per hver 2 skke post af ankommen post (jvf dokumentation for mere information). Kun aktiv hvis towngrowthratemode' er sat til 2. Interval %ld..%ld. Standard %ld.")
SETTEXT(CFG_TGRMAILINWEIGHT, "`%s' (ikke en kommandolinie kontakt) definere hvor effektivt ankommen post medvirker til byens vkst (jvf dokumentation for mere information). Kun aktiv hvis towngrowthratemode' er sat til 2. Interval %ld..%ld. Standard %ld.")
SETTEXT(CFG_TGRGOODSINOPTIM, "`%s' (ikke en kommandolinie kontakt) definere den optimale befolkning per hver 2 kasse af ankommen gods (jvf dokumentation for mere information). Kun aktiv hvis towngrowthratemode' er sat til 2. Interval %ld..%ld. Standard %ld.")
SETTEXT(CFG_TGRGOODSINWEIGHT, "`%s' (ikke en kommandolinie kontakt) definere hvor effektivt ankommen gods medvirker til byens vkst (jvf dokumentation for mere information). Kun aktiv hvis towngrowthratemode' er sat til 2. Interval %ld..%ld. Standard %ld.")
SETTEXT(CFG_TGRFOODINMIN, "`%s' (ikke en kommandolinie kontakt) definere det minimum madbehov for byer i sne- eller rkenomrder, i befolkning per 2 tons af ankommen mad (jvf dokumentation for mere information). Kun aktiv hvis towngrowthratemode' er sat til 2. Interval %ld..%ld. Standard %ld.")
SETTEXT(CFG_TGRFOODINOPTIM, "`%s' (ikke en kommandolinie kontakt) definere den optimale befolkning per hver 2 tons af ankommen mad (jvf dokumentation for mere information). Kun aktiv hvis towngrowthratemode' er sat til 2. Interval %ld..%ld. Standard %ld.")
SETTEXT(CFG_TGRFOODINWEIGHT, "`%s' (ikke en kommandolinie kontakt) definere hvor effektivt ankommen mad medvirker til byens vkst (jvf dokumentation for mere information). Kun aktiv hvis towngrowthratemode' er sat til 2. Interval %ld..%ld. Standard %ld.")
SETTEXT(CFG_TGRWATERINMIN, "`%s' (ikke en kommandolinie kontakt) definere det minimum vandbehov for byer i rkenomrder, i befolkning per 2 tons (2.000 liter) af ankommen vand (jvf dokumentation for mere information). Kun aktiv hvis towngrowthratemode' er sat til 2. Interval %ld..%ld. Standard %ld.")
SETTEXT(CFG_TGRWATERINOPTIM, "`%s' (ikke en kommandolinie kontakt) definere den optimale befolkning per hver 2 tons (2.000 liter) af ankommen vand i det sub-tropiske klima (jvf dokumentation for mere information). Kun aktiv hvis towngrowthratemode' er sat til 2. Interval %ld..%ld. Standard %ld.")
SETTEXT(CFG_TGRWATERINWEIGHT, "`%s' (ikke en kommandolinie kontakt) definere hvor effektivt ankommen vand medvirker til byens vkst i det subtropiske klima (jvf dokumentation for mere information). Kun aktiv hvis towngrowthratemode' er sat til 2. Interval %ld..%ld. Standard %ld.")
SETTEXT(CFG_TGRSWEETSINOPTIM, "`%s' (ikke en kommandolinie kontakt) definere den optimale befolkning per hver 2 skke af ankommen slik (sweets) i legetjsland klimaet (jvf dokumentation for mere information). Kun aktiv hvis towngrowthratemode' er sat til 2. Interval %ld..%ld. Standard %ld.")
SETTEXT(CFG_TGRSWEETSINWEIGHT, "`%s' (ikke en kommandolinie kontakt) definere hvor effektivt ankommen slik (sweets) medvirker til byens vkst i legetjsland klimaet (jvf dokumentation for mere information). Kun aktiv hvis towngrowthratemode' er sat til 2. Interval %ld..%ld. Standard %ld.")
SETTEXT(CFG_TGRFIZZYDRINKSINOPTIM, "`%s' (ikke en kommandolinie kontakt) definere den optimale befolkning per hver 2 ankommen sodavand (fizzy drinks) i legetjsland klimaet (jvf dokumentation for mere information). Kun aktiv hvis towngrowthratemode' er sat til 2. Interval %ld..%ld. Standard %ld.")
SETTEXT(CFG_TGRFIZZYDRINKSINWEIGHT, "`%s' (ikke en kommandolinie kontakt) definere hvor effektivt ankommen sodavand (fizzy drinks) medvirker til byens vkst i legetjsland klimaet (jvf dokumentation for mere information). Kun aktiv hvis towngrowthratemode' er sat til 2. Interval %ld..%ld. Standard %ld.")
SETTEXT(CFG_TGRTOWNSIZEBASE, "`%s' (ikke en kommandolinie kontakt) definere det basis antal af bygninger i byen for beregningen der involvere `tgrtownsizefactor' (jvf dokumentation for mere information). Kun aktiv hvis towngrowthratemode' er sat til 2. Interval %ld..%ld. Standard %ld.")
SETTEXT(CFG_TGRTOWNSIZEFACTOR, "`%s' (ikke en kommandolinie kontakt) definere hvor meget byens strrelse betyder for dens vkst (jvf dokumentation for mere information). Kun aktiv hvis towngrowthratemode' er sat til 2. Interval 0..255. Standard %ld. (svare til 25%% indflydelse (%ld/%ld)).")
SETTEXT(CFG_TOWNMINPOPULATIONSNOW, "`%s' (ikke en kommandolinie kontakt) definere den mindste befolkning som byer i sne-omrder kan vokse til uden madforsyninger. Kun aktiv hvis `towngrowthratemode', `towngrowthlimit' eller `generalfixes' er slet til. Interval %ld..%ld. Standard %ld.") 
SETTEXT(CFG_TOWNMINPOPULATIONDESERT, "`%s' (ikke en kommandolinie kontakt) definere den mindste befolkning som byer i rken-omrder kan vokse til uden mad- og vandforsyninger. Kun aktiv hvis `towngrowthratemode', `towngrowthlimit' eller `generalfixes' er slet til. Interval %ld..%ld. Standard %ld.") 
SETTEXT(CFG_MORETOWNSTATS, "With `%s' (-%s) Yderligere statistiker bliver vist i byens informationsvindue.")
SETTEXT(CFG_BUILDONSLOPES, "`%s' (-%s) gr det muligt at bygge spor, veje og stationer p skrninger, p et fundament ligesom husene.")
SETTEXT(CFG_BUILDONCOASTS, "`%s' (-%s) gr det muligt at bygge p kyster og flodsider uden frst at skulle bruge dynamit-vrktjet.")
SETTEXT(CFG_TRACKTYPECOSTDIFF, "`%s' (-%s) giver forskellige sporsystemer forskellige priser.")
SETTEXT(CFG_CUSMULTIPLIER, "`%s' (ikke en kommandolinie kontakt) stter vekselkursus for egen valuta CUS * 1000. Default is 1000 (1 CUS = 1 pound). Kun aktiv hvis `morecurrencies' er slet til.")
SETTEXT(CFG_EXPERIMENTALFEATURES, "`%s' (-%s) aktivere seneste eksperimentielle dele.")
SETTEXT(CFG_PLANESPEED, "`%s' (-%s) gr at fly bevger sig den hastighed der er vist, og ikke det kvarte, og reducere hastigheden til 5/8 i tilflde af nedbrud.")
SETTEXT(CFG_FASTWAGONSELL, "`%s' (-%s) giver hurtigere vognsalg vha. Ctrl")
SETTEXT(CFG_NEWRVCRASH,"`%s' (-%s) ndre tog/kretj kollisioner. %ld gr at toget byder ned efter kollisionen. %ld afskaffer tog/kretj kollisioner. Standard: type %ld");
SETTEXT(CFG_STABLEINDUSTRY,"`%s' (-%s) modvirker industrilukninger hvis konomien er sat til rolig (Steady) i svrhedsgrad indstillingerne");


//----------------------------------------------------
//   SWITCH DISPLAY ('-v')
//----------------------------------------------------

// Wait for a key before displaying the switches
SETTEXT(LANG_SWWAITFORKEY, "\nTryk Enter for at krer TTD, Escape for at annullere, eller en vilkrlig tast for at vise indstillingerne.")

// Introduction
SETTEXT(LANG_SHOWSWITCHINTRO, "\n"
	  "\n"
	  "    Benyttede parametre:   (%c tndt, %c slukket)\n")

// Five characters: vertical line for the table; enabled switch; disabled switch;
// table heading; table heading column separator.
SETTEXT(LANG_SWTABLEVERCHAR, "*")

// 1-way and 2-way captions after "Nye togventetider vej rdt signal"
SETTEXT(LANG_SWONEWAY, "en-vejs: ")
SETTEXT(LANG_SWTWOWAY, "To-vejs: ")

// Train wait time is either in days or infinite
SETTEXT(LANG_TIMEDAYS, "%d dag(e)")
SETTEXT(LANG_INFINITETIME, "uendeligt")


// Shows the load options for ttdload.  %s is the given parameters to be passed to ttdload
SETTEXT(LANG_SWSHOWLOAD, "Tryk en tast for at kre \"TTDLOAD %s\" (Escape for at afbryde).")

SETTEXT(LANG_SWABORTLOAD, "\nProgram indlsning afbrudt p brugerens anfordring.\n")


//---------------------------------------
//  STARTUP AND REPORTING
//---------------------------------------

// Internal error in TTDPatch (%d is error number)
SETTEXT(LANG_INTERNALERROR, "*** Intern TTDPatch fejl #%d ***\n")

// Error fixing the Windows version HDPath registry entry
SETTEXT(LANG_REGISTRYERROR, "TTD er ikke installeret ordenligt (registreringsfejl %d)\n")

// DOS reports no memory available
SETTEXT(LANG_NOTENOUGHMEM, "Der er ikke nok hukommelse ledig %s, skal bruge %d KB mere.\n")

// ...for starting TTD
SETTEXT(LANG_TOSTARTTTD, "til at starte TTD")

// Protected mode code exceeds 32kb
SETTEXT(LANG_PROTECTEDTOOLARGE, "Beskyttet tilstands kode for stor!\n")

// Show where the code was stored, %p is the location
SETTEXT(LANG_CODESTOREDAT, "Beskyttet tilstands kode gemt p %lX.\n")

// Swapping TTDPatch out
SETTEXT(LANG_SWAPPING, "Swapper ud.\n")

// Just before running ttdload, show this.
// 1st %s is ttdload.ovl, then %s is a space if there are options,
// and the 3rd %s contains the options
SETTEXT(LANG_RUNTTDLOAD, "Starter %s%s%s\n")

// Error executing ttdload.  1st %s is ttdload.ovl, 2nd %s is the error message from the OS
SETTEXT(LANG_RUNERROR, "Kunne ikke udfre %s: %s\n")

// Show the result after after running, %s is one of the following strings
SETTEXT(LANG_RUNRESULT, "Resultat: [%s]\n")
SETTEXT(LANG_RUNRESULTOK, "OK")
SETTEXT(LANG_RUNRESULTERROR, "Fejl!")

// Messages about the graphics file ttdpatch.grf
SETTEXT(LANG_NOTTDPATCHGRF, "Kunne ikke finde patch grafik %s, genererer en tom fil.\n")
SETTEXT(LANG_ERRORCREATING, "Fejl ved skabelse af  %s: %s\n")
